/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.proxy;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import oracle.oc4j.sql.proxy.SQLBCELProxy;
import oracle.oc4j.sql.proxy.SQLBCELProxyEvent;

public abstract class ResultSetBCELProxy
extends SQLBCELProxy
implements ResultSet {
    protected ResultSetBCELProxy(Object target, SQLBCELProxy parent) {
        super(target, parent);
    }

    protected void oc4j_releaseTarget() throws SQLException {
        if (this.m_target == null) {
            return;
        }
        ((ResultSet)this.m_target).close();
        super.oc4j_releaseTarget();
    }

    protected void oc4j_notify(SQLBCELProxyEvent event) throws SQLException {
        super.oc4j_notify(event);
        if (event.getSource() == this.oc4j_getParent() && event.getType() == SQLBCELProxyEvent.STATEMENT_EXECUTE_EVENT) {
            this.oc4j_close(false);
        }
    }

    public boolean next() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).next();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public void close() throws SQLException {
        try {
            this.oc4j_close(true);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public String getString(int columnIndex) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getString(columnIndex);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getBoolean(columnIndex);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public byte getByte(int columnIndex) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getByte(columnIndex);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public short getShort(int columnIndex) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getShort(columnIndex);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public int getInt(int columnIndex) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getInt(columnIndex);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public long getLong(int columnIndex) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getLong(columnIndex);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public float getFloat(int columnIndex) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getFloat(columnIndex);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public double getDouble(int columnIndex) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getDouble(columnIndex);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getBigDecimal(columnIndex, scale);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getBytes(columnIndex);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public Date getDate(int columnIndex) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getDate(columnIndex);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public Time getTime(int columnIndex) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getTime(columnIndex);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getTimestamp(columnIndex);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getAsciiStream(columnIndex);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getUnicodeStream(columnIndex);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getBinaryStream(columnIndex);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public String getString(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getString(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public boolean getBoolean(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getBoolean(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public byte getByte(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getByte(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public short getShort(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getShort(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public int getInt(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getInt(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public long getLong(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getLong(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public float getFloat(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getFloat(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public double getDouble(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getDouble(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getBigDecimal(columnName, scale);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public byte[] getBytes(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getBytes(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public Date getDate(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getDate(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public Time getTime(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getTime(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getTimestamp(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getAsciiStream(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getUnicodeStream(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getBinaryStream(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getWarnings();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).clearWarnings();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public String getCursorName() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getCursorName();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public int findColumn(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).findColumn(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getCharacterStream(columnIndex);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getCharacterStream(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getBigDecimal(columnIndex);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getBigDecimal(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public boolean isBeforeFirst() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).isBeforeFirst();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public boolean isAfterLast() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).isAfterLast();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public boolean isFirst() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).isFirst();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public boolean isLast() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).isLast();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public void beforeFirst() throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).beforeFirst();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void afterLast() throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).afterLast();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public boolean first() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).first();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public boolean last() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).last();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public int getRow() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getRow();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public boolean absolute(int row) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).absolute(row);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public boolean relative(int rows) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).relative(rows);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public boolean previous() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).previous();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).setFetchDirection(direction);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getFetchDirection();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).setFetchSize(rows);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getFetchSize();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public int getType() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getType();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public int getConcurrency() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getConcurrency();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public boolean rowUpdated() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).rowUpdated();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public boolean rowInserted() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).rowInserted();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public boolean rowDeleted() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).rowDeleted();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public void updateNull(int columnIndex) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateNull(columnIndex);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateBoolean(columnIndex, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateByte(columnIndex, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateShort(columnIndex, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateInt(columnIndex, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateLong(columnIndex, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateFloat(columnIndex, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateDouble(columnIndex, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateBigDecimal(columnIndex, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateString(columnIndex, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateBytes(columnIndex, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateDate(columnIndex, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateTime(columnIndex, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateTimestamp(columnIndex, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateAsciiStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateBinaryStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateCharacterStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateObject(columnIndex, x, scale);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateObject(columnIndex, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateNull(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateNull(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateBoolean(columnName, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateByte(columnName, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateShort(String columnName, short x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateShort(columnName, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateInt(String columnName, int x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateInt(columnName, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateLong(String columnName, long x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateLong(columnName, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateFloat(columnName, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateDouble(columnName, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateBigDecimal(columnName, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateString(String columnName, String x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateString(columnName, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateBytes(columnName, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateDate(columnName, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateTime(columnName, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateTimestamp(columnName, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateAsciiStream(columnName, x, length);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateBinaryStream(columnName, x, length);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateCharacterStream(columnName, reader, length);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateObject(columnName, x, scale);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateObject(columnName, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void insertRow() throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).insertRow();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateRow() throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateRow();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void deleteRow() throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).deleteRow();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void refreshRow() throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).refreshRow();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void cancelRowUpdates() throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).cancelRowUpdates();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void moveToInsertRow() throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).moveToInsertRow();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void moveToCurrentRow() throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).moveToCurrentRow();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getDate(columnIndex, cal);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getDate(columnName, cal);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getTime(columnIndex, cal);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getTime(columnName, cal);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getTimestamp(columnIndex, cal);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getTimestamp(columnName, cal);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public URL getURL(int columnIndex) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getURL(columnIndex);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public URL getURL(String columnName) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((ResultSet)this.m_target).getURL(columnName);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateRef(columnIndex, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateRef(columnName, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateBlob(columnIndex, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateBlob(columnName, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateClob(columnIndex, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateClob(columnName, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateArray(columnIndex, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        try {
            this.oc4j_intercept();
            ((ResultSet)this.m_target).updateArray(columnName, x);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }
}

