/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Arrays;
import oracle.j2ee.connector.proxy.AbstractProxy;
import oracle.j2ee.connector.proxy.BCELProxyBuilder;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.proxy.ConstructionKey;
import oracle.oc4j.sql.proxy.SQLBCELProxy;
import oracle.oc4j.sql.proxy.SQLBCELProxyFactory;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;

public class SQLBCELProxyBuilder
implements BCELProxyBuilder {
    private static final ObjectType SQLEXCEPTION_TYPE = new ObjectType(SQLException.class.getName());
    private static final ObjectType SQLBCELPROXY_TYPE = new ObjectType(SQLBCELProxy.class.getName());
    private static final ObjectType ABSTRACTPROXY_TYPE = new ObjectType(AbstractProxy.class.getName());
    private static final ObjectType CONSTRUCTIONKEY_TYPE = new ObjectType(ConstructionKey.class.getName());
    protected Object m_target;
    protected SQLBCELProxy m_parent;
    protected String m_requiredTypeClassName;
    private SQLBCELProxyFactory m_factory;
    private static final String OC4J_HANDLESQLEXCEPTION_METHOD_NAME = "oc4j_handleSQLException";
    private static final String OC4J_HANDLESQLEXCEPTIONNORETHROW_METHOD_NAME = "oc4j_handleSQLExceptionNoRethrow";
    private static final String OC4J_GETPROXYIFREQUIRED_METHOD_NAME = "oc4j_getProxyForReturnedObjectIfRequired";
    private static final String OC4J_GETPROXY_METHOD_NAME = "oc4j_getProxyForReturnedObject";
    private static final String OC4J_SETCONSTRUCTIONKEY_METHOD_NAME = "oc4j_setConstructionKey";
    private static final String OC4J_INTERCEPT_METHOD_NAME = "oc4j_intercept";
    private static final String OC4J_GETCACHEDOBJECT_METHOD_NAME = "oc4j_getCachedObject";
    private static final String OC4J_CREATECONSTUCTIONKEY_METHOD_NAME = "oc4j_createConstructionKey";
    private static final String KEY_SETARG_METHOD_NAME = "setArg";
    private static final Class[] SQLPROXY_CONSTRUCTOR_PARAMETER_TYPES = new Class[]{Object.class, SQLBCELProxy.class};

    public SQLBCELProxyBuilder(Object target, SQLBCELProxy parent, String requiredTypeClassName, SQLBCELProxyFactory factory) {
        this.m_target = target;
        this.m_parent = parent;
        this.m_requiredTypeClassName = requiredTypeClassName;
        this.m_factory = factory;
    }

    public void setFactory(SQLBCELProxyFactory factory) {
        this.m_factory = factory;
    }

    public MethodGen buildConstructor(String name, Class superClass, ConstantPoolGen constantPool, InstructionFactory instructionFactory) {
        InstructionList il = new InstructionList();
        il.append((Instruction)InstructionConstants.THIS);
        il.append((Instruction)new ALOAD(1));
        il.append((Instruction)new ALOAD(2));
        il.append((Instruction)new INVOKESPECIAL(constantPool.addMethodref(superClass.getName(), "<init>", "(" + Type.getType((Class)Object.class).getSignature() + Type.getType((Class)SQLBCELProxy.class).getSignature() + ")V")));
        il.append((Instruction)InstructionConstants.RETURN);
        MethodGen mg = new MethodGen(1, (Type)Type.VOID, new Type[]{Type.OBJECT, SQLBCELPROXY_TYPE}, null, "<init>", name, il, constantPool);
        return mg;
    }

    public MethodGen buildMethod(String name, Class intf, Method method, ConstantPoolGen constantPool, InstructionFactory instructionFactory, boolean proxyResults, Method preInvokeMethod) {
        String preInvokeSignature;
        Object[] preInvokeArgumentTypes;
        InstructionList instructionList = new InstructionList();
        String signature = Type.getSignature((Method)method);
        Type returnType = Type.getReturnType((String)signature);
        Object[] argumentTypes = Type.getArgumentTypes((String)signature);
        ArgumentList argumentList = new ArgumentList((Type[])argumentTypes);
        if (!(preInvokeMethod == null || Arrays.equals(preInvokeArgumentTypes = Type.getArgumentTypes((String)(preInvokeSignature = Type.getSignature((Method)preInvokeMethod))), argumentTypes) && Type.getReturnType((String)preInvokeSignature).equals((Object)Type.VOID))) {
            String result = DataSourceMessages.severePreInvokeInBuildMethod(method.getName());
            throw new IllegalArgumentException(result);
        }
        MethodGen methodGen = new MethodGen(1, returnType, (Type[])argumentTypes, null, method.getName(), name, instructionList, constantPool);
        InstructionHandle tryStartInstruction = instructionList.append((Instruction)new NOP());
        IFNE jumpToInterceptIfDoInterceptTrue = new IFNE(null);
        instructionList.append((Instruction)InstructionConstants.THIS);
        instructionList.append((Instruction)instructionFactory.createGetField(SQLBCELProxy.class.getName(), "m_doIntercept", (Type)Type.BOOLEAN));
        instructionList.append((BranchInstruction)jumpToInterceptIfDoInterceptTrue);
        GOTO gotoPastInterceptInstruction = new GOTO(null);
        instructionList.append((BranchInstruction)gotoPastInterceptInstruction);
        InstructionHandle interceptInstr = this.addInterceptInvocation(instructionList, instructionFactory);
        jumpToInterceptIfDoInterceptTrue.setTarget(interceptInstr);
        InstructionHandle pastInterceptInstruction = instructionList.append((Instruction)new NOP());
        gotoPastInterceptInstruction.setTarget(pastInterceptInstruction);
        if (proxyResults) {
            this.addTargetInvocationWithProxiedResults(methodGen, instructionList, instructionFactory, constantPool, intf, method, argumentList, signature, preInvokeMethod);
            instructionList.append((Instruction)new CHECKCAST(constantPool.addClass((ObjectType)returnType)));
        } else {
            this.addTargetInvocation(instructionList, instructionFactory, intf, method, argumentList, signature, preInvokeMethod);
        }
        InstructionHandle tryEndInstruction = instructionList.append((Instruction)new NOP());
        GOTO gotoInstruction = new GOTO(null);
        if (this.methodThrowsSQLException(method)) {
            instructionList.append((BranchInstruction)gotoInstruction);
            InstructionHandle exceptionHandlerInstruction = this.addSQLExceptionHandler(methodGen, instructionList, instructionFactory, returnType, true);
            methodGen.addExceptionHandler(tryStartInstruction, tryEndInstruction, exceptionHandlerInstruction, SQLEXCEPTION_TYPE);
        }
        gotoInstruction.setTarget(instructionList.append((Instruction)InstructionFactory.createReturn((Type)returnType)));
        return methodGen;
    }

    public AbstractProxy instantiate(Class cl) throws InstantiationException {
        try {
            Constructor constructor = cl.getConstructor(SQLPROXY_CONSTRUCTOR_PARAMETER_TYPES);
            return (AbstractProxy)constructor.newInstance(null, null);
        }
        catch (Exception e) {
            throw new InstantiationException(e.toString());
        }
    }

    public Object getTarget() {
        return this.m_target;
    }

    public String getRequiredTypeClassName() {
        return this.m_requiredTypeClassName;
    }

    public AbstractProxy cloneProxy(AbstractProxy proxy) {
        SQLBCELProxy clonedProxy = null;
        clonedProxy = (SQLBCELProxy)proxy.clone();
        clonedProxy.oc4j_setTarget(this.getTarget());
        clonedProxy.oc4j_setParent(this.getParent());
        return clonedProxy;
    }

    private InstructionHandle addSQLExceptionHandler(MethodGen mg, InstructionList il, InstructionFactory instructionFactory, Type returnType, boolean rethrow) {
        int exceptionIndex = mg.addLocalVariable("exception", (Type)SQLEXCEPTION_TYPE, null, null).getIndex();
        InstructionHandle exceptionHandlerInstruction = il.append((Instruction)new ASTORE(exceptionIndex));
        il.append((Instruction)InstructionConstants.THIS);
        il.append((Instruction)new ALOAD(exceptionIndex));
        il.append((Instruction)instructionFactory.createInvoke(SQLBCELProxy.class.getName(), rethrow ? OC4J_HANDLESQLEXCEPTION_METHOD_NAME : OC4J_HANDLESQLEXCEPTIONNORETHROW_METHOD_NAME, (Type)Type.VOID, new Type[]{SQLEXCEPTION_TYPE}, (short)182));
        if (rethrow && !returnType.equals((Object)Type.VOID)) {
            il.append((Instruction)new ALOAD(exceptionIndex));
            il.append((Instruction)new ATHROW());
        }
        return exceptionHandlerInstruction;
    }

    private InstructionHandle addTargetInvocation(InstructionList il, InstructionFactory instructionFactory, Class intf, Method method, ArgumentList argumentList, String signature, Method preInvokeMethod) {
        int i;
        InstructionHandle firstInstruction;
        int numberOfArguments = argumentList.getNumberOfArguments();
        if (preInvokeMethod != null) {
            firstInstruction = il.append((Instruction)InstructionConstants.THIS);
            for (i = 0; i < numberOfArguments; ++i) {
                il.append((Instruction)InstructionFactory.createLoad((Type)argumentList.getArgumentType(i), (int)argumentList.getArgumentIndex(i)));
            }
            il.append((Instruction)instructionFactory.createInvoke(preInvokeMethod.getDeclaringClass().getName(), preInvokeMethod.getName(), (Type)Type.VOID, Type.getArgumentTypes((String)signature), (short)183));
            il.append((Instruction)InstructionConstants.THIS);
        } else {
            firstInstruction = il.append((Instruction)InstructionConstants.THIS);
        }
        il.append((Instruction)instructionFactory.createGetField(SQLBCELProxy.class.getName(), "m_target", (Type)Type.OBJECT));
        for (i = 0; i < numberOfArguments; ++i) {
            il.append((Instruction)InstructionFactory.createLoad((Type)argumentList.getArgumentType(i), (int)argumentList.getArgumentIndex(i)));
        }
        il.append((Instruction)instructionFactory.createInvoke(intf.getName(), method.getName(), Type.getReturnType((String)signature), Type.getArgumentTypes((String)signature), (short)185));
        return firstInstruction;
    }

    private InstructionHandle addTargetInvocationWithProxiedResults(MethodGen methodGen, InstructionList il, InstructionFactory instructionFactory, ConstantPoolGen constantPool, Class intf, Method method, ArgumentList argumentList, String signature, Method preInvokeMethod) {
        Class<?> methodReturnType = method.getReturnType();
        boolean returnTypeObject = methodReturnType == Object.class;
        int keyLocalVariableIndex = methodGen.addLocalVariable("key", (Type)CONSTRUCTIONKEY_TYPE, null, null).getIndex();
        int targetLocalVariableIndex = methodGen.addLocalVariable("target", (Type)Type.OBJECT, null, null).getIndex();
        IFNONNULL ifCachedTargetNonNull = new IFNONNULL(null);
        InstructionHandle firstInstruction = il.append((Instruction)InstructionConstants.THIS);
        if (this.shouldCreateConstructionKey(methodReturnType)) {
            this.addCreateConstructionKey(il, instructionFactory, intf, method, signature, keyLocalVariableIndex, argumentList);
            if (this.m_factory.isCacheableType(methodReturnType)) {
                this.addGetCachedTarget(il, instructionFactory, keyLocalVariableIndex, targetLocalVariableIndex);
                il.append((BranchInstruction)ifCachedTargetNonNull);
            }
        }
        this.addTargetInvocation(il, instructionFactory, intf, method, argumentList, signature, preInvokeMethod);
        GOTO newTargetInstruction = new GOTO(null);
        il.append((BranchInstruction)newTargetInstruction);
        ifCachedTargetNonNull.setTarget(il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)targetLocalVariableIndex)));
        newTargetInstruction.setTarget(il.append((CompoundInstruction)new PUSH(constantPool, methodReturnType.getName())));
        il.append((Instruction)instructionFactory.createInvoke(SQLBCELProxy.class.getName(), returnTypeObject ? OC4J_GETPROXYIFREQUIRED_METHOD_NAME : OC4J_GETPROXY_METHOD_NAME, (Type)(returnTypeObject ? Type.OBJECT : ABSTRACTPROXY_TYPE), new Type[]{Type.OBJECT, Type.STRING}, (short)182));
        if (this.m_factory.isReconstructableType(methodReturnType)) {
            this.addSetConstructionKeyInvocation(il, constantPool, instructionFactory, keyLocalVariableIndex);
        }
        return firstInstruction;
    }

    private void addSetConstructionKeyInvocation(InstructionList il, ConstantPoolGen constantPool, InstructionFactory instructionFactory, int keyLocalVariableIndex) {
        IFNULL ifNullProxy = new IFNULL(null);
        il.append((Instruction)new DUP());
        il.append((BranchInstruction)ifNullProxy);
        il.append((Instruction)new DUP());
        il.append((Instruction)new CHECKCAST(constantPool.addClass(SQLBCELPROXY_TYPE)));
        il.append((Instruction)InstructionFactory.createLoad((Type)CONSTRUCTIONKEY_TYPE, (int)keyLocalVariableIndex));
        il.append((Instruction)instructionFactory.createInvoke(SQLBCELProxy.class.getName(), OC4J_SETCONSTRUCTIONKEY_METHOD_NAME, (Type)Type.VOID, new Type[]{CONSTRUCTIONKEY_TYPE}, (short)182));
        ifNullProxy.setTarget(il.append((Instruction)new NOP()));
    }

    private InstructionHandle addInterceptInvocation(InstructionList il, InstructionFactory instructionFactory) {
        InstructionHandle tryStartInstruction = il.append((Instruction)InstructionConstants.THIS);
        il.append((Instruction)instructionFactory.createInvoke(SQLBCELProxy.class.getName(), OC4J_INTERCEPT_METHOD_NAME, (Type)Type.VOID, Type.NO_ARGS, (short)182));
        return tryStartInstruction;
    }

    private void addGetCachedTarget(InstructionList il, InstructionFactory instructionFactory, int keyLocalVariableIndex, int targetLocalVariableIndex) {
        il.append((Instruction)InstructionConstants.THIS);
        il.append((Instruction)InstructionFactory.createLoad((Type)CONSTRUCTIONKEY_TYPE, (int)keyLocalVariableIndex));
        il.append((Instruction)instructionFactory.createInvoke(SQLBCELProxy.class.getName(), OC4J_GETCACHEDOBJECT_METHOD_NAME, (Type)Type.OBJECT, new Type[]{CONSTRUCTIONKEY_TYPE}, (short)182));
        il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)targetLocalVariableIndex));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)targetLocalVariableIndex));
    }

    private void addCreateConstructionKey(InstructionList il, InstructionFactory instructionFactory, Class intf, Method method, String signature, int keyLocalVariableIndex, ArgumentList argumentList) {
        il.append((Instruction)InstructionConstants.THIS);
        String constructionKeyClassName = ConstructionKey.getConstructionKeyClassName(intf.getName(), method.getName(), signature);
        il.append(instructionFactory.createConstant((Object)constructionKeyClassName));
        il.append(instructionFactory.createConstant((Object)intf.getName()));
        il.append(instructionFactory.createConstant((Object)method.getName()));
        il.append(instructionFactory.createConstant((Object)signature));
        il.append((Instruction)instructionFactory.createInvoke(SQLBCELProxy.class.getName(), OC4J_CREATECONSTUCTIONKEY_METHOD_NAME, (Type)CONSTRUCTIONKEY_TYPE, new Type[]{Type.STRING, Type.STRING, Type.STRING, Type.STRING}, (short)182));
        il.append((Instruction)InstructionFactory.createStore((Type)CONSTRUCTIONKEY_TYPE, (int)keyLocalVariableIndex));
        int numberOfArguments = argumentList.getNumberOfArguments();
        for (int i = 0; i < numberOfArguments; ++i) {
            il.append((Instruction)InstructionFactory.createLoad((Type)CONSTRUCTIONKEY_TYPE, (int)keyLocalVariableIndex));
            Type argumentType = argumentList.getArgumentType(i);
            il.append((Instruction)InstructionFactory.createLoad((Type)argumentType, (int)argumentList.getArgumentIndex(i)));
            il.append((Instruction)instructionFactory.createInvoke((class$oracle$oc4j$sql$proxy$ConstructionKey == null ? SQLBCELProxyBuilder.class$("oracle.oc4j.sql.proxy.ConstructionKey") : class$oracle$oc4j$sql$proxy$ConstructionKey).getName(), KEY_SETARG_METHOD_NAME, (Type)Type.VOID, new Type[]{argumentType instanceof BasicType ? argumentType : Type.OBJECT}, (short)182));
        }
    }

    private boolean methodThrowsSQLException(Method method) {
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        for (int i = 0; i < exceptionTypes.length; ++i) {
            if (!(class$java$sql$SQLException == null ? SQLBCELProxyBuilder.class$("java.sql.SQLException") : class$java$sql$SQLException).isAssignableFrom(exceptionTypes[i])) continue;
            return true;
        }
        return false;
    }

    private boolean shouldCreateConstructionKey(Class methodReturnType) {
        return this.m_factory.isReconstructableType(methodReturnType) || this.m_factory.isCacheableType(methodReturnType);
    }

    public AbstractProxy getParent() {
        return this.m_parent;
    }

    class ArgumentList {
        private Type[] m_argumentTypes;
        private int[] m_argumentIndexes;

        public ArgumentList(Type[] argumentTypes) {
            this.m_argumentTypes = argumentTypes;
            this.m_argumentIndexes = new int[this.m_argumentTypes.length];
            int nextIndex = 1;
            for (int i = 0; i < argumentTypes.length; ++i) {
                this.m_argumentIndexes[i] = nextIndex;
                nextIndex += argumentTypes[i].getSize();
            }
        }

        public Type getArgumentType(int argNumber) {
            return this.m_argumentTypes[argNumber];
        }

        public int getNumberOfArguments() {
            return this.m_argumentTypes.length;
        }

        public int getArgumentIndex(int argNumber) {
            return this.m_argumentIndexes[argNumber];
        }
    }
}

