/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.security;

import java.util.Iterator;
import java.util.Set;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import oracle.oc4j.sql.spi.ConnectionRequestInfoImpl;

public final class CredentialUtility {
    private static char[] m_emptyCharArray = new char[0];

    private CredentialUtility() {
    }

    public static PasswordCredential getCredential(ManagedConnectionFactory managedConnectionFactory, Subject subject, ConnectionRequestInfo connectionRequestInfo) {
        PasswordCredential credential = null;
        if (subject != null) {
            return CredentialUtility.getCredentialFromSubject(managedConnectionFactory, subject);
        }
        if (connectionRequestInfo == null) {
            return null;
        }
        String password = ((ConnectionRequestInfoImpl)connectionRequestInfo).getPassword();
        String user = ((ConnectionRequestInfoImpl)connectionRequestInfo).getUser();
        credential = new PasswordCredential(user == null ? "" : user, password == null ? m_emptyCharArray : password.toCharArray());
        credential.setManagedConnectionFactory(managedConnectionFactory);
        return credential;
    }

    public static PasswordCredential getCredentialFromSubject(ManagedConnectionFactory managedConnectionFactory, Subject subject) {
        PasswordCredential credential = null;
        Set passwordCredentials = subject.getPrivateCredentials(PasswordCredential.class);
        Iterator iterator = passwordCredentials.iterator();
        while (iterator.hasNext()) {
            credential = (PasswordCredential)iterator.next();
            if (!managedConnectionFactory.equals(credential.getManagedConnectionFactory())) continue;
            return credential;
        }
        throw new SecurityException("Can't match password credential.");
    }

    public static boolean areCredentialsEqual(PasswordCredential credential1, PasswordCredential credential2) {
        if (credential1 == null || credential2 == null) {
            return credential1 == credential2;
        }
        return credential1.equals((Object)credential2);
    }
}

