/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.spi;

import com.evermind.util.ArraySet;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import javax.resource.ResourceException;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.DataSourceConnectionEventListener;
import oracle.oc4j.sql.DataSourceConnectionLocalTxEvent;
import oracle.oc4j.sql.DataSourceConnectionPool;
import oracle.oc4j.sql.DataSourceConnectionXAResourceEvent;
import oracle.oc4j.sql.DataSourceException;
import oracle.oc4j.sql.ListenableConnection;
import oracle.oc4j.sql.ManagedDataSource;
import oracle.oc4j.sql.config.ErrorCodeConfig;
import oracle.oc4j.sql.proxy.ConnectionBCELProxy;
import oracle.oc4j.sql.proxy.ConstructionKey;
import oracle.oc4j.sql.proxy.SQLBCELProxy;
import oracle.oc4j.sql.proxy.SQLBCELProxyBuilder;
import oracle.oc4j.sql.proxy.SQLBCELProxyEvent;
import oracle.oc4j.sql.proxy.SQLBCELProxyFactory;
import oracle.oc4j.sql.spi.ConnectionFinalizer;
import oracle.oc4j.sql.spi.ManagedConnectionFactoryImpl;
import oracle.oc4j.sql.spi.ManagedConnectionImpl;

public abstract class ConnectionHandle
extends ConnectionBCELProxy
implements ListenableConnection {
    private ManagedConnectionImpl m_managedConnection;
    private ManagedConnectionFactoryImpl m_managedConnectionFactory;
    private boolean m_isTransactional;
    private DeferredOperationHashSet m_listeners;
    private long m_waitTime;
    private long m_createTime;
    private ConnectionFinalizer m_finalizer = null;
    private boolean m_notificationInProgress = false;

    protected ConnectionHandle(Object target, SQLBCELProxy parent) {
        super(target, parent);
        this.createListenerSet();
        this.m_createTime = System.currentTimeMillis();
    }

    public void preInvokeBCELProxy_setSavepoint() throws SQLException {
        this.oc4j_throwSQLExceptionIfGlobalTxActive("setSavepoint");
    }

    public void preInvokeBCELProxy_setSavepoint(String name) throws SQLException {
        this.oc4j_throwSQLExceptionIfGlobalTxActive("setSavepoint");
    }

    public void preInvokeBCELProxy_rollback(Savepoint savepoint) throws SQLException {
        this.oc4j_throwSQLExceptionIfGlobalTxActive("rollback");
    }

    public void commit() throws SQLException {
        this.oc4j_throwSQLExceptionIfGlobalTxActive("commit");
        try {
            this.oc4j_intercept();
            try {
                this.m_managedConnection.callCommit();
            }
            catch (ResourceException e) {
                SQLException sqlException = new SQLException(e.toString());
                sqlException.initCause(e);
                throw sqlException;
            }
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void rollback() throws SQLException {
        this.oc4j_throwSQLExceptionIfGlobalTxActive("rollback");
        try {
            this.oc4j_intercept();
            try {
                this.m_managedConnection.callRollback();
            }
            catch (ResourceException e) {
                SQLException sqlException = new SQLException(e.toString());
                sqlException.initCause(e);
                throw sqlException;
            }
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit) {
            this.oc4j_throwSQLExceptionIfGlobalTxActive("setAutoCommit(true)");
        }
        try {
            this.oc4j_intercept();
            try {
                this.m_managedConnection.callSetAutoCommit(autoCommit);
            }
            catch (ResourceException e) {
                SQLException sqlException = new SQLException(e.toString());
                sqlException.initCause(e);
                throw sqlException;
            }
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void close() throws SQLException {
        try {
            this.oc4j_close(true);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public synchronized void addConnectionEventListener(DataSourceConnectionEventListener listener) {
        if (this.m_notificationInProgress) {
            this.m_listeners.deferredAdd(listener);
        } else {
            this.m_listeners.add(listener);
        }
    }

    public synchronized void removeConnectionEventListener(DataSourceConnectionEventListener listener) {
        if (this.m_notificationInProgress) {
            this.m_listeners.deferredRemove(listener);
        } else {
            this.m_listeners.remove(listener);
        }
    }

    protected boolean oc4j_close(boolean removeFromParent) throws SQLException {
        if (this.m_isClosed) {
            return false;
        }
        this.m_isClosed = true;
        if (this.m_isActive) {
            ManagedDataSource mds = this.m_managedConnection.getManagedConnectionFactory().getManagedDataSource();
            if (mds != null) {
                mds.cleanupConnection(this);
            }
            this.oc4j_notifyChildren(SQLBCELProxyEvent.CLOSE_EVENT);
            this.m_managedConnection.dissociateConnectionProxy(this);
            this.m_managedConnection.connectionClosed(this);
            if (DataSourceMessages.LOG_LEVEL_FINER_OR_HIGHER && mds != null) {
                mds.getDebug().connectionClosed(this);
            }
        }
        return true;
    }

    protected void oc4j_releaseTarget() throws SQLException {
        this.m_target = null;
    }

    protected void oc4j_intercept() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(DataSourceMessages.warningClosedHandle(this));
        }
        if (!this.m_isValid) {
            throw new SQLException(DataSourceMessages.severeInvalidHandle(this));
        }
        try {
            if (this.m_isTransactional) {
                this.m_managedConnectionFactory.checkAssociation(this, this.m_managedConnection, this.m_managedConnection.getConnectionRequestInfo());
            }
            if (!this.m_isActive) {
                this.m_managedConnectionFactory.activateConnection(this, this.m_managedConnection.getConnectionRequestInfo());
            }
            if (this.m_isTransactional) {
                this.m_managedConnection.setupTransaction();
            }
        }
        catch (ResourceException e) {
            String result = DataSourceMessages.severeIntercept((Exception)((Object)e));
            SQLException se = new SQLException(result);
            se.initCause(e);
            throw se;
        }
    }

    protected void oc4j_setActive(boolean active) {
        this.m_isActive = active;
    }

    protected boolean oc4j_isActive() {
        return this.m_isActive;
    }

    protected ManagedConnectionImpl oc4j_getManagedConnection() {
        if (this.m_managedConnection == null && this.oc4j_getParent() != null) {
            SQLBCELProxy root = (SQLBCELProxy)SQLBCELProxy.oc4j_getRoot(this.oc4j_getParent());
            this.m_managedConnection = ((ConnectionHandle)root).oc4j_getManagedConnection();
        }
        return this.m_managedConnection;
    }

    protected void oc4j_setManagedConnection(ManagedConnectionImpl managedConnection) throws ResourceException {
        this.m_managedConnection = managedConnection;
        try {
            this.m_managedConnection.associateConnectionProxy(this);
        }
        catch (SQLException e) {
            throw new ResourceException(e.toString(), (Throwable)e);
        }
        this.m_managedConnectionFactory = managedConnection.getManagedConnectionFactory();
        this.m_isTransactional = this.m_managedConnection.getConnectionRequestInfo().isTransactional();
    }

    protected void oc4j_associateManagedConnection(ManagedConnectionImpl managedConnection) throws ResourceException {
        try {
            if (this.m_isActive) {
                if (this.m_managedConnection == managedConnection) {
                    return;
                }
                this.oc4j_getManagedConnection().dissociateConnectionProxy(this);
            }
        }
        catch (SQLException e) {
            String result = DataSourceMessages.severeAssociateManagedConnection(e);
            throw new ResourceException(result);
        }
        finally {
            this.oc4j_resetTarget(managedConnection.getConnection());
            this.oc4j_setManagedConnection(managedConnection);
        }
    }

    protected void oc4j_dissociate() throws SQLException {
        super.oc4j_dissociate();
    }

    protected void oc4j_associate() throws SQLException {
        super.oc4j_associate();
    }

    private void oc4j_throwSQLExceptionIfGlobalTxActive(String methodName) throws SQLException {
        if (this.m_managedConnection.isGlobalTxActive()) {
            String result = DataSourceMessages.warningGlobalTxActive(methodName);
            throw new SQLException(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void oc4j_localTransactionStarted() {
        this.m_notificationInProgress = true;
        try {
            DataSourceConnectionLocalTxEvent connectionEvent = new DataSourceConnectionLocalTxEvent(this);
            Iterator iterator = this.m_listeners.iterator();
            while (iterator.hasNext()) {
                ((DataSourceConnectionEventListener)iterator.next()).localTransactionStarted(connectionEvent);
            }
        }
        finally {
            this.m_notificationInProgress = false;
            this.m_listeners.doPendingOperations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void oc4j_localTransactionCommitted() {
        this.m_notificationInProgress = true;
        try {
            DataSourceConnectionLocalTxEvent connectionEvent = new DataSourceConnectionLocalTxEvent(this);
            Iterator iterator = this.m_listeners.iterator();
            while (iterator.hasNext()) {
                ((DataSourceConnectionEventListener)iterator.next()).localTransactionCommitted(connectionEvent);
            }
        }
        finally {
            this.m_notificationInProgress = false;
            this.m_listeners.doPendingOperations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void oc4j_localTransactionRolledback() {
        this.m_notificationInProgress = true;
        try {
            DataSourceConnectionLocalTxEvent connectionEvent = new DataSourceConnectionLocalTxEvent(this);
            Iterator iterator = this.m_listeners.iterator();
            while (iterator.hasNext()) {
                ((DataSourceConnectionEventListener)iterator.next()).localTransactionRolledback(connectionEvent);
            }
        }
        finally {
            this.m_notificationInProgress = false;
            this.m_listeners.doPendingOperations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void oc4j_xaResourceStartCalled(int flags) {
        this.m_notificationInProgress = true;
        try {
            DataSourceConnectionXAResourceEvent connectionEvent = new DataSourceConnectionXAResourceEvent(this, flags);
            Iterator iterator = this.m_listeners.iterator();
            while (iterator.hasNext()) {
                ((DataSourceConnectionEventListener)iterator.next()).xaResourceStartOccurred(connectionEvent);
            }
        }
        finally {
            this.m_notificationInProgress = false;
            this.m_listeners.doPendingOperations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void oc4j_xaResourceEndCalled(int flags) {
        this.m_notificationInProgress = true;
        try {
            DataSourceConnectionXAResourceEvent connectionEvent = new DataSourceConnectionXAResourceEvent(this, flags);
            Iterator iterator = this.m_listeners.iterator();
            while (iterator.hasNext()) {
                ((DataSourceConnectionEventListener)iterator.next()).xaResourceEndOccurred(connectionEvent);
            }
        }
        finally {
            this.m_notificationInProgress = false;
            this.m_listeners.doPendingOperations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void oc4j_xaResourceCommitCalled() {
        this.m_notificationInProgress = true;
        try {
            DataSourceConnectionXAResourceEvent connectionEvent = new DataSourceConnectionXAResourceEvent(this);
            Iterator iterator = this.m_listeners.iterator();
            while (iterator.hasNext()) {
                ((DataSourceConnectionEventListener)iterator.next()).xaResourceCommitOccurred(connectionEvent);
            }
        }
        finally {
            this.m_notificationInProgress = false;
            this.m_listeners.doPendingOperations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void oc4j_xaResourceRollbackCalled() {
        this.m_notificationInProgress = true;
        try {
            DataSourceConnectionXAResourceEvent connectionEvent = new DataSourceConnectionXAResourceEvent(this);
            Iterator iterator = this.m_listeners.iterator();
            while (iterator.hasNext()) {
                ((DataSourceConnectionEventListener)iterator.next()).xaResourceRollbackOccurred(connectionEvent);
            }
        }
        finally {
            this.m_notificationInProgress = false;
            this.m_listeners.doPendingOperations();
        }
    }

    protected Object oc4j_getCachedObject(ConstructionKey key) {
        return this.m_managedConnection.getCachedObject(key);
    }

    protected boolean oc4j_addObjectToCache(ConstructionKey key, Object obj, boolean shareable) {
        return this.m_managedConnection.addObjectToCache(key, obj, shareable);
    }

    protected boolean oc4j_isTransactional() {
        return this.m_isTransactional;
    }

    public long oc4j_getWaitTime() {
        return this.m_waitTime;
    }

    public void oc4j_setWaitTime(long waitTime) {
        this.m_waitTime = waitTime;
    }

    public long oc4j_getCreateTime() {
        return this.m_createTime;
    }

    public boolean oc4j_isFatalError(SQLException sqlException) {
        DataSourceConnectionPool dscp;
        if (this.m_managedConnectionFactory != null && (dscp = this.m_managedConnectionFactory.getDataSourceConnectionPool()) != null) {
            int errorCode = sqlException.getErrorCode();
            ErrorCodeConfig[] errorCodesConfig = dscp.getConnectionFactory().getConnectionFactoryConfig().getFatalErrorCodesConfig().getErrorCodes();
            for (int i = 0; i < errorCodesConfig.length; ++i) {
                if (errorCode != errorCodesConfig[i].getCode()) continue;
                return true;
            }
        }
        return false;
    }

    protected void oc4j_handleSQLException(SQLException exception) throws SQLException {
        if (this.oc4j_isFatalError(exception)) {
            DataSourceMessages.infoFatalErrorDetected(exception.getErrorCode(), exception);
            this.oc4j_invalidate();
            this.m_managedConnectionFactory.setInvalidConnection(this.m_managedConnection);
            try {
                this.m_managedConnectionFactory.getDataSourceConnectionPool().refreshConnectionPool();
            }
            catch (DataSourceException dataSourceException) {
                DataSourceMessages.warningHandleFatalErrorException(dataSourceException);
            }
        }
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void oc4j_validate(String validateConnectionStatement) throws SQLException {
        block13: {
            invalid = false;
            cause = null;
            connection = (Connection)this.m_target;
            if (validateConnectionStatement == null || validateConnectionStatement.length() == 0 || connection == null) {
                return;
            }
            statement = null;
            try {
                statement = connection.createStatement();
                statement.execute(validateConnectionStatement);
                var8_6 = null;
                ** if (statement == null) goto lbl-1000
            }
            catch (Throwable var7_13) {
                var8_8 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                throw var7_13;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block13;
                catch (Exception e) {
                    cause = e;
                    invalid = true;
                    var8_7 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException e) {}
                    }
                }
            }
        }
        if (invalid) {
            this.throwSQLException("Connection validation failed : " + cause.getMessage(), cause);
        }
    }

    protected void throwSQLException(String message, Exception cause) throws SQLException {
        try {
            this.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        SQLException sqlEx = new SQLException(message, null, 17143);
        sqlEx.initCause(cause);
        throw sqlEx;
    }

    private void setFinalizer(ConnectionFinalizer finalizer) {
        this.m_finalizer = finalizer;
    }

    protected static Connection getConnectionHandle(SQLBCELProxyFactory factory, Connection target, ManagedConnectionImpl managedConnection) throws SQLException {
        SQLBCELProxyBuilder builder = new SQLBCELProxyBuilder(target, null, "java.sql.Connection", factory);
        ConnectionHandle proxy = null;
        try {
            proxy = (ConnectionHandle)factory.getProxy(builder);
            proxy.oc4j_setManagedConnection(managedConnection);
        }
        catch (InstantiationException e) {
            SQLException se = new SQLException(e.toString());
            se.initCause(e);
            throw se;
        }
        catch (ResourceException e) {
            SQLException se = new SQLException(e.toString());
            se.initCause(e);
            throw se;
        }
        Throwable creationStack = null;
        if (DataSourceMessages.isLoggable(Level.FINE)) {
            creationStack = new Throwable();
        }
        if (!proxy.m_managedConnection.getManagedConnectionFactory().isMinimalManagement()) {
            proxy.setFinalizer(new ConnectionFinalizer(proxy, creationStack));
        }
        return proxy;
    }

    protected ConnectionFinalizer getFinalizer() {
        return this.m_finalizer;
    }

    protected void createListenerSet() {
        this.m_listeners = new DeferredOperationHashSet();
    }

    public Object clone() {
        ConnectionHandle clone = (ConnectionHandle)super.clone();
        clone.createListenerSet();
        return clone;
    }

    private class DeferredOperationHashSet
    extends HashSet {
        private ArraySet m_additions = new ArraySet();
        private ArraySet m_removals = new ArraySet();

        private DeferredOperationHashSet() {
        }

        public void deferredAdd(Object obj) {
            this.m_additions.add(obj);
        }

        public void deferredRemove(Object obj) {
            this.m_removals.add(obj);
        }

        public void doPendingOperations() {
            this.doPendingAdds();
            this.doPendingRemoves();
        }

        private void doPendingAdds() {
            int size = this.m_additions.size();
            for (int i = 0; i < size; ++i) {
                this.add(this.m_additions.get(i));
            }
            this.m_additions.clear();
        }

        private void doPendingRemoves() {
            int size = this.m_removals.size();
            for (int i = 0; i < size; ++i) {
                this.remove(this.m_removals.get(i));
            }
            this.m_removals.clear();
        }
    }
}

