/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.spi;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import oracle.j2ee.connector.proxy.AbstractProxy;
import oracle.oc4j.sql.DataSourceUtils;
import oracle.oc4j.sql.proxy.SQLBCELProxy;
import oracle.oc4j.sql.spi.ConnectionHandle;

public abstract class OracleConnectionHandle
extends ConnectionHandle {
    private static Set m_noProxyResultMethods = null;
    private static Method m_getPhysicalConnectionMethod = null;
    private Method m_pingDatabaseMethod = null;

    public OracleConnectionHandle(Object target, SQLBCELProxy parent) {
        super(target, parent);
    }

    public static Set oc4j_getNoProxyResultMethods(ClassLoader loader) throws ClassNotFoundException {
        if (m_noProxyResultMethods == null) {
            m_noProxyResultMethods = new HashSet();
            Class<?> oracleConnectionClass = Class.forName("oracle.jdbc.OracleConnection", true, loader);
            Class<?> internalOracleConnectionClass = Class.forName("oracle.jdbc.internal.OracleConnection", true, loader);
            OracleConnectionHandle.oc4j_addNoProxyResultMethod(oracleConnectionClass, "_getPC", new Class[0]);
            OracleConnectionHandle.oc4j_addNoProxyResultMethod(oracleConnectionClass, "unwrap", new Class[0]);
            OracleConnectionHandle.oc4j_addNoProxyResultMethod(internalOracleConnectionClass, "getPhysicalConnection", new Class[0]);
            OracleConnectionHandle.oc4j_addNoProxyResultMethod(internalOracleConnectionClass, "physicalConnectionWithin", new Class[0]);
            OracleConnectionHandle.oc4j_addNoProxyResultMethod(internalOracleConnectionClass, "getLogicalConnection", new Class[0]);
        }
        return m_noProxyResultMethods;
    }

    private static void oc4j_addNoProxyResultMethod(Class intf, String name, Class[] parameterTypes) {
        try {
            m_noProxyResultMethods.add(intf.getMethod(name, parameterTypes));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected AbstractProxy oc4j_findExistingProxyForTarget(Object target) {
        if (this.m_target == target || this.m_target.equals(target)) {
            return this;
        }
        if (m_getPhysicalConnectionMethod == null) {
            try {
                Class<?> oracleConnectionClass = Class.forName("oracle.jdbc.OracleConnection", true, target.getClass().getClassLoader());
                m_getPhysicalConnectionMethod = oracleConnectionClass.getMethod("getPhysicalConnection", new Class[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (m_getPhysicalConnectionMethod != null && DataSourceUtils.isClass(target.getClass(), "oracle.jdbc.OracleConnection")) {
            try {
                Connection physicalConnection = (Connection)m_getPhysicalConnectionMethod.invoke(this.m_target, new Object[0]);
                if (physicalConnection != null && (physicalConnection == target || physicalConnection.equals(target))) {
                    return this;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean oc4j_isFatalError(SQLException sqlException) {
        boolean retVal = DataSourceUtils.isOracleFatalError(sqlException);
        if (!retVal) {
            retVal = super.oc4j_isFatalError(sqlException);
        }
        return retVal;
    }

    public void oc4j_validate(String validateConnectionStatement) throws SQLException {
        boolean invalid = false;
        Exception cause = null;
        if (validateConnectionStatement != null && validateConnectionStatement.length() > 0) {
            super.oc4j_validate(validateConnectionStatement);
        } else {
            try {
                int retPing;
                Connection physical = (Connection)this.m_target;
                if (physical == null) {
                    return;
                }
                if (this.m_pingDatabaseMethod == null) {
                    Class<?> oracleConnectionClass = Class.forName("oracle.jdbc.OracleConnection", true, physical.getClass().getClassLoader());
                    this.m_pingDatabaseMethod = oracleConnectionClass.getMethod("pingDatabase", Integer.TYPE);
                }
                if ((retPing = ((Integer)this.m_pingDatabaseMethod.invoke((Object)physical, new Integer(0))).intValue()) != 0) {
                    invalid = true;
                }
            }
            catch (Exception e) {
                cause = e;
                invalid = true;
            }
            if (invalid) {
                this.throwSQLException("Connection validation failed : ping return value indicates a problem with the database", cause);
            }
        }
    }

    public boolean isLogicalConnection() {
        return true;
    }
}

