/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.logging.Logger;

public class FileLockUtil {
    private FileChannel s_lockFile = null;
    private FileLock s_lock = null;
    private Logger s_logger = null;
    private static final String LOCK_ACQUIRE_ERROR = ":13";
    private static final long LOCK_REGION_SIZE = File.separatorChar == '\\' ? 1L : 0L;
    private int s_maxRetryCount = 0;

    public FileLockUtil(FileChannel lockFile, Logger logger, int maxRetryCount) {
        this.s_lockFile = lockFile;
        this.s_logger = logger;
        this.s_maxRetryCount = maxRetryCount;
    }

    public void acquire() throws IOException {
        boolean firstWait = true;
        long start = System.currentTimeMillis();
        int retryCount = 0;
        while (this.s_lock == null) {
            block9: {
                try {
                    this.s_lock = this.s_lockFile.tryLock(0L, LOCK_REGION_SIZE, false);
                }
                catch (IOException e) {
                    if (e.getMessage() != null && e.getMessage().indexOf(LOCK_ACQUIRE_ERROR) != -1) break block9;
                    throw (IOException)new IOException("Error, unable to obtain DeploymentLockFile lock").initCause(e);
                }
            }
            if (this.s_lock != null) break;
            if (firstWait) {
                this.log("Waiting for the deployment lock");
                firstWait = false;
            } else {
                this.log("Waiting for the deployment lock again ...");
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                throw (IOException)new IOException("Error, unable to obtain DeploymentLockFile lock").initCause(e);
            }
            if (this.s_maxRetryCount == -1 || ++retryCount < this.s_maxRetryCount) continue;
        }
        if (this.s_lock != null) {
            this.log("Got the deployment lock after waiting for " + (System.currentTimeMillis() - start) / 1000L + " seconds.");
        } else {
            this.log("Failed to get the deployment lock after waiting for " + (System.currentTimeMillis() - start) / 1000L + " seconds.");
        }
    }

    public void release() throws IOException {
        if (null == this.s_lock) {
            throw new IllegalStateException("Attempted to release deployment lock while lock not currently held.");
        }
        try {
            this.s_lock.release();
            this.log("Released the deployment lock.");
        }
        catch (IOException e) {
            throw (IOException)new IOException("Error while releasing deployment lock.").initCause(e);
        }
        finally {
            this.s_lock = null;
        }
    }

    public boolean isLocked() {
        return this.s_lock != null;
    }

    private void log(String value) {
        if (this.s_logger != null) {
            this.s_logger.finest(value);
        } else {
            System.out.println(value);
        }
    }

    public static void main(String[] args) {
        try {
            File f = new File("./LOCKTEST.tmp");
            FileChannel m_lockFile = new RandomAccessFile(f, "rw").getChannel();
            FileLockUtil lock = new FileLockUtil(m_lockFile, null, -1);
            for (int i = 0; i < 10; ++i) {
                lock.acquire();
                System.out.println("lock is acquired");
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                lock.release();
                System.out.println("lock is released");
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

