/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.ReferenceQueue;
import sun.misc.Cleaner;
import sun.misc.JavaLangRefAccess;
import sun.misc.SharedSecrets;

public abstract class Reference<T> {
    private T referent;
    volatile ReferenceQueue<? super T> queue;
    Reference next;
    private transient Reference<T> discovered;
    private static Lock lock = new Lock();
    private static Reference<Object> pending = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean tryHandlePending(boolean bl) {
        Cleaner cleaner;
        Reference<Object> reference;
        ReferenceQueue referenceQueue;
        try {
            referenceQueue = lock;
            synchronized (referenceQueue) {
                if (pending == null) {
                    if (bl) {
                        lock.wait();
                    }
                    return bl;
                }
                reference = pending;
                cleaner = reference instanceof Cleaner ? (Cleaner)reference : null;
                pending = reference.discovered;
                reference.discovered = null;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Thread.yield();
            return true;
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
        if (cleaner != null) {
            cleaner.clean();
            return true;
        }
        referenceQueue = reference.queue;
        if (referenceQueue != ReferenceQueue.NULL) {
            referenceQueue.enqueue(reference);
        }
        return true;
    }

    public T get() {
        return this.referent;
    }

    public void clear() {
        this.referent = null;
    }

    public boolean isEnqueued() {
        return this.queue == ReferenceQueue.ENQUEUED;
    }

    public boolean enqueue() {
        return this.queue.enqueue(this);
    }

    Reference(T t) {
        this(t, null);
    }

    Reference(T t, ReferenceQueue<? super T> referenceQueue) {
        this.referent = t;
        this.queue = referenceQueue == null ? ReferenceQueue.NULL : referenceQueue;
    }

    static {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Object object = threadGroup;
        while (object != null) {
            threadGroup = object;
            object = threadGroup.getParent();
        }
        object = new ReferenceHandler(threadGroup, "Reference Handler");
        ((Thread)object).setPriority(10);
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
        SharedSecrets.setJavaLangRefAccess(new JavaLangRefAccess(){

            @Override
            public boolean tryHandlePendingReference() {
                return Reference.tryHandlePending(false);
            }
        });
    }

    private static class ReferenceHandler
    extends Thread {
        static boolean firstTime = true;
        static final long defaultFinalizerCount = 1L;

        private static void ensureClassInitialized(Class<?> clazz) {
            try {
                Class.forName(clazz.getName(), true, clazz.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Error)new NoClassDefFoundError(classNotFoundException.getMessage()).initCause(classNotFoundException);
            }
        }

        ReferenceHandler(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Reference.tryHandlePending(true);
                if (!firstTime) continue;
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    if (firstTime) {
                        Object object;
                        String string = System.getProperty("java.finalizer.threadCount");
                        long l = 1L;
                        if (string != null && string.length() != 0) {
                            try {
                                object = new Long(string);
                                l = (Long)object;
                            }
                            catch (Exception exception) {
                                System.err.println("Error in java.finalizer.threadCount value");
                            }
                        }
                        object = Thread.currentThread().getThreadGroup();
                        ThreadGroup threadGroup = object;
                        while (threadGroup != null) {
                            object = threadGroup;
                            threadGroup = ((ThreadGroup)object).getParent();
                        }
                        int n = 0;
                        while ((long)n < l - 1L) {
                            ReferenceHandler referenceHandler = new ReferenceHandler((ThreadGroup)object, "Reference Handler");
                            referenceHandler.setPriority(10);
                            referenceHandler.setDaemon(true);
                            referenceHandler.start();
                            ++n;
                        }
                        firstTime = false;
                    }
                }
            }
        }

        static {
            ReferenceHandler.ensureClassInitialized(InterruptedException.class);
            ReferenceHandler.ensureClassInitialized(Cleaner.class);
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

