/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.LookAndFeel;
import javax.swing.MultiUIDefaults;
import javax.swing.RepaintManager;
import javax.swing.SwingPaintEventDispatcher;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.OSInfo;
import sun.awt.PaintEventDispatcher;
import sun.awt.SunToolkit;
import sun.security.action.GetPropertyAction;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;

public class UIManager
implements Serializable {
    private static final Object classLock = new Object();
    private static final String defaultLAFKey = "swing.defaultlaf";
    private static final String auxiliaryLAFsKey = "swing.auxiliarylaf";
    private static final String multiplexingLAFKey = "swing.plaf.multiplexinglaf";
    private static final String installedLAFsKey = "swing.installedlafs";
    private static final String disableMnemonicKey = "swing.disablenavaids";
    private static LookAndFeelInfo[] installedLAFs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LAFState getLAFState() {
        LAFState lAFState = (LAFState)SwingUtilities.appContextGet(SwingUtilities2.LAF_STATE_KEY);
        if (lAFState == null) {
            Object object = classLock;
            synchronized (object) {
                lAFState = (LAFState)SwingUtilities.appContextGet(SwingUtilities2.LAF_STATE_KEY);
                if (lAFState == null) {
                    lAFState = new LAFState();
                    SwingUtilities.appContextPut(SwingUtilities2.LAF_STATE_KEY, lAFState);
                }
            }
        }
        return lAFState;
    }

    private static String makeInstalledLAFKey(String string, String string2) {
        return "swing.installedlaf." + string + "." + string2;
    }

    private static String makeSwingPropertiesFilename() {
        String string = File.separator;
        String string2 = System.getProperty("java.home");
        if (string2 == null) {
            string2 = "<java.home undefined>";
        }
        return string2 + string + "lib" + string + "swing.properties";
    }

    public static LookAndFeelInfo[] getInstalledLookAndFeels() {
        UIManager.maybeInitialize();
        LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getLAFState().installedLAFs;
        if (lookAndFeelInfoArray == null) {
            lookAndFeelInfoArray = installedLAFs;
        }
        LookAndFeelInfo[] lookAndFeelInfoArray2 = new LookAndFeelInfo[lookAndFeelInfoArray.length];
        System.arraycopy(lookAndFeelInfoArray, 0, lookAndFeelInfoArray2, 0, lookAndFeelInfoArray.length);
        return lookAndFeelInfoArray2;
    }

    public static void setInstalledLookAndFeels(LookAndFeelInfo[] lookAndFeelInfoArray) throws SecurityException {
        UIManager.maybeInitialize();
        LookAndFeelInfo[] lookAndFeelInfoArray2 = new LookAndFeelInfo[lookAndFeelInfoArray.length];
        System.arraycopy(lookAndFeelInfoArray, 0, lookAndFeelInfoArray2, 0, lookAndFeelInfoArray.length);
        UIManager.getLAFState().installedLAFs = lookAndFeelInfoArray2;
    }

    public static void installLookAndFeel(LookAndFeelInfo lookAndFeelInfo) {
        LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        LookAndFeelInfo[] lookAndFeelInfoArray2 = new LookAndFeelInfo[lookAndFeelInfoArray.length + 1];
        System.arraycopy(lookAndFeelInfoArray, 0, lookAndFeelInfoArray2, 0, lookAndFeelInfoArray.length);
        lookAndFeelInfoArray2[lookAndFeelInfoArray.length] = lookAndFeelInfo;
        UIManager.setInstalledLookAndFeels(lookAndFeelInfoArray2);
    }

    public static void installLookAndFeel(String string, String string2) {
        UIManager.installLookAndFeel(new LookAndFeelInfo(string, string2));
    }

    public static LookAndFeel getLookAndFeel() {
        UIManager.maybeInitialize();
        return UIManager.getLAFState().lookAndFeel;
    }

    public static void setLookAndFeel(LookAndFeel lookAndFeel) throws UnsupportedLookAndFeelException {
        if (lookAndFeel != null && !lookAndFeel.isSupportedLookAndFeel()) {
            String string = lookAndFeel.toString() + " not supported on this platform";
            throw new UnsupportedLookAndFeelException(string);
        }
        LAFState lAFState = UIManager.getLAFState();
        LookAndFeel lookAndFeel2 = lAFState.lookAndFeel;
        if (lookAndFeel2 != null) {
            lookAndFeel2.uninitialize();
        }
        lAFState.lookAndFeel = lookAndFeel;
        if (lookAndFeel != null) {
            DefaultLookup.setDefaultLookup(null);
            lookAndFeel.initialize();
            lAFState.setLookAndFeelDefaults(lookAndFeel.getDefaults());
        } else {
            lAFState.setLookAndFeelDefaults(null);
        }
        SwingPropertyChangeSupport swingPropertyChangeSupport = lAFState.getPropertyChangeSupport(false);
        if (swingPropertyChangeSupport != null) {
            swingPropertyChangeSupport.firePropertyChange("lookAndFeel", lookAndFeel2, lookAndFeel);
        }
    }

    public static void setLookAndFeel(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        if ("javax.swing.plaf.metal.MetalLookAndFeel".equals(string)) {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
        } else {
            Class<?> clazz = SwingUtilities.loadSystemClass(string);
            UIManager.setLookAndFeel((LookAndFeel)clazz.newInstance());
        }
    }

    public static String getSystemLookAndFeelClassName() {
        String string = AccessController.doPrivileged(new GetPropertyAction("swing.systemlaf"));
        if (string != null) {
            return string;
        }
        String string2 = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        OSInfo.OSType oSType = AccessController.doPrivileged(OSInfo.getOSTypeAction());
        if (oSType == OSInfo.OSType.WINDOWS) {
            return "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        }
        String string3 = AccessController.doPrivileged(new GetPropertyAction("sun.desktop"));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if ("gnome".equals(string3) && toolkit instanceof SunToolkit && ((SunToolkit)toolkit).isNativeGTKAvailable()) {
            return "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
        }
        if (oSType == OSInfo.OSType.MACOSX && toolkit.getClass().getName().equals("sun.lwawt.macosx.LWCToolkit")) {
            return "com.apple.laf.AquaLookAndFeel";
        }
        if (oSType == OSInfo.OSType.SOLARIS || string2.indexOf("HP-UX") != -1) {
            return "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
        }
        return UIManager.getCrossPlatformLookAndFeelClassName();
    }

    public static String getCrossPlatformLookAndFeelClassName() {
        String string = AccessController.doPrivileged(new GetPropertyAction("swing.crossplatformlaf"));
        if (string != null) {
            return string;
        }
        return "javax.swing.plaf.metal.MetalLookAndFeel";
    }

    public static UIDefaults getDefaults() {
        UIManager.maybeInitialize();
        return UIManager.getLAFState().multiUIDefaults;
    }

    public static Font getFont(Object object) {
        return UIManager.getDefaults().getFont(object);
    }

    public static Font getFont(Object object, Locale locale) {
        return UIManager.getDefaults().getFont(object, locale);
    }

    public static Color getColor(Object object) {
        return UIManager.getDefaults().getColor(object);
    }

    public static Color getColor(Object object, Locale locale) {
        return UIManager.getDefaults().getColor(object, locale);
    }

    public static Icon getIcon(Object object) {
        return UIManager.getDefaults().getIcon(object);
    }

    public static Icon getIcon(Object object, Locale locale) {
        return UIManager.getDefaults().getIcon(object, locale);
    }

    public static Border getBorder(Object object) {
        return UIManager.getDefaults().getBorder(object);
    }

    public static Border getBorder(Object object, Locale locale) {
        return UIManager.getDefaults().getBorder(object, locale);
    }

    public static String getString(Object object) {
        return UIManager.getDefaults().getString(object);
    }

    public static String getString(Object object, Locale locale) {
        return UIManager.getDefaults().getString(object, locale);
    }

    static String getString(Object object, Component component) {
        Locale locale = component == null ? Locale.getDefault() : component.getLocale();
        return UIManager.getString(object, locale);
    }

    public static int getInt(Object object) {
        return UIManager.getDefaults().getInt(object);
    }

    public static int getInt(Object object, Locale locale) {
        return UIManager.getDefaults().getInt(object, locale);
    }

    public static boolean getBoolean(Object object) {
        return UIManager.getDefaults().getBoolean(object);
    }

    public static boolean getBoolean(Object object, Locale locale) {
        return UIManager.getDefaults().getBoolean(object, locale);
    }

    public static Insets getInsets(Object object) {
        return UIManager.getDefaults().getInsets(object);
    }

    public static Insets getInsets(Object object, Locale locale) {
        return UIManager.getDefaults().getInsets(object, locale);
    }

    public static Dimension getDimension(Object object) {
        return UIManager.getDefaults().getDimension(object);
    }

    public static Dimension getDimension(Object object, Locale locale) {
        return UIManager.getDefaults().getDimension(object, locale);
    }

    public static Object get(Object object) {
        return UIManager.getDefaults().get(object);
    }

    public static Object get(Object object, Locale locale) {
        return UIManager.getDefaults().get(object, locale);
    }

    public static Object put(Object object, Object object2) {
        return UIManager.getDefaults().put(object, object2);
    }

    public static ComponentUI getUI(JComponent jComponent) {
        UIManager.maybeInitialize();
        UIManager.maybeInitializeFocusPolicy(jComponent);
        ComponentUI componentUI = null;
        LookAndFeel lookAndFeel = UIManager.getLAFState().multiLookAndFeel;
        if (lookAndFeel != null) {
            componentUI = lookAndFeel.getDefaults().getUI(jComponent);
        }
        if (componentUI == null) {
            componentUI = UIManager.getDefaults().getUI(jComponent);
        }
        return componentUI;
    }

    public static UIDefaults getLookAndFeelDefaults() {
        UIManager.maybeInitialize();
        return UIManager.getLAFState().getLookAndFeelDefaults();
    }

    private static LookAndFeel getMultiLookAndFeel() {
        LookAndFeel lookAndFeel = UIManager.getLAFState().multiLookAndFeel;
        if (lookAndFeel == null) {
            String string = "javax.swing.plaf.multi.MultiLookAndFeel";
            String string2 = UIManager.getLAFState().swingProps.getProperty(multiplexingLAFKey, string);
            try {
                Class<?> clazz = SwingUtilities.loadSystemClass(string2);
                lookAndFeel = (LookAndFeel)clazz.newInstance();
            }
            catch (Exception exception) {
                System.err.println("UIManager: failed loading " + string2);
            }
        }
        return lookAndFeel;
    }

    public static void addAuxiliaryLookAndFeel(LookAndFeel lookAndFeel) {
        UIManager.maybeInitialize();
        if (!lookAndFeel.isSupportedLookAndFeel()) {
            return;
        }
        Vector<LookAndFeel> vector = UIManager.getLAFState().auxLookAndFeels;
        if (vector == null) {
            vector = new Vector();
        }
        if (!vector.contains(lookAndFeel)) {
            vector.addElement(lookAndFeel);
            lookAndFeel.initialize();
            UIManager.getLAFState().auxLookAndFeels = vector;
            if (UIManager.getLAFState().multiLookAndFeel == null) {
                UIManager.getLAFState().multiLookAndFeel = UIManager.getMultiLookAndFeel();
            }
        }
    }

    public static boolean removeAuxiliaryLookAndFeel(LookAndFeel lookAndFeel) {
        UIManager.maybeInitialize();
        Vector<LookAndFeel> vector = UIManager.getLAFState().auxLookAndFeels;
        if (vector == null || vector.size() == 0) {
            return false;
        }
        boolean bl = vector.removeElement(lookAndFeel);
        if (bl) {
            if (vector.size() == 0) {
                UIManager.getLAFState().auxLookAndFeels = null;
                UIManager.getLAFState().multiLookAndFeel = null;
            } else {
                UIManager.getLAFState().auxLookAndFeels = vector;
            }
        }
        lookAndFeel.uninitialize();
        return bl;
    }

    public static LookAndFeel[] getAuxiliaryLookAndFeels() {
        UIManager.maybeInitialize();
        Vector<LookAndFeel> vector = UIManager.getLAFState().auxLookAndFeels;
        if (vector == null || vector.size() == 0) {
            return null;
        }
        LookAndFeel[] lookAndFeelArray = new LookAndFeel[vector.size()];
        for (int i = 0; i < lookAndFeelArray.length; ++i) {
            lookAndFeelArray[i] = vector.elementAt(i);
        }
        return lookAndFeelArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = classLock;
        synchronized (object) {
            UIManager.getLAFState().getPropertyChangeSupport(true).addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = classLock;
        synchronized (object) {
            UIManager.getLAFState().getPropertyChangeSupport(true).removePropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyChangeListener[] getPropertyChangeListeners() {
        Object object = classLock;
        synchronized (object) {
            return UIManager.getLAFState().getPropertyChangeSupport(true).getPropertyChangeListeners();
        }
    }

    private static Properties loadSwingProperties() {
        if (UIManager.class.getClassLoader() != null) {
            return new Properties();
        }
        final Properties properties = new Properties();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                OSInfo.OSType oSType = AccessController.doPrivileged(OSInfo.getOSTypeAction());
                if (oSType == OSInfo.OSType.MACOSX) {
                    properties.put(UIManager.defaultLAFKey, UIManager.getSystemLookAndFeelClassName());
                }
                try {
                    File file = new File(UIManager.makeSwingPropertiesFilename());
                    if (file.exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        properties.load(fileInputStream);
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                UIManager.checkProperty(properties, UIManager.defaultLAFKey);
                UIManager.checkProperty(properties, UIManager.auxiliaryLAFsKey);
                UIManager.checkProperty(properties, UIManager.multiplexingLAFKey);
                UIManager.checkProperty(properties, UIManager.installedLAFsKey);
                UIManager.checkProperty(properties, UIManager.disableMnemonicKey);
                return null;
            }
        });
        return properties;
    }

    private static void checkProperty(Properties properties, String string) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            properties.put(string, string2);
        }
    }

    private static void initializeInstalledLAFs(Properties properties) {
        String string = properties.getProperty(installedLAFsKey);
        if (string == null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        Vector<LookAndFeelInfo> vector2 = new Vector<LookAndFeelInfo>(vector.size());
        for (String string2 : vector) {
            String string3 = properties.getProperty(UIManager.makeInstalledLAFKey(string2, "name"), string2);
            String string4 = properties.getProperty(UIManager.makeInstalledLAFKey(string2, "class"));
            if (string4 == null) continue;
            vector2.addElement(new LookAndFeelInfo(string3, string4));
        }
        LookAndFeelInfo[] lookAndFeelInfoArray = new LookAndFeelInfo[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            lookAndFeelInfoArray[i] = (LookAndFeelInfo)vector2.elementAt(i);
        }
        UIManager.getLAFState().installedLAFs = lookAndFeelInfoArray;
    }

    private static void initializeDefaultLAF(Properties properties) {
        if (UIManager.getLAFState().lookAndFeel != null) {
            return;
        }
        String string = null;
        HashMap hashMap = (HashMap)AppContext.getAppContext().remove("swing.lafdata");
        if (hashMap != null) {
            string = (String)hashMap.remove("defaultlaf");
        }
        if (string == null) {
            string = UIManager.getCrossPlatformLookAndFeelClassName();
        }
        string = properties.getProperty(defaultLAFKey, string);
        try {
            UIManager.setLookAndFeel(string);
        }
        catch (Exception exception) {
            throw new Error("Cannot load " + string);
        }
        if (hashMap != null) {
            for (Object k : hashMap.keySet()) {
                UIManager.put(k, hashMap.get(k));
            }
        }
    }

    private static void initializeAuxiliaryLAFs(Properties properties) {
        String string = properties.getProperty(auxiliaryLAFsKey);
        if (string == null) {
            return;
        }
        Vector<LookAndFeel> vector = new Vector<LookAndFeel>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                Class<?> clazz = SwingUtilities.loadSystemClass(string2);
                LookAndFeel lookAndFeel = (LookAndFeel)clazz.newInstance();
                lookAndFeel.initialize();
                vector.addElement(lookAndFeel);
            }
            catch (Exception exception) {
                System.err.println("UIManager: failed loading auxiliary look and feel " + string2);
            }
        }
        if (vector.size() == 0) {
            vector = null;
        } else {
            UIManager.getLAFState().multiLookAndFeel = UIManager.getMultiLookAndFeel();
            if (UIManager.getLAFState().multiLookAndFeel == null) {
                vector = null;
            }
        }
        UIManager.getLAFState().auxLookAndFeels = vector;
    }

    private static void initializeSystemDefaults(Properties properties) {
        UIManager.getLAFState().swingProps = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void maybeInitialize() {
        Object object = classLock;
        synchronized (object) {
            if (!UIManager.getLAFState().initialized) {
                UIManager.getLAFState().initialized = true;
                UIManager.initialize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void maybeInitializeFocusPolicy(JComponent jComponent) {
        if (jComponent instanceof JRootPane) {
            Object object = classLock;
            synchronized (object) {
                if (!UIManager.getLAFState().focusPolicyInitialized) {
                    UIManager.getLAFState().focusPolicyInitialized = true;
                    if (FocusManager.isFocusManagerEnabled()) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
                    }
                }
            }
        }
    }

    private static void initialize() {
        Properties properties = UIManager.loadSwingProperties();
        UIManager.initializeSystemDefaults(properties);
        UIManager.initializeDefaultLAF(properties);
        UIManager.initializeAuxiliaryLAFs(properties);
        UIManager.initializeInstalledLAFs(properties);
        if (RepaintManager.HANDLE_TOP_LEVEL_PAINT) {
            PaintEventDispatcher.setPaintEventDispatcher(new SwingPaintEventDispatcher());
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(new KeyEventPostProcessor(){

            @Override
            public boolean postProcessKeyEvent(KeyEvent keyEvent) {
                Component component = keyEvent.getComponent();
                if ((!(component instanceof JComponent) || component != null && !component.isEnabled()) && JComponent.KeyboardState.shouldProcess(keyEvent) && SwingUtilities.processKeyBindings(keyEvent)) {
                    keyEvent.consume();
                    return true;
                }
                return false;
            }
        });
        AWTAccessor.getComponentAccessor().setRequestFocusController(JComponent.focusController);
    }

    static {
        ArrayList<LookAndFeelInfo> arrayList = new ArrayList<LookAndFeelInfo>(4);
        arrayList.add(new LookAndFeelInfo("Metal", "javax.swing.plaf.metal.MetalLookAndFeel"));
        arrayList.add(new LookAndFeelInfo("Nimbus", "javax.swing.plaf.nimbus.NimbusLookAndFeel"));
        arrayList.add(new LookAndFeelInfo("CDE/Motif", "com.sun.java.swing.plaf.motif.MotifLookAndFeel"));
        OSInfo.OSType oSType = AccessController.doPrivileged(OSInfo.getOSTypeAction());
        if (oSType == OSInfo.OSType.WINDOWS) {
            arrayList.add(new LookAndFeelInfo("Windows", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel"));
            if (Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive") != null) {
                arrayList.add(new LookAndFeelInfo("Windows Classic", "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel"));
            }
        } else if (oSType == OSInfo.OSType.MACOSX) {
            arrayList.add(new LookAndFeelInfo("Mac OS X", "com.apple.laf.AquaLookAndFeel"));
        } else {
            arrayList.add(new LookAndFeelInfo("GTK+", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel"));
        }
        installedLAFs = arrayList.toArray(new LookAndFeelInfo[arrayList.size()]);
    }

    public static class LookAndFeelInfo {
        private String name;
        private String className;

        public LookAndFeelInfo(String string, String string2) {
            this.name = string;
            this.className = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.className;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.getName() + " " + this.getClassName() + "]";
        }
    }

    private static class LAFState {
        Properties swingProps;
        private UIDefaults[] tables = new UIDefaults[2];
        boolean initialized = false;
        boolean focusPolicyInitialized = false;
        MultiUIDefaults multiUIDefaults = new MultiUIDefaults(this.tables);
        LookAndFeel lookAndFeel;
        LookAndFeel multiLookAndFeel = null;
        Vector<LookAndFeel> auxLookAndFeels = null;
        SwingPropertyChangeSupport changeSupport;
        LookAndFeelInfo[] installedLAFs;

        private LAFState() {
        }

        UIDefaults getLookAndFeelDefaults() {
            return this.tables[0];
        }

        void setLookAndFeelDefaults(UIDefaults uIDefaults) {
            this.tables[0] = uIDefaults;
        }

        UIDefaults getSystemDefaults() {
            return this.tables[1];
        }

        void setSystemDefaults(UIDefaults uIDefaults) {
            this.tables[1] = uIDefaults;
        }

        public synchronized SwingPropertyChangeSupport getPropertyChangeSupport(boolean bl) {
            if (bl && this.changeSupport == null) {
                this.changeSupport = new SwingPropertyChangeSupport(UIManager.class);
            }
            return this.changeSupport;
        }
    }
}

