/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent;

import com.eg.agent.LazyInstrumentationThread;
import com.eg.agent.visitor.EgByteCodeWriter;
import com.eg.agent.visitor.EgGenericServletClassVisitor;
import com.eg.agent.visitor.EgHTTPClassVisitor;
import com.eg.agent.visitor.EgJSPClassVisitor;
import com.eg.agent.visitor.EgMAILClassVisitor;
import com.eg.agent.visitor.EgMySQLClassVisitor;
import com.eg.agent.visitor.EgOtherClassVisitor;
import com.eg.agent.visitor.EgPojoClassVisitor;
import com.eg.agent.visitor.EgSQLClassVisitor;
import com.eg.agent.visitor.EgServletClassVisitor;
import com.eg.agent.visitor.EgStrutsClassVisitor;
import com.eg.agent.visitor.EgStrutsTwoClassVisitor;
import com.eg.agent.visitor.EgWebServiceClassVisitor;
import com.eg.jtm.JTMLog;
import com.eg.jtm.PropsManager;
import com.eg.org.objectweb.asm.ClassReader;
import com.eg.org.objectweb.asm.ClassVisitor;
import com.eg.org.objectweb.asm.util.CheckClassAdapter;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgClassFileTransformer
implements ClassFileTransformer {
    private boolean checkExcludeFlag = false;
    private boolean isJDK5 = false;
    private static ArrayList<String> excludeClassList = new ArrayList();
    private static ArrayList<String> excludePackageList = new ArrayList();
    private static ArrayList<String> excludePojoList = new ArrayList();
    private static ArrayList<String> excludePatternList = new ArrayList();
    private static ArrayList<String> LazyList = new ArrayList();
    private static ArrayList<String> includePackageList = new ArrayList();
    private static ArrayList<String> includeClassList = new ArrayList();

    public EgClassFileTransformer(Instrumentation instrumentation, boolean isJDK6, boolean checkExcludeFlag) {
        boolean isRetransformClassesSupported = false;
        if (isJDK6) {
            isRetransformClassesSupported = instrumentation.isRetransformClassesSupported();
            instrumentation.addTransformer(this, isRetransformClassesSupported);
        } else {
            this.isJDK5 = true;
            instrumentation.addTransformer(this);
        }
        this.checkExcludeFlag = checkExcludeFlag;
        if (PropsManager.jtmDebugEnabled) {
            JTMLog.debugLogger.info("JTM Home :" + PropsManager.EG_JTM_HOME);
            JTMLog.debugLogger.info("JTM-Debug is enabled and can be viewed " + PropsManager.EG_JTM_HOME + "/log/JTMDebug.log , (By default)");
        }
        EgClassFileTransformer.prepareExcludeList();
        if (isRetransformClassesSupported) {
            if (LazyList != null && LazyList.size() > 0) {
                LazyInstrumentationThread lazyThread = new LazyInstrumentationThread(instrumentation, isRetransformClassesSupported, LazyList);
                lazyThread.start();
            }
            Class[] classes = instrumentation.getAllLoadedClasses();
            ArrayList<Class> classList = new ArrayList<Class>();
            JTMLog.debugLogger.info("Retransforming URLConnection (or) HttpURLConnection");
            int i = 0;
            while (i < classes.length) {
                if (instrumentation.isModifiableClass(classes[i]) && (classes[i].getName().equals("java.net.URLConnection") || classes[i].getName().equals("sun.net.www.protocol.http.HttpURLConnection"))) {
                    classList.add(classes[i]);
                }
                ++i;
            }
            int size = classList.size();
            if (size > 0) {
                Class[] workaround = new Class[size];
                try {
                    int i2 = 0;
                    while (i2 < classList.size()) {
                        workaround[i2] = (Class)classList.get(i2);
                        ++i2;
                    }
                    instrumentation.retransformClasses(workaround);
                }
                catch (UnmodifiableClassException unmodifiableClassException) {
                    // empty catch block
                }
            }
        }
    }

    public EgClassFileTransformer(boolean checkExcludeFlag) {
        this.checkExcludeFlag = checkExcludeFlag;
    }

    private boolean isValidClassByteArray(byte[] classfileBuffer) {
        return classfileBuffer.length >= 4 && classfileBuffer[0] == -54 && classfileBuffer[0] == -2 && classfileBuffer[0] == -70 && classfileBuffer[0] == -66;
    }

    public boolean isInterface(ClassReader cr) {
        return (cr.getAccess() & 0x200) != 0;
    }

    private static int getClassJavaVersion(ClassReader classReader) {
        return classReader.readUnsignedShort(6);
    }

    public static String verifyClass(byte[] classfileBuffer, ClassLoader loader) {
        StringWriter sw = new StringWriter();
        PrintWriter printer = new PrintWriter(sw);
        CheckClassAdapter.verify(new ClassReader(classfileBuffer), loader, false, printer);
        return sw.toString();
    }

    public static int getExcludeClassSize() {
        int size = -1;
        if (excludeClassList != null) {
            size = excludeClassList.size();
        }
        return size;
    }

    public static int getExcludePojoSize() {
        int size = -1;
        if (excludePojoList != null) {
            size = excludePojoList.size();
        }
        return size;
    }

    static ArrayList getExcludePatternList() {
        return excludePatternList;
    }

    static ArrayList getExcludePackageList() {
        return excludePackageList;
    }

    static ArrayList GetExcludeClassList() {
        return excludeClassList;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        block77: {
            if (className == null) {
                return classfileBuffer;
            }
            if (loader == null && this.isJDK5) {
                return classfileBuffer;
            }
            if (this.isValidClassByteArray(classfileBuffer)) {
                return classfileBuffer;
            }
            if (this.checkExcludeFlag) {
                if (this.isExcludedClass(className)) {
                    return classfileBuffer;
                }
                if (!className.startsWith("sun/net/www/") && this.isExcludedPackage(className)) {
                    return classfileBuffer;
                }
                if (this.isExcludedPattern(className)) {
                    return classfileBuffer;
                }
                if (this.isLazyList(className)) {
                    return classfileBuffer;
                }
            }
            ClassReader classReader = null;
            boolean httpCallFlag = false;
            byte[] originalClassfileBuffer = classfileBuffer;
            if (className.startsWith("java/") || className.startsWith("sun/net/www/")) {
                if (className.equals("java/net/HttpURLConnection") || className.equals("com/sun/net/ssl/internal/www/protocol/https/HttpsURLConnectionOldImpl") || className.equals("java/net/URLConnection") || className.equals("sun/net/www/protocol/http/HttpURLConnection")) {
                    httpCallFlag = true;
                } else {
                    return classfileBuffer;
                }
            }
            if (httpCallFlag) {
                try {
                    classReader = new ClassReader(classfileBuffer);
                }
                catch (Exception e) {
                    return classfileBuffer;
                }
            }
            try {
                classReader = new ClassReader(classfileBuffer);
            }
            catch (Exception exp) {
                return classfileBuffer;
            }
            if (this.isInterface(classReader)) {
                return classfileBuffer;
            }
            String superClassName = classReader.getSuperName();
            boolean isInterface = false;
            String[] interfaces = classReader.getInterfaces();
            if (interfaces != null && interfaces.length > 0) {
                isInterface = true;
            }
            ArrayList<String> thisList = new ArrayList<String>();
            ArrayList allInterFaces = new ArrayList();
            String callType = "Others";
            thisList.add(superClassName);
            ArrayList superList = EgClassFileTransformer.getSuperClassNames(superClassName, thisList, loader);
            if (!httpCallFlag && !isInterface && superList != null && superList.size() == 1 && superList.contains("java/lang/Object")) {
                callType = "POJO";
            } else {
                allInterFaces = EgClassFileTransformer.getAllInterFaces(className, superList, loader);
                if (allInterFaces != null && allInterFaces.size() == 0 && isInterface) {
                    int k = 0;
                    while (k < interfaces.length) {
                        allInterFaces.add(interfaces[k]);
                        ++k;
                    }
                }
            }
            if (callType.equals("Others")) {
                callType = this.findCallType(className, superList, allInterFaces);
            }
            int writerFlag = 1;
            int accpetFlag = 8;
            int classFileversion = EgClassFileTransformer.getClassJavaVersion(classReader);
            if (classFileversion > 50) {
                writerFlag = 2;
                accpetFlag = 12;
            }
            boolean byteCodeVerifyRequired = false;
            if (PropsManager.jtmDebugEnabled) {
                JTMLog.debugLogger.info("[CLASS NAME] :" + className + " Ver :" + classFileversion + " ==>" + " [SUPER CLASSES] :" + superList + " ==>" + " [CALL TYPE] :" + callType + " [ALL-INTERFACES] :" + allInterFaces);
            }
            ClassVisitor classVisitor = null;
            try {
                EgByteCodeWriter classWriter = new EgByteCodeWriter(classReader, loader, writerFlag);
                if (callType.equals("POJO")) {
                    if (PropsManager.isPojoTrack()) {
                        EgPojoClassVisitor pojoClassVisitor = new EgPojoClassVisitor(classWriter, className, loader, classFileversion);
                        byteCodeVerifyRequired = pojoClassVisitor.isByteCodeChanged();
                        classVisitor = pojoClassVisitor;
                    }
                } else if (callType.equals("HTTPSERVLET")) {
                    classVisitor = new EgServletClassVisitor(classWriter, className, loader, classFileversion);
                } else if (callType.equals("GENERICSERVLET")) {
                    classVisitor = new EgGenericServletClassVisitor(classWriter, className, loader, classFileversion);
                } else if (callType.equals("JSP")) {
                    classVisitor = new EgJSPClassVisitor(classWriter, className, loader, classFileversion);
                } else if (callType.equals("HTTP")) {
                    classVisitor = new EgHTTPClassVisitor(classWriter, className, loader, classFileversion);
                } else if (callType.equals("WEBSERVICE")) {
                    classVisitor = new EgWebServiceClassVisitor(classWriter, className, loader, classFileversion);
                } else if (callType.equals("STRUTS")) {
                    classVisitor = new EgStrutsClassVisitor(classWriter, className, loader, classFileversion);
                } else if (callType.equals("STRUTS2")) {
                    classVisitor = new EgStrutsTwoClassVisitor(classWriter, className, loader, classFileversion);
                } else if (callType.equals("EMAIL")) {
                    classVisitor = new EgMAILClassVisitor(classWriter, className, loader, classFileversion);
                } else if (callType.equals("Others")) {
                    if (className.startsWith("net/sourceforge/jtds/jdbc/")) {
                        classVisitor = new EgSQLClassVisitor(classWriter, className, superList, allInterFaces, loader, classFileversion);
                    } else if (className.startsWith("com/microsoft/sqlserver/jdbc/")) {
                        classVisitor = new EgSQLClassVisitor(classWriter, className, superList, allInterFaces, loader, classFileversion);
                    } else if (className.startsWith("com/mysql/jdbc/")) {
                        classVisitor = new EgMySQLClassVisitor(classWriter, className, superList, allInterFaces, loader, classFileversion);
                    } else if (className.startsWith("com/ibm/db2/jcc/")) {
                        classVisitor = new EgSQLClassVisitor(classWriter, className, superList, allInterFaces, loader, classFileversion);
                    } else if (className.startsWith("oracle/jdbc/driver/")) {
                        classVisitor = new EgSQLClassVisitor(classWriter, className, superList, allInterFaces, loader, classFileversion);
                    } else if (className.startsWith("org/postgresql/")) {
                        classVisitor = new EgSQLClassVisitor(classWriter, className, superList, allInterFaces, loader, classFileversion);
                    } else if (className.startsWith("org/hsqldb/jdbc/")) {
                        classVisitor = new EgSQLClassVisitor(classWriter, className, superList, allInterFaces, loader, classFileversion);
                    } else {
                        EgOtherClassVisitor otherClassVisitor = new EgOtherClassVisitor(classWriter, className, superList, allInterFaces, loader, classFileversion);
                        byteCodeVerifyRequired = otherClassVisitor.isByteCodeChanged();
                        classVisitor = otherClassVisitor;
                    }
                }
                if (classVisitor != null) {
                    try {
                        try {
                            classReader.accept(classVisitor, accpetFlag);
                        }
                        catch (Exception exception) {
                            classfileBuffer = classWriter.toByteArray();
                            if (classFileversion <= 50 || !byteCodeVerifyRequired) break block77;
                            try {
                                String bytString = EgClassFileTransformer.verifyClass(classfileBuffer, loader);
                                if (bytString != null && bytString.length() > 0) {
                                    JTMLog.logger.warn("Verify Error : Bytecode of the class " + className + " is not valid, so excluding the class from byte code injection.");
                                    JTMLog.logger.error("\t Invalid Bytecode is  :" + bytString);
                                    classfileBuffer = originalClassfileBuffer;
                                }
                                break block77;
                            }
                            catch (Exception e) {
                                classfileBuffer = originalClassfileBuffer;
                            }
                        }
                        break block77;
                    }
                    finally {
                        classfileBuffer = classWriter.toByteArray();
                        if (classFileversion > 50 && byteCodeVerifyRequired) {
                            try {
                                String bytString = EgClassFileTransformer.verifyClass(classfileBuffer, loader);
                                if (bytString != null && bytString.length() > 0) {
                                    JTMLog.logger.warn("Verify Error : Bytecode of the class " + className + " is not valid, so excluding the class from byte code injection.");
                                    JTMLog.logger.error("\t Invalid Bytecode is  :" + bytString);
                                    classfileBuffer = originalClassfileBuffer;
                                }
                            }
                            catch (Exception e) {
                                classfileBuffer = originalClassfileBuffer;
                            }
                        }
                    }
                }
                classfileBuffer = originalClassfileBuffer;
            }
            catch (Exception exception) {
                if (PropsManager.jtmDebugEnabled) {
                    JTMLog.debugLogger.error(exception.toString(), exception);
                }
                return null;
            }
        }
        return classfileBuffer;
    }

    private String findCallType(String ClassName, ArrayList superClassList, ArrayList interFaceList) {
        String callType = "Others";
        if (ClassName.equals("javax/mail/Transport")) {
            callType = "EMAIL";
            return callType;
        }
        if (ClassName.equals("java/net/HttpURLConnection") || ClassName.equals("com/sun/net/ssl/internal/www/protocol/https/HttpsURLConnectionOldImpl") || ClassName.equals("java/net/URLConnection") || ClassName.equals("sun/net/www/protocol/http/HttpURLConnection")) {
            callType = "HTTP";
            return callType;
        }
        if (ClassName.equals("org/apache/struts/action/ActionServlet")) {
            callType = "STRUTS";
            return callType;
        }
        if (ClassName.startsWith("org/apache/struts2/dispatcher/") && (ClassName.equals("org/apache/struts2/dispatcher/FilterDispatcher") || ClassName.equals("org/apache/struts2/dispatcher/ng/filter/StrutsPrepareAndExecuteFilter") || ClassName.equals("org/apache/struts2/dispatcher/ng/filter/StrutsPrepareFilter") || ClassName.equals("org/apache/struts2/dispatcher/ng/filter/StrutsExecuteFilter"))) {
            callType = "STRUTS2";
            return callType;
        }
        if (ClassName.equals("org/apache/struts2/dispatcher/ActionContextCleanUp")) {
            callType = "STRUTS2";
            return callType;
        }
        if (ClassName.equals("org/apache/jasper/runtime/HttpJspBase") || ClassName.equals("com/caucho/jsp/JavaPage") || ClassName.equals("org/jboss/portal/core/servlet/jsp/PortalJsp") || ClassName.equals("com/bea/portlet/jsp/PortletJspBase") || ClassName.equals("com/ibm/ws/jsp/runtime/HttpJspBase") || ClassName.equals("com/ibm/ws/webcontainer/jsp/runtime/HttpJspBase") || ClassName.equals("weblogic/servlet/jsp/JspBase")) {
            callType = "JSP";
            return callType;
        }
        if (superClassList != null) {
            int superListSize = superClassList.size();
            int k = 0;
            while (k < superListSize) {
                String thisSuperClassName = (String)superClassList.get(k);
                if (thisSuperClassName.equals("javax/xml/soap/SOAPConnection") || interFaceList.indexOf("javax/xml/rpc/Call") >= 0) {
                    callType = "WEBSERVICE";
                    break;
                }
                if (thisSuperClassName.equals("java/net/HttpURLConnection") || thisSuperClassName.equals("com/sun/net/ssl/internal/www/protocol/https/HttpsURLConnectionOldImpl") || thisSuperClassName.equals("java/net/URLConnection") || thisSuperClassName.equals("sun/net/www/protocol/http/HttpURLConnection")) {
                    callType = "HTTP";
                    break;
                }
                if (thisSuperClassName.equals("org/apache/jasper/runtime/HttpJspBase") || thisSuperClassName.equals("com/caucho/jsp/JavaPage") || thisSuperClassName.equals("org/jboss/portal/core/servlet/jsp/PortalJsp") || thisSuperClassName.equals("com/bea/portlet/jsp/PortletJspBase") || thisSuperClassName.equals("com/ibm/ws/jsp/runtime/HttpJspBase") || thisSuperClassName.equals("com/ibm/ws/webcontainer/jsp/runtime/HttpJspBase") || thisSuperClassName.equals("weblogic/servlet/jsp/JspBase")) {
                    callType = "JSP";
                    break;
                }
                if (thisSuperClassName.startsWith("org/apache/struts2") && (thisSuperClassName.equals("org/apache/struts2/dispatcher/FilterDispatcher") || thisSuperClassName.equals("org/apache/struts2/dispatcher/ng/filter/StrutsPrepareAndExecuteFilter") || thisSuperClassName.equals("org/apache/struts2/dispatcher/ng/filter/StrutsPrepareFilter") || thisSuperClassName.equals("org/apache/struts2/dispatcher/ng/filter/StrutsExecuteFilter"))) {
                    callType = "STRUTS2";
                    break;
                }
                if (thisSuperClassName.equals("org/apache/struts2/dispatcher/ActionContextCleanUp")) {
                    callType = "STRUTS2";
                    break;
                }
                if (thisSuperClassName.equals("org/apache/struts/action/ActionServlet")) {
                    callType = "STRUTS";
                    break;
                }
                if (thisSuperClassName.equals("javax/servlet/http/HttpServlet")) {
                    callType = "HTTPSERVLET";
                    break;
                }
                if (thisSuperClassName.equals("javax/servlet/GenericServlet")) {
                    callType = "GENERICSERVLET";
                    break;
                }
                if (thisSuperClassName.equals("javax/mail/Transport")) {
                    callType = "EMAIL";
                    break;
                }
                if (thisSuperClassName.equals("java/lang/Object")) {
                    callType = "Others";
                    break;
                }
                ++k;
            }
        }
        return callType;
    }

    private boolean isExcludedClass(String className) {
        boolean flag = false;
        if (excludeClassList.contains(className) && this.isIncludedPackage(className)) {
            flag = this.isIncludedClass(className);
        }
        return flag;
    }

    private boolean isExcludedPackage(String className) {
        boolean accept = false;
        int k = 0;
        while (k < excludePackageList.size()) {
            String superPackageName = excludePackageList.get(k);
            if (className.startsWith(superPackageName)) {
                if (!this.isIncludedPackage(className)) break;
                accept = this.isIncludedClass(className);
                break;
            }
            ++k;
        }
        return accept;
    }

    private boolean isIncludedPackage(String className) {
        boolean accept = true;
        int s = 0;
        while (s < includePackageList.size()) {
            String subPackageName = includePackageList.get(s);
            if (className.startsWith(subPackageName)) {
                accept = false;
                break;
            }
            ++s;
        }
        return accept;
    }

    private boolean isIncludedClass(String className) {
        boolean accept = true;
        if (includeClassList.contains(className)) {
            accept = false;
        }
        return accept;
    }

    private boolean isExcludedPattern(String className) {
        boolean flag = false;
        int k = 0;
        while (k < excludePatternList.size()) {
            String excludePattern = excludePatternList.get(k);
            if (className.startsWith(excludePattern) || className.indexOf("/" + excludePattern) > 0) {
                if (!this.isIncludedPackage(className)) break;
                flag = this.isIncludedClass(className);
                break;
            }
            ++k;
        }
        return flag;
    }

    private boolean isLazyList(String className) {
        boolean f = false;
        int len = LazyList.size();
        int k = 0;
        while (k < len) {
            String pkgname = LazyList.get(k);
            if (pkgname.startsWith("/")) {
                if (pkgname.endsWith("/") && className.indexOf(pkgname) > 0) {
                    f = true;
                } else if (className.endsWith(pkgname)) {
                    f = true;
                }
            } else if (pkgname.endsWith("/")) {
                if (className.startsWith(pkgname)) {
                    f = true;
                }
            } else if (className.equals(pkgname)) {
                f = true;
            }
            if (f) break;
            ++k;
        }
        return f;
    }

    private static ClassReader getClassReader(String className, ClassLoader loader) {
        ClassReader classReader;
        block12: {
            classReader = null;
            InputStream inputStream = null;
            try {
                try {
                    if (loader != null) {
                        inputStream = loader.getResourceAsStream(String.valueOf(className.replace('.', '/')) + ".class");
                        classReader = new ClassReader(inputStream);
                        break block12;
                    }
                    classReader = new ClassReader(className);
                }
                catch (Exception exception) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return classReader;
    }

    public static ArrayList getSuperClassNames(String className, ArrayList SuperList, ClassLoader loader) {
        ClassReader cr = null;
        String superName = null;
        try {
            cr = EgClassFileTransformer.getClassReader(className, loader);
            superName = cr.getSuperName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (superName != null && !superName.equals("java/lang/Object")) {
            SuperList.add(superName);
            String superClass = superName.replace('.', '/');
            EgClassFileTransformer.getSuperClassNames(superClass, SuperList, loader);
        }
        return SuperList;
    }

    public static ArrayList findSuperInterface(String interfaceName, ArrayList allInterfaceList, ClassLoader loader) {
        block4: {
            ClassReader cr = null;
            try {
                String[] interfaces;
                cr = EgClassFileTransformer.getClassReader(interfaceName, loader);
                if (cr != null && (interfaces = cr.getInterfaces()) != null && interfaces.length > 0) {
                    int k = 0;
                    while (k < interfaces.length) {
                        String ifName = interfaces[k];
                        allInterfaceList.add(ifName);
                        EgClassFileTransformer.findSuperInterface(ifName, allInterfaceList, loader);
                        ++k;
                    }
                }
            }
            catch (Exception e) {
                if (!PropsManager.jtmDebugEnabled) break block4;
                JTMLog.debugLogger.debug("InterFACE NAME :" + interfaceName);
            }
        }
        return allInterfaceList;
    }

    public static ArrayList getAllInterFaces(String className, ArrayList superList, ClassLoader loader) {
        ArrayList<String> interFaceList = new ArrayList<String>();
        ClassReader cr = null;
        try {
            String[] interfaces;
            cr = EgClassFileTransformer.getClassReader(className, loader);
            if (cr != null && (interfaces = cr.getInterfaces()) != null && interfaces.length > 0) {
                int k = 0;
                while (k < interfaces.length) {
                    String ifName = interfaces[k];
                    interFaceList.add(ifName);
                    ArrayList tempList = EgClassFileTransformer.findSuperInterface(ifName, new ArrayList(), loader);
                    if (tempList != null && tempList.size() > 0) {
                        interFaceList.addAll(tempList);
                    }
                    ++k;
                }
            }
            ClassReader cr2 = null;
            int y = 0;
            while (y < superList.size()) {
                String superName = (String)superList.get(y);
                String[] superInterfaces = null;
                try {
                    cr2 = EgClassFileTransformer.getClassReader(superName, loader);
                    if (cr2 != null) {
                        superInterfaces = cr2.getInterfaces();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (superInterfaces != null && superInterfaces.length > 0) {
                    int k = 0;
                    while (k < superInterfaces.length) {
                        String ifName = superInterfaces[k];
                        interFaceList.add(ifName);
                        ArrayList tempList = EgClassFileTransformer.findSuperInterface(ifName, new ArrayList(), loader);
                        if (tempList != null && tempList.size() > 0) {
                            interFaceList.addAll(tempList);
                        }
                        ++k;
                    }
                }
                ++y;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return interFaceList;
    }

    private static ArrayList getLazyList(String lazyString) {
        ArrayList lazyResult = new ArrayList();
        if (lazyString != null && lazyString.length() > 0) {
            HashSet<String> lazySet = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(lazyString, "|");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token == null || token.length() <= 0) continue;
                token = token.trim();
                int first = token.indexOf("*/");
                int last = token.lastIndexOf("/*");
                if (first < 0 && last < 0) {
                    lazySet.add(token);
                    continue;
                }
                if (first >= 0 && last > 0) {
                    lazySet.add(token.substring(first + 1, last + 1));
                    continue;
                }
                if (first >= 0) {
                    lazySet.add(token.substring(first + 1));
                    continue;
                }
                if (last <= 0) continue;
                lazySet.add(token.substring(0, last + 1));
            }
            if (lazySet != null && lazySet.size() > 0) {
                lazyResult = new ArrayList(lazySet);
            }
        }
        return lazyResult;
    }

    public static void prepareExcludeList() {
        block13: {
            Properties excludeProps;
            block12: {
                excludeProps = new Properties();
                if (PropsManager.EG_JTM_HOME == null || PropsManager.EG_JTM_HOME.length() == 0) {
                    PropsManager.EG_JTM_HOME = System.getProperty("EG_JTM_HOME");
                }
                try {
                    excludeProps.load(new BufferedInputStream(new FileInputStream(String.valueOf(PropsManager.EG_JTM_HOME) + "/exclude.props")));
                }
                catch (FileNotFoundException e) {
                    if (PropsManager.jtmDebugEnabled) {
                        JTMLog.debugLogger.warn("[PROPERTIES] " + PropsManager.EG_JTM_HOME + "/exclude.props " + "is not available");
                    }
                }
                catch (IOException e) {
                    if (!PropsManager.jtmDebugEnabled) break block12;
                    JTMLog.debugLogger.warn("[PROPERTIES] " + PropsManager.EG_JTM_HOME + "/exclude.props " + "is not available");
                }
            }
            if (excludeProps != null) {
                String exClassString = excludeProps.getProperty("exclude.class");
                String exPackageString = excludeProps.getProperty("exclude.package.STARTSWITH");
                String exPojoString = excludeProps.getProperty("exclude.pojo");
                String exPatternString = excludeProps.getProperty("exclude.package.CONTAINS");
                String lazyString = excludeProps.getProperty("lazy.retransform.packages");
                String includepackage = excludeProps.getProperty("include.package");
                String includeClass = excludeProps.getProperty("include.class");
                excludeClassList = EgClassFileTransformer.getExcludeClasses(exClassString);
                excludePackageList = EgClassFileTransformer.getExcludePackages(exPackageString);
                excludePojoList = EgClassFileTransformer.getPojoList(exPojoString);
                excludePatternList = EgClassFileTransformer.getExcludePatterns(exPatternString);
                LazyList = EgClassFileTransformer.getLazyList(lazyString);
                includePackageList = EgClassFileTransformer.getIncludePackage(includepackage);
                includeClassList = EgClassFileTransformer.getIncludeClasses(includeClass);
            }
            Properties otherProps = new Properties();
            try {
                otherProps.load(new BufferedInputStream(new FileInputStream(String.valueOf(PropsManager.EG_JTM_HOME) + "/jtmOther.props")));
                String trackPojo = otherProps.getProperty("ENABLE_POJO_PROFILING");
                try {
                    if (trackPojo != null && trackPojo.equalsIgnoreCase("true")) {
                        PropsManager.setPojoTrack(true);
                        break block13;
                    }
                    PropsManager.setPojoTrack(false);
                }
                catch (Exception ee) {
                    PropsManager.setPojoTrack(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (PropsManager.jtmDebugEnabled) {
            JTMLog.debugLogger.info(" ExcludeClassList        \t:" + excludeClassList);
            JTMLog.debugLogger.info(" IncludeClassList        \t:" + includeClassList);
            JTMLog.debugLogger.info(" ExcludePackageList \t\t:" + excludePackageList);
            JTMLog.debugLogger.info(" IncludePackageList \t\t:" + includePackageList);
            JTMLog.debugLogger.info(" ExcludePojoList    \t\t:" + excludePojoList);
            JTMLog.debugLogger.info(" ExcludePatternList \t\t:" + excludePatternList);
            JTMLog.debugLogger.info(" LazyList           \t\t:" + LazyList);
            JTMLog.debugLogger.info(" ENABLE_POJO_PROFILING\t\t:" + PropsManager.isPojoTrack());
        }
    }

    private static ArrayList getIncludeClasses(String includeClass) {
        ArrayList result = new ArrayList();
        if (includeClass != null && includeClass.length() > 0) {
            HashSet<String> resultSet = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(includeClass, "|");
            while (st.hasMoreTokens()) {
                String resultString = st.nextToken();
                if (resultString == null || resultString.length() <= 0) continue;
                resultSet.add(resultString.trim());
            }
            if (resultSet != null && resultSet.size() > 0) {
                result = new ArrayList(resultSet);
            }
        }
        return result;
    }

    private static ArrayList getIncludePackage(String includePackage) {
        ArrayList result = new ArrayList();
        if (includePackage != null && includePackage.length() > 0) {
            HashSet<String> resultSet = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(includePackage, "|");
            while (st.hasMoreTokens()) {
                int len;
                String resultString = st.nextToken();
                if (resultString == null || resultString.length() <= 0 || (len = (resultString = resultString.trim()).length()) <= 2 || !resultString.endsWith("/*")) continue;
                String myString = resultString.substring(0, len - 1);
                resultSet.add(myString);
            }
            if (resultSet != null && resultSet.size() > 0) {
                result = new ArrayList(resultSet);
            }
        }
        return result;
    }

    private static ArrayList getExcludeClasses(String excludeClassString) {
        ArrayList result = new ArrayList();
        if (excludeClassString != null && excludeClassString.length() > 0) {
            HashSet<String> resultSet = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(excludeClassString, "|");
            while (st.hasMoreTokens()) {
                String resultString = st.nextToken();
                if (resultString == null || resultString.length() <= 0) continue;
                resultSet.add(resultString.trim());
            }
            if (resultSet != null && resultSet.size() > 0) {
                result = new ArrayList(resultSet);
            }
        }
        return result;
    }

    private static ArrayList getExcludePackages(String exPackageString) {
        ArrayList result = new ArrayList();
        if (exPackageString != null && exPackageString.length() > 0) {
            HashSet<String> resultSet = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(exPackageString, "|");
            while (st.hasMoreTokens()) {
                int len;
                String resultString = st.nextToken();
                if (resultString == null || resultString.length() <= 0 || (len = (resultString = resultString.trim()).length()) <= 2 || !resultString.endsWith("/*")) continue;
                String myString = resultString.substring(0, len - 1);
                resultSet.add(myString);
            }
            if (resultSet != null && resultSet.size() > 0) {
                result = new ArrayList(resultSet);
            }
        }
        return result;
    }

    private static ArrayList getPojoList(String exPojoString) {
        ArrayList result = new ArrayList();
        if (exPojoString != null && exPojoString.length() > 0) {
            HashSet<String> resultSet = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(exPojoString, "|");
            while (st.hasMoreTokens()) {
                int len;
                String resultString = st.nextToken();
                if (resultString == null || resultString.length() <= 0 || (len = (resultString = resultString.trim()).length()) <= 2 || !resultString.endsWith("/*")) continue;
                String myString = resultString.substring(0, len - 1);
                resultSet.add(myString);
            }
            if (resultSet != null && resultSet.size() > 0) {
                result = new ArrayList(resultSet);
            }
        }
        return result;
    }

    private static ArrayList getExcludePatterns(String exPatternString) {
        ArrayList result = new ArrayList();
        if (exPatternString != null && exPatternString.length() > 0) {
            StringTokenizer st = new StringTokenizer(exPatternString, "|");
            HashSet<String> resultSet = new HashSet<String>();
            while (st.hasMoreTokens()) {
                int len;
                String resultString = st.nextToken();
                if (resultString == null || resultString.length() <= 0 || (len = (resultString = resultString.trim()).length()) <= 4 || !resultString.startsWith("*/") || !resultString.endsWith("/*")) continue;
                resultSet.add(resultString.substring(2, len - 1));
            }
            if (resultSet != null && resultSet.size() > 0) {
                result = new ArrayList(resultSet);
            }
        }
        return result;
    }

    public static boolean isClassPresentExcludePojo(String className) {
        boolean classPresentInExcludePojoList = false;
        int k = 0;
        while (k < excludePojoList.size()) {
            String pojoString = excludePojoList.get(k);
            if (className.startsWith(pojoString)) {
                classPresentInExcludePojoList = true;
                break;
            }
            ++k;
        }
        return classPresentInExcludePojoList;
    }
}

