/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.adapter;

import com.eg.jtm.JTMLog;
import com.eg.jtm.PropsManager;
import com.eg.org.objectweb.asm.Label;
import com.eg.org.objectweb.asm.MethodVisitor;
import com.eg.org.objectweb.asm.Type;
import com.eg.org.objectweb.asm.commons.AdviceAdapter;

public class ConnectionPoolMethodAdviceAdapter
extends AdviceAdapter {
    private String methodName;
    private String className;
    private String description;
    private boolean isConnectMethod;
    private int classFileVersion;
    private static final String INTERFACE_DATASOURCE_GETCONNECT_METHOD1_DESC = "()Ljava/sql/Connection;";
    private static final String INTERFACE_DATASOURCE_GETCONNECT_METHOD2_DESC = "(Ljava/lang/String;Ljava/lang/String;)Ljava/sql/Connection;";
    private static final String INTERFACE_CONNECTIONPOOLDATASOURCE_GETPOOLEDCONNECTION_METHOD1_DESC = "()Ljava/sql/PooledConnection;";
    private static final String INTERFACE_CONNECTIONPOOLDATASOURCE_GETPOOLEDCONNECTION_METHOD2_DESC = "(Ljava/lang/String;Ljava/lang/String;)Ljava/sql/PooledConnection;";
    private static final String INTERFACE_XADATASOURCE_GETXACONNECTION_METHOD1_DESC = "()Ljava/sql/XAConnection;";
    private static final String INTERFACE_XADATASOURCE_GETXACONNECTION_METHOD2_DESC = "(Ljava/lang/String;Ljava/lang/String;)Ljava/sql/XAConnection;";
    private int okFlag = this.newLocal(Type.BOOLEAN_TYPE);
    Label startFinally = new Label();

    public ConnectionPoolMethodAdviceAdapter(int access, MethodVisitor mv, String methodName, String description, String className, int classFileVersion) {
        super(327680, mv, access, methodName, description);
        this.className = className;
        this.methodName = methodName;
        this.description = description;
        this.classFileVersion = classFileVersion;
        this.isConnectMethod = false;
        if (this.methodName.equals("getXAConnection")) {
            if (this.description.equals(INTERFACE_DATASOURCE_GETCONNECT_METHOD1_DESC) || this.description.equals(INTERFACE_DATASOURCE_GETCONNECT_METHOD2_DESC)) {
                this.isConnectMethod = true;
            }
        } else if (this.methodName.equals("getConnection")) {
            if (this.description.equals(INTERFACE_CONNECTIONPOOLDATASOURCE_GETPOOLEDCONNECTION_METHOD1_DESC) || this.description.equals(INTERFACE_CONNECTIONPOOLDATASOURCE_GETPOOLEDCONNECTION_METHOD2_DESC)) {
                this.isConnectMethod = true;
            }
        } else if (this.methodName.equals("getPooledConnection") && (this.description.equals(INTERFACE_XADATASOURCE_GETXACONNECTION_METHOD1_DESC) || this.description.equals(INTERFACE_XADATASOURCE_GETXACONNECTION_METHOD2_DESC))) {
            this.isConnectMethod = true;
        }
        if (PropsManager.jtmDebugEnabled) {
            JTMLog.debugLogger.info("[JDBC-ConnectionPool MethodAdviceAdapter] :" + className + " \t " + methodName + " \t  " + description);
        }
    }

    public void visitCode() {
        super.visitCode();
        this.mv.visitLabel(this.startFinally);
    }

    protected void onMethodEnter() {
        if (this.isConnectMethod) {
            this.mv.visitInsn(3);
            this.mv.visitVarInsn(54, this.okFlag);
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "jdbcConnectionMethodBegin", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", false);
            this.mv.visitVarInsn(54, this.okFlag);
        }
    }

    protected void onMethodExit(int opcode) {
        if (opcode != 191) {
            this.onFinally(opcode);
        }
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinally = new Label();
        this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
        this.mv.visitLabel(endFinally);
        this.onFinally(191);
        this.mv.visitInsn(191);
        super.visitMaxs(maxStack, maxLocals);
    }

    private void onFinally(int opcode) {
        if (this.isConnectMethod) {
            if (opcode == 191) {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(this.className);
                this.mv.visitLdcInsn(this.methodName);
                this.mv.visitLdcInsn(this.description);
                this.mv.visitVarInsn(54, this.okFlag);
                this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "recordSQLException", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", false);
            }
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitVarInsn(21, this.okFlag);
            this.mv.visitLdcInsn(opcode);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "jdbcConnectionMethodEnd", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZI)V", false);
        }
    }
}

