/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.adapter;

import com.eg.jtm.JTMLog;
import com.eg.jtm.PropsManager;
import com.eg.org.objectweb.asm.Label;
import com.eg.org.objectweb.asm.MethodVisitor;
import com.eg.org.objectweb.asm.Type;
import com.eg.org.objectweb.asm.commons.AdviceAdapter;

public class EgHTTPMethodAdviceAdapter
extends AdviceAdapter {
    private String methodName;
    private String className;
    private String description;
    private int classFileVersion;
    private static final String HTTP_CONNECT_METHOD_DESC = "()V";
    private boolean isHttpConnMethod;
    private int okFlag = this.newLocal(Type.BOOLEAN_TYPE);
    Label startFinally = new Label();

    public EgHTTPMethodAdviceAdapter(int access, MethodVisitor mv, String methodName, String description, String className, int classFileVersion) {
        super(327680, mv, access, methodName, description);
        this.className = className;
        this.methodName = methodName;
        this.description = description;
        this.classFileVersion = classFileVersion;
        this.isHttpConnMethod = false;
        if (methodName.equals("connect") && description.equals(HTTP_CONNECT_METHOD_DESC)) {
            this.isHttpConnMethod = true;
        }
        if (PropsManager.jtmDebugEnabled) {
            JTMLog.debugLogger.info(" [HTTP Connection MethodAdviceAdapter] :" + className + " \t " + methodName + " \t  " + description);
        }
    }

    public void visitCode() {
        super.visitCode();
        this.mv.visitLabel(this.startFinally);
    }

    protected void onMethodEnter() {
        if (this.isHttpConnMethod) {
            this.mv.visitInsn(3);
            this.mv.visitVarInsn(54, this.okFlag);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "httpUrlConnMethodBegin", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", false);
            this.mv.visitVarInsn(54, this.okFlag);
        }
    }

    protected void onMethodExit(int opcode) {
        if (opcode != 191) {
            this.onFinally(opcode);
        }
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinally = new Label();
        this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
        this.mv.visitLabel(endFinally);
        this.onFinally(191);
        this.mv.visitInsn(191);
        super.visitMaxs(maxStack, maxLocals);
    }

    private void onFinally(int opcode) {
        if (this.isHttpConnMethod) {
            if (opcode == 191) {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(this.className);
                this.mv.visitLdcInsn(this.methodName);
                this.mv.visitLdcInsn(this.description);
                this.mv.visitVarInsn(21, this.okFlag);
                this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "recordPOJOException", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", false);
            }
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitVarInsn(21, this.okFlag);
            this.mv.visitLdcInsn(opcode);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "httpUrlConnMethodEnd", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZI)V", false);
        }
    }
}

