/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.visitor;

import com.eg.agent.EgClassFileTransformer;
import com.eg.agent.adapter.EgPojoMethodAdviceAdapter;
import com.eg.agent.adapter.EgServletFilterMethodAdviceAdapter;
import com.eg.jtm.JTMLog;
import com.eg.jtm.PropsManager;
import com.eg.org.objectweb.asm.ClassVisitor;
import com.eg.org.objectweb.asm.MethodVisitor;
import java.util.ArrayList;

public class EgOtherClassVisitor
extends ClassVisitor {
    private String className;
    private ArrayList superClassList;
    private boolean servletFilter = false;
    private boolean pojoFlag = false;
    private static final String servletFilterClassName = "javax/servlet/Filter";
    private boolean isExcludePojoClass = false;
    private boolean byteCodeChanged = false;
    private boolean bootLoader = false;
    private int classFileVersion;

    public EgOtherClassVisitor(ClassVisitor classVisitor, String className, ArrayList superClassList, ArrayList interFaceList, ClassLoader loader, int classFileVersion) {
        super(327680, classVisitor);
        this.className = className;
        this.superClassList = superClassList;
        this.bootLoader = loader == null;
        this.isExcludePojoClass = EgClassFileTransformer.isClassPresentExcludePojo(className);
        this.classFileVersion = classFileVersion;
        if (interFaceList != null && interFaceList.size() > 0) {
            if (interFaceList.indexOf(servletFilterClassName) >= 0) {
                this.servletFilter = true;
            }
            this.pojoFlag = !this.servletFilter;
        } else {
            this.pojoFlag = true;
        }
        if (PropsManager.jtmDebugEnabled) {
            JTMLog.debugLogger.info("[EgOtherClassVisitor] :" + className + " \t " + interFaceList + " servletFilter :  " + this.servletFilter + "  pojoFlag :" + this.pojoFlag);
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if ((access & 0x100) != 0 || (access & 0x400) != 0) {
            return mv;
        }
        if (name.equals("<clinit>") || name.equals("<init>")) {
            return mv;
        }
        if (mv != null) {
            if (this.servletFilter) {
                mv = new EgServletFilterMethodAdviceAdapter(access, mv, name, desc, this.className, this.classFileVersion);
            }
            if (PropsManager.isPojoTrack() && this.pojoFlag) {
                boolean proceed = true;
                if (this.isExcludePojoClass || this.bootLoader) {
                    proceed = false;
                }
                if (this.superClassList != null && proceed && (this.superClassList.contains("java/rmi/Remote") || this.superClassList.contains("javax/mail/Transport") || this.superClassList.contains("javax/xml/soap/SOAPConnection") || this.superClassList.contains("javax/naming/directory/DirContext") || this.superClassList.contains("javax/naming/Context"))) {
                    proceed = false;
                }
                if (proceed) {
                    mv = new EgPojoMethodAdviceAdapter(access, mv, name, desc, this.className, this.classFileVersion);
                    this.byteCodeChanged = true;
                }
            }
        }
        return mv;
    }

    public boolean isByteCodeChanged() {
        return this.byteCodeChanged;
    }
}

