/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.JTMLog;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.StringTokenizer;

public class JTMUtils {
    public static final String sepStarLine = "*******************************************************************************************";
    public static final String sepDashLine = "---------------------------------------------";
    public static final String ExcpnRowSep = "?^?";
    public static final int NumRowsInStackTrace = 10;
    private static final Double invalidDouble = new Double(-1.0);
    private static final Long invalidLong = new Long(-1L);
    private static final Integer invalidInteger = new Integer(-1);
    private static final char newLineChar = '\n';
    private static final char space = ' ';
    private static final String acuteRegex = ",N'";
    private static final String acuteReplStr = ",'";

    public static boolean patternMatch(String outString, String searchString) {
        StringTokenizer st;
        int count;
        if (searchString.equals("*")) {
            return true;
        }
        int ir = searchString.indexOf("*");
        if (ir < 0) {
            return outString.equalsIgnoreCase(searchString);
        }
        boolean flag = false;
        boolean startsWithCond = false;
        boolean endsWithCond = false;
        if (!searchString.startsWith("*")) {
            startsWithCond = true;
        }
        if (!searchString.endsWith("*")) {
            endsWithCond = true;
        }
        if ((count = (st = new StringTokenizer(searchString, "*")).countTokens()) <= 0) {
            return false;
        }
        String newString = new String(outString);
        String[] patterns = new String[count];
        int i = 0;
        while (i < count) {
            patterns[i] = st.nextToken();
            ++i;
        }
        int index = 0;
        if (startsWithCond && !newString.startsWith(patterns[0])) {
            return false;
        }
        if (endsWithCond && !newString.endsWith(patterns[count - 1])) {
            return false;
        }
        String s1 = null;
        int j = 0;
        while (j < count) {
            s1 = patterns[j];
            index = newString.indexOf(s1);
            if (index == -1) {
                return false;
            }
            flag = true;
            newString = new String(newString.substring(index += s1.length()));
            ++j;
        }
        return flag;
    }

    public static long getTimeStamp() {
        return System.currentTimeMillis();
    }

    public static String getQueryHeading(String inQry) {
        if (inQry == null) {
            return "";
        }
        StringTokenizer qryTokenizer = new StringTokenizer(inQry.trim());
        int tokCount = qryTokenizer.countTokens();
        String headStr = "";
        if (tokCount == 1) {
            headStr = qryTokenizer.nextToken();
            return headStr;
        }
        headStr = qryTokenizer.nextToken().toUpperCase();
        String tableName = "QUERY";
        if (headStr.startsWith("UPDATE")) {
            tableName = qryTokenizer.nextToken();
        } else if (headStr.startsWith("INSERT")) {
            while (qryTokenizer.hasMoreTokens()) {
                String tmpToken = qryTokenizer.nextToken();
                if (!tmpToken.equalsIgnoreCase("into")) continue;
                tableName = qryTokenizer.nextToken();
                break;
            }
        } else if (headStr.startsWith("SELECT") || headStr.startsWith("DELETE")) {
            while (qryTokenizer.hasMoreTokens()) {
                String tmpToken = qryTokenizer.nextToken();
                if (tmpToken == null || !tmpToken.trim().equalsIgnoreCase("from")) continue;
                tableName = qryTokenizer.nextToken();
            }
        } else if (headStr.startsWith("CREATE") || headStr.startsWith("REPLACE") || headStr.startsWith("TRUNCATE") || headStr.startsWith("DROP")) {
            while (qryTokenizer.hasMoreTokens()) {
                String tmpToken = qryTokenizer.nextToken();
                if (tmpToken.equalsIgnoreCase("table")) {
                    tableName = qryTokenizer.nextToken();
                } else if (tmpToken.equalsIgnoreCase("database")) {
                    tableName = "DATABASE " + qryTokenizer.nextToken();
                } else if (tmpToken.equalsIgnoreCase("index")) {
                    tableName = "INDEX " + qryTokenizer.nextToken();
                } else {
                    if (!tmpToken.equalsIgnoreCase("view")) continue;
                    tableName = "VIEW " + qryTokenizer.nextToken();
                }
                break;
            }
        } else if (headStr.startsWith("ALTER")) {
            while (qryTokenizer.hasMoreTokens()) {
                String tmpToken = qryTokenizer.nextToken();
                if (!tmpToken.equalsIgnoreCase("table")) continue;
                tableName = qryTokenizer.nextToken();
                break;
            }
        } else {
            tableName = "QUERY";
        }
        if (tableName.indexOf("(") > 0) {
            tableName = tableName.substring(0, tableName.indexOf("("));
        }
        headStr = String.valueOf(tableName) + " - " + headStr;
        return headStr;
    }

    public static String prepQryForUI(String inQry) {
        String tempQry;
        if (inQry.indexOf(10) == -1) {
            tempQry = inQry;
        } else {
            StringTokenizer myTokenizer = new StringTokenizer(inQry, "\n");
            StringBuffer myBuffer = new StringBuffer();
            int tokCount = myTokenizer.countTokens();
            int k = 0;
            while (k < tokCount) {
                String myToken = myTokenizer.nextToken();
                if (myToken != null && myToken.length() > 0) {
                    myBuffer.append(myToken.trim());
                    myBuffer.append(' ');
                }
                ++k;
            }
            tempQry = myBuffer.toString();
        }
        if (tempQry.indexOf(acuteRegex) != -1) {
            return tempQry.replaceAll(acuteRegex, acuteReplStr);
        }
        return tempQry;
    }

    public static double measurize(double rawVal) {
        return (double)Math.round(rawVal * 10000.0) / 10000.0;
    }

    public static double measurize(double rawVal, int precision) {
        precision = precision > 0 ? precision : 1;
        return (double)Math.round(rawVal * ((double)precision * 10.0)) / ((double)precision * 10.0);
    }

    public static String STEs2Str(Throwable t) {
        return JTMUtils.partialSTEs2Str(t, -1);
    }

    public static String partialSTEs2Str(Throwable t) {
        return JTMUtils.partialSTEs2Str(t, 10);
    }

    public static String partialSTEs2Str(Throwable t, int numRows) {
        StringBuffer TraceSB = new StringBuffer();
        StackTraceElement[] STEArr = t.getStackTrace();
        String shortExpDes = t.toString().trim();
        StringTokenizer expTokenizer = new StringTokenizer(shortExpDes, "\n");
        StringBuffer expBuffer = new StringBuffer();
        while (expTokenizer.hasMoreTokens()) {
            String expToken = expTokenizer.nextToken();
            if (expToken == null || expToken.length() <= 0) continue;
            expBuffer.append(expToken.trim());
            expBuffer.append(' ');
        }
        TraceSB.append(expBuffer).append(ExcpnRowSep);
        int totalRows = STEArr.length;
        if (numRows < 1 || numRows > totalRows) {
            numRows = totalRows;
        }
        int i = 0;
        while (i < numRows) {
            String stackLine = STEArr[i].toString().trim();
            if (stackLine != null && stackLine.length() > 0 && !stackLine.equals("\n")) {
                TraceSB.append(stackLine).append(ExcpnRowSep);
            }
            ++i;
        }
        return TraceSB.toString();
    }

    public static String partialSTEs2Str(StackTraceElement[] STEArr, int numRows) {
        StringBuffer TraceSB = new StringBuffer();
        int totalRows = STEArr.length;
        if (numRows < 1 || numRows > totalRows) {
            numRows = totalRows;
        }
        int i = 0;
        while (i < numRows) {
            String stackLine = STEArr[i].toString().trim();
            if (stackLine != null && stackLine.length() > 0 && !stackLine.equals("\n")) {
                TraceSB.append(stackLine).append(ExcpnRowSep);
            }
            ++i;
        }
        return TraceSB.toString();
    }

    public static String STEs2Str(StackTraceElement[] STEArr) {
        return JTMUtils.partialSTEs2Str(STEArr, -1);
    }

    public static String checkPortAvailability(String portStr) {
        ServerSocket tempSrvSock;
        int port;
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException nfe) {
            return "port number " + portStr + " is not valid";
        }
        try {
            tempSrvSock = new ServerSocket(port);
        }
        catch (Exception e) {
            if (e instanceof BindException) {
                JTMLog.logger.warn("BindException from checkPortAvailability for " + port, e);
                return "Port " + port + " may already be in use.";
            }
            JTMLog.logger.warn("Exception while checking PortAvailability for " + port, e);
            return "Exception while checking availability of port " + port;
        }
        try {
            JTMLog.logger.info("Closing temporary server socket");
            tempSrvSock.close();
        }
        catch (IOException ioe) {
            JTMLog.logger.error("Exception while closing temporary server socket", ioe);
            return "Could not close server socket created for testing connection properties! : " + ioe.toString();
        }
        return null;
    }

    public static Double String2Double(String str) {
        Double retVal = invalidDouble;
        try {
            retVal = new Double(str);
        }
        catch (NumberFormatException nfe) {
            JTMLog.logger.warn("Obtained invalid double value " + str, nfe);
        }
        return retVal;
    }

    public static Long String2Long(String str) {
        Long retVal = invalidLong;
        try {
            retVal = new Long(str);
        }
        catch (NumberFormatException nfe) {
            JTMLog.logger.warn("Obtained invalid long value " + str, nfe);
        }
        return retVal;
    }

    public static Integer String2Integer(String str) {
        Integer retVal = invalidInteger;
        try {
            retVal = new Integer(str);
        }
        catch (NumberFormatException nfe) {
            JTMLog.logger.warn("Obtained invalid int value " + str, nfe);
        }
        return retVal;
    }

    public static Boolean String2Boolean(String str) {
        if (str.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

