/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.agent.EgClassFileTransformer;
import com.eg.jtm.JTMLog;
import com.eg.jtm.JTMUtils;
import com.eg.jtm.LogbackManager;
import com.eg.jtm.PropsManager;
import com.eg.jtm.UPDManager;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.TimerTask;

public class TrackerTask
extends TimerTask {
    private long lastModLogProps = -1L;
    private long lastModConnProps = -1L;
    private long lastModOtherProps = -1L;
    static PrintWriter pw = null;
    private String jtmHome = null;
    private boolean isJtmHomeOk;
    private boolean logPropsFileValid = false;
    private boolean connPropsFileValid = false;
    private boolean otherPropsFileValid = false;
    private String currPortStr;
    private String currDesigAgt;

    public TrackerTask() {
        try {
            if (PropsManager.connPropsFile == null || PropsManager.otherPropsFile == null || PropsManager.logPropsFile == null) {
                this.jtmHome = PropsManager.EG_JTM_HOME = System.getProperty("EG_JTM_HOME");
                PropsManager.setPropFileNames();
            }
            this.logPropsFileValid = PropsManager.isPropsFileValid(PropsManager.logPropsFile);
            this.connPropsFileValid = PropsManager.isPropsFileValid(PropsManager.connPropsFile);
            this.otherPropsFileValid = PropsManager.isPropsFileValid(PropsManager.otherPropsFile);
            if (this.otherPropsFileValid) {
                PropsManager.initProps();
                PropsManager.loadPropsFromFile();
                if (EgClassFileTransformer.getExcludeClassSize() <= 0 || EgClassFileTransformer.getExcludePojoSize() <= 0) {
                    EgClassFileTransformer.prepareExcludeList();
                }
            }
            this.jtmHome = PropsManager.EG_JTM_HOME;
            this.isJtmHomeOk = this.jtmHome != null && this.jtmHome.length() > 0;
        }
        catch (Exception e) {
            JTMLog.logger.error(" Exception Occured in  TrackerTask Contructor.....", e);
            this.isJtmHomeOk = false;
        }
    }

    public void run() {
        this.trackConnProps();
        this.trackLogProps();
        this.trackOtherProps();
    }

    private void trackOtherProps() {
        try {
            long currLastMod;
            if (this.otherPropsFileValid && this.isJtmHomeOk && this.lastModOtherProps != (currLastMod = PropsManager.otherPropsFile.lastModified())) {
                Properties otherProps = new Properties();
                otherProps.load(new BufferedInputStream(new FileInputStream(PropsManager.otherPropsFile)));
                String debugString = otherProps.getProperty("Debug");
                if (debugString != null && debugString.length() > 0 && debugString.equalsIgnoreCase("true")) {
                    if (!PropsManager.jtmDebugEnabled) {
                        PropsManager.jtmDebugEnabled = true;
                    }
                } else {
                    PropsManager.jtmDebugEnabled = false;
                }
                PropsManager.loadPropsFromFile();
                PropsManager.updateOtherJTMProps();
                this.lastModOtherProps = currLastMod;
            }
        }
        catch (Exception e) {
            JTMLog.logger.error("Exception Occured in trackOtherProps ....", e);
        }
    }

    private void trackLogProps() {
        if (!this.logPropsFileValid || JTMLog.isNone) {
            return;
        }
        long currLastMod = PropsManager.logPropsFile.lastModified();
        if (this.lastModLogProps == -1L) {
            this.lastModLogProps = currLastMod;
            return;
        }
        if (this.lastModLogProps != currLastMod) {
            JTMLog.logger.info("Modification detected for file " + PropsManager.logPropsFileName);
            this.modifyLogProperties();
            this.lastModLogProps = currLastMod;
        }
    }

    private void modifyLogProperties() {
        Properties logProps = new Properties();
        try {
            logProps.load(new BufferedInputStream(new FileInputStream(PropsManager.logPropsFileName)));
            LogbackManager.updateLogProps(logProps);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        logProps = null;
    }

    private void trackConnProps() {
        if (!this.connPropsFileValid) {
            return;
        }
        long currLastMod = PropsManager.connPropsFile.lastModified();
        if (this.lastModConnProps != currLastMod) {
            JTMLog.logger.info("Modification detected for file " + PropsManager.connPropsFileName);
            this.checkAndSetConnProps();
            this.lastModConnProps = currLastMod;
        }
    }

    private void checkAndSetConnProps() {
        String newPortStr;
        Properties connProps = new Properties();
        try {
            connProps.load(new BufferedInputStream(new FileInputStream(PropsManager.connPropsFile)));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        String newDesigAgt = connProps.getProperty("Designated_Agent");
        if (newDesigAgt != null && newDesigAgt.length() > 0) {
            if (this.currDesigAgt == null || this.currDesigAgt != null && !this.currDesigAgt.equals(newDesigAgt)) {
                String DACheckStr = this.chkDesigAgtValidity(newDesigAgt);
                if (DACheckStr == null) {
                    UPDManager.setDesigAgtInetAddr(newDesigAgt);
                    this.currDesigAgt = newDesigAgt;
                } else {
                    JTMLog.logger.warn("New Designated Agent in jtm connection properties file seems to be invalid : " + DACheckStr + ". Please rectify.");
                }
            }
        } else {
            this.currDesigAgt = null;
            UPDManager.resetDesigAgtInetAddr();
        }
        if ((newPortStr = connProps.getProperty("JTM_Port")) != null) {
            if (this.currPortStr == null || this.currPortStr != null && !this.currPortStr.equals(newPortStr)) {
                String portCheckStr = JTMUtils.checkPortAvailability(newPortStr);
                if (portCheckStr == null) {
                    UPDManager.setJTMPort(newPortStr);
                    this.currPortStr = newPortStr;
                } else {
                    JTMLog.logger.warn("New port in jtm connection properties file is invalid/unavailable : " + portCheckStr + ". Please rectify.");
                }
            }
        } else {
            JTMLog.logger.warn("Please provide the JTM Port value in the JTM connection properties file.");
        }
    }

    private String chkDesigAgtValidity(String DesigAgtToChk) {
        try {
            InetAddress.getByName(DesigAgtToChk);
        }
        catch (UnknownHostException uhe) {
            return "Designated Agent cannot be resolved.";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Cannot determine validity of designated agent." + e.toString();
        }
        return null;
    }
}

