/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.text.NumberFormat;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;

public class PrestimeCPUCCTNodeBacked
extends PrestimeCPUCCTNode {
    private static NumberFormat percentFormat = null;
    protected int compactDataOfs;
    protected int nChildren;

    public PrestimeCPUCCTNodeBacked(CPUCCTContainer cPUCCTContainer, PrestimeCPUCCTNode prestimeCPUCCTNode, int n) {
        super(cPUCCTContainer, prestimeCPUCCTNode);
        this.compactDataOfs = n;
        this.container = cPUCCTContainer;
        this.nChildren = cPUCCTContainer.getNChildrenForNodeOfs(n);
    }

    protected PrestimeCPUCCTNodeBacked(CPUCCTContainer cPUCCTContainer, PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray) {
        super(cPUCCTContainer, null);
        this.setThreadNode();
        this.children = prestimeCPUCCTNodeArray;
        this.nChildren = prestimeCPUCCTNodeArray.length;
        for (int i = 0; i < this.nChildren; ++i) {
            prestimeCPUCCTNodeArray[i].parent = this;
        }
    }

    protected PrestimeCPUCCTNodeBacked() {
    }

    @Override
    public CCTNode getChild(int n) {
        this.getChildren();
        if (n < this.children.length) {
            return this.children[n];
        }
        return null;
    }

    @Override
    public CCTNode[] getChildren() {
        if (this.nChildren == 0) {
            return null;
        }
        if (this.children != null) {
            return this.children;
        }
        int n = this.isThreadNode() ? 0 : 1;
        this.children = new PrestimeCPUCCTNode[this.nChildren + n];
        for (int i = 0; i < this.nChildren; ++i) {
            int n2 = this.container.getChildOfsForNodeOfs(this.compactDataOfs, i);
            this.children[i + n] = new PrestimeCPUCCTNodeBacked(this.container, this, n2);
        }
        if (n > 0) {
            this.children[0] = this.createSelfTimeNodeForThisNode();
            ++this.nChildren;
        }
        this.sortChildren(this.container.getCPUResSnapshot().getSortBy(), this.container.getCPUResSnapshot().getSortOrder());
        return this.children;
    }

    @Override
    public int getMethodId() {
        return this.container.getMethodIdForNodeOfs(this.compactDataOfs);
    }

    @Override
    public int getNCalls() {
        return this.container.getNCallsForNodeOfs(this.compactDataOfs);
    }

    @Override
    public int getNChildren() {
        if (this.children == null) {
            int n = this.nChildren > 0 ? (this.isThreadNode() ? 0 : 1) : 0;
            return this.nChildren + n;
        }
        return this.nChildren;
    }

    @Override
    public long getSleepTime0() {
        return this.container.getSleepTime0ForNodeOfs(this.compactDataOfs);
    }

    @Override
    public int getThreadId() {
        return this.container.getThreadId();
    }

    @Override
    public long getTotalTime0() {
        if (!this.isSelfTimeNode()) {
            return this.container.getTotalTime0ForNodeOfs(this.compactDataOfs);
        }
        return this.container.getSelfTime0ForNodeOfs(this.compactDataOfs);
    }

    @Override
    public float getTotalTime0InPerCent() {
        float f = (float)(this.container.getWholeGraphNetTime0() > 0L ? (double)this.getTotalTime0() / (double)this.container.getWholeGraphNetTime0() * 100.0 : 0.0);
        return f < 100.0f ? f : 100.0f;
    }

    @Override
    public long getTotalTime1() {
        if (!this.isSelfTimeNode()) {
            return this.container.getTotalTime1ForNodeOfs(this.compactDataOfs);
        }
        return this.container.getSelfTime1ForNodeOfs(this.compactDataOfs);
    }

    @Override
    public float getTotalTime1InPerCent() {
        return (float)(this.container.getWholeGraphNetTime1() > 0L ? (double)this.getTotalTime1() / (double)this.container.getWholeGraphNetTime1() * 100.0 : 0.0);
    }

    @Override
    public long getWaitTime0() {
        return this.container.getWaitTime0ForNodeOfs(this.compactDataOfs);
    }

    @Override
    public void sortChildren(int n, boolean bl) {
        this.container.getCPUResSnapshot().saveSortParams(n, bl);
        if (this.nChildren == 0 || this.children == null) {
            return;
        }
        this.doSortChildren(n, bl);
    }

    protected PrestimeCPUCCTNode createSelfTimeNodeForThisNode() {
        PrestimeCPUCCTNodeBacked prestimeCPUCCTNodeBacked = new PrestimeCPUCCTNodeBacked();
        prestimeCPUCCTNodeBacked.setSelfTimeNode();
        prestimeCPUCCTNodeBacked.compactDataOfs = this.compactDataOfs;
        prestimeCPUCCTNodeBacked.container = this.container;
        prestimeCPUCCTNodeBacked.parent = this;
        return prestimeCPUCCTNodeBacked;
    }

    public void exportXMLData(ExportDataDumper exportDataDumper, String string) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(string + "<node>" + string2);
        stringBuffer.append(string + " <Name>" + this.replaceHTMLCharacters(this.getNodeName()) + "</Name>" + string2);
        stringBuffer.append(string + " <Parent>" + this.replaceHTMLCharacters(this.getParent() == null ? "none" : ((PrestimeCPUCCTNodeBacked)this.getParent()).getNodeName()) + "</Parent>" + string2);
        stringBuffer.append(string + " <Time_Relative>" + percentFormat.format((double)this.getTotalTime0InPerCent() / 100.0) + "</Time_Relative>" + string2);
        stringBuffer.append(string + " <Time>" + this.getTotalTime0() + "</Time>" + string2);
        stringBuffer.append(string + " <Invocations>" + this.getNCalls() + "</Invocations>" + string2);
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (int i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)this.children[i]).exportXMLData(exportDataDumper, string + "  ");
            }
        } else if (this.nChildren > 0) {
            int n = this.nChildren;
            PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray = (PrestimeCPUCCTNode[])this.getChildren();
            this.children = null;
            for (int i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)prestimeCPUCCTNodeArray[i]).exportXMLData(exportDataDumper, string + "  ");
            }
            prestimeCPUCCTNodeArray = null;
            this.nChildren = n;
        }
        stringBuffer = new StringBuffer(string + "</node>");
        exportDataDumper.dumpData(stringBuffer);
    }

    public void exportHTMLData(ExportDataDumper exportDataDumper, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("<tr><td class=\"method\"><pre class=\"method\">.");
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(".");
        }
        stringBuffer.append(this.replaceHTMLCharacters(this.getNodeName()) + "</pre></td><td class=\"right\">" + percentFormat.format((double)this.getTotalTime0InPerCent() / 100.0) + "</td><td class=\"right\">" + this.getTotalTime0() + "</td><td class=\"right\">" + this.getNCalls() + "</td></tr>");
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (n2 = 0; n2 < this.nChildren; ++n2) {
                ((PrestimeCPUCCTNodeBacked)this.children[n2]).exportHTMLData(exportDataDumper, n + 1);
            }
        } else if (this.nChildren > 0) {
            n2 = this.nChildren;
            PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray = (PrestimeCPUCCTNode[])this.getChildren();
            this.children = null;
            for (int i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)prestimeCPUCCTNodeArray[i]).exportHTMLData(exportDataDumper, n + 1);
            }
            prestimeCPUCCTNodeArray = null;
            this.nChildren = n2;
        }
    }

    private String replaceHTMLCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public void exportCSVData(String string, int n, ExportDataDumper exportDataDumper) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "\r\n";
        String string3 = "\"";
        String string4 = " ";
        stringBuffer.append(string3);
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(this.getNodeName() + string3 + string);
        stringBuffer.append(string3 + this.getTotalTime0InPerCent() + string3 + string);
        stringBuffer.append(string3 + this.getTotalTime0() + string3 + string);
        stringBuffer.append(string3 + this.getNCalls() + string3 + string2);
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (n2 = 0; n2 < this.nChildren; ++n2) {
                ((PrestimeCPUCCTNodeBacked)this.children[n2]).exportCSVData(string, n + 1, exportDataDumper);
            }
        } else if (this.nChildren > 0) {
            n2 = this.nChildren;
            PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray = (PrestimeCPUCCTNode[])this.getChildren();
            this.children = null;
            for (int i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)prestimeCPUCCTNodeArray[i]).exportCSVData(string, n + 1, exportDataDumper);
            }
            prestimeCPUCCTNodeArray = null;
            this.nChildren = n2;
        }
    }

    public static void setPercentFormat(NumberFormat numberFormat) {
        percentFormat = numberFormat;
    }
}

