/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.visitor;

import com.eg.agent.adapter.ConnectionPoolMethodAdviceAdapter;
import com.eg.agent.adapter.EgDriverMethodAdviceAdapter;
import com.eg.agent.adapter.EgMySQLConnectionMethodAdviceAdapter;
import com.eg.agent.adapter.EgMySQLStatmentMethodAdviceAdapter;
import com.eg.agent.adapter.EgSQLCallableStatmentMethodAdviceAdapter;
import com.eg.agent.adapter.EgSQLPreparedStatmentMethodAdviceAdapter;
import com.eg.org.objectweb.asm.ClassVisitor;
import com.eg.org.objectweb.asm.MethodVisitor;
import java.util.ArrayList;

public class EgMySQLClassVisitor
extends ClassVisitor {
    private String className;
    private boolean driverFlag = false;
    private boolean connectionFlag = false;
    private boolean connectionPoolFlag = false;
    private boolean isCallableStmt = false;
    private boolean isPreparedStmt = false;
    private boolean isStmt = false;
    private int classFileVersion;

    public EgMySQLClassVisitor(ClassVisitor classVisitor, String className, ArrayList superClassList, ArrayList interFaceList, ClassLoader loader, int classFileVersion) {
        super(327680, classVisitor);
        this.className = className;
        this.classFileVersion = classFileVersion;
        if (interFaceList != null && interFaceList.size() > 0) {
            if (interFaceList.indexOf("java/sql/CallableStatement") >= 0) {
                this.isCallableStmt = true;
            } else if (interFaceList.indexOf("java/sql/PreparedStatement") >= 0) {
                this.isPreparedStmt = true;
            } else if (interFaceList.indexOf("java/sql/Statement") >= 0) {
                this.isStmt = true;
            } else if (interFaceList.indexOf("java/sql/Driver") >= 0) {
                this.driverFlag = true;
            } else if (interFaceList.indexOf("java/sql/Connection") >= 0) {
                this.connectionFlag = true;
            } else if (interFaceList.indexOf("javax/sql/DataSource") >= 0 || interFaceList.indexOf("javax/sql/ConnectionPoolDataSource") >= 0 || interFaceList.indexOf("javax/sql/XADataSource") >= 0) {
                this.connectionPoolFlag = true;
            }
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if ((access & 0x100) != 0 || (access & 0x400) != 0) {
            return mv;
        }
        if (name.equals("<clinit>") || name.equals("<init>")) {
            return mv;
        }
        if (mv != null) {
            if (this.driverFlag) {
                mv = new EgDriverMethodAdviceAdapter(access, mv, name, desc, this.className, this.classFileVersion);
            } else if (this.connectionPoolFlag) {
                mv = new ConnectionPoolMethodAdviceAdapter(access, mv, name, desc, this.className, this.classFileVersion);
            } else if (this.connectionFlag) {
                mv = new EgMySQLConnectionMethodAdviceAdapter(access, mv, name, desc, this.className, this.classFileVersion);
            } else if (this.isCallableStmt) {
                mv = new EgSQLCallableStatmentMethodAdviceAdapter(access, mv, name, desc, this.className, this.classFileVersion);
            } else if (this.isPreparedStmt) {
                mv = new EgSQLPreparedStatmentMethodAdviceAdapter(access, mv, name, desc, this.className, this.classFileVersion);
            } else if (this.isStmt) {
                mv = new EgMySQLStatmentMethodAdviceAdapter(access, mv, name, desc, this.className, this.classFileVersion);
            }
        }
        return mv;
    }
}

