/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.JTMLog;
import com.eg.jtm.PropsManager;
import com.eg.jtm.SnapshotManager;
import com.eg.jtm.URLPatternData;
import com.eg.jtm.URLPatternMeasure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;

public class UPDManager {
    private static Hashtable<String, URLPatternData> UPDTblWC1 = new Hashtable();
    private static Hashtable<String, URLPatternData> UPDTblWC2 = new Hashtable();
    private static Hashtable<String, URLPatternMeasure> UPMTblTC = new Hashtable();
    private static boolean workingCopy1_isProcessing = false;
    private static boolean isValidPattern = true;

    public static void updatePatternData(String patternsString) {
        ArrayList<String> currentPatternsList = new ArrayList<String>();
        if (patternsString != null) {
            if (patternsString.equalsIgnoreCase("none")) {
                UPDManager.setValidPattern(false);
            } else {
                String[] patterns = patternsString.split(",");
                if (patterns.length != 0) {
                    String[] stringArray = patterns;
                    int n = patterns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String pattern = stringArray[n2];
                        String[] patternNameAndStr = pattern.split(":");
                        String patternName = patternNameAndStr[0].trim();
                        String patternValue = patternNameAndStr[1].trim();
                        currentPatternsList.add(patternName);
                        PropsManager.patternTbl.put(patternName, patternValue);
                        ++n2;
                    }
                }
            }
        } else {
            UPDManager.setValidPattern(false);
        }
        if (isValidPattern) {
            Hashtable cloneTable = (Hashtable)PropsManager.patternTbl.clone();
            Enumeration patternEnum = cloneTable.keys();
            UPDManager.setValidPattern(true);
            while (patternEnum.hasMoreElements()) {
                String pName = (String)patternEnum.nextElement();
                if (currentPatternsList.contains(pName)) continue;
                UPDManager.removePatternData(pName);
            }
        }
        currentPatternsList.clear();
        currentPatternsList = null;
        UPDManager.updateTbls();
        JTMLog.logger.info("URL Pattern data updated with " + PropsManager.patternTbl.toString());
    }

    public static boolean isValidPattern() {
        return isValidPattern;
    }

    public static void setValidPattern(boolean isValidPattern) {
        UPDManager.isValidPattern = isValidPattern;
        if (!isValidPattern) {
            PropsManager.patternTbl.clear();
            UPDTblWC1.clear();
            UPDTblWC2.clear();
            UPMTblTC.clear();
        }
    }

    public static void updateFilteredPatternsTbl(String patternsString) {
        PropsManager.FilteredPatternsList.clear();
        if (!patternsString.equalsIgnoreCase("None") && patternsString.trim().length() != 0) {
            String[] patterns;
            String[] stringArray = patterns = patternsString.split(",");
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                PropsManager.FilteredPatternsList.add(pattern.trim());
                ++n2;
            }
        }
    }

    public static Hashtable getUPDTblWC() {
        if (workingCopy1_isProcessing) {
            return UPDTblWC2;
        }
        return UPDTblWC1;
    }

    public static URLPatternMeasure getUPMTblTC(String patternString) {
        URLPatternMeasure urlPatternMeasure = UPMTblTC.get(patternString);
        UPMTblTC.put(patternString, new URLPatternMeasure(patternString));
        return urlPatternMeasure;
    }

    public static void updateTC() {
        if (workingCopy1_isProcessing) {
            workingCopy1_isProcessing = false;
            JTMLog.logger.debug("Snapshot manager is going to update transmit copy using working copy two !!!");
            Set workingCopy2Keys = PropsManager.patternTbl.keySet();
            for (String workingCopy2Pattern : workingCopy2Keys) {
                URLPatternData UPD = UPDTblWC2.remove(workingCopy2Pattern);
                UPDTblWC2.put(workingCopy2Pattern, new URLPatternData(workingCopy2Pattern));
                if (UPD.modified) {
                    URLPatternMeasure UPM = UPMTblTC.get(workingCopy2Pattern);
                    UPM.update(UPD);
                    UPD = null;
                } else {
                    UPD = null;
                }
                JTMLog.logger.debug("Updated the transmit copy & purged old information for the pattern from WC2:" + workingCopy2Pattern);
            }
        } else {
            workingCopy1_isProcessing = true;
            JTMLog.logger.debug("Snapshot manager is going to update transmit copy using working copy one !!!");
            Set workingCopy1Keys = PropsManager.patternTbl.keySet();
            for (String workingCopy1Pattern : workingCopy1Keys) {
                URLPatternData UPD = UPDTblWC1.remove(workingCopy1Pattern);
                UPDTblWC1.put(workingCopy1Pattern, new URLPatternData(workingCopy1Pattern));
                if (UPD.modified) {
                    URLPatternMeasure UPM = UPMTblTC.get(workingCopy1Pattern);
                    UPM.update(UPD);
                    UPD = null;
                } else {
                    UPD = null;
                }
                JTMLog.logger.debug("Updated the transmit copy & purged old information for the pattern from WC1:" + workingCopy1Pattern);
            }
        }
    }

    public static void updateTbls() {
        Enumeration patternEnum = PropsManager.patternTbl.keys();
        while (patternEnum.hasMoreElements()) {
            String pName = (String)patternEnum.nextElement();
            UPDManager.updateTblWC(pName, null);
            UPDManager.updateTblTC(pName, null);
        }
    }

    private static void updateTblWC(String pName, String pStr) {
        URLPatternData UPD = UPDTblWC1.get(pName);
        if (UPD == null) {
            UPD = new URLPatternData(pName);
            UPDTblWC1.put(pName, UPD);
        }
        if ((UPD = UPDTblWC2.get(pName)) == null) {
            UPD = new URLPatternData(pName);
            UPDTblWC2.put(pName, UPD);
        }
    }

    private static void updateTblTC(String pName, String pStr) {
        URLPatternMeasure UPM = UPMTblTC.get(pName);
        if (UPM == null) {
            UPM = new URLPatternMeasure(pName);
            UPMTblTC.put(pName, UPM);
        }
    }

    private static void removePatternData(String pName) {
        PropsManager.patternTbl.remove(pName);
        UPDTblWC1.remove(pName);
        UPDTblWC2.remove(pName);
        UPMTblTC.remove(pName);
    }

    public static void setSlowURLThreshold(String thresholdStr) {
        try {
            PropsManager.Slow_URL_Threshold = Double.parseDouble(thresholdStr);
            PropsManager.setMaxTracePeriod();
            JTMLog.logger.info("Slow_URL_Threshold parsed and set to " + UPDManager.getSlowURLThreshold() + " seconds.");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static double getSlowURLThreshold() {
        return PropsManager.Slow_URL_Threshold;
    }

    public static void setEgMeasPeriod(String mpStr) {
        try {
            PropsManager.egMeasPeriod = Long.parseLong(mpStr) * 1000L;
            SnapshotManager.scheduleSnapshotTaker();
            PropsManager.RASwitchOverCutoff = 10L * PropsManager.egMeasPeriod;
            JTMLog.logger.info("Registered Agent Switchover cut off is " + PropsManager.RASwitchOverCutoff + "ms");
            UPDManager.setMeasPeriodChanged();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static long getEgMeasPeriod() {
        return PropsManager.egMeasPeriod;
    }

    public static long getRASwitchOverCutoff() {
        return PropsManager.RASwitchOverCutoff;
    }

    public static void setJTMPort(String portStr) {
        try {
            UPDManager.savePrevJTMPort();
            PropsManager.JTM_Port = Integer.parseInt(portStr);
            JTMLog.logger.info("JTM_Port parsed and set to " + UPDManager.getJTMPort());
            UPDManager.setPortChanged();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static int getJTMPort() {
        return PropsManager.JTM_Port;
    }

    private static void savePrevJTMPort() {
        PropsManager.prev_JTM_Port = UPDManager.getJTMPort();
        JTMLog.logger.info("Previous JTM_Port set to " + UPDManager.getPrevJTMPort());
    }

    public static int getPrevJTMPort() {
        return PropsManager.prev_JTM_Port;
    }

    public static void setMethExecCutOff(String cutOffStr) {
        try {
            double cutOff;
            PropsManager.Meth_Exec_CutOff = cutOff = Double.parseDouble(cutOffStr);
            JTMLog.logger.info("Method execution cutoff parsed and set to " + UPDManager.getMethExecCutOff());
        }
        catch (NumberFormatException nfe) {
            PropsManager.Meth_Exec_CutOff = 0.05;
        }
    }

    public static double getMethExecCutOff() {
        return PropsManager.Meth_Exec_CutOff;
    }

    public static int getMaxSlowURLs() {
        return PropsManager.Max_Slow_URLs;
    }

    public static void setMaxSlowURLs(String numURLsStr) {
        try {
            PropsManager.Max_Slow_URLs = Integer.parseInt(numURLsStr);
            JTMLog.logger.info("Maximum number of slow URLs  set to " + UPDManager.getMaxSlowURLs());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static int getMaxErrorURLs() {
        return PropsManager.Max_Error_URLs;
    }

    public static void setMaxErrorURLs(String numURLsStr) {
        try {
            PropsManager.Max_Error_URLs = Integer.parseInt(numURLsStr);
            JTMLog.logger.info("Maximum number of Error URLs  set to " + UPDManager.getMaxErrorURLs());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static boolean getPortChanged() {
        return PropsManager.portChanged;
    }

    public static void resetPortChanged() {
        JTMLog.logger.info("Port change handled");
        PropsManager.portChanged = false;
    }

    public static void setPortChanged() {
        JTMLog.logger.info("Registered port change in properties");
        PropsManager.portChanged = true;
    }

    public static boolean getMeasPeriodChanged() {
        return PropsManager.measPeriodChanged;
    }

    public static void resetMeasPeriodChanged() {
        JTMLog.logger.info("Measure Period change handled");
        PropsManager.measPeriodChanged = false;
    }

    public static void setMeasPeriodChanged() {
        JTMLog.logger.info("Registered measure period change in properties");
        PropsManager.measPeriodChanged = true;
    }

    public static void setDesigAgtInetAddr(String DesigAgt) {
        try {
            PropsManager.DesigAgtInetAddr = InetAddress.getByName(DesigAgt);
            PropsManager.useDesigAgtOnly = true;
            PropsManager.desigAgtChanged = true;
            JTMLog.logger.info("Accepting requests from Designated Agents only. Designated agent is now " + DesigAgt);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void resetDesigAgtInetAddr() {
        PropsManager.DesigAgtInetAddr = null;
        PropsManager.useDesigAgtOnly = false;
        JTMLog.logger.info("Not using designated agents any more.");
    }

    public static InetAddress getDesigAgtInetAddr() {
        return PropsManager.DesigAgtInetAddr;
    }

    public static boolean isUseDesigAgtOnly() {
        return PropsManager.useDesigAgtOnly;
    }

    public static boolean hasDesigAgtChanged() {
        return PropsManager.desigAgtChanged;
    }

    public static void resetDesigAgtChanged() {
        PropsManager.desigAgtChanged = false;
    }

    public static void sendMeasures(ObjectOutputStream oos, ObjectInputStream ois, boolean discard) {
        try {
            Enumeration patsEnum = PropsManager.patternTbl.keys();
            Hashtable<String, Hashtable> mainMeasureHT = new Hashtable<String, Hashtable>();
            while (patsEnum.hasMoreElements()) {
                String pName = (String)patsEnum.nextElement();
                URLPatternMeasure UPM = UPDManager.getUPMTblTC(pName);
                if (UPM != null) {
                    Hashtable cloneCopy;
                    if (discard) {
                        cloneCopy = UPM.getMeasureTbl();
                        UPM = null;
                        continue;
                    }
                    cloneCopy = UPM.getMeasureTbl();
                    if (cloneCopy != null) {
                        mainMeasureHT.put(pName, cloneCopy);
                        JTMLog.logger.debug(String.valueOf(pName) + " -> " + UPM.toString());
                        continue;
                    }
                    JTMLog.logger.debug(String.valueOf(pName) + " -> No data to transmit.......");
                    continue;
                }
                JTMLog.logger.warn("Mismatch between current pattern list and pattern measure data. No data found for pattern : " + pName);
            }
            if (discard) {
                oos.writeObject("Hi eG Agent, Please re-send config data");
            } else {
                oos.writeObject(mainMeasureHT);
            }
            oos.flush();
            mainMeasureHT = null;
            SnapshotManager.resetSnapshotCtr();
            JTMLog.logger.debug("Successfully sent data to agent");
        }
        catch (IOException e) {
            JTMLog.logger.warn("Exception sending data back to agent.", e);
        }
    }

    public static void setURLPatternDiscoveryMode(String patternMode) {
        PropsManager.urlPatternMode = patternMode;
        PropsManager.isAutoURLPatternDiscovery = true;
        if (patternMode.equalsIgnoreCase("Manual")) {
            PropsManager.isAutoURLPatternDiscovery = false;
        }
        if (!PropsManager.prevURLPatternMode.equalsIgnoreCase(patternMode)) {
            JTMLog.logger.info("Switching URL pattern discovery " + PropsManager.prevURLPatternMode + " to " + patternMode);
            PropsManager.prevURLPatternMode = patternMode;
            Hashtable cloneTable = (Hashtable)PropsManager.patternTbl.clone();
            Enumeration patternEnum = cloneTable.keys();
            while (patternEnum.hasMoreElements()) {
                String pName = (String)patternEnum.nextElement();
                UPDManager.removePatternData(pName);
            }
        }
    }

    public static void setNoOfURLSegments(String urlLevel) {
        try {
            int level = Integer.parseInt(urlLevel);
            if (level <= 0) {
                level = 2;
            }
            PropsManager.URLLevel = level;
        }
        catch (NumberFormatException nfe) {
            PropsManager.URLLevel = 2;
        }
        if (PropsManager.isAutoURLPatternDiscovery) {
            UPDManager.removePatternData(PropsManager.URLLevel);
        }
    }

    public static int getURLlevel() {
        return PropsManager.URLLevel;
    }

    private static void removePatternData(int urlLevel) {
        Hashtable cloneTable = (Hashtable)PropsManager.patternTbl.clone();
        Enumeration patternEnum = cloneTable.keys();
        while (patternEnum.hasMoreElements()) {
            String pName = (String)patternEnum.nextElement();
            UPDManager.removePatternData(pName);
        }
    }

    public static void clearStoredData() {
        UPDTblWC1.clear();
        UPDTblWC2.clear();
        UPMTblTC.clear();
        UPDTblWC1 = new Hashtable();
        UPDTblWC2 = new Hashtable();
        UPMTblTC = new Hashtable();
        PropsManager.patternTbl.clear();
    }
}

