/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSSL;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class ApacheStatusTest
extends GenericTest {
    double prevAccess = -5.0;
    double prevTraffic = -5.0;
    String url = "";
    boolean isSsl = false;

    public ApacheStatusTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
        this.url = this.getValueForParam("url");
        if (this.url != null && this.url.startsWith("https")) {
            this.isSsl = true;
        }
        if (this.isContainerApp && this.strContainerId != null && this.strContainerId.length() > 0) {
            String string = this.strContainerId.toLowerCase();
            if (this.url != null && this.url.toLowerCase().indexOf(string) > 0) {
                this.url = ApacheStatusTest.findAndReplaceInfoString(this.url, this.strContainerId, this.targetHost);
            }
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        double d = -5.0;
        double d2 = -5.0;
        ArrayList arrayList = this.returnMeasures();
        if (arrayList == null) {
            this.prevAccess = -5.0;
            this.prevTraffic = -5.0;
            return;
        }
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            String string = (String)arrayList.get(i);
            if (string.indexOf("Total accesses") >= 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (stringTokenizer.countTokens() < 3) continue;
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                double d6 = -5.0;
                try {
                    d6 = Double.parseDouble(stringTokenizer.nextToken());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (d6 < 0.0) {
                    d6 = -5.0;
                }
                if (this.prevAccess < 0.0) {
                    this.prevAccess = d6;
                } else {
                    d3 = d6 - this.prevAccess;
                    if (d3 < 0.0) {
                        d3 = -5.0;
                    }
                    this.prevAccess = d6;
                }
                d3 = d3 >= 0.0 && this.timeSinceLastTest > 0.0 ? (d3 /= this.timeSinceLastTest) : -5.0;
            }
            if (string.indexOf("Total Traffic") >= 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (stringTokenizer.countTokens() < 8) continue;
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                double d7 = -5.0;
                try {
                    d7 = Double.parseDouble(stringTokenizer.nextToken());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (d7 < 0.0) {
                    d7 = -5.0;
                }
                if (this.prevTraffic < 0.0) {
                    this.prevTraffic = d7;
                } else {
                    d4 = d7 - this.prevTraffic;
                    if (d4 < 0.0) {
                        d4 = -5.0;
                    }
                    this.prevTraffic = d7;
                }
                d4 = d4 >= 0.0 && this.timeSinceLastTest > 0.0 ? (d4 /= this.timeSinceLastTest) : -5.0;
            }
            if (string.indexOf("CPU load") >= 0 && string.indexOf("%") >= 0) {
                d5 = -5.0;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (!string2.endsWith("%")) continue;
                    string2 = string2.substring(0, string2.length() - 1);
                    try {
                        d5 = Double.parseDouble(string2);
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            if (string.indexOf("requests currently being processed") >= 0) {
                int n2;
                if (string.startsWith("<") && (n2 = string.indexOf(62)) >= 0) {
                    string = string.substring(n2 + 1);
                }
                string = string.trim();
                int n3 = string.indexOf(32);
                String string3 = string.substring(0, n3);
                try {
                    d = Double.parseDouble(string3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((n = string.indexOf("idle workers")) < 0) continue;
            string = string.trim();
            string = string.substring(0, n);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string4 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            }
            try {
                d2 = Double.parseDouble(string4);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        arrayList2.add(new Double(d3));
        arrayList2.add(new Double(d4));
        arrayList2.add(new Double(d5));
        arrayList2.add(new Double(d));
        arrayList2.add(new Double(d2));
        this.addNewMeasure(arrayList2);
    }

    private ArrayList returnMeasures() {
        HttpURLConnection httpURLConnection = null;
        Object var2_2 = null;
        Object var3_3 = null;
        URL uRL = null;
        if (this.isSsl) {
            String string = this.url;
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var8_12 = null;
            try {
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                uRL = new URL(string);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.connect();
                ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false);
                ArrayList arrayList = null;
                int n = 0;
                boolean bl = this.checkForTimeout(connectionThread);
                if (bl) {
                    n = connectionThread.code;
                    arrayList = connectionThread.data;
                }
                connectionThread = null;
                httpURLConnection.disconnect();
                httpURLConnection = null;
                if (!bl || n != 200) {
                    return null;
                }
                if (arrayList == null || arrayList.size() == 0) {
                    return null;
                }
                return arrayList;
            }
            catch (Exception exception) {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                return null;
            }
        }
        String string = this.url;
        try {
            uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.connect();
            ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false);
            ArrayList arrayList = null;
            int n = 0;
            boolean bl = this.checkForTimeout(connectionThread);
            if (bl) {
                n = connectionThread.code;
                arrayList = connectionThread.data;
            }
            connectionThread = null;
            httpURLConnection.disconnect();
            httpURLConnection = null;
            if (!bl || n != 200) {
                return null;
            }
            if (arrayList == null || arrayList.size() == 0) {
                return null;
            }
            return arrayList;
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return null;
        }
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            long l4 = System.currentTimeMillis();
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            long l5 = System.currentTimeMillis();
            long l6 = l5 - l4;
            if ((l2 += l6) >= this.timeout || l6 < 0L) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }
}

