/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import com.eg.EgSSL;
import com.eg.IniFile;
import com.eg.IniHelper;
import com.eg.apm.APMCleanUpUtils;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMDiscoveryHelper;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMFileOperations;
import com.eg.apm.APMUtils;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.ContainersService;
import com.eg.apm.KubernetesAPI;
import com.eg.jtm.BTMConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApmDiscoveryContributor
extends Thread {
    String sep = System.getProperty("file.separator");
    protected String loggerDispStr = "[ApmDiscoveryContributor]";
    private static final String winCommand_1 = "cmd /c netstat -aonp tcp | findstr ";
    private static final String winCommand_2 = "| findstr LISTENING";
    private static final long minSleep = 50L;
    private static long lastModifiedTime = -1L;
    private static long lastAgentTestsModifiedTime = -1L;
    private static boolean agentDiscoverEnabled = true;
    private static long lastCleanupiniModifiedTime = -1L;
    private boolean isCleanUpEnabled = true;
    private String btmJarDefaultLogPath = EgInstallInfo.getInstallDir() + "/lib/apm/Java/default/logs";
    private String btmJarLogPath = "lib/apm/Java/default/logs";
    private String btmJarLogPathWindows = "lib/apm/Java/default/logs";
    private String windowsTempPath = System.getenv("TEMP") + "/logs";
    private String linuxTempPath = "/tmp/logs";
    private String btmFileName = "BTMLog.log";
    private String cleanIni = EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_CLEANUP;
    private int cleanUpThreshold = 3;
    private int checkForEvery = 3;
    long threshTimeForDeletion = this.checkForEvery * 60 * 60 * 1000;
    private int dicoveryMaxWaitTime = 15;
    private HashMap unknownContainers = new HashMap();
    private HashMap<String, Long> manualHttpReq = new HashMap();
    private long lastBtmLogDeletionTime = -1L;
    private long lastApmIniModifiedTime = -1L;
    private long lastRunTime = 0L;
    private int customPort = 7011;
    public static String kubeSync = new String("kube");

    public ApmDiscoveryContributor() {
        this.setDaemon(true);
        this.setName("ApmDiscoveryContributor");
        this.start();
        this.readFromini();
        APMDiscoveryLogger.discoveryLogger.info(this.loggerDispStr + " ApmDiscoveryContributor Thread started ");
    }

    public ApmDiscoveryContributor(boolean bl) {
    }

    @Override
    public void run() {
        this.suspendThread(30000L);
        this.isAgentTestsIniUpdated();
        APMDiscoveryLogger.discoveryLogger.trace("{} agentDiscoverEnabled  : {} ", (Object)this.loggerDispStr, (Object)agentDiscoverEnabled);
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_FILEPATH);
        int n = this.getPort(iniFile, "APM_DISCOVERY", "Custom_Port_For_AutoManage");
        this.customPort = n > 0 ? n : 7011;
        ContainersService.initContainerClusterEnvDiscovery();
        while (true) {
            try {
                while (true) {
                    if (!agentDiscoverEnabled) {
                        this.suspendThread(180000L);
                        this.isAgentTestsIniUpdated();
                        APMDiscoveryLogger.discoveryLogger.trace("{} agentDiscoverEnabled  : {} ", (Object)this.loggerDispStr, (Object)agentDiscoverEnabled);
                        if (!agentDiscoverEnabled) {
                            APMDiscoveryLogger.discoveryLogger.trace("{} agentDiscoverEnabled  : {} , Skipping the process..", (Object)this.loggerDispStr, (Object)agentDiscoverEnabled);
                            continue;
                        }
                    }
                    boolean bl = this.discoveryIniUpdated();
                    long l = System.currentTimeMillis();
                    long l2 = l - this.lastRunTime;
                    boolean bl2 = false;
                    if (l2 >= 300000L) {
                        this.isAgentTestsIniUpdated();
                        bl2 = true;
                    }
                    if (APMDiscoveryLogger.discoveryLogger.isTraceEnabled()) {
                        APMDiscoveryLogger.discoveryLogger.trace("{} agentDiscoverEnabled  : {} ", (Object)this.loggerDispStr, (Object)agentDiscoverEnabled);
                        APMDiscoveryLogger.discoveryLogger.trace("{} lastRunTime  : {} ", (Object)this.loggerDispStr, (Object)this.lastRunTime);
                        APMDiscoveryLogger.discoveryLogger.trace("{} iniUpdated  : {} ", (Object)this.loggerDispStr, (Object)bl);
                        APMDiscoveryLogger.discoveryLogger.trace("{} doProcess  : {} ", (Object)this.loggerDispStr, (Object)bl2);
                        APMDiscoveryLogger.discoveryLogger.trace("{} fullyDiscoveredContainerIds : {} ", (Object)this.loggerDispStr, (Object)APMDiscoveryHelper.getDiscoveredList());
                    }
                    if (bl || bl2) {
                        this.processDiscoveryDetails();
                        this.processForManualHttpRequest();
                        this.findKubernetesServiceNames();
                        this.lastRunTime = System.currentTimeMillis();
                    } else {
                        APMDiscoveryLogger.discoveryLogger.trace("{} ApmDiscoveryContributor.run()  suspending thread for 10sec....", (Object)this.loggerDispStr);
                    }
                    this.processBtmJarLogFileDeletion();
                    if (this.apmIniUpdated()) {
                        this.readFromApmIni();
                    }
                    this.suspendThread(ApmConfigManager.getInstance().getDiscoveryContributorSleepTime());
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to do process discovery details : ", (Throwable)exception);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findKubernetesServiceNames() {
        if (!ContainersService.isKube()) {
            APMDiscoveryLogger.discoveryLogger.trace("{}  No Kubernetes Env found, Skipping findKubernetesServiceNames() process", (Object)this.loggerDispStr);
            return;
        }
        try {
            boolean bl = true;
            ArrayList<IniHelper> arrayList = new ArrayList<IniHelper>();
            ArrayList<IniHelper> arrayList2 = new ArrayList<IniHelper>();
            String string = kubeSync;
            synchronized (string) {
                IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_FILEPATH);
                String string2 = "KUBERNETES_DETAILS_TEMP";
                String[] stringArray = iniFile.getVariables(string2);
                Vector vector = iniFile.getAllValues(string2);
                APMDiscoveryLogger.discoveryLogger.info("{}  Kubernetes Service Name Discovery Starting : {}", (Object)this.loggerDispStr, (Object)vector);
                APMDiscoveryLogger.discoveryLogger.info("{}  kubeValueList : {}", (Object)this.loggerDispStr, (Object)vector);
                APMDiscoveryLogger.discoveryLogger.info("{}  Kubernetes ip : {}, port : {}, ssl : {}, token : {} ", new Object[]{this.loggerDispStr, ContainersService.ip, ContainersService.port, ContainersService.ssl, ContainersService.serviceToken});
                if (stringArray != null && stringArray.length > 0) {
                    KubernetesAPI kubernetesAPI = new KubernetesAPI(ContainersService.ip, ContainersService.port, ContainersService.serviceToken, ContainersService.ssl);
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string3 = stringArray[i];
                        if (i == 2 && !kubernetesAPI.isKubeMasterReachable()) {
                            APMDiscoveryLogger.discoveryLogger.warn("{} Kubernetes Master is unreachable, Skipping Kubernetes Service Name Discovery,  isKubeMasterReachable : {}", (Object)this.loggerDispStr, (Object)kubernetesAPI.isKubeMasterReachable());
                            return;
                        }
                        if (string3 == null || string3.length() <= 0) continue;
                        String string4 = (String)vector.get(i);
                        StringTokenizer stringTokenizer = new StringTokenizer(string4, ":");
                        String string5 = "";
                        String string6 = "";
                        int n = stringTokenizer.countTokens();
                        if (n != 2) continue;
                        string5 = stringTokenizer.nextToken();
                        string6 = stringTokenizer.nextToken();
                        HashMap hashMap = kubernetesAPI.getCachedServiceCopy(string6);
                        ArrayList arrayList3 = kubernetesAPI.getLabelNameFromPod(string6, string5);
                        bl = kubernetesAPI.isKubeMasterReachable();
                        APMDiscoveryLogger.discoveryLogger.trace("{}  Cached Service map : {}", (Object)this.loggerDispStr, (Object)hashMap);
                        APMDiscoveryLogger.discoveryLogger.debug("{}  Doing Kubernetes Service Name Discovery for Namespace - {}, Pod - {} labelList : {}", new Object[]{this.loggerDispStr, string6, string5, arrayList3});
                        String string7 = "";
                        if (arrayList3 != null && arrayList3.size() > 0) {
                            string7 = (String)arrayList3.get(0);
                        }
                        boolean bl2 = false;
                        String string8 = "";
                        if (string7 == null || string7.length() <= 0) continue;
                        try {
                            if (hashMap != null && hashMap.containsKey(string7)) {
                                bl2 = true;
                                string8 = (String)hashMap.get(string7);
                            } else {
                                string8 = kubernetesAPI.getServicename(string6, string7);
                                bl2 = true;
                            }
                            APMDiscoveryLogger.discoveryLogger.trace("{}  serviceName : {}", (Object)this.loggerDispStr, (Object)string8);
                            if (!bl2) continue;
                            String string9 = string4 + ":" + string8;
                            arrayList.add(this.getIniHelper("KUBERNETES_DETAILS", string3, string9));
                            arrayList2.add(this.getIniHelper(string2, string3, string3));
                            continue;
                        }
                        catch (Exception exception) {
                            APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to do port finding : ", (Throwable)exception);
                        }
                    }
                }
                boolean bl3 = this.storeToIni(arrayList, arrayList2);
                if (APMDiscoveryLogger.discoveryLogger.isTraceEnabled()) {
                    APMDiscoveryLogger.discoveryLogger.trace(this.loggerDispStr + " ServiceName addThis    : " + arrayList);
                    APMDiscoveryLogger.discoveryLogger.trace(this.loggerDispStr + " ServiceName deleteThis :   " + arrayList2);
                    APMDiscoveryLogger.discoveryLogger.trace(this.loggerDispStr + " ServiceName stored : " + bl3);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to process kunernetes service name discovery details : ", (Throwable)exception);
        }
    }

    int getPort(IniFile iniFile, String string, String string2) {
        try {
            String string3 = iniFile.getValue(string, string2);
            if (string3 != null && string3.length() > 0) {
                int n = Integer.parseInt(string3);
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while retriving port from ini!!...{} ", (Object)this.loggerDispStr, (Object)numberFormatException);
        }
        return 0;
    }

    private boolean isMaxDiscoveryTimeReached(String string, long l, long l2) {
        boolean bl = false;
        try {
            if (this.manualHttpReq.containsKey(string)) {
                long l3 = this.manualHttpReq.get(string);
                long l4 = l2 - l3;
                if (l >= l4) {
                    bl = true;
                }
            } else {
                bl = true;
                this.manualHttpReq.put(string, l2);
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to do process isMaxDiscoveryTimeReached() : ", (Throwable)exception);
        }
        return bl;
    }

    private void processForManualHttpRequest() {
        try {
            ArrayList<IniHelper> arrayList = new ArrayList<IniHelper>();
            ArrayList arrayList2 = new ArrayList();
            ArrayList<IniHelper> arrayList3 = new ArrayList<IniHelper>();
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_FILEPATH);
            String string = "JAVA_SERVER_DETAILS_DO_HTTP_REQ";
            String[] stringArray = iniFile.getVariables(string);
            Vector vector = iniFile.getAllValues(string);
            long l = this.dicoveryMaxWaitTime * 60 * 1000;
            long l2 = System.currentTimeMillis();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                StringTokenizer stringTokenizer;
                int n;
                String string3 = stringArray[i];
                if (string3 == null || string3.length() <= 0 || (n = (stringTokenizer = new StringTokenizer(string2 = (String)vector.get(i), "#~#")).countTokens()) != 3) continue;
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                if (!APMDiscoveryHelper.isInDiscoverdList(string5) && this.isMaxDiscoveryTimeReached(string5, l, l2)) {
                    String string6 = stringTokenizer.nextToken();
                    ArrayList<String> arrayList4 = this.getAllAvailablePort(string4);
                    APMDiscoveryLogger.discoveryLogger.trace("{}  Port list {} for  {} :{}", new Object[]{this.loggerDispStr, arrayList4, string3, string5});
                    APMDiscoveryLogger.discoveryLogger.debug("{}  Going to do Http request for {} :{}  {}", new Object[]{this.loggerDispStr, string3, string4, string5});
                    this.doManualHttpRequest(string3, arrayList4);
                    continue;
                }
                this.manualHttpReq.remove(string5);
                arrayList.add(APMUtils.getIniHelper(string, string3, string3));
                arrayList3.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS_HTTP_CALL_DONE", string4 + "@" + string3, string2));
                APMDiscoveryLogger.discoveryLogger.trace("{} {} is in discoverd list so skipping manual request for  {}:{} ", new Object[]{this.loggerDispStr, string5, string3, string4});
            }
            APMDiscoveryHelper.storeToIni(arrayList2, arrayList);
            if (ApmConfigManager.getInstance().isSaveDetailsOnTempFile()) {
                APMDiscoveryHelper.saveToIni(APMCleanUpUtils.getTrashFileName(), arrayList3, null);
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to do process processForManualHttpRequest() : ", (Throwable)exception);
        }
    }

    public String makeGetRequest(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            try {
                APMDiscoveryLogger.discoveryLogger.trace("{}  Doing Http request to {} with  {}", new Object[]{this.loggerDispStr, string, string2});
                URL uRL = new URL(string);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.setRequestProperty("User-Agent", string2);
                int n = httpURLConnection.getResponseCode();
                stringBuilder.append(" <h1>Response Code :</h1>").append(n);
                if (n != 200) {
                    stringBuilder.append("GET request not worked : ");
                }
            }
            catch (Exception exception) {
                stringBuilder.append(exception.getCause());
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to do make http url hit  : ", (Throwable)exception);
        }
        return stringBuilder.toString();
    }

    private void enableSsl() {
        EgSSL egSSL = EgSSL.getInstance();
        egSSL.enableSSL();
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        Object var3_3 = null;
        try {
            MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to enable ssl to  make Http Request : ", (Throwable)exception);
        }
    }

    private void doManualHttpRequest(String string, ArrayList arrayList) {
        try {
            if (arrayList != null && arrayList.size() > 0) {
                int n;
                for (n = 0; n < arrayList.size(); ++n) {
                    try {
                        int n2 = Integer.parseInt((String)arrayList.get(n));
                        this.hitTheUrl(string, n2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to do process doManualHttpRequest() : ", (Throwable)numberFormatException);
                    }
                }
                if (!arrayList.contains("80")) {
                    n = Integer.parseInt("80");
                    this.hitTheUrl(string, n);
                }
                if (!arrayList.contains("8080")) {
                    n = Integer.parseInt("8080");
                    this.hitTheUrl(string, n);
                }
                if (!arrayList.contains("443")) {
                    n = Integer.parseInt("443");
                    this.hitTheUrl(string, n);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to do process doManualHttpRequest() : ", (Throwable)exception);
        }
    }

    private void hitTheUrl(String string, int n) {
        try {
            String string2 = "http://" + string + ":" + n + "/";
            String string3 = "https://" + string + ":" + n + "/";
            String string4 = "Mozilla/5.0";
            this.makeGetRequest(string2, string4);
            this.enableSsl();
            this.makeGetRequest(string3, string4);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to do process discovery details : ", (Throwable)exception);
        }
    }

    public ArrayList<String> getAllAvailablePort(String string) {
        String string2 = System.getProperty("os.name").toLowerCase();
        Runtime runtime = Runtime.getRuntime();
        if (string2.indexOf("win") >= 0) {
            try {
                Process process = runtime.exec(winCommand_1 + string + winCommand_2);
                ArrayList<String> arrayList = this.getPortUsingPid(process, "win");
                APMDiscoveryLogger.discoveryLogger.debug(this.loggerDispStr + "Windows mode retrived all listening port for Pid [{}]", (Object)string);
                return arrayList;
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Exception occurred while executing [Windows command] to get ports and PID.... ", (Throwable)exception);
            }
        } else if (string2.indexOf("nix") > -1 || string2.indexOf("nux") > -1 || string2.indexOf("aix") > -1) {
            String[] stringArray = new String[]{"/bin/sh", "-c", "netstat -anlp | grep " + string + " | grep LISTEN"};
            try {
                Process process = runtime.exec(stringArray);
                ArrayList<String> arrayList = this.getPortUsingPid(process, "linux");
                APMDiscoveryLogger.discoveryLogger.debug(this.loggerDispStr + " Linux mode retrived all listening port for Pid [{}]", (Object)string);
                return arrayList;
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Exception occurred while executing [Linux command] to get ports and PID.... ", (Throwable)exception);
            }
        } else {
            APMDiscoveryLogger.discoveryLogger.debug(this.loggerDispStr + " Unsuported OS: unable to get port details for Pid: [{}] return false ", (Object)string);
            return null;
        }
        return null;
    }

    private ArrayList<String> getPortUsingPid(Process process, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                String string3;
                StringTokenizer stringTokenizer;
                String string4;
                if (string.equals("win")) {
                    string4 = string2.trim().replaceAll(" +", "#");
                    stringTokenizer = new StringTokenizer(string4, "#");
                    stringTokenizer.nextElement();
                    string3 = (String)stringTokenizer.nextElement();
                    if (string3 == null || (n = string3.indexOf(":")) <= -1) continue;
                    arrayList.add(string3.substring(n + 1));
                    continue;
                }
                string4 = string2.trim().replaceAll(" +", "#");
                stringTokenizer = new StringTokenizer(string4, "#");
                stringTokenizer.nextElement();
                stringTokenizer.nextElement();
                stringTokenizer.nextElement();
                string3 = (String)stringTokenizer.nextElement();
                if (string3 == null || (n = string3.indexOf(":")) <= -1) continue;
                String string5 = string3.substring(n);
                arrayList.add(string5.replaceAll(":", "").trim());
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Exception occurred while getting Port using master PID....  ", (Throwable)exception);
        }
        return arrayList;
    }

    void processBtmJarLogFileDeletion() {
        try {
            long l = System.currentTimeMillis() - this.lastBtmLogDeletionTime;
            APMDiscoveryLogger.discoveryLogger.trace(this.loggerDispStr + " lastBtmLogDeletionTime  : {} , checkForEvery : {}", (Object)this.lastBtmLogDeletionTime, (Object)this.checkForEvery);
            if (l >= this.threshTimeForDeletion) {
                Hashtable hashtable;
                this.lastBtmLogDeletionTime = System.currentTimeMillis();
                if (this.cleanupIniUpdated()) {
                    this.readFromini();
                }
                if (!this.isCleanUpEnabled) {
                    APMDiscoveryLogger.discoveryLogger.info(this.loggerDispStr + " APM Discovery - BTM Jar log folder cleanup is not enabled");
                    return;
                }
                DockerContainers dockerContainers = this.getDockerInstance();
                if (dockerContainers != null) {
                    hashtable = this.getBtmjarLogFolderNames(this.btmJarLogPath);
                    this.processForDockerContainers(this.btmJarLogPath, hashtable, dockerContainers);
                }
                if (APMUtils.isWindows) {
                    hashtable = this.getBtmjarLogFolderNames(this.btmJarLogPathWindows);
                    this.processForStandAlone(this.btmJarLogPathWindows, hashtable);
                } else {
                    hashtable = this.getBtmjarLogFolderNames(this.btmJarLogPath);
                    this.processForStandAlone(this.btmJarLogPath, hashtable);
                }
                hashtable = this.getBtmjarLogFolderNames(this.btmJarDefaultLogPath);
                this.processForStandAlone(this.btmJarDefaultLogPath, hashtable);
                if (APMUtils.isWindows) {
                    hashtable = this.getBtmjarLogFolderNames(this.windowsTempPath);
                    this.processForStandAlone(this.windowsTempPath, hashtable);
                } else {
                    hashtable = this.getBtmjarLogFolderNames(this.linuxTempPath);
                    this.processForStandAlone(this.linuxTempPath, hashtable);
                }
                HashMap hashMap = this.getPathsSentByBTMJar();
                this.processIndividualPath(hashMap);
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to do apm discvoery log deletion process : ", (Throwable)exception);
        }
    }

    private HashMap getPathsSentByBTMJar() {
        Hashtable hashtable = new Hashtable();
        IniFile iniFile = new IniFile(this.cleanIni);
        return APMUtils.getLinesAsMap(iniFile, "LOG_PATHS", APMDiscoveryLogger.discoveryLogger);
    }

    private void processIndividualPath(HashMap hashMap) {
        if (hashMap.size() < 0) {
            return;
        }
        Iterator iterator = hashMap.entrySet().iterator();
        APMFileOperations aPMFileOperations = new APMFileOperations();
        long l = System.currentTimeMillis();
        long l2 = this.cleanUpThreshold * 60 * 60 * 1000;
        ArrayList<IniHelper> arrayList = new ArrayList<IniHelper>();
        while (iterator.hasNext()) {
            try {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                string2 = string2.substring(string2.indexOf("^") + 1);
                File file = new File(string2);
                if (file.exists()) {
                    String string3;
                    long l3 = file.lastModified();
                    if (l - l3 < l2 || !aPMFileOperations.deleteDirectory(string3 = string2.replace(this.btmFileName, ""))) continue;
                    APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Old eG_BTM log folder [{}] has been deleted ", (Object)string3);
                    arrayList.add(APMUtils.getIniHelper("LOG_PATHS", string, string));
                    continue;
                }
                arrayList.add(APMUtils.getIniHelper("LOG_PATHS", string, string));
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to do log folder deletion process for a specific foldername : ", (Throwable)exception);
            }
        }
        if (arrayList.size() > 0) {
            APMDiscoveryHelper.saveToIni(this.cleanIni, null, arrayList);
            APMDiscoveryLogger.discoveryLogger.trace(this.loggerDispStr + " Remove log paths from ini  : {} ", arrayList);
        }
    }

    private void processForStandAlone(String string, Hashtable hashtable) {
        if (hashtable.size() < 0) {
            return;
        }
        APMDiscoveryLogger.discoveryLogger.info(this.loggerDispStr + "Log path : {}, logFolderNamemap  : {}", (Object)string, (Object)hashtable);
        Iterator iterator = hashtable.entrySet().iterator();
        APMFileOperations aPMFileOperations = new APMFileOperations();
        long l = System.currentTimeMillis();
        long l2 = this.cleanUpThreshold * 60 * 60 * 1000;
        while (iterator.hasNext()) {
            try {
                String string2;
                Map.Entry entry = iterator.next();
                String string3 = (String)entry.getKey();
                long l3 = (Long)entry.getValue();
                long l4 = l - l3;
                if (l4 < l2 || !aPMFileOperations.deleteDirectory(string2 = string + File.separator + string3)) continue;
                APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Old eG_BTM log folder [{}] that belongs to {} has been deleted ", (Object)string2, (Object)string3);
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to do log folder deletion process for specific foldername : ", (Throwable)exception);
            }
        }
    }

    private void processForDockerContainers(String string, Hashtable hashtable, DockerContainers dockerContainers) {
        if (hashtable.size() < 0) {
            return;
        }
        Hashtable hashtable2 = dockerContainers.getRunningContainerIpDetails();
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
        }
        APMDiscoveryLogger.discoveryLogger.info(this.loggerDispStr + " ipMap  : {}", hashtable2);
        APMDiscoveryLogger.discoveryLogger.info(this.loggerDispStr + "Log path : {}, logFolderNamemap  : {}", (Object)string, (Object)hashtable);
        Iterator iterator = hashtable.entrySet().iterator();
        APMFileOperations aPMFileOperations = new APMFileOperations();
        long l = System.currentTimeMillis();
        long l2 = this.cleanUpThreshold * 60 * 60 * 1000;
        while (iterator.hasNext()) {
            try {
                String string2;
                Map.Entry entry = iterator.next();
                String string3 = (String)entry.getKey();
                long l3 = (Long)entry.getValue();
                long l4 = l - l3;
                if (l4 < l2 || hashtable2.containsKey(string3) || !aPMFileOperations.deleteDirectory(string2 = string + File.separator + string3)) continue;
                APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Old eG_BTM log folder [{}] that belongs to {} has been deleted ", (Object)string2, (Object)string3);
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to do log folder deletion process for specific foldername : ", (Throwable)exception);
            }
        }
    }

    private Hashtable getBtmjarLogFolderNames(String string) {
        Hashtable<Object, Long> hashtable = new Hashtable<Object, Long>();
        try {
            String string2 = string;
            File file = new File(string2);
            boolean bl = file.exists();
            boolean bl2 = file.canWrite();
            APMDiscoveryLogger.discoveryLogger.debug(" Log path : {}, isExist : {} , canWrite :{} ", new Object[]{string, bl, bl2});
            if (!bl || !bl2) {
                return hashtable;
            }
            Object[] objectArray = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return new File(file, string).isDirectory();
                }
            });
            APMDiscoveryLogger.discoveryLogger.debug(this.loggerDispStr + " Available folder names under {} : {} ", (Object)this.btmJarLogPath, (Object)Arrays.toString(objectArray));
            if (objectArray != null && objectArray.length > 0) {
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    String string3 = string2 + File.separator + (String)object + File.separator + this.btmFileName;
                    File file2 = new File(string3);
                    if (!file2.exists()) continue;
                    long l = file2.lastModified();
                    hashtable.put(object, l);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to get BTM jar log folder name from {}: ", (Object)this.btmJarLogPath, (Object)exception);
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readFromini() {
        boolean bl = false;
        String string = null;
        String string2 = null;
        int n = 3;
        int n2 = 3;
        try {
            block14: {
                try {
                    IniFile iniFile = new IniFile(this.cleanIni);
                    String string3 = iniFile.getValue("APM_DISCOVERY_CLEANUP", "Apm_Discovery_Cleanup");
                    string3 = string3.trim();
                    if (string3 != null && string3.length() > 0) {
                        bl = Boolean.parseBoolean(string3);
                    }
                    String string4 = iniFile.getValue("APM_DISCOVERY_CLEANUP", "Btm_Jar_Log_Location");
                    if ((string4 = string4.trim()) != null && string4.length() > 0) {
                        string = string4;
                    }
                    String string5 = iniFile.getValue("APM_DISCOVERY_CLEANUP", "Btm_Jar_Log_Location_Windows");
                    if ((string5 = string5.trim()) != null && string5.length() > 0) {
                        string2 = string5;
                    }
                    String string6 = iniFile.getValue("APM_DISCOVERY_CLEANUP", "Log_Cleanup_Threshold");
                    if ((string6 = string6.trim()) != null && string6.length() > 0) {
                        n = Integer.parseInt(string6);
                    }
                    String string7 = iniFile.getValue("APM_DISCOVERY_CLEANUP", "Check_Update_For_Btm_Logs");
                    if ((string7 = string7.trim()) == null || string7.length() <= 0) break block14;
                    n2 = Integer.parseInt(string7);
                }
                catch (Exception exception) {
                    APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to read discovery clean up ini : ", (Throwable)exception);
                    Object var13_14 = null;
                    this.isCleanUpEnabled = bl;
                    this.cleanUpThreshold = n;
                    this.checkForEvery = n2;
                    this.threshTimeForDeletion = this.checkForEvery * 60 * 60 * 1000;
                    if (string != null && string.length() > 0) {
                        this.btmJarLogPath = string;
                    }
                    if (string2 != null && string2.length() > 0) {
                        this.btmJarLogPathWindows = string2;
                    }
                    APMDiscoveryLogger.discoveryLogger.info(this.loggerDispStr + " isCleanUpEnabled : {}, btmLogPath : {}, btmJarLogPathWindows : {}, cleanUpThreshold : {}, checkForEvery : {}, lastBtmLogDeletionTime : {}, windowsTempPath : {}, linuxTempPath : {}, btmJarDefaultLogPath : {} ", new Object[]{this.isCleanUpEnabled, this.btmJarLogPath, this.btmJarLogPathWindows, this.cleanUpThreshold, this.checkForEvery, this.lastBtmLogDeletionTime, this.windowsTempPath, this.linuxTempPath, this.btmJarDefaultLogPath});
                    return;
                }
            }
            Object var13_13 = null;
            this.isCleanUpEnabled = bl;
            this.cleanUpThreshold = n;
            this.checkForEvery = n2;
            this.threshTimeForDeletion = this.checkForEvery * 60 * 60 * 1000;
            if (string != null && string.length() > 0) {
                this.btmJarLogPath = string;
            }
            if (string2 != null && string2.length() > 0) {
                this.btmJarLogPathWindows = string2;
            }
            APMDiscoveryLogger.discoveryLogger.info(this.loggerDispStr + " isCleanUpEnabled : {}, btmLogPath : {}, btmJarLogPathWindows : {}, cleanUpThreshold : {}, checkForEvery : {}, lastBtmLogDeletionTime : {}, windowsTempPath : {}, linuxTempPath : {}, btmJarDefaultLogPath : {} ", new Object[]{this.isCleanUpEnabled, this.btmJarLogPath, this.btmJarLogPathWindows, this.cleanUpThreshold, this.checkForEvery, this.lastBtmLogDeletionTime, this.windowsTempPath, this.linuxTempPath, this.btmJarDefaultLogPath});
            return;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.isCleanUpEnabled = bl;
            this.cleanUpThreshold = n;
            this.checkForEvery = n2;
            this.threshTimeForDeletion = this.checkForEvery * 60 * 60 * 1000;
            if (string != null && string.length() > 0) {
                this.btmJarLogPath = string;
            }
            if (string2 != null && string2.length() > 0) {
                this.btmJarLogPathWindows = string2;
            }
            APMDiscoveryLogger.discoveryLogger.info(this.loggerDispStr + " isCleanUpEnabled : {}, btmLogPath : {}, btmJarLogPathWindows : {}, cleanUpThreshold : {}, checkForEvery : {}, lastBtmLogDeletionTime : {}, windowsTempPath : {}, linuxTempPath : {}, btmJarDefaultLogPath : {} ", new Object[]{this.isCleanUpEnabled, this.btmJarLogPath, this.btmJarLogPathWindows, this.cleanUpThreshold, this.checkForEvery, this.lastBtmLogDeletionTime, this.windowsTempPath, this.linuxTempPath, this.btmJarDefaultLogPath});
            throw throwable;
        }
    }

    void processDiscoveryDetails() {
        try {
            ArrayList<IniHelper> arrayList = new ArrayList<IniHelper>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<IniHelper> arrayList3 = new ArrayList<IniHelper>();
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_FILEPATH);
            String string = "JAVA_SERVER_DETAILS_CONTAINER_BASED_TEMP";
            String string2 = "JAVA_UNIQUE_GUID_MAPPING_TEMP";
            String string3 = "APPFLOW_SERVICE_AUTO_NAME_MAPPING_TEMP";
            String[] stringArray = iniFile.getVariables(string);
            Vector vector = iniFile.getAllValues(string);
            String[] stringArray2 = iniFile.getVariables(string2);
            Vector vector2 = iniFile.getAllValues(string2);
            Vector<String> vector3 = new Vector<String>();
            vector3.addAll(Arrays.asList(stringArray2));
            String[] stringArray3 = iniFile.getLinesUnderSubject(string3);
            HashMap hashMap = APMDiscoveryHelper.getLinesAsMap(stringArray3);
            if (stringArray != null && stringArray.length > 0) {
                DockerContainers dockerContainers = this.getDockerInstance();
                Hashtable hashtable = new Hashtable();
                Hashtable hashtable2 = new Hashtable();
                if (dockerContainers != null) {
                    hashtable = dockerContainers.getRunningContainerIpDetails();
                    hashtable2 = dockerContainers.getContinerPortDetails();
                }
                if (APMDiscoveryLogger.discoveryLogger.isInfoEnabled()) {
                    APMDiscoveryLogger.discoveryLogger.trace("{}  is Docker Server : {}", (Object)this.loggerDispStr, (Object)dockerContainers.isDockerServer);
                    APMDiscoveryLogger.discoveryLogger.trace("{}  Container Docker port map() : {}", (Object)this.loggerDispStr, (Object)hashtable2);
                    APMDiscoveryLogger.discoveryLogger.trace("{}  Container Docker ip map() : {}", (Object)this.loggerDispStr, (Object)hashtable);
                    APMDiscoveryLogger.discoveryLogger.info("{}  tempAppNameMap() : {}", (Object)this.loggerDispStr, (Object)hashMap);
                    APMDiscoveryLogger.discoveryLogger.info("{} unknownContainers  : {}", (Object)this.loggerDispStr, (Object)this.unknownContainers);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4 = stringArray[i];
                    if (string4 == null || string4.length() <= 0) continue;
                    APMDiscoveryLogger.discoveryLogger.trace("{}  Doing docker port check for  : {}", (Object)this.loggerDispStr, (Object)string4);
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, ":");
                    String string5 = "";
                    String string6 = "";
                    int n = stringTokenizer.countTokens();
                    if (n != 3) continue;
                    String string7 = stringTokenizer.nextToken();
                    string6 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                    boolean bl = false;
                    int n2 = 0;
                    if (string7 == null || string7.length() <= 0) continue;
                    try {
                        String string8;
                        int n3;
                        if (hashtable2.containsKey(string7)) {
                            bl = true;
                            n2 = Integer.parseInt((String)hashtable2.get(string7));
                        } else {
                            if (dockerContainers != null) {
                                n2 = dockerContainers.getDockerPort(string7);
                                APMDiscoveryLogger.discoveryLogger.info("{} dockerContainerName: {}, getDockerPort() : {}", new Object[]{this.loggerDispStr, string7, n2});
                            }
                            if (n2 == 0) {
                                if (dockerContainers != null) {
                                    n2 = dockerContainers.getPodPort(string7);
                                    APMDiscoveryLogger.discoveryLogger.info("{} dockerContainerName: {}, getPodPort(): {}", new Object[]{this.loggerDispStr, string7, n2});
                                }
                                if (n2 != 0) {
                                    bl = true;
                                }
                            } else {
                                bl = true;
                            }
                        }
                        if (hashtable.containsKey(string7) && n2 == 0) {
                            if (ApmConfigManager.getInstance().isManageByCustomPortForDocker()) {
                                n2 = this.customPort > 0 ? this.customPort : 7011;
                                APMDiscoveryLogger.discoveryLogger.warn("{} {} port not found in 'docker inspect' cmd but its is available in list of running containers, so considering this as ghost container and using {} to manage the component.", new Object[]{this.loggerDispStr, string7, n2});
                                bl = true;
                            } else {
                                APMDiscoveryLogger.discoveryLogger.warn("{} DOCKER DISCOVERY - Unable to discover port for {}, So, Skipping the auto manage. Component type :{} , Contaiener ID :{} , ", new Object[]{this.loggerDispStr, string7, string5, string7});
                            }
                        }
                        if (bl) {
                            boolean bl2 = this.isReachedToMaximumDeletionCounter(string4);
                            if (bl2) {
                                APMDiscoveryLogger.discoveryLogger.warn("{} {} is in unknown container list and reached maximum counter for deletion and adding to deletion list.", new Object[]{this.loggerDispStr, string7, string4});
                                arrayList3.add(this.getIniHelper(string, string4, string4));
                                arrayList3.add(this.getIniHelper(string2, string4, string4));
                                this.unknownContainers.remove(string4);
                            } else {
                                APMDiscoveryLogger.discoveryLogger.warn("{} container ip & port not found for {} & adding it into unknown containers list ", (Object)this.loggerDispStr, (Object)string7);
                                this.addToUnKnownContainers(string4);
                            }
                        }
                        if (!bl) continue;
                        String string9 = string7 + ":" + n2 + ":" + string5;
                        String string10 = (String)vector.get(i);
                        if (string10 != null) {
                            string10 = string10.replace("#~#0#~#", "#~#" + n2 + "#~#");
                        }
                        if ((n3 = vector3.indexOf(string4)) <= -1 || (string8 = (String)vector2.get(n3)) == null || string8.length() <= 0) continue;
                        if (!arrayList2.contains(string8) && !APMDiscoveryHelper.isInDiscoverdList(string8)) {
                            arrayList.add(this.getIniHelper("JAVA_UNIQUE_GUID_MAPPING", string9, string8));
                            arrayList.add(this.getIniHelper("JAVA_SERVER_DETAILS_CONTAINER_BASED", string9, string10));
                            arrayList.add(this.getIniHelper("JAVA_SERVER_DETAILS_DISCOVERD_TIME", string9, System.currentTimeMillis() + ""));
                            String string11 = (String)hashMap.get(string4);
                            if (string11 != null && string11.length() > 0) {
                                arrayList.add(this.getIniHelper("APPFLOW_SERVICE_AUTO_NAME_MAPPING", string9, string11));
                                arrayList3.add(this.getIniHelper(string3, string4, string4));
                            }
                            arrayList3.add(this.getIniHelper(string2, string4, string4));
                            arrayList3.add(this.getIniHelper(string, string4, string4));
                            arrayList2.add(string8);
                            if (!APMComponentIDRepository.isThisManaged(string9)) continue;
                            String string12 = APMComponentIDRepository.getJvmGuidFromTemp(string9);
                            APMComponentIDRepository.addToTempComponentRepository(string12, string8);
                            APMComponentIDRepository.addToTempComponentRepository(string8, string12);
                            APMDiscoveryLogger.discoveryLogger.info(this.loggerDispStr + " {} is already discovered and auto-managed with {}:{}, Skipping port docker finding and registering temporary id into repo", new Object[]{string8, string9, string12});
                            continue;
                        }
                        if (APMDiscoveryHelper.isInDiscoverdList(string8)) {
                            APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " {} Already discovered, so skipping port finding for [{}] and adding to delete list : ", (Object)string8, (Object)string4);
                        }
                        arrayList3.add(this.getIniHelper(string2, string4, string4));
                        arrayList3.add(this.getIniHelper(string, string4, string4));
                        continue;
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to do port finding : ", (Throwable)exception);
                    }
                }
            }
            boolean bl = this.storeToIni(arrayList, arrayList3);
            if (APMDiscoveryLogger.discoveryLogger.isTraceEnabled()) {
                APMDiscoveryLogger.discoveryLogger.trace(this.loggerDispStr + " addThis    : " + arrayList);
                APMDiscoveryLogger.discoveryLogger.trace(this.loggerDispStr + " deleteThis :   " + arrayList3);
                APMDiscoveryLogger.discoveryLogger.trace(this.loggerDispStr + " guids : " + arrayList2);
                APMDiscoveryLogger.discoveryLogger.trace(this.loggerDispStr + " stored : " + bl);
            }
            if (bl && arrayList2.size() > 0) {
                this.setStatus(arrayList2);
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to process discovery details : ", (Throwable)exception);
        }
    }

    private void setStatus(ArrayList arrayList) {
        try {
            if (arrayList != null && arrayList.size() > 0) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    APMDiscoveryHelper.addToDiscoveredList(string);
                    APMComponentIDRepository.setStatusForBtmDiscovery(string, true);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to set status foe newly discovered jvm guids : ", (Throwable)exception);
        }
    }

    private boolean storeToIni(ArrayList arrayList, ArrayList arrayList2) {
        return APMDiscoveryHelper.storeToIni(arrayList, arrayList2);
    }

    public DockerContainers getDockerInstance() {
        DockerContainers dockerContainers = null;
        if (!EgInstallInfo.isWindows) {
            dockerContainers = DockerContainers.getDockerContainerInstance();
        }
        return dockerContainers;
    }

    private boolean discoveryIniUpdated() {
        boolean bl = false;
        long l = IniFile.getLastModified(EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_FILEPATH);
        APMDiscoveryLogger.discoveryLogger.trace(this.loggerDispStr + " Current eg_apmdiscovery.ini file LastModified " + l);
        APMDiscoveryLogger.discoveryLogger.trace(this.loggerDispStr + " Previous eg_apmdiscovery.ini lastModifiedTime " + lastModifiedTime);
        if (lastModifiedTime > -1L) {
            if (l != lastModifiedTime) {
                bl = true;
                lastModifiedTime = l;
            }
        } else {
            lastModifiedTime = l;
            bl = true;
        }
        return bl;
    }

    private boolean isAgentTestsIniUpdated() {
        boolean bl;
        block8: {
            bl = false;
            try {
                long l = IniFile.getLastModified(EgInstallInfo.getInstallDir() + "/agent/config/eg_agentTests.ini");
                APMDiscoveryLogger.discoveryLogger.debug(this.loggerDispStr + " Current eg_agentTests.ini file LastModified " + l);
                APMDiscoveryLogger.discoveryLogger.debug(this.loggerDispStr + " Previous eg_agentTests.ini lastAgentTestsModifiedTime " + lastAgentTestsModifiedTime);
                if (lastAgentTestsModifiedTime > -1L) {
                    if (l != lastAgentTestsModifiedTime) {
                        bl = true;
                        lastAgentTestsModifiedTime = l;
                    }
                } else {
                    lastAgentTestsModifiedTime = l;
                    bl = true;
                }
                if (!bl) break block8;
                try {
                    IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_agentTests.ini");
                    String string = iniFile.getValue("AGENT_SETTINGS", "AgentDiscover");
                    if (string != null && string.length() != 0) {
                        agentDiscoverEnabled = Boolean.parseBoolean(string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    private boolean cleanupIniUpdated() {
        boolean bl = false;
        long l = IniFile.getLastModified(this.cleanIni);
        APMDiscoveryLogger.discoveryLogger.trace(this.loggerDispStr + " Current eg_apmdiscovery_cleanup.inifile LastModified " + l);
        APMDiscoveryLogger.discoveryLogger.trace(this.loggerDispStr + " Previous eg_apmdiscovery_cleanup.ini lastModifiedTime " + lastModifiedTime);
        if (lastCleanupiniModifiedTime > -1L) {
            if (l != lastCleanupiniModifiedTime) {
                bl = true;
                lastCleanupiniModifiedTime = l;
            }
        } else {
            lastCleanupiniModifiedTime = l;
            bl = true;
        }
        return bl;
    }

    private void suspendThread(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.error(" exception in Agent data Contributor thread while suspending Thread... ", (Throwable)exception);
        }
    }

    private IniHelper getIniHelper(final String string, final String string2, final String string3) {
        IniHelper iniHelper = new IniHelper(string, string2, string3){

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string);
                stringBuilder.append("  ");
                stringBuilder.append(string2);
                stringBuilder.append("=");
                stringBuilder.append(string3);
                return stringBuilder.toString();
            }
        };
        return iniHelper;
    }

    private void addToUnKnownContainers(String string) {
        try {
            if (this.unknownContainers.containsKey(string)) {
                int n = (Integer)this.unknownContainers.get(string);
                this.unknownContainers.put(string, n + 1);
            } else {
                this.unknownContainers.put(string, 1);
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to do process discovery details : ", (Throwable)exception);
        }
    }

    private boolean isReachedToMaximumDeletionCounter(String string) {
        try {
            int n;
            if (this.unknownContainers.containsKey(string) && (n = ((Integer)this.unknownContainers.get(string)).intValue()) >= 5) {
                return true;
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to do process discovery details : ", (Throwable)exception);
        }
        return false;
    }

    private void readFromApmIni() {
        try {
            String string = EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_FILEPATH;
            IniFile iniFile = new IniFile(string);
            String string2 = iniFile.getValue("APM_DISCOVERY", "Discovery_Max_Wait_Time");
            string2 = string2.trim();
            if (string2 != null && string2.length() > 0) {
                this.dicoveryMaxWaitTime = Integer.parseInt(string2);
            }
            APMDiscoveryLogger.discoveryLogger.debug(this.loggerDispStr + "dicoveryMaxWaitTime :  {} ", (Object)this.dicoveryMaxWaitTime);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn(this.loggerDispStr + " Unable to do read ini file : ", (Throwable)exception);
        }
    }

    private boolean apmIniUpdated() {
        boolean bl = false;
        long l = IniFile.getLastModified(EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_FILEPATH);
        APMDiscoveryLogger.discoveryLogger.trace(this.loggerDispStr + " Current eg_apm.ini file LastModified : {}, lastModifiedTime : {}", (Object)l, (Object)lastModifiedTime);
        if (this.lastApmIniModifiedTime > -1L) {
            if (l != this.lastApmIniModifiedTime) {
                bl = true;
                this.lastApmIniModifiedTime = l;
            }
        } else {
            this.lastApmIniModifiedTime = l;
            bl = true;
        }
        return bl;
    }
}

