/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class AtsInputStatTest
extends EgSnmpGenericTest {
    boolean isFirst = true;

    public AtsInputStatTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(3);
        this.isNewDynamicInfoTest = true;
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            Hashtable hashtable2 = this.getMeasureHash(".1.3.6.1.4.1.318.1.1.8.5.3.2.1.6");
            if (hashtable2 == null || hashtable2.size() == 0) {
                if (this.isFirst) {
                    this.logToErrorFile("Info :", "AtsInputStatTest No input source available for ", this.targetHost);
                    this.isFirst = false;
                }
                return;
            }
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = ((String)hashtable2.get(string)).trim();
                System.out.println(this.entity + " Key :" + string + " Value :" + string2);
                if (string2 == null || string2.length() <= 0) continue;
                double d = this.getDoubleMeasures(".1.3.6.1.4.1.318.1.1.8.5.3.3.1.3." + string);
                double d2 = this.getDoubleMeasures(".1.3.6.1.4.1.318.1.1.8.5.3.3.1.6." + string);
                double d3 = this.getDoubleMeasures(".1.3.6.1.4.1.318.1.1.8.5.3.3.1.9." + string);
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                System.out.println(this.entity + " MeasureList :" + arrayList);
                this.addNewMeasure(string2, arrayList);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "AtsInputStatTest Exception occured in computeMeasures() for", this.targetHost);
        }
    }

    private double getDoubleMeasures(String string) {
        double d = -5.0;
        try {
            boolean bl = this.runSnmpCmdForOid(string);
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    if (this.rhs[i] != null && this.rhs[i].trim().length() > 0) {
                        String string2 = this.rhs[i].trim();
                        d = Double.parseDouble(string2);
                        if (!(d < 0.0)) continue;
                        d = -5.0;
                        continue;
                    }
                    d = -5.0;
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "AtsInputStatTest Exception occured in getDoubleMeasures() for " + this.targetHost, exception.toString());
            d = -5.0;
        }
        return d;
    }

    private Hashtable getMeasureHash(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            String string2 = "";
            String string3 = "";
            boolean bl = this.runSnmpCmdForOid(string);
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    string3 = this.lhs[i].trim();
                    if (this.rhs[i] == null || this.rhs[i].trim().length() <= 0) continue;
                    string2 = this.rhs[i].trim();
                    hashtable.put(string3, string2);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "AtsInputStatTest Exception occured in getMeasureHash() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    public static void main(String[] stringArray) {
        AtsInputStatTest atsInputStatTest = new AtsInputStatTest(stringArray);
        atsInputStatTest.computeMeasures(new Hashtable());
    }
}

