/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgAgentInfo;
import com.eg.EgInstallInfo;
import com.eg.apm.APMUtils;
import com.eg.apm.AgentJavaSocketServer;
import com.eg.apm.AgentNodeSocketServer;
import com.eg.apm.AgentStartupLogger;
import com.eg.apm.BTMOffloadAPMSocketConfiguration;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;

public class BTMOffloadServerSocketCreater
extends Thread {
    private String logPrefix = " [" + this.getClass().getName() + "] ";
    private static final String threadName = "BTM Offload Server Socket Creator";

    public BTMOffloadServerSocketCreater() {
        this.setName(threadName);
        this.setDaemon(true);
        AgentStartupLogger.logger.trace("{} constructor !!!", (Object)this.logPrefix);
    }

    public void run() {
        AgentStartupLogger.logger.trace("{} BTM Offload Server Socket Creator started !!!", (Object)this.logPrefix);
        while (true) {
            BTMOffloadAPMSocketConfiguration bTMOffloadAPMSocketConfiguration = BTMOffloadAPMSocketConfiguration.getBTMOffloadAPMSocketConfiguration("eg_agentTests.ini");
            boolean bl = bTMOffloadAPMSocketConfiguration.isOpenOffloadPort();
            AgentStartupLogger.logger.trace("{} Open Java BTM Offload Server Socket Port : {}", (Object)this.logPrefix, (Object)bl);
            EgAgentInfo egAgentInfo = new EgAgentInfo("agent");
            ArrayList arrayList = egAgentInfo.getCurrentTests();
            AgentStartupLogger.logger.trace("{} Current tests:  {} ", (Object)this.logPrefix, (Object)arrayList);
            this.socket4JavaTechnology(bTMOffloadAPMSocketConfiguration, bl, arrayList);
            this.socket4NodeJsTechnology(bTMOffloadAPMSocketConfiguration, bl, arrayList);
            long l = bTMOffloadAPMSocketConfiguration.getCheckInterval();
            this.suspendThread(l * 60L * 1000L * 1L);
        }
    }

    private void socket4NodeJsTechnology(BTMOffloadAPMSocketConfiguration bTMOffloadAPMSocketConfiguration, boolean bl, ArrayList arrayList) {
        boolean bl2 = AgentNodeSocketServer.isSocketServerStarted();
        boolean bl3 = this.isOffloadNodeJsTestsEnabled(arrayList);
        AgentStartupLogger.logger.trace("{} Is any  NodeJS BTM test(s) running ? : {}", (Object)this.logPrefix, (Object)bl3);
        if (bl || bl3) {
            try {
                if (!bl2) {
                    AgentNodeSocketServer.startServer(bTMOffloadAPMSocketConfiguration);
                    bl2 = true;
                    System.out.println(new Date() + " BTM Offload NodeJS Server Socket Started : " + bl2);
                }
            }
            catch (Exception exception) {
                AgentStartupLogger.logger.error("{} Unable to Start Offload NodeJS Server with Agent : {}", (Object)this.logPrefix, (Object)exception);
            }
        } else if (!bl && !bl3) {
            try {
                if (bl2) {
                    AgentNodeSocketServer.closeServerSocket();
                }
            }
            catch (Exception exception) {
                AgentStartupLogger.logger.error("{} Unable to close BTM Offload NodeJS socket server {}", (Object)this.logPrefix, (Object)exception);
            }
        }
    }

    private void socket4JavaTechnology(BTMOffloadAPMSocketConfiguration bTMOffloadAPMSocketConfiguration, boolean bl, ArrayList arrayList) {
        boolean bl2 = AgentJavaSocketServer.isSocketServerStarted();
        boolean bl3 = this.isOffloadTestsEnabled(arrayList);
        AgentStartupLogger.logger.trace("{} Is any Java BTM test(s) running ? {}", (Object)this.logPrefix, (Object)bl3);
        if (bl || bl3) {
            try {
                if (!bl2) {
                    DockerContainers dockerContainers = this.getDockerInstance();
                    boolean bl4 = false;
                    if (dockerContainers != null) {
                        bl4 = dockerContainers.isDockerServer;
                    }
                    AgentStartupLogger.logger.info("{} isDockerHost : {} , dockConObj : {}", new Object[]{this.logPrefix, bl4, dockerContainers});
                    if (bl4) {
                        String string = dockerContainers.getDockerHostInternalIp();
                        if (string.equalsIgnoreCase("127.0.0.1")) {
                            String string2 = this.getAgentIp();
                            AgentStartupLogger.logger.trace("{} Agent IP for binding : {} ", (Object)this.logPrefix, (Object)string2);
                            APMUtils.setContainerHostIp(string2, AgentStartupLogger.logger);
                            if (!string2.equalsIgnoreCase("127.0.0.1")) {
                                bTMOffloadAPMSocketConfiguration.setAgentIpAsBindIp(true);
                                AgentStartupLogger.logger.warn("{} INFO:- This Host found as a docker environment,but unable to find docker internal IP address. Using Agent Host IP address as a Offload Socket bind IP : {}", (Object)this.logPrefix, (Object)string2);
                            }
                        } else {
                            APMUtils.setContainerHostIp(string, AgentStartupLogger.logger);
                        }
                        AgentStartupLogger.logger.info("{} Assigned container Host IP {} ", (Object)this.logPrefix, (Object)APMUtils.getContainerHostIp());
                    }
                    AgentJavaSocketServer.startServer(bTMOffloadAPMSocketConfiguration, bl4);
                    bl2 = true;
                    System.out.println(new Date() + " BTM Offload Server Socket Started : " + bl2);
                }
            }
            catch (Exception exception) {
                AgentStartupLogger.logger.error("{} Unable to Start Offload Server with Agent : {}", (Object)this.logPrefix, (Object)exception);
            }
        } else if (!bl && !bl3) {
            try {
                if (bl2) {
                    AgentJavaSocketServer.closeServerSocket();
                }
            }
            catch (Exception exception) {
                AgentStartupLogger.logger.error("{} Unable to close BTM Offload socket server {}", (Object)this.logPrefix, (Object)exception);
            }
        }
    }

    private DockerContainers getDockerInstance() {
        DockerContainers dockerContainers = null;
        if (!EgInstallInfo.isWindows) {
            dockerContainers = DockerContainers.getDockerContainerInstance();
        }
        return dockerContainers;
    }

    private void suspendThread(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isOffloadTestsEnabled(ArrayList arrayList) {
        boolean bl = false;
        try {
            if (arrayList != null && arrayList.size() > 0 && (arrayList.contains("BusinessTransTest") || arrayList.contains("KBusinessTransTest"))) {
                bl = true;
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Unable to check BTM offload testes {} ", (Object)this.logPrefix, (Object)exception);
        }
        return bl;
    }

    private boolean isOffloadNodeJsTestsEnabled(ArrayList arrayList) {
        boolean bl = false;
        try {
            if (arrayList != null && arrayList.size() > 0 && (arrayList.contains("NodeTransTest") || arrayList.contains("KNodeTransTest"))) {
                bl = true;
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Unable to check NodeJS BTM offload testes {} ", (Object)this.logPrefix, (Object)exception);
        }
        return bl;
    }

    private String getAgentIp() {
        String string;
        block3: {
            string = "127.0.0.1";
            try {
                String string2 = InetAddress.getLocalHost().getHostName();
                InetAddress[] inetAddressArray = InetAddress.getAllByName(string2);
                AgentStartupLogger.logger.trace("{} localHostName : {} & InetAddress : {} ", new Object[]{this.logPrefix, string2, inetAddressArray});
                if (inetAddressArray == null || inetAddressArray.length < 1) break block3;
                for (int i = 0; i < inetAddressArray.length; ++i) {
                    String string3;
                    InetAddress inetAddress = inetAddressArray[i];
                    AgentStartupLogger.logger.trace("{} Ip Address : {} ", (Object)this.logPrefix, (Object)inetAddress.getHostAddress());
                    if (inetAddress != null && this.isLoopbackAddress(inetAddress) || (string3 = inetAddress.getHostAddress()) == null || string3.startsWith("169.254.") || string3.indexOf(":") > 0) continue;
                    string = string3;
                    break;
                }
            }
            catch (UnknownHostException unknownHostException) {
                AgentStartupLogger.logger.error("{} Exception occured while getting agent Ip {}", (Object)this.logPrefix, (Object)unknownHostException);
            }
        }
        return string;
    }

    private boolean isLoopbackAddress(InetAddress inetAddress) {
        boolean bl = false;
        String string = inetAddress.getHostAddress();
        if (string.startsWith("127.") || string.startsWith("0:0:0:0:0:0:0:1") || string.startsWith("::1")) {
            bl = true;
        }
        return bl;
    }
}

