/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMLanguage;
import com.eg.apm.APMWorker;
import com.eg.apm.ComponentWatcherTracker;
import com.eg.apm.JavaAPMComponent;
import com.eg.apm.JavaBTMLogger;
import com.eg.apm.SnapShotTakerWatcher;
import com.eg.apm.Status;
import com.eg.apm.UserAgentUtil;
import com.eg.apm.util.IPAddressMaskHelper;
import com.eg.apm.util.UrlParamMaskHelper;
import com.eg.jtm.DataBaseUtils;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.PropsManager;
import com.eg.jtm.UPDManager;
import com.eg.org.objectweb.asm.Type;
import com.eg.org.slf4j.Logger;
import com.egurkha.util.IPAddressUtils;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.mail.URLName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BusinessTransTestBase
extends BTMBase {
    protected Hashtable sourceTable;
    protected Hashtable DataBaseHT;
    protected static String logPrefix = "BusinessTransTestBase";
    protected static final Hashtable<String, Hashtable<String, String>> jdbcURLDetails = new Hashtable();
    protected Hashtable slowURLTable = null;
    protected Hashtable stalledURLTable = null;
    protected Hashtable errorURLTable = null;
    protected Hashtable allURLTable = null;
    protected Hashtable externalTable = null;
    protected Hashtable stackTraceTable = null;
    protected Hashtable recentThresholdTable = null;
    protected Hashtable previousThresholdTable = new Hashtable();
    protected HashMap previousAppNameTable = new HashMap();
    protected boolean cpuTimeTrackingFlag = false;
    protected boolean contentionTimeTrackingFlag = false;
    private boolean isFirstTime = true;
    private static Hashtable<String, String> ldapMethodMapping = new Hashtable();
    private static final String SESSION_USER_KEY = "SESSION_USER_KEY";
    private HashMap sessionUserMapping = null;
    public static final String TRANSACTION_FLOW_TEST = "TransactionFlowTest";
    private static int read_timeout;
    private static int thread_timeout;
    protected int status_code;

    public BusinessTransTestBase(String[] stringArray) {
        super(stringArray);
        String string;
        String string2;
        this.loggerDispStr = "[" + this.reportingName + ":" + this.portNo + "] [" + logPrefix + "]";
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        this.trgtHost = this.getValueForParam("trgtHost");
        if (!this.entity.equals(TRANSACTION_FLOW_TEST) && !this.entity.equals("JavaExceptionsTest")) {
            string2 = this.getValueForParam("Enable_Thread_Cpu_Monitoring");
            if (string2 != null && string2.equalsIgnoreCase("true")) {
                this.cpuTimeTrackingFlag = true;
            }
            if ((string = this.getValueForParam("Enable_Thread_Contention_Monitoring")) != null && string.equalsIgnoreCase("true")) {
                this.contentionTimeTrackingFlag = true;
            }
            JavaBTMLogger.btmLogger.debug("{} Thread CPU Time Tracking ? :{} Thread Contention Monitoring ? {}", new Object[]{this.loggerDispStr, string2, string});
        }
        string2 = testerInfo.getValueFor("BTM_TIMEOUT_SETTINGS", "ReadTimeout");
        read_timeout = 2000;
        if (string2 != null && string2.length() > 0) {
            try {
                read_timeout = Integer.parseInt(string2);
                if (thread_timeout < 0) {
                    read_timeout = 2000;
                }
            }
            catch (Exception exception) {
                JavaBTMLogger.btmLogger.warn("Exception occured while converting {}, assigning default value for ReadTimeout", (Object)string2);
            }
        }
        string = testerInfo.getValueFor("BTM_TIMEOUT_SETTINGS", "TCPTimeout");
        thread_timeout = 10000;
        if (string != null && string.length() > 0) {
            try {
                thread_timeout = Integer.parseInt(string);
                if (thread_timeout < 0) {
                    thread_timeout = 10000;
                }
            }
            catch (Exception exception) {
                JavaBTMLogger.btmLogger.warn("Exception occured while converting {} , assigning default value for TCPTimeout", (Object)string);
            }
        }
    }

    private void checkForPropsChanges(String[] stringArray, JavaAPMComponent javaAPMComponent) {
        PropsManager propsManager = javaAPMComponent.getPropsManager();
        if (propsManager != null) {
            ArrayList arrayList = this.makePropsListForOffload(stringArray);
            propsManager.handlePropChangesFromTest(arrayList, this.entity);
            HashMap hashMap = new HashMap(propsManager.getBTMprops());
            if (this.entity.equalsIgnoreCase(TRANSACTION_FLOW_TEST)) {
                hashMap = this.getAppNameTierNameFromIni(hashMap);
            }
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap2.put("ModifiedPropsTable", hashMap);
            hashMap2.put("Entity", this.entity);
            hashMap2.put("PropsValuesByOrder", arrayList);
            javaAPMComponent.setPropsDetails(this.entity, hashMap2);
            JavaBTMLogger.btmLogger.debug("{} {} is registered with Props {} ", new Object[]{this.loggerDispStr, javaAPMComponent.getID(), hashMap2});
        }
    }

    private void checkForAppNameChanges(JavaAPMComponent javaAPMComponent) {
        HashMap hashMap = new HashMap();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        HashMap hashMap3 = this.getAppNameTierNameFromIni(new HashMap());
        HashMap hashMap4 = this.getModifiedProps(hashMap3, this.previousAppNameTable);
        hashMap.putAll(hashMap4);
        this.previousAppNameTable = hashMap3;
        JavaBTMLogger.btmLogger.debug("{}  currentAppNameTable: {} ,  previousAppNameTable: {} , modifiedAppTable: {} ", new Object[]{this.loggerDispStr, hashMap3, this.previousAppNameTable, hashMap4});
        if (hashMap != null && hashMap.size() > 0) {
            hashMap2.put("ModifiedPropsTable", hashMap);
            hashMap2.put("Entity", this.entity);
            javaAPMComponent.setPropsDetails(this.entity, hashMap2);
            JavaBTMLogger.btmLogger.debug("{}  propsData: {} ", (Object)this.loggerDispStr, hashMap2);
        } else {
            JavaBTMLogger.btmLogger.trace("{}  No difference in props table:", (Object)this.loggerDispStr);
        }
    }

    public void computeMeasures(Hashtable hashtable, String[] stringArray) {
        Object object;
        Object object2;
        this.getJvmGuid(true);
        this.checkTempComponentID();
        JavaAPMComponent javaAPMComponent = APMComponentIDRepository.getJavaAPMComponent(this.jvmGUID);
        if (javaAPMComponent == null) {
            JavaBTMLogger.btmLogger.warn("{} Component [{}] - {} is not available in the Repository", new Object[]{this.loggerDispStr, this.jvmGUID, this.NodeID});
            return;
        }
        javaAPMComponent.printAPMRepositoryDetails(JavaBTMLogger.btmLogger);
        if (JavaBTMLogger.btmLogger.isDebugEnabled()) {
            JavaBTMLogger.btmLogger.debug("{}  Component {} - {} is available in the Repository", new Object[]{this.loggerDispStr, this.jvmGUID, this.NodeID});
            Hashtable hashtable2 = APMComponentIDRepository.getComponentRepository();
            JavaBTMLogger.btmLogger.debug("{} ALL ID's : {} ", (Object)this.loggerDispStr, (Object)hashtable2);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.entity.equalsIgnoreCase(TRANSACTION_FLOW_TEST)) {
            this.getAppNameTierNameFromIni(new HashMap());
            this.checkForAppNameChanges(javaAPMComponent);
            JavaBTMLogger.btmLogger.trace("{} App Name : {}", (Object)this.loggerDispStr, (Object)this.applicationName);
            JavaBTMLogger.btmLogger.trace("{}  Tier Name : {}", (Object)this.loggerDispStr, (Object)this.tierName);
            APMWorker.addNewEntryToAppTierNameTable(this.NodeID + "_AppName", this.applicationName);
            APMWorker.addNewEntryToAppTierNameTable(this.NodeID + "_TierName", this.tierName);
        }
        this.slowURLTable = new Hashtable();
        this.stalledURLTable = new Hashtable();
        this.errorURLTable = new Hashtable();
        this.allURLTable = new Hashtable();
        this.externalTable = new Hashtable();
        this.stackTraceTable = new Hashtable();
        this.sourceTable = new Hashtable();
        this.DataBaseHT = new Hashtable();
        this.recentThresholdTable = new Hashtable();
        if (javaAPMComponent.getStatus() == Status.NONE) {
            int n = 1;
            while (!bl && n <= 10) {
                JavaBTMLogger.btmLogger.trace("{} Component {} - {} - Trying to get data from PUSH MODE ", new Object[]{this.loggerDispStr, this.jvmGUID, this.NodeID});
                bl = this.getOffLoadData(javaAPMComponent);
                if (bl && javaAPMComponent.getStatus() == Status.MANAGED_OFFLOAD) {
                    JavaBTMLogger.btmLogger.debug("{} Component {} - {} is registered as {} ", new Object[]{this.loggerDispStr, this.jvmGUID, this.NodeID, Status.MANAGED_OFFLOAD});
                    break;
                }
                if (javaAPMComponent.getStatus() == Status.MANAGED_OFFLOAD) break;
                ++n;
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {}
            }
        }
        if (javaAPMComponent.getStatus() == Status.NONE) {
            JavaBTMLogger.btmLogger.warn("{} Unable to get data for the component via PUSH MODE {} - {} - Current mode is {} , Ensure that server is up and running on BTM PUSH MODE ", new Object[]{this.loggerDispStr, this.jvmGUID, this.NodeID, javaAPMComponent.getStatus()});
        }
        Enumeration enumeration = this.results.keys();
        while (enumeration.hasMoreElements()) {
            Threshold threshold;
            double[] dArray;
            object2 = (String)enumeration.nextElement();
            EgResultSet egResultSet = (EgResultSet)this.results.get(object2);
            object = egResultSet.thresholds;
            if (object == null || ((Threshold[])object).length <= 0 || (dArray = (threshold = object[1]).getUpperBound()) == null || dArray.length < 2) continue;
            String string = dArray[0] + "/" + dArray[1];
            Object object3 = object2;
            int n = ((String)object2).indexOf(siteAndInfoSeparator);
            if (n > 0) {
                object3 = ((String)object2).substring(n + 1);
            }
            this.recentThresholdTable.put(object3, string);
        }
        object2 = this.getModifiedThresholdPatterns(this.recentThresholdTable, this.previousThresholdTable);
        JavaBTMLogger.btmLogger.debug("{} modifiedThreshPatterns: {}", (Object)this.loggerDispStr, object2);
        if (javaAPMComponent.getStatus() == Status.NONE) {
            JavaBTMLogger.btmLogger.trace("{} Component {} - {} - Trying to get data from PULL MODE ", new Object[]{this.loggerDispStr, this.jvmGUID, this.NodeID});
            this.makePropsList(stringArray);
            bl2 = this.pullDataFromBTMjar((Hashtable)object2, stringArray);
            if (bl2) {
                javaAPMComponent.setStatus(Status.MANAGED_NON_OFFLOAD);
                JavaBTMLogger.btmLogger.debug("{} Component {} - {} is registered as {} ", new Object[]{this.loggerDispStr, this.jvmGUID, this.NodeID, Status.MANAGED_NON_OFFLOAD});
            }
        }
        JavaBTMLogger.btmLogger.debug("{} Component {} - {} is available in the Respository & it's mode {} ", new Object[]{this.loggerDispStr, this.jvmGUID, this.NodeID, javaAPMComponent.getStatus()});
        if (javaAPMComponent.getStatus() == Status.MANAGED_OFFLOAD) {
            boolean bl3;
            boolean bl4 = bl3 = javaAPMComponent.getHeartbeatStatus() == Status.HEART_BEATING;
            if (!bl && bl3) {
                bl = this.getOffLoadData(javaAPMComponent);
            }
            if ((object = this.updateThresholds((Hashtable)object2, this.entity)) != null) {
                javaAPMComponent.setThresholdDetails(this.entity, (HashMap)object);
            }
            if (this.isFirstTime) {
                this.checkForPropsChanges(stringArray, javaAPMComponent);
                this.isFirstTime = false;
            }
            if (javaAPMComponent.isPrepareBtmTestConfigs(this.entity)) {
                JavaBTMLogger.btmLogger.info("{} [eGTest_Config_Request] Preparing BTM configs for {} - {} - {}", new Object[]{this.loggerDispStr, this.NodeID, this.jvmGUID, this.entity});
                this.checkForPropsChanges(stringArray, javaAPMComponent);
                javaAPMComponent.setPrepareBtmTestConfigs(this.entity, false);
            }
            if (javaAPMComponent.isPrepareTresholdConfigs(this.entity)) {
                JavaBTMLogger.btmLogger.info("{} [eGTest_Config_Request] Preparing threshold configs for {} - {} - {}", new Object[]{this.loggerDispStr, this.NodeID, this.jvmGUID, this.entity});
                object = this.updateThresholds(this.recentThresholdTable, this.entity);
                if (object != null) {
                    javaAPMComponent.setThresholdDetails(this.entity, (HashMap)object);
                }
                javaAPMComponent.setPrepareTresholdConfigs(this.entity, false);
            }
        } else if (javaAPMComponent.getStatus() == Status.MANAGED_NON_OFFLOAD && !bl2) {
            bl2 = this.pullDataFromBTMjar((Hashtable)object2, stringArray);
        }
        if (javaAPMComponent.getStatus() == Status.NONE) {
            JavaBTMLogger.btmLogger.warn("{} Unable to find the running mode [PULL MODE or PUSH MODE] of the Component {} - {} - Current mode is {} \n \t \t \t\t \t \t\t [PULL MODE] --> eGAgent communicate with BTM enabled application server and collect metrics i.e) /<<eg_btm_jar_location>>/config.props having PUSH_TO_AGENT_MODE=false property.\n \t \t \t\t \t \t\t [PUSH MODE] --> eGBTM Jar communicate with eG Agent and send collected metrics  i.e) /<<eg_btm_jar_location>>/config.props having PUSH_TO_AGENT_MODE=true property.", new Object[]{this.loggerDispStr, this.jvmGUID, this.NodeID, javaAPMComponent.getStatus()});
            return;
        }
        ComponentWatcherTracker.isWatcherNull(true);
        SnapShotTakerWatcher.isWatcherNull(true, this.jvmGUID);
        JavaBTMLogger.btmLogger.debug("{} sourceTable:{} ", (Object)this.loggerDispStr, (Object)this.sourceTable);
        if (this.status_code == 200 && this.sourceTable != null && this.sourceTable.size() > 0) {
            this.computeBTMData(this.sourceTable, javaAPMComponent);
        } else if (this.status_code != 200) {
            JavaBTMLogger.btmLogger.warn("{} Getting status code {} due to some reasons", (Object)this.loggerDispStr, (Object)this.status_code);
        }
    }

    private boolean pullDataFromBTMjar(Hashtable hashtable, String[] stringArray) {
        boolean bl = false;
        if (this.establishConnectionResources()) {
            this.queryServer(hashtable, JavaBTMLogger.btmLogger);
            boolean bl2 = this.getBTMData();
            this.closeConnectionResources();
            this.propsList.clear();
            if (bl2) {
                bl = true;
            } else {
                this.makePropsList(stringArray);
                this.previousThresholdTable = new Hashtable();
            }
        } else {
            JavaBTMLogger.btmLogger.warn("{} Could not establish connection to BTM[PULL MODE] !!! ", (Object)this.loggerDispStr);
            this.makePropsList(stringArray);
        }
        return bl;
    }

    private boolean getBTMData() {
        boolean bl = false;
        try {
            BTMHelperThread bTMHelperThread = new BTMHelperThread(this.cliSock, this.entity, JavaBTMLogger.btmLogger, this.loggerDispStr);
            long l = 0L;
            long l2 = thread_timeout;
            long l3 = 250L;
            int n = 0;
            long l4 = System.currentTimeMillis();
            while (true) {
                this.suspendForPeriod(l3);
                if (bTMHelperThread.isDone) {
                    this.sourceTable = bTMHelperThread.getsourceTable();
                    this.DataBaseHT = bTMHelperThread.getDataBaseHT();
                    this.status_code = bTMHelperThread.getStatusCode();
                    bl = bTMHelperThread.getIsSuccess();
                    bTMHelperThread.closeConnectionResources();
                    break;
                }
                if (++n >= 5) {
                    n = 0;
                    l = System.currentTimeMillis() - l4;
                } else {
                    l += l3;
                }
                if (l >= l2 || l3 <= 0L) {
                    bTMHelperThread.interrupt();
                    Thread.currentThread();
                    Thread.yield();
                    this.sourceTable = bTMHelperThread.getsourceTable();
                    this.DataBaseHT = bTMHelperThread.getDataBaseHT();
                    this.status_code = bTMHelperThread.getStatusCode();
                    bl = bTMHelperThread.getIsSuccess();
                    bTMHelperThread.stop();
                    bTMHelperThread = null;
                    break;
                }
                long l5 = l2 - l;
                if (l5 >= l3) continue;
                l3 = l5;
            }
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} IOException : {}", (Object)this.loggerDispStr, (Object)exception);
        }
        JavaBTMLogger.btmLogger.debug("{} Method getBTMData returns : {}", (Object)this.loggerDispStr, (Object)bl);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean establishConnectionResources() {
        block20: {
            var1_1 = false;
            try {
                var2_2 = InetAddress.getByName(this.trgtHost);
                this.cliSock = new Socket();
                this.cliSock.bind(null);
                JavaBTMLogger.btmLogger.debug("{} Trying to connect to {} at port {} ", new Object[]{this.loggerDispStr, var2_2, this.BTM_Port});
                this.cliSock.connect(new InetSocketAddress(var2_2, this.BTM_Port), this.socketTimeout);
                this.cliSock.setSoTimeout(BusinessTransTestBase.read_timeout);
                JavaBTMLogger.btmLogger.debug("{} Connected to {} on port {} ", new Object[]{this.loggerDispStr, var2_2, this.BTM_Port});
                var1_1 = true;
                var4_7 = null;
                ** if (var1_1 || this.cliSock == null) goto lbl-1000
            }
            catch (Throwable var3_19) {
                var4_12 = null;
                if (!var1_1 && this.cliSock != null) {
                    try {
                        this.cliSock.close();
                    }
                    catch (IOException var5_18) {
                        JavaBTMLogger.btmLogger.error("{} Unable to close client socket: {} ", (Object)this.loggerDispStr, (Object)var5_18);
                    }
                }
                throw var3_19;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    this.cliSock.close();
                }
                catch (IOException var5_13) {
                    JavaBTMLogger.btmLogger.error("{} Unable to close client socket: {} ", (Object)this.loggerDispStr, (Object)var5_13);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block20;
                catch (UnknownHostException var2_3) {
                    JavaBTMLogger.btmLogger.error("{} UnknownHostException : {} ", (Object)this.loggerDispStr, (Object)var2_3.getMessage());
                    var1_1 = false;
                    var4_8 = null;
                    if (!var1_1 && this.cliSock != null) {
                        try {
                            this.cliSock.close();
                        }
                        catch (IOException var5_14) {
                            JavaBTMLogger.btmLogger.error("{} Unable to close client socket: {} ", (Object)this.loggerDispStr, (Object)var5_14);
                        }
                    }
                    break block20;
                }
                catch (SocketTimeoutException var2_4) {
                    JavaBTMLogger.btmLogger.warn("{} SocketTimeoutException : Unable to connect BTM port, Ensure that server is up and running on BTM PULL MODE -  {} ", (Object)this.loggerDispStr, (Object)var2_4.getMessage());
                    var1_1 = false;
                    var4_9 = null;
                    if (!var1_1 && this.cliSock != null) {
                        try {
                            this.cliSock.close();
                        }
                        catch (IOException var5_15) {
                            JavaBTMLogger.btmLogger.error("{} Unable to close client socket: {} ", (Object)this.loggerDispStr, (Object)var5_15);
                        }
                    }
                    break block20;
                }
                catch (ConnectException var2_5) {
                    JavaBTMLogger.btmLogger.warn("{} ConnectException - Connection refused:  Unable to connect BTM port, Ensure that server is up and running on BTM PULL MODE -  {} ", (Object)this.loggerDispStr, (Object)var2_5.getMessage());
                    var1_1 = false;
                    var4_10 = null;
                    if (!var1_1 && this.cliSock != null) {
                        try {
                            this.cliSock.close();
                        }
                        catch (IOException var5_16) {
                            JavaBTMLogger.btmLogger.error("{} Unable to close client socket: {} ", (Object)this.loggerDispStr, (Object)var5_16);
                        }
                    }
                    break block20;
                }
                catch (IOException var2_6) {
                    JavaBTMLogger.btmLogger.error("{}  IOException : {}", (Object)this.loggerDispStr, (Object)var2_6);
                    var1_1 = false;
                    var4_11 = null;
                    if (!var1_1 && this.cliSock != null) {
                        try {
                            this.cliSock.close();
                        }
                        catch (IOException var5_17) {
                            JavaBTMLogger.btmLogger.error("{} Unable to close client socket: {} ", (Object)this.loggerDispStr, (Object)var5_17);
                        }
                    }
                }
            }
        }
        JavaBTMLogger.btmLogger.debug("{}  Method establishConnectionResources returns : {}", (Object)this.loggerDispStr, (Object)var1_1);
        return var1_1;
    }

    protected void closeConnectionResources() {
        try {
            if (this.oos != null) {
                this.oos.close();
            }
            if (this.cliSock != null) {
                this.cliSock.close();
            }
        }
        catch (IOException iOException) {
            JavaBTMLogger.btmLogger.error("{} Error closing connection resources after getting measures from BTM : {} ", (Object)this.loggerDispStr, (Object)iOException);
        }
    }

    protected void queryServer(Hashtable hashtable, Logger logger) {
        try {
            if (this.propsList != null && this.propsList.size() == 0) {
                this.propsList.add("BTM");
                this.propsList.add(this.entity);
            }
            this.oos = new ObjectOutputStream(this.cliSock.getOutputStream());
            this.oos.writeObject(this.propsList);
            this.oos.writeObject(hashtable);
            this.oos.flush();
            JavaBTMLogger.btmLogger.debug("{} Sent the following props list to BTM : {} ", (Object)this.loggerDispStr, (Object)this.propsList);
        }
        catch (IOException iOException) {
            JavaBTMLogger.btmLogger.error("{} Error in sending the props list to BTM : {}", (Object)this.loggerDispStr, (Object)iOException);
        }
    }

    protected void makePropsList(String[] stringArray) {
        if (this.propsList != null && this.propsList.size() > 0) {
            this.propsList.clear();
        }
        if (stringArray.length == 0) {
            this.propsList.add("BTM");
            this.propsList.add(this.entity);
            this.propsList.add(String.valueOf(this.measurePeriod));
        } else {
            String string = null;
            this.propsList.add("BTM");
            this.propsList.add(this.entity);
            for (int i = 0; i < stringArray.length; ++i) {
                string = this.getValueForParam(stringArray[i]);
                if (string != null) {
                    this.propsList.add(string);
                    continue;
                }
                this.propsList.add("-");
            }
            this.propsList.add(this.NodeID);
            string = null;
        }
        JavaBTMLogger.btmLogger.debug("{} propsList value is {} ", (Object)this.loggerDispStr, (Object)this.propsList);
    }

    protected ArrayList makePropsListForOffload(String[] stringArray) {
        if (this.propsList != null && this.propsList.size() > 0) {
            this.propsList.clear();
        }
        if (stringArray.length > 0) {
            String string = null;
            for (int i = 0; i < stringArray.length; ++i) {
                string = this.getValueForParam(stringArray[i]);
                if (string != null) {
                    this.propsList.add(string);
                    continue;
                }
                this.propsList.add("-");
            }
            this.propsList.add(this.NodeID);
            string = null;
        }
        JavaBTMLogger.btmLogger.debug("{} propsList value is {} ", (Object)this.loggerDispStr, (Object)this.propsList);
        return this.propsList;
    }

    public ArrayList getSlowURLDetails(String string) {
        ArrayList arrayList = null;
        if (this.slowURLTable != null && this.slowURLTable.size() > 0) {
            arrayList = (ArrayList)this.slowURLTable.get(string);
        }
        return arrayList;
    }

    public ArrayList getErrorURLDetails(String string) {
        ArrayList arrayList = null;
        if (this.errorURLTable != null && this.errorURLTable.size() > 0) {
            arrayList = (ArrayList)this.errorURLTable.get(string);
        }
        return arrayList;
    }

    public ArrayList getStalledURLDetails(String string) {
        ArrayList arrayList = null;
        if (this.stalledURLTable != null && this.stalledURLTable.size() > 0) {
            arrayList = (ArrayList)this.stalledURLTable.get(string);
        }
        return arrayList;
    }

    public ArrayList getAllURLDetails(String string) {
        ArrayList arrayList = null;
        if (this.allURLTable != null && this.allURLTable.size() > 0) {
            arrayList = (ArrayList)this.allURLTable.get(string);
        }
        return arrayList;
    }

    public ArrayList getExternalCallDetails(String string) {
        ArrayList arrayList = null;
        if (this.externalTable != null && this.externalTable.size() > 0) {
            arrayList = (ArrayList)this.externalTable.get(string);
        }
        return arrayList;
    }

    public Hashtable getStackTraceTable(String string) {
        Hashtable hashtable = null;
        if (this.stackTraceTable != null && this.stackTraceTable.size() > 0) {
            hashtable = (Hashtable)this.stackTraceTable.get(string);
        }
        return hashtable;
    }

    public Hashtable DataBaseInfo(String string) {
        Hashtable<Object, Object> hashtable = new Hashtable();
        if (jdbcURLDetails.containsKey(string)) {
            hashtable = jdbcURLDetails.get(string);
        } else {
            hashtable = DataBaseUtils.getDBInfo(string, null, null, JavaBTMLogger.btmLogger, APMLanguage.JAVA);
            String string2 = (String)hashtable.get("PORTNUMBER");
            String string3 = (String)hashtable.get("SERVERNAME");
            if (string3.startsWith("jdbc:")) {
                String string4 = this.maskedJdbcURL(string3);
                int n = string4.length();
                if (n > 256) {
                    string4 = string4.substring(0, 252);
                }
                hashtable.put("SERVERNAME", string4);
            } else if (!string2.equals("-") && !string3.startsWith("jdbc:")) {
                try {
                    int n = Integer.parseInt(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    string3 = string3 + "\\" + string2;
                    string2 = "-";
                    hashtable.put("PORTNUMBER", string2);
                    hashtable.put("SERVERNAME", string3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            jdbcURLDetails.put(string, hashtable);
        }
        return hashtable;
    }

    private String maskedJdbcURL(String string) {
        int n = 0;
        string = string.toLowerCase();
        String[] stringArray = new String[]{"password=", "ldap_passwd="};
        n = string.indexOf(stringArray[0]);
        int n2 = 0;
        int n3 = -1;
        if (n < 0) {
            n = string.indexOf(stringArray[1]);
            n2 = stringArray[1].length();
            n3 = 1;
        } else {
            n2 = stringArray[0].length();
            n3 = 0;
        }
        if (n <= 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (n > 0) {
            int n4 = n + n2;
            String string2 = string.substring(n4);
            String string3 = string.substring(0, n4);
            stringBuilder.append(string3);
            int n5 = 0;
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                boolean bl = false;
                switch (c) {
                    case '&': 
                    case ')': 
                    case ',': 
                    case ';': {
                        bl = true;
                        break;
                    }
                    default: {
                        ++n5;
                    }
                }
                if (bl) break;
            }
            if (n5 > 0) {
                string2 = string2.substring(n5);
                stringBuilder.append("$$$$");
            }
            if ((n = string2.indexOf(stringArray[n3])) < 0) {
                stringBuilder.append(string2);
                break;
            }
            string = string2;
        }
        return stringBuilder.toString();
    }

    public HashMap getSessionUserMapping() {
        return this.sessionUserMapping;
    }

    public void clearSessionUserMapping() {
        if (this.sessionUserMapping != null) {
            this.sessionUserMapping.clear();
        }
        this.sessionUserMapping = null;
    }

    public String getJvmGUID() {
        return this.jvmGUID;
    }

    public String getApplicationName() {
        JavaBTMLogger.btmLogger.debug("{} Method getApplicationName returns :  {}", (Object)this.loggerDispStr, (Object)this.applicationName);
        return this.applicationName;
    }

    public void printOut(String string) {
        System.out.println(this.toString() + " " + this.reportingName + " " + mySDF.format(new Date()) + " :" + logPrefix + string);
    }

    public void printErr(String string) {
        System.err.println(this.toString() + " " + this.reportingName + " " + mySDF.format(new Date()) + " :" + logPrefix + string);
    }

    String STEs2Str(StackTraceElement[] stackTraceElementArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuilder.append('\t').append(stackTraceElementArray[i].toString()).append('\n');
        }
        return stringBuilder.toString();
    }

    private long calculateExclusiveTime(MethodInfo methodInfo, HashMap hashMap) {
        long l = 0L;
        List<Long> list = methodInfo.getChildMinfos();
        int n = list.size();
        long l2 = methodInfo.getExecutionTime();
        for (int i = 0; i < n; ++i) {
            Long l3 = list.get(i);
            MethodInfo methodInfo2 = (MethodInfo)hashMap.get(l3);
            if (methodInfo2 == null) continue;
            l += methodInfo2.getExecutionTime();
        }
        long l4 = l2 - l;
        if (l4 < 0L) {
            l4 = 0L;
        }
        return l4;
    }

    private String getUserName(String string, String string2) {
        if (string.equals("-")) {
            return string2;
        }
        if (string2.equals("-") && this.sessionUserMapping != null && this.sessionUserMapping.containsKey(string)) {
            return (String)this.sessionUserMapping.get(string);
        }
        return string2;
    }

    protected Hashtable formatSource(ArrayList arrayList, Hashtable hashtable, String string, boolean bl) {
        if (arrayList == null || arrayList.isEmpty()) {
            return null;
        }
        Hashtable hashtable2 = new Hashtable();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Serializable serializable;
            Object object8;
            Object object9;
            String string2;
            Map map;
            String string3;
            String string4;
            String string5;
            String string6;
            MethodInfo methodInfo;
            block92: {
                methodInfo = (MethodInfo)arrayList.get(i);
                if (methodInfo == null) {
                    JavaBTMLogger.btmLogger.debug("{} rootInfo is NULL ", (Object)this.loggerDispStr);
                    continue;
                }
                String string7 = null;
                try {
                    string7 = methodInfo.getGuidString();
                    JavaBTMLogger.btmLogger.debug("{} guidWithNodeOrder  {}", (Object)this.loggerDispStr, (Object)string7);
                }
                catch (Exception exception) {
                    JavaBTMLogger.btmLogger.error("{} guidWithNodeOrder is NULL in Catch Block ==> {}", (Object)this.loggerDispStr, (Object)exception);
                }
                if (string7 == null) {
                    JavaBTMLogger.btmLogger.debug("{} guidWithNodeOrder is NULL ", (Object)this.loggerDispStr);
                    continue;
                }
                int n = string7.indexOf("#~#");
                JavaBTMLogger.btmLogger.debug("{} nodeIndex :  {}", (Object)this.loggerDispStr, (Object)n);
                if (n < 0) continue;
                string6 = string7.substring(0, n);
                string5 = string7.substring(n + 3);
                String string8 = methodInfo.getRawURL();
                String[] stringArray = string8.split(" @ ");
                String string9 = stringArray[1];
                string4 = stringArray[0];
                string3 = "-";
                map = methodInfo.getProperties();
                string2 = (String)map.get("UTC");
                try {
                    object9 = mySDF.parse(string9);
                    string3 = finalFormat.format((Date)object9);
                    if (string2 != null) break block92;
                    try {
                        object8 = utcSDF.parse(string9 + " " + string);
                        string2 = finalUtcDateFormatter.format((Date)object8);
                        break block92;
                    }
                    catch (Exception exception) {
                        JavaBTMLogger.btmLogger.error("{} Exception while Parsing Date for UTC format : {} ", (Object)this.loggerDispStr, (Object)exception);
                    }
                }
                catch (Exception exception) {
                    JavaBTMLogger.btmLogger.error("{} Exception while Parsing Date : {}", (Object)this.loggerDispStr, (Object)exception);
                }
                continue;
            }
            object9 = methodInfo.getType();
            object8 = "Web";
            if (object9 != null && ((String)object9).equals("THREAD")) {
                object8 = "Thread";
            }
            long l = methodInfo.getExecutionTime();
            Double d = new Double(l);
            String string10 = (String)map.get("CONTEXT");
            Object object10 = (String)map.get("remoteHost");
            String string11 = (String)map.get("Thread_GUID");
            Double d2 = (Double)map.get("SlowLimit");
            Double d3 = (Double)map.get("StalledLimit");
            String string12 = (String)map.get("QUERYSTRING");
            String string13 = (String)map.get("SESSIONID");
            String string14 = (String)map.get("THREAD");
            String string15 = (String)map.get("DEVICE");
            String string16 = (String)map.get("OS");
            String string17 = (String)map.get("BROWSER");
            String string18 = (String)map.get("REFERER");
            String string19 = "-";
            String string20 = "-";
            String string21 = "-";
            String string22 = "-5.0";
            String string23 = "-";
            String string24 = "-";
            String string25 = "-";
            String string26 = "-";
            String string27 = "-";
            String string28 = "-";
            String string29 = "-5.0";
            String string30 = "-5.0";
            String string31 = "-5.0";
            String string32 = "-";
            String string33 = "-";
            String string34 = "-";
            String string35 = "-";
            if (((String)object10).startsWith("/")) {
                object10 = ((String)object10).substring(1);
            }
            Object object11 = object10;
            String string36 = "-";
            if (string != null && string.equals("unknown")) {
                string = (String)map.get("TimeZone");
            }
            if (this.urlParamsMaskFlag && string12 != null && !string12.equalsIgnoreCase("-")) {
                serializable = new StringBuilder();
                ((StringBuilder)serializable).append("?");
                ((StringBuilder)serializable).append(string12);
                string12 = ((StringBuilder)serializable).toString();
                string12 = UrlParamMaskHelper.maskURLParams(string12);
                int n = string12.indexOf("?");
                if (n > -1) {
                    string12 = string12.substring(n + 1);
                }
            }
            if (((String)object8).equals("Web")) {
                try {
                    string23 = (String)map.get("METHODTYPE");
                    if (string23 == null) {
                        string23 = "-";
                    }
                }
                catch (Exception exception) {
                    JavaBTMLogger.btmLogger.error("{} Exception while getting HTTP Method Type!!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)exception);
                }
                serializable = null;
                try {
                    serializable = map.get("STATUS");
                }
                catch (Exception exception) {
                    JavaBTMLogger.btmLogger.error("{} Exception while getting HTTP Status Code!!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)exception);
                }
                if (serializable != null) {
                    try {
                        string24 = serializable.toString();
                    }
                    catch (Exception exception) {
                        JavaBTMLogger.btmLogger.error("{} Exception occured while performing type casting for HTTP Status Code, so setting the default value..{}", (Object)this.loggerDispStr, (Object)exception);
                    }
                }
                Hashtable hashtable3 = null;
                try {
                    hashtable3 = (Hashtable)map.get("HEADERS");
                }
                catch (Exception exception) {
                    JavaBTMLogger.btmLogger.error("{} Exception while doing type casting for Header Data, so setting the default value.. {}", (Object)this.loggerDispStr, (Object)exception);
                }
                object7 = (String)map.get("REMOTE_ADDRESS_HEADER_NAME");
                if (hashtable3 != null && hashtable3.size() > 0) {
                    try {
                        object6 = hashtable3.keySet();
                        object5 = object6.iterator();
                        object4 = null;
                        while (object5.hasNext()) {
                            object4 = (String)object5.next();
                            if (!((String)object4).equalsIgnoreCase("cookie")) continue;
                            string26 = (String)hashtable3.remove(object4);
                            break;
                        }
                        if (string26 == null) {
                            string26 = "-";
                        } else if (string26.length() > 2000) {
                            object3 = string26.substring(0, 2000);
                            string26 = ((String)object3).substring(0, ((String)object3).lastIndexOf(59));
                        }
                    }
                    catch (Exception exception) {
                        JavaBTMLogger.btmLogger.error("{} Exception while getting Cookie Values, so setting the default value.. {}", (Object)this.loggerDispStr, (Object)exception);
                    }
                    if (hashtable3 != null && hashtable3.size() > 0) {
                        string25 = this.getHeaderString(hashtable3);
                    }
                    if (object7 != null) {
                        object6 = (String)hashtable3.get(object7);
                        if (object6 == null) {
                            object6 = (String)hashtable3.get(((String)object7).toLowerCase());
                        }
                        if (object6 != null) {
                            object10 = object6;
                        }
                    }
                    string32 = (String)hashtable3.get("User-Agent".toLowerCase());
                } else {
                    if (object7 != null && (object6 = (String)map.get("REMOTE_ADDRESS_HEADER_VALUE")) != null) {
                        object10 = object6;
                    }
                    string32 = (String)map.get("User-Agent".toLowerCase());
                }
                try {
                    if (string32 == null || string32.equalsIgnoreCase("null") || string32.length() < 0) {
                        string32 = "-";
                    }
                }
                catch (Exception exception) {
                    JavaBTMLogger.btmLogger.error("{} Exception while getting User Agent!!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)exception);
                }
                try {
                    string27 = (String)map.get("Username");
                    if (string27 == null) {
                        string27 = "-";
                    } else if (string27.length() > 2000) {
                        string27 = string27.substring(0, 1995) + "...";
                    }
                }
                catch (Exception exception) {
                    JavaBTMLogger.btmLogger.error("{} Exception while getting Username!!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)exception);
                }
                try {
                    string28 = (String)map.get("BusinessContext");
                    if (string28 == null) {
                        string28 = "-";
                    } else if (string28.length() > 2000) {
                        string28 = string28.substring(0, 1995) + "...";
                    }
                }
                catch (Exception exception) {
                    JavaBTMLogger.btmLogger.error("{} Exception while getting BusinessContext!!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)exception);
                }
            }
            string27 = this.getUserName(string13, string27);
            if (JavaBTMLogger.btmLogger.isDebugEnabled()) {
                JavaBTMLogger.btmLogger.debug("{} IC userName is : {}", (Object)this.loggerDispStr, (Object)string27);
                JavaBTMLogger.btmLogger.debug("{} IC businessContext is : {}", (Object)this.loggerDispStr, (Object)string28);
                JavaBTMLogger.btmLogger.debug("{} HTTP MethodType : {}", (Object)this.loggerDispStr, (Object)string23);
                JavaBTMLogger.btmLogger.debug("{} HTTP ResponseStatusCode : {}", (Object)this.loggerDispStr, (Object)string24);
                JavaBTMLogger.btmLogger.debug("{} headerString : {} requestType : {}", new Object[]{this.loggerDispStr, string25, object8});
                JavaBTMLogger.btmLogger.debug("{} cookies :  {}", (Object)this.loggerDispStr, (Object)string26);
            }
            serializable = (HashMap)map.get("Fast_Method_Map");
            HashMap hashMap = (HashMap)map.get("Slow_Exceed_Sql_Limit_Map");
            object7 = (HashMap)map.get("Error_Exceed_Sql_Limit_Map");
            if (((String)object10).startsWith("/")) {
                object10 = ((String)object10).substring(1);
            }
            if (((String)object10).startsWith("127.") || ((String)object10).equals("0:0:0:0:0:0:0:1")) {
                object10 = "localhost";
            }
            if (string11 == null) {
                string11 = "-";
            }
            if (string12.length() > 1024) {
                string12 = string12.substring(0, 1019) + "...";
            }
            if (string18.length() > 2000) {
                string18 = string18.substring(0, 1995) + "...";
            }
            object6 = "-";
            object5 = (HashMap)map.get("CHILD_MAP");
            object4 = this.getDetailsList(methodInfo, hashtable, bl, (HashMap)object5);
            if (object4 != null && ((ArrayList)object4).size() == 2) {
                Object object12;
                Object object13;
                Comparable<Boolean> comparable;
                Object object14;
                object3 = (StringBuilder)((ArrayList)object4).get(0);
                if (object3 != null) {
                    object6 = ((StringBuilder)object3).toString();
                }
                object2 = (ArrayList)((ArrayList)object4).get(1);
                if (serializable != null && serializable.size() > 0) {
                    this.updateFastAndExceedSqlDetails((ArrayList)object2, (Map)((Object)serializable), "FASTQUERY");
                }
                if (hashMap != null && hashMap.size() > 0) {
                    this.updateFastAndExceedSqlDetails((ArrayList)object2, hashMap, "SLOWEXCCEDQUERY");
                }
                if (object7 != null && object7.size() > 0) {
                    this.updateFastAndExceedSqlDetails((ArrayList)object2, (Map)object7, "ERROREXCCEDQUERY");
                }
                if ((object = (HashMap)map.get("EHCACHE_DETAILS")) != null && object.size() > 0) {
                    object14 = object.keySet().iterator();
                    while (object14.hasNext()) {
                        comparable = new StringBuilder();
                        object13 = (String)object14.next();
                        object12 = (double[])object.get(object13);
                        ((StringBuilder)comparable).append("EHCACHE").append("#=#");
                        ((StringBuilder)comparable).append((String)object13).append("#=#");
                        ((StringBuilder)comparable).append(object12[1]).append("#=#");
                        ((StringBuilder)comparable).append(object12[0]);
                        ((ArrayList)object2).add(comparable);
                    }
                }
                if (object2 != null && ((ArrayList)object2).size() > 0) {
                    object14 = new ArrayList();
                    ((ArrayList)object14).add(string6);
                    ((ArrayList)object14).add(string5);
                    ((ArrayList)object14).add(object8);
                    ((ArrayList)object14).add(string3);
                    ((ArrayList)object14).add(new ArrayList(object2));
                    arrayList3.add(object14);
                }
                boolean bl2 = false;
                comparable = (Boolean)map.get("isErrorURL");
                if (comparable != null) {
                    bl2 = (Boolean)comparable;
                }
                if (!map.containsKey("ExceptionTrace") && bl2) {
                    object13 = new ArrayList();
                    object12 = (String)map.get("STATUS_MESSAGE");
                    ((ArrayList)object13).add(string6);
                    ((ArrayList)object13).add(string5);
                    ((ArrayList)object13).add(object8);
                    ((ArrayList)object13).add(string3);
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("EXCEPTION").append("#=#").append("0.1.2.3.4.5.6.7.8");
                    stringBuilder.append("#=#").append(0.0);
                    stringBuilder.append("#=#").append("HTTP Error Code " + string24);
                    if (map.containsKey("STATUS_MESSAGE") && ((String)object12).equals("-")) {
                        stringBuilder.append("#=#").append("This request has been marked as error due to response status code :" + string24);
                    } else {
                        stringBuilder.append("#=#").append("This request has been marked as error due to : " + (String)object12);
                    }
                    ((ArrayList)object2).add(stringBuilder);
                    ((ArrayList)object13).add(new ArrayList(object2));
                    arrayList3.add(object13);
                }
            }
            try {
                object3 = (Long)map.get("cpuTime");
                object2 = (Long)map.get("blockedTime");
                object = (Long)map.get("waitedTime");
                if (object3 != null && (Long)object3 >= 0L) {
                    string29 = ((Long)object3).toString();
                }
                if (object2 != null && (Long)object2 >= 0L) {
                    string31 = ((Long)object2).toString();
                }
                if (object != null && (Long)object >= 0L) {
                    string30 = ((Long)object).toString();
                }
            }
            catch (Exception exception) {
                JavaBTMLogger.btmLogger.error("{} Exception while getting Thread Transaction Timings !!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)exception);
            }
            string4 = BusinessTransTestBase.decodeUrlString(string4, this.loggerDispStr);
            string12 = BusinessTransTestBase.decodeUrlString(string12, this.loggerDispStr);
            string18 = BusinessTransTestBase.decodeUrlString(string18, this.loggerDispStr);
            if (string12.length() > 1024) {
                string12 = string12.substring(0, 1019) + "...";
            }
            if (string18.length() > 2000) {
                string18 = string18.substring(0, 1995) + "...";
            }
            try {
                if (this.measureCount > 23 && !string32.equals("-")) {
                    object3 = UserAgentUtil.getUserAgentDetails(string32);
                    string15 = (String)((Hashtable)object3).get("DEVICE");
                    string16 = (String)((Hashtable)object3).get("OS");
                    string17 = (String)((Hashtable)object3).get("BROWSER");
                    string33 = (String)((Hashtable)object3).get("Browser_version");
                }
            }
            catch (Exception exception) {
                JavaBTMLogger.btmLogger.error("{} Exception while getting Device, OS, Browser Details from UserAgent !!.. so set the default value... {} ", (Object)this.loggerDispStr, (Object)exception);
            }
            object3 = null;
            try {
                object2 = new GeoLocalXmlFile(this.reportingName);
                object3 = ((GeoLocalXmlFile)object2).getLocation((String)object10);
                if (object3 == null || ((ArrayList)object3).size() < 6) {
                    object = GeoLocationInfo.getInstance();
                    ArrayList<Object> arrayList4 = new ArrayList<Object>();
                    arrayList4.add(object10);
                    object.setIPAddresses(arrayList4);
                    object3 = object.getGeoLocationDetails((String)object10);
                }
            }
            catch (Exception exception) {
                JavaBTMLogger.btmLogger.error("{} Exception while getting Country, Location, Position Details from IP !!.. so set the default value... {} ", (Object)this.loggerDispStr, (Object)exception);
            }
            if (object3 != null && ((ArrayList)object3).size() > 0) {
                string19 = (String)((ArrayList)object3).get(0);
                string35 = (String)((ArrayList)object3).get(2);
                string34 = (String)((ArrayList)object3).get(3);
                object2 = (String)((ArrayList)object3).get(4);
                object = (String)((ArrayList)object3).get(5);
                string21 = (String)object2 + "," + (String)object;
            }
            try {
                object2 = (HashMap)this.getCauseExceptionTracingTable();
                if (object2 != null && this.jvmGUID != null && ((HashMap)object2).size() > 0 && (object = ((HashMap)object2).get(this.jvmGUID)) != null) {
                    boolean bl3 = (Boolean)object;
                    string36 = bl3 ? (String)map.get("JAVA_EXCEPTION_FQCN_BOTTOM") : (String)map.get("JAVA_EXCEPTION_FQCN_ROOT");
                    string36 = string36 == null ? "-" : string36;
                }
            }
            catch (Exception exception) {
                JavaBTMLogger.btmLogger.error("{} Exception occoured while checking exception FQCN for BusinessTransTest. {} ", (Object)this.loggerDispStr, (Object)exception);
            }
            if (this.publicIPMaskFlag || this.privateIPMaskFlag) {
                object2 = object10;
                if (!this.checkIsIpLocalhost((String)object10)) {
                    object10 = this.getMaskedIP((String)object10);
                }
                if (!this.checkIsIpLocalhost((String)object11)) {
                    object11 = ((String)object2).equals(object11) ? object10 : this.getMaskedIP((String)object11);
                }
            }
            object2 = new ArrayList<String>();
            ((ArrayList)object2).add(string6);
            ((ArrayList)object2).add(string5);
            ((ArrayList)object2).add(this.applicationName);
            ((ArrayList)object2).add(string10);
            ((ArrayList)object2).add(string3);
            ((ArrayList)object2).add(string11);
            ((ArrayList)object2).add(string4);
            ((ArrayList)object2).add(d);
            ((ArrayList)object2).add(string);
            ((ArrayList)object2).add(object10);
            ((ArrayList)object2).add(object8);
            ((ArrayList)object2).add(object9);
            ((ArrayList)object2).add(d2);
            ((ArrayList)object2).add(d3);
            ((ArrayList)object2).add(string12);
            ((ArrayList)object2).add(string13);
            ((ArrayList)object2).add(string14);
            ((ArrayList)object2).add(string15);
            ((ArrayList)object2).add(string16);
            ((ArrayList)object2).add(string17);
            ((ArrayList)object2).add(string18);
            ((ArrayList)object2).add(string19);
            ((ArrayList)object2).add(string20);
            ((ArrayList)object2).add(string21);
            ((ArrayList)object2).add(object6);
            ((ArrayList)object2).add(string22);
            ((ArrayList)object2).add(string23);
            ((ArrayList)object2).add(string24);
            ((ArrayList)object2).add(string26);
            ((ArrayList)object2).add(string25);
            ((ArrayList)object2).add(string27);
            ((ArrayList)object2).add(string28);
            if (this.measureCount > 23) {
                ((ArrayList)object2).add(string29);
                ((ArrayList)object2).add(string30);
                ((ArrayList)object2).add(string31);
                int n = string32.length();
                if (n > 1996) {
                    string32 = string32.substring(0, 1996) + "...";
                }
                ((ArrayList)object2).add(string32);
                ((ArrayList)object2).add(string33);
                ((ArrayList)object2).add(string34);
                ((ArrayList)object2).add(string35);
                ((ArrayList)object2).add(object11);
                ((ArrayList)object2).add(string36);
                ((ArrayList)object2).add(this.jvmGUID);
                ((ArrayList)object2).add(string2);
            }
            arrayList2.add(object2);
        }
        hashtable2.put("DD", arrayList2);
        hashtable2.put("EXTRA", arrayList3);
        return hashtable2;
    }

    private void updateFastAndExceedSqlDetails(ArrayList arrayList, Map map, String string) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = (String)iterator.next();
            Object v = map.get(string2);
            double d = 0.0;
            int n = 0;
            if (v instanceof double[]) {
                object = (double[])map.get(string2);
                n = (int)object[0];
                d = (double)object[1];
            } else {
                object = map.get(string2);
                String string3 = object.toString();
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    d += Double.parseDouble(string4);
                    ++n;
                }
            }
            stringBuilder.append("SQL").append("#=#");
            stringBuilder.append(string).append("#=#");
            stringBuilder.append(d).append("#=#");
            stringBuilder.append(string2).append("#=#");
            stringBuilder.append(n).append("#=#");
            stringBuilder.append("-").append("#=#");
            stringBuilder.append("-");
            arrayList.add(stringBuilder);
        }
    }

    private String getHeaderString(Hashtable hashtable) {
        StringBuilder stringBuilder = null;
        try {
            Set set = hashtable.keySet();
            Iterator iterator = set.iterator();
            if (set.size() > 0) {
                stringBuilder = new StringBuilder();
                int n = 2000;
                while (iterator.hasNext()) {
                    int n2;
                    String string = (String)iterator.next();
                    String string2 = (String)hashtable.get(string);
                    int n3 = string.length();
                    int n4 = n3 + (n2 = string2.length()) + 2;
                    if (n4 < n) {
                        stringBuilder.append(string);
                        stringBuilder.append("=");
                        stringBuilder.append(string2);
                        stringBuilder.append("#~#");
                        n -= n4;
                        continue;
                    }
                    JavaBTMLogger.btmLogger.warn("{} Header size too big ! Header Name........: {} ", (Object)this.loggerDispStr, (Object)string);
                }
            } else {
                stringBuilder = new StringBuilder();
                stringBuilder.append("-");
            }
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} Exception occured while iterating header data : {} ", (Object)this.loggerDispStr, (Object)exception);
        }
        return stringBuilder.toString();
    }

    private ArrayList getDetailsList(MethodInfo methodInfo, Hashtable hashtable, boolean bl, HashMap hashMap) {
        HashMap hashMap2 = this.prepareOrderMap(methodInfo, hashMap);
        boolean bl2 = false;
        long l = 0L;
        String string = null;
        StringBuilder stringBuilder = null;
        ArrayList<Serializable> arrayList = null;
        if (hashMap2 != null && hashMap2.size() > 0) {
            Set set = hashMap2.keySet();
            ArrayList arrayList2 = new ArrayList(set);
            Collections.sort(arrayList2, new AlphanumComparator());
            int n = arrayList2.size();
            Iterator iterator = arrayList2.iterator();
            int n2 = 1;
            stringBuilder = new StringBuilder();
            arrayList = new ArrayList<Serializable>();
            ArrayList<StringBuilder> arrayList3 = new ArrayList<StringBuilder>();
            while (iterator.hasNext()) {
                StringBuilder stringBuilder2;
                block70: {
                    String string2;
                    String string3;
                    Object object;
                    Set set2;
                    String string4;
                    Object object2;
                    String string5 = (String)iterator.next();
                    MethodInfo methodInfo2 = (MethodInfo)hashMap2.get(string5);
                    String string6 = methodInfo2.getType();
                    long l2 = methodInfo2.getExecutionTime();
                    long l3 = this.calculateExclusiveTime(methodInfo2, hashMap);
                    StringBuilder stringBuilder3 = BusinessTransTestBase.getMethodDisplayName(methodInfo2, string6);
                    stringBuilder.append(string5).append("#=#");
                    stringBuilder.append(l2).append("#=#");
                    stringBuilder.append(l3).append("#=#");
                    stringBuilder.append(stringBuilder3.toString()).append("#=#");
                    if (!bl2 && string6.startsWith("EJB_")) {
                        stringBuilder.append("EJB");
                    } else {
                        stringBuilder.append(string6);
                    }
                    if (n2 < n) {
                        stringBuilder.append("%*%");
                    }
                    stringBuilder2 = null;
                    if (string6.equals("SQL")) {
                        object2 = (String)methodInfo2.getProperties().get("sqlStmt");
                        string4 = (String)methodInfo2.getProperties().get("jdbcUrl");
                        String string7 = (String)methodInfo2.getProperties().get("sqlError");
                        String string8 = (String)methodInfo2.getProperties().get("stackTrace");
                        set2 = BusinessTransTestBase.prepQryForUI((String)object2);
                        stringBuilder2 = new StringBuilder();
                        stringBuilder2.append(string6).append("#=#").append(string5);
                        stringBuilder2.append("#=#").append(l2);
                        stringBuilder2.append("#=#").append(string4);
                        stringBuilder2.append("#=#").append((String)((Object)set2));
                        stringBuilder2.append("#=#").append(string7);
                        stringBuilder2.append("#=#").append(string8);
                    } else if (string6.equals("EXCEPTION")) {
                        object2 = (String)methodInfo2.getProperties().get("EXCEPTION");
                        if (object2 != null && ((String)object2).length() > 0 && ((String)object2).indexOf("?^?") > 0) {
                            stringBuilder2 = new StringBuilder();
                            stringBuilder2.append(string6).append("#=#").append(string5);
                            stringBuilder2.append("#=#").append(l2);
                            stringBuilder2.append("#=#").append(((String)object2).substring(0, ((String)object2).indexOf("?^?")));
                            stringBuilder2.append("#=#").append((String)object2);
                        }
                    } else if (string6.equals("HTTP") || string6.equals("HTTPStream") || string6.equals("HttpConn")) {
                        object2 = null;
                        string4 = null;
                        String string9 = null;
                        String string10 = null;
                        set2 = null;
                        if (methodInfo2.getProperties() != null) {
                            object2 = (String)methodInfo2.getProperties().get("EXTURL");
                            string4 = (String)methodInfo2.getProperties().get("METHOD");
                            string9 = (String)methodInfo2.getProperties().get("NODE_ORDER");
                            string10 = (String)methodInfo2.getProperties().get("SC");
                            set2 = (String)methodInfo2.getProperties().get("RM");
                        }
                        if (string9 == null) {
                            string9 = "-";
                        }
                        if (object2 == null) {
                            object2 = "-";
                        }
                        if (string4 == null) {
                            string4 = "-";
                        }
                        if (string10 == null) {
                            string10 = "-";
                        }
                        if (set2 == null) {
                            set2 = "-";
                        }
                        stringBuilder2 = new StringBuilder();
                        stringBuilder2.append(string6).append("#=#").append(string5);
                        stringBuilder2.append("#=#").append(l2);
                        stringBuilder2.append("#=#").append((String)object2);
                        stringBuilder2.append("#=#").append(string4);
                        stringBuilder2.append("#=#").append(string9);
                        stringBuilder2.append("#=#").append(string10);
                        stringBuilder2.append("#=#").append((String)((Object)set2));
                    } else if (string6.equals("WEBSERVICE")) {
                        object2 = (String)methodInfo2.getProperties().get("TargetUrl");
                        string4 = (String)methodInfo2.getProperties().get("OperationName");
                        if (string4.indexOf("[*#*]") > -1) {
                            int n3 = string4.indexOf("[*#*]");
                            String string11 = string4.substring(0, n3);
                            int n4 = string11.lastIndexOf("/}");
                            if (n4 > -1) {
                                string11 = string11.substring(n4 + 2, string11.length());
                            }
                            if ((n4 = ((String)(object = string4.substring(n3, string4.length()))).lastIndexOf("/}")) > -1) {
                                object = ((String)object).substring(n4 + 2, ((String)object).length());
                            }
                            string4 = string11 + "." + (String)object;
                        }
                        String string12 = (String)methodInfo2.getProperties().get("NODE_ORDER");
                        String string13 = (String)methodInfo2.getProperties().get("SC");
                        set2 = (String)methodInfo2.getProperties().get("RM");
                        if (string12 == null) {
                            string12 = "-";
                        }
                        if (string13 == null) {
                            string13 = "-";
                        }
                        if (set2 == null) {
                            set2 = "-";
                        }
                        stringBuilder2 = new StringBuilder();
                        stringBuilder2.append(string6).append("#=#").append(string5);
                        stringBuilder2.append("#=#").append(l2);
                        stringBuilder2.append("#=#").append((String)object2);
                        stringBuilder2.append("#=#").append(string4);
                        stringBuilder2.append("#=#").append(string12);
                        stringBuilder2.append("#=#").append(string13);
                        stringBuilder2.append("#=#").append((String)((Object)set2));
                    } else if (string6.startsWith("EJB")) {
                        if (string6.equalsIgnoreCase("EJB")) {
                            l = l2;
                            string = string5;
                            bl2 = true;
                        } else {
                            string6 = "EJB";
                            object2 = (String)methodInfo2.getProperties().get("ejbhost");
                            string4 = (String)methodInfo2.getProperties().get("method");
                            String string14 = BusinessTransTestBase.getEjbMethodName(string4);
                            if (object2 == null) {
                                object2 = "-";
                                string14 = "-";
                            } else if (object2 != null && !((String)object2).contains("://") && ((String)object2).lastIndexOf(47) > -1) {
                                object2 = ((String)object2).substring(((String)object2).lastIndexOf(47) + 1);
                            }
                            try {
                                if (bl2) {
                                    bl2 = false;
                                    stringBuilder2 = new StringBuilder();
                                    stringBuilder2.append(string6).append("#=#").append(string);
                                    stringBuilder2.append("#=#").append(l);
                                    stringBuilder2.append("#=#").append((String)object2);
                                    stringBuilder2.append("#=#").append(string14);
                                    break block70;
                                }
                                stringBuilder2 = new StringBuilder();
                                stringBuilder2.append(string6).append("#=#").append(string5);
                                stringBuilder2.append("#=#").append(l2);
                                stringBuilder2.append("#=#").append((String)object2);
                                stringBuilder2.append("#=#").append(string14);
                            }
                            catch (Exception exception) {
                                JavaBTMLogger.btmLogger.error("{}  Exception in [BusinessTransTestBase] [getDetailsList] {} ", (Object)this.loggerDispStr, (Object)exception);
                            }
                        }
                    } else if (string6.equals("RMI")) {
                        object2 = (String)methodInfo2.getProperties().get("host");
                        string4 = (String)methodInfo2.getProperties().get("protocol");
                        try {
                            if (object2 != null) {
                                int n5 = ((String)object2).indexOf(91) + 1;
                                int n6 = ((String)object2).lastIndexOf(93);
                                object2 = ((String)object2).substring(n5, n6);
                            }
                            stringBuilder2 = new StringBuilder();
                            stringBuilder2.append(string6).append("#=#").append(string5);
                            stringBuilder2.append("#=#").append(l2);
                            stringBuilder2.append("#=#").append((String)object2);
                            stringBuilder2.append("#=#").append(string4);
                        }
                        catch (Exception exception) {
                            JavaBTMLogger.btmLogger.error("{}  Exception in getDetailsList while preparing data for RMI : {} ", (Object)this.loggerDispStr, (Object)exception);
                        }
                    } else if (string6.equals("RUNTIME")) {
                        object2 = (String)methodInfo2.getProperties().get("COMMAND");
                        try {
                            stringBuilder2 = new StringBuilder();
                            stringBuilder2.append(string6).append("#=#").append(string5);
                            stringBuilder2.append("#=#").append(l2);
                            stringBuilder2.append("#=#").append((String)object2);
                        }
                        catch (Exception exception) {
                            JavaBTMLogger.btmLogger.error("{}  Exception in getDetailsList while preparing data for Runtime : {} ", (Object)this.loggerDispStr, (Object)exception);
                        }
                    } else if (string6.equals("EMAIL") || string6.equals("LDAP")) {
                        object2 = (String)methodInfo2.getProperties().get("method");
                        string4 = (String)methodInfo2.getProperties().get("endPoint");
                        try {
                            if (string6.equals("LDAP")) {
                                object2 = BusinessTransTestBase.getLdapDisplayMethodName((String)object2);
                            } else {
                                string4 = this.getEmailEndPoint(string4);
                            }
                            stringBuilder2 = new StringBuilder();
                            stringBuilder2.append(string6).append("#=#").append(string5);
                            stringBuilder2.append("#=#").append(l2);
                            stringBuilder2.append("#=#").append((String)object2);
                            stringBuilder2.append("#=#").append(string4);
                        }
                        catch (Exception exception) {
                            JavaBTMLogger.btmLogger.error("{}  Exception in getDetailsList while preparing data for EMAIL/LDAP  : {}", (Object)this.loggerDispStr, (Object)exception);
                        }
                    } else if (string6.equals("JMS")) {
                        object2 = (String)methodInfo2.getProperties().get("JMS-PROVIDER");
                        string4 = (String)methodInfo2.getProperties().get("JMS-QUEUE");
                        String string15 = (String)methodInfo2.getProperties().get("TYPE");
                        String string16 = (String)methodInfo2.getProperties().get("NODE_ORDER");
                        if (string16 == null) {
                            string16 = "-";
                        }
                        stringBuilder2 = new StringBuilder();
                        stringBuilder2.append(string6).append("#=#").append(string5);
                        stringBuilder2.append("#=#").append(l2);
                        stringBuilder2.append("#=#").append((String)object2);
                        stringBuilder2.append("#=#").append(string4);
                        stringBuilder2.append("#=#").append(string15);
                        stringBuilder2.append("#=#").append(string16);
                    } else if (string6.equals("JMS_ENTRY")) {
                        object2 = (String)methodInfo2.getProperties().get("JMS-PROVIDER");
                        string4 = (String)methodInfo2.getProperties().get("JMS-QUEUE");
                        String string17 = (String)methodInfo2.getProperties().get("TYPE");
                        stringBuilder2 = new StringBuilder();
                        stringBuilder2.append(string6).append("#=#").append(string5);
                        stringBuilder2.append("#=#").append(l2);
                        stringBuilder2.append("#=#").append((String)object2);
                        stringBuilder2.append("#=#").append(string4);
                        stringBuilder2.append("#=#").append(string17);
                    } else if (string6.equals("SAP JCO")) {
                        object2 = methodInfo2.getProperties();
                        string4 = (String)object2.get("ASHost");
                        String string18 = (String)object2.get("CLIENT");
                        String string19 = (String)object2.get("GWHost");
                        set2 = (String)object2.get("GWServ");
                        object = (String)object2.get("MSHost");
                        string3 = (String)object2.get("Group");
                        string2 = (String)object2.get("SystemID");
                        String string20 = (String)object2.get("SystemNo");
                        String string21 = (String)object2.get("TPName");
                        String string22 = (String)object2.get("URL");
                        String string23 = (String)object2.get("JCOFunction");
                        String string24 = (String)object2.get("User");
                        stringBuilder2 = new StringBuilder();
                        stringBuilder2.append(string6).append("#=#").append(string5);
                        stringBuilder2.append("#=#").append(l2);
                        stringBuilder2.append("#=#").append(string4);
                        stringBuilder2.append("#=#").append(string20);
                        stringBuilder2.append("#=#").append(string2);
                        stringBuilder2.append("#=#").append(string24);
                        stringBuilder2.append("#=#").append(string18);
                        stringBuilder2.append("#=#").append(string23);
                        stringBuilder2.append("#=#").append(string3);
                        stringBuilder2.append("#=#").append(string22);
                        stringBuilder2.append("#=#").append(string21);
                        stringBuilder2.append("#=#").append(string19);
                        stringBuilder2.append("#=#").append((String)((Object)set2));
                        stringBuilder2.append("#=#").append((String)object);
                    } else if (string6.equals("MONGODB")) {
                        object2 = "localhost";
                        string4 = "27017";
                        String string25 = (String)methodInfo2.getProperties().get("mongoServerDetails");
                        int n7 = string25.indexOf(":");
                        if (n7 > -1) {
                            object2 = string25.substring(0, n7);
                            string4 = string25.substring(n7 + 1);
                        }
                        set2 = (String)methodInfo2.getProperties().get("mongoDBName");
                        object = (String)methodInfo2.getProperties().get("mongoTableName");
                        string3 = (String)methodInfo2.getProperties().get("mongoMethodName");
                        string2 = (String)methodInfo2.getProperties().get("mongoQuery");
                        stringBuilder2 = new StringBuilder();
                        stringBuilder2.append(string6).append("#=#").append(string5);
                        stringBuilder2.append("#=#").append(l2);
                        stringBuilder2.append("#=#").append((String)object2);
                        stringBuilder2.append("#=#").append(string4);
                        stringBuilder2.append("#=#").append((String)((Object)set2));
                        stringBuilder2.append("#=#").append((String)object);
                        stringBuilder2.append("#=#").append(string3);
                        stringBuilder2.append("#=#").append(string2);
                    } else if (string6.equals("REDIS")) {
                        object2 = (String)methodInfo2.getProperties().get("redisIP");
                        string4 = (String)methodInfo2.getProperties().get("redisPort");
                        String string26 = (String)methodInfo2.getProperties().get("redisDetails");
                        HashMap<String, String> hashMap3 = new HashMap<String, String>();
                        if (string26.contains(",")) {
                            set2 = new StringTokenizer(string26, ",");
                            while (((StringTokenizer)((Object)set2)).hasMoreElements()) {
                                object = (String)((StringTokenizer)((Object)set2)).nextElement();
                                BusinessTransTestBase.retriveRedisDBAndCommand((String)object, hashMap3);
                            }
                        } else {
                            BusinessTransTestBase.retriveRedisDBAndCommand(string26, hashMap3);
                        }
                        stringBuilder2 = new StringBuilder();
                        stringBuilder2.append(string6).append("#=#").append(string5);
                        stringBuilder2.append("#=#").append(l2);
                        stringBuilder2.append("#=#").append((String)object2);
                        stringBuilder2.append("#=#").append(string4);
                        if (hashMap3 != null && hashMap3.size() >= 1) {
                            set2 = hashMap3.keySet();
                            object = set2.iterator();
                            while (object.hasNext()) {
                                string3 = (String)object.next();
                                stringBuilder2.append("#=#").append(string3);
                                stringBuilder2.append("#=#").append((String)hashMap3.get(string3));
                            }
                        }
                    } else if (string6.startsWith("Custom_") && (object2 = (String)hashtable.get(string6)) != null && ((String)object2).length() > 0) {
                        stringBuilder2 = new StringBuilder();
                        stringBuilder2.append(string6).append("#=#").append(string5);
                        stringBuilder2.append("#=#").append(l2);
                        stringBuilder2.append("#=#").append((String)object2);
                    }
                }
                if (stringBuilder2 != null) {
                    arrayList3.add(stringBuilder2);
                }
                ++n2;
            }
            arrayList.add(stringBuilder);
            arrayList.add(arrayList3);
        }
        return arrayList;
    }

    protected String getEmailEndPoint(String string) {
        try {
            if (string != null && string.length() > 1) {
                StringBuilder stringBuilder = new StringBuilder();
                URLName uRLName = new URLName(string);
                String string2 = uRLName.getProtocol();
                String string3 = uRLName.getHost();
                int n = uRLName.getPort();
                if (string2 != null) {
                    stringBuilder.append(string2);
                    stringBuilder.append("://");
                }
                if (string3 != null) {
                    stringBuilder.append(string3);
                }
                if (n != -1) {
                    stringBuilder.append(":");
                    stringBuilder.append(n);
                }
                return stringBuilder.toString();
            }
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} Exception occurred while retriving Email EndPoint {} ", (Object)this.loggerDispStr, (Object)exception);
        }
        return "-";
    }

    private static Map retriveRedisDBAndCommand(String string, Map<String, String> map) {
        int n = string.indexOf("#");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        if (map.containsKey(string2)) {
            String string4 = map.get(string2);
            String string5 = string3 + "," + string4;
            map.put(string2, string5);
        } else {
            map.put(string2, string3);
        }
        return map;
    }

    private static String getLdapDisplayMethodName(String string) {
        String string2 = "-";
        if (ldapMethodMapping != null && ldapMethodMapping.containsKey(string)) {
            string2 = ldapMethodMapping.get(string);
        } else if (string != null && string.indexOf(93) > -1) {
            string2 = "LDAP " + string.substring(string.indexOf(93) + 1);
        }
        return string2;
    }

    private static String getEjbMethodName(String string) {
        String string2 = "";
        if (string != null && string.length() > 0) {
            try {
                String string3 = string.substring(string.lastIndexOf(40));
                String string4 = string.substring(0, string.lastIndexOf(40));
                int n = string4.lastIndexOf(46);
                String string5 = string4.substring(0, n);
                String string6 = string4.substring(string4.lastIndexOf(46));
                String string7 = string5.substring(string5.lastIndexOf(46) + 1);
                string2 = string7 + string6;
            }
            catch (Exception exception) {
                JavaBTMLogger.btmLogger.error(" Exception in [BusinessTransTestBase] [getEjbMethodName] {} ", (Throwable)exception);
            }
        }
        return string2;
    }

    private static StringBuilder getMethodDisplayName(MethodInfo methodInfo, String string) {
        StringBuilder stringBuilder = null;
        String string2 = null;
        if (methodInfo != null) {
            String string3 = methodInfo.getClassName();
            String string4 = methodInfo.getMethodName();
            String string5 = methodInfo.getDesc();
            String string6 = null;
            if (string.equals("THREAD_INIT") && string5 != null && string5.indexOf(" [ASYNC]-") > 0) {
                string2 = string5.substring(string5.indexOf(" [ASYNC]-") + 1);
                int n = string5.indexOf("[#");
                if (n > 0) {
                    string6 = string5.substring(string5.indexOf("[#") + 2, string5.indexOf("#] "));
                    string5 = string5.substring(0, string5.indexOf("[#"));
                }
            }
            String string7 = string3.replace("/", ".");
            String string8 = BusinessTransTestBase.getParamNames(string5.trim());
            stringBuilder = new StringBuilder();
            stringBuilder.append(string7);
            stringBuilder.append(".");
            stringBuilder.append(string4);
            stringBuilder.append("(");
            stringBuilder.append(string8);
            stringBuilder.append(")");
            if (string6 != null) {
                stringBuilder.append(" [").append(string6).append("] ");
            }
            if (string2 != null) {
                stringBuilder.append(string2);
            }
        }
        return stringBuilder;
    }

    private static String prepQryForUI(String string) {
        String string2;
        if (string == null) {
            return "NULL";
        }
        if (string.indexOf(10) == -1) {
            string2 = string;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            StringBuilder stringBuilder = new StringBuilder();
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                String string3 = stringTokenizer.nextToken();
                if (string3 == null || string3.length() <= 0) continue;
                stringBuilder.append(string3.trim());
                stringBuilder.append(' ');
            }
            string2 = stringBuilder.toString();
        }
        if (string2.indexOf(",N'") != -1) {
            return string2.replaceAll(",N'", ",'");
        }
        return string2;
    }

    private static String getParamNames(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Type type : Type.getArgumentTypes(string)) {
            String string2 = "";
            string2 = type.equals(Type.BOOLEAN_TYPE) ? "boolean" : (type.equals(Type.BYTE_TYPE) ? "byte" : (type.equals(Type.CHAR_TYPE) ? "char" : (type.equals(Type.SHORT_TYPE) ? "short" : (type.equals(Type.INT_TYPE) ? "int" : (type.equals(Type.LONG_TYPE) ? "long" : (type.equals(Type.FLOAT_TYPE) ? "float" : (type.equals(Type.DOUBLE_TYPE) ? "double" : (type.equals(Type.VOID_TYPE) ? "void" : type.getInternalName()))))))));
            int n = string2.lastIndexOf(47);
            if (n > 0) {
                String string3 = string2.substring(n + 1);
                stringBuilder.append(string3 + ",");
                continue;
            }
            stringBuilder.append(string2 + ",");
        }
        String string4 = stringBuilder.toString();
        int n = string4.lastIndexOf(44);
        if (n > 0) {
            string4 = string4.substring(0, n);
        }
        return string4;
    }

    private void updateWebServiceProperties(MethodInfo methodInfo, MethodInfo methodInfo2) {
        try {
            String string = (String)methodInfo2.getProperties().get("NODE_ORDER");
            String string2 = (String)methodInfo2.getProperties().get("SC");
            String string3 = (String)methodInfo2.getProperties().get("RM");
            if (string == null) {
                string = "-";
            }
            if (string2 == null) {
                string2 = "-";
            }
            if (string3 == null) {
                string3 = "-";
            }
            methodInfo.getProperties().put("NODE_ORDER", string);
            methodInfo.getProperties().put("SC", string2);
            methodInfo.getProperties().put("RM", string3);
            methodInfo2.setProperties(null);
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} Error Occured in updateWebServiceProperties : {} ", (Object)this.loggerDispStr, (Object)exception);
        }
    }

    private boolean isHttpCallExists(MethodInfo methodInfo, HashMap hashMap, ArrayList arrayList) {
        boolean bl = false;
        MethodInfo methodInfo2 = methodInfo;
        HashSet hashSet = new HashSet();
        ArrayList arrayList2 = (ArrayList)methodInfo2.getChildMinfos();
        if (arrayList2 == null || arrayList2.size() == 0) {
            return bl;
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            MethodInfo methodInfo3;
            Long l = (Long)arrayList2.get(i);
            MethodInfo methodInfo4 = (MethodInfo)hashMap.get(l);
            if (methodInfo4 == null) continue;
            String string = methodInfo4.getType();
            if (string.equals("HTTP")) {
                methodInfo3 = this.getExceptionInfoList(methodInfo, hashMap, hashSet, true);
                if (methodInfo3 != null) {
                    this.updateWebServiceProperties(methodInfo, methodInfo3);
                }
                this.getExceptionInfoList(methodInfo, hashMap, hashSet, false);
                if (hashSet != null && hashSet.size() > 0) {
                    bl = true;
                }
                arrayList.add(methodInfo4);
                break;
            }
            if (string.equals("HTTPStream") || string.equals("EXCEPTION")) {
                methodInfo3 = this.getExceptionInfoList(methodInfo, hashMap, hashSet, true);
                if (methodInfo3 != null && methodInfo3.getProperties() != null) {
                    this.updateWebServiceProperties(methodInfo, methodInfo3);
                }
                this.getExceptionInfoList(methodInfo, hashMap, hashSet, false);
                if (hashSet != null && hashSet.size() > 0) {
                    bl = true;
                }
                arrayList.add(methodInfo3);
                continue;
            }
            methodInfo2 = methodInfo4;
        }
        if (hashSet.size() > 0) {
            methodInfo.getChildMinfos().clear();
            methodInfo.getChildMinfos().addAll(new ArrayList(hashSet));
        }
        return bl;
    }

    private MethodInfo getExceptionInfoList(MethodInfo methodInfo, HashMap hashMap, Set set, boolean bl) {
        Stack<MethodInfo> stack = new Stack<MethodInfo>();
        stack.push(methodInfo);
        int n = 0;
        while (!stack.isEmpty() && n < 500) {
            ArrayList arrayList;
            ++n;
            MethodInfo methodInfo2 = (MethodInfo)stack.pop();
            String string = methodInfo2.getType();
            if (string.equals("HTTP") && bl) {
                return methodInfo2;
            }
            if (string.equals("EXCEPTION")) {
                set.add(methodInfo2.getId());
            }
            if ((arrayList = (ArrayList)methodInfo2.getChildMinfos()) == null || arrayList.size() <= 0) continue;
            for (int i = 0; i < arrayList.size(); ++i) {
                Long l = (Long)arrayList.get(i);
                MethodInfo methodInfo3 = (MethodInfo)hashMap.get(l);
                stack.push(methodInfo3);
            }
        }
        return null;
    }

    private HashMap prepareOrderMap(MethodInfo methodInfo, HashMap hashMap) {
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        try {
            Stack<Object> stack = new Stack<Object>();
            MethodInfo methodInfo2 = methodInfo;
            stack.push(methodInfo2);
            HashMap<Object, String> hashMap3 = new HashMap<Object, String>();
            hashMap3.put(methodInfo2, "0");
            hashMap2.put("0", methodInfo2);
            ArrayList arrayList = new ArrayList();
            while (!stack.isEmpty()) {
                Object object;
                Serializable serializable;
                String string;
                block20: {
                    Object object2;
                    Serializable serializable2;
                    methodInfo2 = (MethodInfo)stack.pop();
                    if (arrayList.contains(methodInfo2)) continue;
                    string = (String)hashMap3.get(methodInfo2);
                    String string2 = methodInfo2.getType();
                    if (string2.equals("WEBSERVICE")) {
                        boolean bl = this.isHttpCallExists(methodInfo2, hashMap, arrayList);
                        if (!bl) {
                            continue;
                        }
                    } else if (string2.equals("EMAIL")) {
                        ArrayList arrayList2 = (ArrayList)methodInfo2.getChildMinfos();
                        if (arrayList2.size() == 1) {
                            serializable2 = (Long)arrayList2.get(0);
                            serializable = (MethodInfo)hashMap.get(serializable2);
                            object = serializable.getType();
                            if (arrayList.contains(serializable)) continue;
                            if (((String)object).equals("EMAIL")) {
                                object2 = (String)serializable.getProperties().get("endPoint");
                                if (object2 == null) {
                                    object2 = "-";
                                }
                                methodInfo2.getProperties().put("endPoint", object2);
                            }
                        }
                    } else if (string2.equals("SQL")) {
                        try {
                            ArrayList arrayList3 = (ArrayList)methodInfo2.getChildMinfos();
                            if (arrayList3 == null || arrayList3.size() <= 0) break block20;
                            serializable2 = new ArrayList();
                            for (int i = 0; i < arrayList3.size(); ++i) {
                                String string3;
                                object = (Long)arrayList3.get(i);
                                object2 = (MethodInfo)hashMap.get(object);
                                if (object2 == null || !(string3 = ((MethodInfo)object2).getType()).equals("EXCEPTION") && !string3.equals("THREAD_INIT")) continue;
                                serializable2.add(((MethodInfo)object2).getId());
                            }
                            try {
                                if (arrayList3 != null) {
                                    arrayList3.clear();
                                }
                            }
                            catch (Exception exception) {
                                JavaBTMLogger.btmLogger.error("{}  Error while clearing SQL ChildInfos : {} ", (Object)this.loggerDispStr, (Object)exception);
                            }
                            if (serializable2.size() > 0) {
                                arrayList3.addAll(serializable2);
                            }
                        }
                        catch (Exception exception) {
                            JavaBTMLogger.btmLogger.error("{} Exception occured due to : {}", (Object)this.loggerDispStr, (Object)exception);
                        }
                    }
                }
                ArrayList arrayList4 = (ArrayList)methodInfo2.getChildMinfos();
                JavaBTMLogger.btmLogger.debug("{} childIDList  : {} ", (Object)this.loggerDispStr, (Object)arrayList4);
                if (arrayList4 == null || arrayList4.size() <= 0) continue;
                for (int i = 0; i < arrayList4.size(); ++i) {
                    serializable = (Long)arrayList4.get(i);
                    object = (MethodInfo)hashMap.get(serializable);
                    if (object.equals(methodInfo2)) continue;
                    stack.push(object);
                    hashMap3.put(object, string + "." + i);
                    hashMap2.put(string + "." + i, object);
                }
            }
            stack = null;
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} Error Occured in prepareOrderMap : {}", (Object)this.loggerDispStr, (Object)exception);
        }
        return hashMap2;
    }

    public static String decodeUrlString(String string, String string2) {
        String string3 = string;
        if (string != null) {
            try {
                string3 = URLDecoder.decode(string, "UTF-8");
            }
            catch (Exception exception) {
                JavaBTMLogger.btmLogger.warn("{} Decoding fails for the string : {}", (Object)string2, (Object)string);
                JavaBTMLogger.btmLogger.error("{} Exception occured while decoding the string : {} {}", new Object[]{string2, string, exception});
            }
        }
        return string3;
    }

    private void computeBTMData(Hashtable hashtable, JavaAPMComponent javaAPMComponent) {
        Set set = hashtable.keySet();
        Iterator iterator = set.iterator();
        long l = this.measurePeriod / 1000L / 60L;
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        String string3 = null;
        Hashtable hashtable2 = null;
        if (javaAPMComponent.getStatus() == Status.MANAGED_OFFLOAD) {
            string = javaAPMComponent.getCPUTimeNotSupported();
            string2 = javaAPMComponent.getBlockedWaitTimeNotSupported();
            string3 = javaAPMComponent.getTimeZone();
            hashtable2 = javaAPMComponent.getCustomPointDetails();
            this.sessionUserMapping = javaAPMComponent.getSessionUserMapping();
        } else {
            JavaBTMLogger.btmLogger.debug(" {} == {} DataBaseHT ==> {}  ", new Object[]{this.loggerDispStr, this.entity, this.DataBaseHT});
            this.sessionUserMapping = (HashMap)this.DataBaseHT.get(SESSION_USER_KEY);
            string = (String)this.DataBaseHT.get("cpuTimeNotSupported");
            string2 = (String)this.DataBaseHT.get("blockedWaitedTimeNotSupported");
            string3 = (String)this.DataBaseHT.get("TimeZone");
            hashtable2 = (Hashtable)this.DataBaseHT.get("CustomPC");
        }
        if (string != null && string.equalsIgnoreCase("true")) {
            bl = true;
        }
        if (string2 != null && string2.equalsIgnoreCase("true")) {
            bl2 = true;
        }
        if (string3 == null) {
            string3 = "unknown";
        }
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
        }
        while (iterator.hasNext()) {
            Hashtable hashtable3;
            Cloneable cloneable;
            Cloneable cloneable2;
            ArrayList arrayList;
            boolean bl3 = false;
            String string4 = (String)iterator.next();
            Hashtable hashtable4 = (Hashtable)hashtable.get(string4);
            if (hashtable4 == null || hashtable4.size() <= 0) continue;
            ArrayList arrayList2 = (ArrayList)hashtable4.get("patternData");
            if (string4.equals("SUMMARY_PATTERN")) {
                bl3 = true;
                arrayList2 = (ArrayList)hashtable4.get("SUMMARY_PATTERN");
            }
            int n = 0;
            if (arrayList2 != null) {
                n = arrayList2.size();
            }
            if (n >= 18) {
                arrayList = new ArrayList();
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                double d9 = 0.0;
                double d10 = 0.0;
                double d11 = 0.0;
                double d12 = 0.0;
                double d13 = 0.0;
                double d14 = 0.0;
                double d15 = 0.0;
                double d16 = 0.0;
                double d17 = 0.0;
                double d18 = 0.0;
                double d19 = 0.0;
                double d20 = 0.0;
                double d21 = 0.0;
                double d22 = (Double)arrayList2.get(0);
                if (d22 == 0.0 && !bl3) {
                    JavaBTMLogger.btmLogger.debug("{}  Transactions for the Pattern   {} is 0, continuing...", (Object)this.loggerDispStr, (Object)string4);
                    continue;
                }
                int n2 = 18;
                block14: for (int i = 0; i < n; i += 2) {
                    double d23 = (Double)arrayList2.get(i);
                    double d24 = (Double)arrayList2.get(i + 1);
                    double d25 = 0.0;
                    if (d23 > 0.0) {
                        d25 = d24 / d23;
                    }
                    if (i < n2) {
                        arrayList.add(new Double(d23));
                        arrayList.add(new Double(d25));
                    }
                    switch (i) {
                        case 0: {
                            d5 = d23;
                            continue block14;
                        }
                        case 2: {
                            d2 = d23;
                            continue block14;
                        }
                        case 4: {
                            d4 = d23;
                            continue block14;
                        }
                        case 6: {
                            d3 = d23;
                            continue block14;
                        }
                        case 10: {
                            d19 = d23;
                            continue block14;
                        }
                        case 12: {
                            d16 = d23;
                            continue block14;
                        }
                        case 14: {
                            d18 = d23;
                            continue block14;
                        }
                        case 16: {
                            d17 = d23;
                            continue block14;
                        }
                        case 18: {
                            d12 = bl ? -4.0 : (this.cpuTimeTrackingFlag ? d25 : -5.0);
                            continue block14;
                        }
                        case 20: {
                            d13 = bl ? -4.0 : (this.contentionTimeTrackingFlag ? d25 : -5.0);
                            continue block14;
                        }
                        case 22: {
                            d14 = bl ? -4.0 : (this.contentionTimeTrackingFlag ? d25 : -5.0);
                        }
                    }
                }
                if (bl3) {
                    string4 = "Summary";
                }
                d15 = d19 - (d16 + d18 + d17);
                d = d5 - (d2 + d4 + d3);
                arrayList.add(new Double(d));
                if (d5 > 0.0) {
                    d6 = Double.parseDouble(this.formatter.format(d / d5 * 100.0));
                    d7 = Double.parseDouble(this.formatter.format(d2 / d5 * 100.0));
                    d8 = Double.parseDouble(this.formatter.format(d4 / d5 * 100.0));
                    d9 = Double.parseDouble(this.formatter.format(d3 / d5 * 100.0));
                    d10 = Double.parseDouble(this.formatter.format(d5 / (double)l));
                    d11 = Double.parseDouble(this.formatter.format(d4 / (double)l));
                    d20 = Double.parseDouble(this.formatter.format(d19 / (double)l));
                    d21 = Double.parseDouble(this.formatter.format(d18 / (double)l));
                }
                arrayList.add(new Double(d6));
                arrayList.add(new Double(d7));
                arrayList.add(new Double(d8));
                arrayList.add(new Double(d9));
                if (this.numOutputFields > 23) {
                    arrayList.add(new Double(d12));
                    arrayList.add(new Double(d13));
                    arrayList.add(new Double(d14));
                    arrayList.add(new Double(d10));
                    arrayList.add(new Double(d11));
                    arrayList.add(new Double(d15));
                    arrayList.add(new Double(d20));
                    arrayList.add(new Double(d21));
                }
                string4 = BusinessTransTestBase.decodeUrlString(string4, this.loggerDispStr);
                this.addNewMeasure(string4, arrayList);
                JavaBTMLogger.btmLogger.debug("{} {}  Sent addNewMeasure: {} = {}", new Object[]{this.loggerDispStr, this.entity, string4, arrayList});
            }
            if (bl3) continue;
            arrayList = new ArrayList();
            Object v = hashtable4.get("SlowURLLists");
            if (v != null && v instanceof ArrayList) {
                arrayList = (ArrayList)v;
            }
            ArrayList arrayList3 = new ArrayList();
            Object v2 = hashtable4.get("ErrorURLLists");
            if (v2 != null && v2 instanceof ArrayList) {
                arrayList3 = (ArrayList)v2;
            }
            ArrayList arrayList4 = new ArrayList();
            Object v3 = hashtable4.get("AllURLLists");
            if (v3 != null && v3 instanceof ArrayList) {
                arrayList4 = (ArrayList)v3;
            }
            ArrayList arrayList5 = new ArrayList();
            Object v4 = hashtable4.get("StalledURLLists");
            if (v4 != null && v4 instanceof ArrayList) {
                arrayList5 = (ArrayList)v4;
            }
            ArrayList arrayList6 = null;
            Object v5 = hashtable4.get("SlowURLThreadLists");
            if (v5 != null && v5 instanceof ArrayList) {
                arrayList6 = (ArrayList)v5;
            }
            ArrayList arrayList7 = null;
            Object v6 = hashtable4.get("ErrorURLThreadLists");
            if (v6 != null && v6 instanceof ArrayList) {
                arrayList7 = (ArrayList)v6;
            }
            ArrayList arrayList8 = null;
            Object v7 = hashtable4.get("StalledURLThreadLists");
            if (v7 != null && v7 instanceof ArrayList) {
                arrayList8 = (ArrayList)v7;
            }
            ArrayList arrayList9 = null;
            Object v8 = hashtable4.get("HealthyURLThreadLists");
            if (v8 != null && v8 instanceof ArrayList) {
                arrayList9 = (ArrayList)v8;
            }
            if (arrayList6 != null && arrayList6.size() > 0) {
                arrayList.addAll(arrayList6);
            }
            if (arrayList7 != null && arrayList7.size() > 0) {
                arrayList3.addAll(arrayList7);
            }
            if (arrayList8 != null && arrayList8.size() > 0) {
                arrayList5.addAll(arrayList8);
            }
            if (arrayList9 != null && arrayList9.size() > 0) {
                arrayList4.addAll(arrayList9);
            }
            ArrayList arrayList10 = new ArrayList();
            Hashtable hashtable5 = this.formatSource(arrayList, hashtable2, string3, true);
            if (hashtable5 != null && hashtable5.size() > 0) {
                cloneable2 = (ArrayList)hashtable5.get("DD");
                ArrayList arrayList11 = (ArrayList)hashtable5.get("EXTRA");
                if (cloneable2 != null && ((ArrayList)cloneable2).size() > 0) {
                    this.slowURLTable.put(string4, cloneable2);
                }
                if (arrayList11 != null && arrayList11.size() > 0) {
                    arrayList10.addAll(arrayList11);
                }
            }
            if ((cloneable2 = this.formatSource(arrayList3, hashtable2, string3, true)) != null && ((Hashtable)cloneable2).size() > 0) {
                ArrayList arrayList12 = (ArrayList)((Hashtable)cloneable2).get("DD");
                cloneable = (ArrayList)((Hashtable)cloneable2).get("EXTRA");
                if (arrayList12 != null && arrayList12.size() > 0) {
                    this.errorURLTable.put(string4, arrayList12);
                }
                if (cloneable != null && ((ArrayList)cloneable).size() > 0) {
                    arrayList10.addAll(cloneable);
                }
            }
            if ((hashtable3 = this.formatSource(arrayList4, hashtable2, string3, true)) != null && hashtable3.size() > 0) {
                cloneable = (ArrayList)hashtable3.get("DD");
                ArrayList arrayList13 = (ArrayList)hashtable3.get("EXTRA");
                if (cloneable != null && ((ArrayList)cloneable).size() > 0) {
                    this.allURLTable.put(string4, cloneable);
                }
                if (arrayList13 != null && arrayList13.size() > 0) {
                    arrayList10.addAll(arrayList13);
                }
            }
            if ((cloneable = this.formatSource(arrayList5, hashtable2, string3, true)) != null && ((Hashtable)cloneable).size() > 0) {
                ArrayList arrayList14 = (ArrayList)((Hashtable)cloneable).get("DD");
                ArrayList arrayList15 = (ArrayList)((Hashtable)cloneable).get("EXTRA");
                if (arrayList14 != null && arrayList14.size() > 0) {
                    this.stalledURLTable.put(string4, arrayList14);
                }
                if (arrayList15 != null && arrayList15.size() > 0) {
                    arrayList10.addAll(arrayList15);
                }
            }
            if (arrayList10 == null || arrayList10.size() <= 0) continue;
            this.externalTable.put(string4, arrayList10);
        }
    }

    private boolean getOffLoadData(JavaAPMComponent javaAPMComponent) {
        boolean bl = false;
        JavaBTMLogger.btmLogger.debug("{} offload JVM GUID :{} - {} & Entity {}", new Object[]{this.loggerDispStr, this.jvmGUID, this.NodeID, this.entity});
        javaAPMComponent.getUPDManager();
        UPDManager uPDManager = javaAPMComponent.getUPDManager();
        if (uPDManager != null) {
            this.sourceTable = uPDManager.getMeasures(false, this.entity);
        }
        if (this.sourceTable != null && this.sourceTable.size() > 0) {
            this.status_code = 200;
            bl = true;
        }
        return bl;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            if (l < 25L) {
                l = 25L;
            }
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private String getMaskedIP(String string) {
        boolean bl;
        if (string != null && ((bl = IPAddressUtils.isValidPublicIp((String)string, (boolean)false)) && this.publicIPMaskFlag || !bl && this.privateIPMaskFlag)) {
            string = IPAddressMaskHelper.maskIPAddress(string, !bl, bl);
        }
        return string;
    }

    private boolean checkIsIpLocalhost(String string) {
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("localhost") || string.startsWith("127.") || string.equals("0:0:0:0:0:0:0:1") || string.equals("-");
    }

    static {
        ldapMethodMapping.put("javax/naming/directory/InitialDirContext[*#*]search", "LDAP Search");
        ldapMethodMapping.put("com/sun/jndi/ldap/LdapClient[*#*]search", "LDAP Client Search");
        ldapMethodMapping.put("com/sun/jndi/ldap/LdapClientFactory[*#*]createPooledConnection", "LDAP ClientFactory Connect");
        ldapMethodMapping.put("com/sun/jndi/ldap/LdapNamingEnumeration[*#*]getNextBatch", "LDAP NamingEnumeration GetNextBatch");
        ldapMethodMapping.put("com/sun/jndi/ldap/LdapNamingEnumeration[*#*]nextAux", "LDAP NamingEnumeration NextAux");
        ldapMethodMapping.put("javax/naming/directory/InitialDirContext[*#*]modifyAttributes", "LDAP ModifyAttributes");
        ldapMethodMapping.put("com/sun/jndi/ldap/LdapClient[*#*]modify", "LDAP Client Modify");
        ldapMethodMapping.put("javax/naming/directory/InitialDirContext[*#*]bind", "LDAP Bind");
        ldapMethodMapping.put("javax/naming/directory/InitialDirContext[*#*]rebind", "LDAP Rebind");
    }
}

