/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import java.util.Hashtable;

public class CiscoCpuTest
extends EgSnmpTest {
    private static String oldCiscoCpuUtiloid = ".1.3.6.1.4.1.9.2.1.57";
    private static String newCiscoCpuUtiloid = ".1.3.6.1.4.1.9.9.109.1.1.1.1.4";
    private static String indexOid = ".1.3.6.1.4.1.9.9.109.1.1.1.1.2";
    private static String nameOid = ".1.3.6.1.2.1.47.1.1.1.1.7";
    private boolean useOldValue = false;
    private boolean useNewValue = false;
    private boolean res = false;
    private int count = 0;
    private int numCpus = 0;
    private int discCount = 4;
    private Hashtable indexToName = new Hashtable();
    private static int ciscoCpuIndex = 0;
    private boolean isNewCisco = false;

    public static void main(String[] stringArray) {
        CiscoCpuTest ciscoCpuTest = new CiscoCpuTest(stringArray);
        ciscoCpuTest.executeTest();
        System.out.println(ciscoCpuTest.errorMsg);
        for (int i = 0; i < ciscoCpuTest.lhs.length; ++i) {
            System.out.println("lhs " + ciscoCpuTest.lhs[i]);
            System.out.println("rhs " + ciscoCpuTest.rhs[i]);
        }
    }

    public CiscoCpuTest(String[] stringArray) {
        super(stringArray);
        this.numOutputFields = 1;
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini");
        String string = iniFile.getValue("AGENT_SETTINGS", "isCiscoNewOid");
        if (string != null && !string.equalsIgnoreCase("")) {
            this.isNewCisco = string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("true");
        }
        if (this.isNewCisco) {
            this.useNewValue = true;
        } else {
            this.useOldValue = true;
        }
    }

    public boolean executeTest() {
        this.initTest();
        String string = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
        try {
            if (this.useNewValue || !this.useOldValue) {
                if (this.count == 0) {
                    this.discoverCpus();
                }
                ++this.count;
                if (this.count == this.discCount) {
                    this.count = 0;
                }
                this.res = this.runSnmpCmdForOid(newCiscoCpuUtiloid);
                if (!this.res || this.rhs.length < 1) {
                    this.useNewValue = false;
                    this.res = this.runSnmpCmdForOid(oldCiscoCpuUtiloid);
                    if (!this.res || this.rhs.length < 1) {
                        this.useOldValue = false;
                        this.updateAllResultSets(true);
                        this.errorMsg = new String(" Failed to get results while executing CiscoCpuTest for OID " + newCiscoCpuUtiloid);
                        return false;
                    }
                    this.count = 0;
                    this.useOldValue = true;
                    this.addValueToResultSet(string, ciscoCpuIndex, Double.parseDouble(this.rhs[0]));
                    this.updateAllResultSets();
                    return true;
                }
                this.useNewValue = true;
                this.useOldValue = false;
                if (this.numCpus <= 1) {
                    this.addValueToResultSet(string, ciscoCpuIndex, Double.parseDouble(this.rhs[0]));
                } else {
                    double d = 0.0;
                    double d2 = 0.0;
                    for (int i = 0; i < this.rhs.length; ++i) {
                        String string2 = (String)this.indexToName.get(this.lhs[i]);
                        if (string2 == null) continue;
                        d += 1.0;
                        if (Double.parseDouble(this.rhs[i]) >= 0.0) {
                            d2 += Double.parseDouble(this.rhs[i]);
                        }
                        String string3 = string + string2;
                        this.addValueToResultSet(string3, ciscoCpuIndex, Double.parseDouble(this.rhs[i]));
                    }
                    double d3 = d2 / d;
                    if (d3 > 100.0) {
                        d3 = 100.0;
                    }
                    this.addValueToResultSet(string + "Summary", ciscoCpuIndex, d3);
                }
            } else {
                this.res = this.runSnmpCmdForOid(oldCiscoCpuUtiloid);
                if (!this.res || this.rhs.length < 1) {
                    this.useOldValue = false;
                    if (this.count == 0) {
                        this.discoverCpus();
                    }
                    ++this.count;
                    if (this.count == this.discCount) {
                        this.count = 0;
                    }
                    this.res = this.runSnmpCmdForOid(newCiscoCpuUtiloid);
                    if (!this.res || this.rhs.length < 1) {
                        this.useNewValue = false;
                        this.updateAllResultSets(true);
                        this.errorMsg = new String(" Failed to get results while executing CiscoCpuTest " + newCiscoCpuUtiloid);
                        return false;
                    }
                    this.useNewValue = true;
                    if (this.numCpus <= 1) {
                        this.addValueToResultSet(string, ciscoCpuIndex, Double.parseDouble(this.rhs[0]));
                    } else {
                        double d = 0.0;
                        double d4 = 0.0;
                        for (int i = 0; i < this.rhs.length; ++i) {
                            String string4 = (String)this.indexToName.get(this.lhs[i]);
                            if (string4 == null) continue;
                            d += 1.0;
                            if (Double.parseDouble(this.rhs[i]) >= 0.0) {
                                d4 += Double.parseDouble(this.rhs[i]);
                            }
                            String string5 = string + string4;
                            this.addValueToResultSet(string5, ciscoCpuIndex, Double.parseDouble(this.rhs[i]));
                        }
                        double d5 = d4 / d;
                        if (d5 > 100.0) {
                            d5 = 100.0;
                        }
                        this.addValueToResultSet(string + "Summary", ciscoCpuIndex, d5);
                    }
                } else {
                    this.count = 0;
                    this.useOldValue = true;
                    this.useNewValue = false;
                    this.addValueToResultSet(string, ciscoCpuIndex, Double.parseDouble(this.rhs[0]));
                    this.updateAllResultSets();
                    return true;
                }
                this.updateAllResultSets(true);
                return true;
            }
            this.updateAllResultSets(true);
            return true;
        }
        catch (Exception exception) {
            this.updateAllResultSets();
            this.count = 0;
            this.useNewValue = false;
            this.useOldValue = false;
            this.errorMsg = new String(" Cannot execute CiscoCpuTest ");
            exception.printStackTrace();
            return false;
        }
    }

    private void discoverCpus() {
        this.res = this.runSnmpCmdForOid(indexOid);
        if (!this.res || this.rhs.length < 1) {
            this.count = 0;
            return;
        }
        this.numCpus = this.rhs.length;
        this.indexToName = new Hashtable();
        if (this.numCpus > 1) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            for (int i = 0; i < this.rhs.length; ++i) {
                hashtable.put(this.rhs[i], this.lhs[i]);
            }
            this.res = this.runSnmpCmdForOid(nameOid);
            Hashtable hashtable2 = new Hashtable();
            if (this.res && this.rhs != null && this.rhs.length > 0) {
                for (int i = 0; i < this.rhs.length; ++i) {
                    String string = (String)hashtable.get(this.lhs[i]);
                    if (string == null) continue;
                    this.rhs[i] = this.rhs[i].replace('\"', ' ').trim();
                    this.rhs[i] = this.rhs[i].replace('\'', ' ').trim();
                    this.indexToName.put(string, this.rhs[i]);
                }
            }
        }
    }
}

