/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class CpqDiskTest
extends EgSnmpGenericTest {
    private static String diskOid = ".1.3.6.1.4.1.232.19.2.7.2.1";
    private static String instanceOid = ".1.3.6.1.4.1.232.19.2.7.2.1.2";
    private static String busyOid = ".1.3.6.1.4.1.232.19.2.7.2.1.4";
    private static String diskCondOid = ".1.3.6.1.4.1.232.19.2.7.2.1.5";
    private static String diskBytesOid = ".1.3.6.1.4.1.232.19.2.7.2.1.6";
    private static String diskReadBytesOid = ".1.3.6.1.4.1.232.19.2.7.2.1.10";
    private static String diskWriteBytesOid = ".1.3.6.1.4.1.232.19.2.7.2.1.11";
    private static String diskReadTimeOid = ".1.3.6.1.4.1.232.19.2.7.2.1.12";
    private static String diskWriteTimeOid = ".1.3.6.1.4.1.232.19.2.7.2.1.13";
    private static String diskQueueLen = ".1.3.6.1.4.1.232.19.2.7.2.1.14";

    public CpqDiskTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(8);
        this.isDynamicInfoTest = true;
    }

    private Double getValue(int n) {
        if (this.lhs == null || this.lhs.length == 0) {
            return new Double(-5.0);
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d < 0.0) {
            d = -5.0;
        }
        return new Double(d);
    }

    private Double getKValue(int n) {
        if (this.lhs == null || this.lhs.length == 0) {
            return new Double(-5.0);
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
            d /= 1024.0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d < 0.0) {
            d = -5.0;
        }
        return new Double(d);
    }

    public void computeMeasures(Hashtable hashtable) {
        String string;
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Hashtable<String, Double> hashtable3 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable4 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable5 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable6 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable7 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable8 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable9 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable10 = new Hashtable<String, Double>();
        if (!this.runSnmpCmdForOid(diskOid)) {
            return;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            double d;
            if (this.lhs[i].startsWith("2.")) {
                string = this.lhs[i].substring(2);
                hashtable2.put(string, this.rhs[i]);
                continue;
            }
            if (this.lhs[i].startsWith("4.")) {
                string = this.lhs[i].substring(2);
                hashtable3.put(string, this.getValue(i));
                continue;
            }
            if (this.lhs[i].startsWith("5.")) {
                string = this.lhs[i].substring(2);
                d = this.getValue(i);
                if (d == 1.0) {
                    d = -5.0;
                } else if (d == 2.0) {
                    d = 0.0;
                } else if (d == 3.0) {
                    d = 1.0;
                } else if (d == 4.0) {
                    d = 2.0;
                }
                hashtable4.put(string, new Double(d));
                continue;
            }
            if (this.lhs[i].startsWith("6.")) {
                string = this.lhs[i].substring(2);
                hashtable5.put(string, this.getKValue(i));
                continue;
            }
            if (this.lhs[i].startsWith("10.")) {
                string = this.lhs[i].substring(3);
                hashtable6.put(string, this.getKValue(i));
                continue;
            }
            if (this.lhs[i].startsWith("11.")) {
                string = this.lhs[i].substring(3);
                hashtable7.put(string, this.getKValue(i));
                continue;
            }
            if (this.lhs[i].startsWith("12.")) {
                string = this.lhs[i].substring(3);
                d = this.getValue(i);
                if (d > 0.0) {
                    d /= 10000.0;
                }
                hashtable8.put(string, new Double(d));
                continue;
            }
            if (this.lhs[i].startsWith("13.")) {
                string = this.lhs[i].substring(3);
                d = this.getValue(i);
                if (d > 0.0) {
                    d /= 10000.0;
                }
                hashtable9.put(string, new Double(d));
                continue;
            }
            if (!this.lhs[i].startsWith("14.")) continue;
            string = this.lhs[i].substring(3);
            hashtable10.put(string, this.getValue(i));
        }
        System.out.println("In CpqDiskTest: busy " + hashtable3 + " cond " + hashtable4);
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            String string2 = (String)hashtable2.get(string);
            if (string2 == null) continue;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            Double d = (Double)hashtable3.get(string);
            if (d != null) {
                arrayList.add(d);
            } else {
                arrayList.add(new Double(-5.0));
            }
            d = (Double)hashtable4.get(string);
            if (d != null) {
                arrayList.add(d);
            } else {
                arrayList.add(new Double(-5.0));
            }
            d = (Double)hashtable5.get(string);
            if (d != null) {
                arrayList.add(d);
            } else {
                arrayList.add(new Double(-5.0));
            }
            d = (Double)hashtable6.get(string);
            if (d != null) {
                arrayList.add(d);
            } else {
                arrayList.add(new Double(-5.0));
            }
            d = (Double)hashtable7.get(string);
            if (d != null) {
                arrayList.add(d);
            } else {
                arrayList.add(new Double(-5.0));
            }
            d = (Double)hashtable8.get(string);
            if (d != null) {
                arrayList.add(d);
            } else {
                arrayList.add(new Double(-5.0));
            }
            d = (Double)hashtable9.get(string);
            if (d != null) {
                arrayList.add(d);
            } else {
                arrayList.add(new Double(-5.0));
            }
            d = (Double)hashtable10.get(string);
            if (d != null) {
                arrayList.add(d);
            } else {
                arrayList.add(new Double(-5.0));
            }
            this.addNewMeasure(string2, arrayList);
        }
    }
}

