/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class DTUptimeTest
extends EgSnmpGenericTest {
    private double prevSysuptime = 0.0;

    public DTUptimeTest(String[] stringArray) {
        super(stringArray);
        this.isNewDynamicInfoTest = true;
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.setMeasureCount(3);
        String string = this.getValueForParam("debug");
        if (string == null) {
            debug = false;
        }
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
            debug = true;
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d = 0.0;
        String string = this.getMeasure(".1.3.6.1.4.1.2592.3.2.1");
        if (debug) {
            System.out.println("[DtUptimeTest] uptime==============:" + string);
        }
        double d2 = Double.parseDouble(string);
        double d3 = d2 / 60.0;
        if (debug) {
            System.out.println("[DtUptimeTest] tot_uptime_min===========:" + d3);
        }
        double d4 = Double.parseDouble(string);
        double d5 = d4 - this.prevSysuptime;
        if (debug) {
            System.out.println("[DtUptimeTest] diffValue:" + d5);
        }
        double d6 = d5 / 60.0;
        if (debug) {
            System.out.println("[DtUptimeTest] diffValue_mins:" + d6);
        }
        d = d5 >= 0.0 ? 1.0 : 0.0;
        if (debug) {
            System.out.println("[DtUptimeTest] Is System Booted : " + d);
            System.out.println("[DtUptimeTest] Total uptime in Mins " + Math.round(d3));
            System.out.println(" [DtUptimeTest] Current uptime in Mins " + d6);
        }
        arrayList.add(new Double(d));
        arrayList.add(new Double(Math.round(d3)));
        arrayList.add(new Double(d6));
        if (debug) {
            System.out.println("[DTUptimeTest] Measure List ====================>" + arrayList);
        }
        this.addNewMeasure(arrayList);
        this.prevSysuptime = d2;
    }

    public String getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        String string2 = "";
        String string3 = "";
        if (bl) {
            for (int i = 0; i < this.lhs.length; ++i) {
                if (this.lhs[i].startsWith(".")) continue;
                string2 = this.lhs[i];
                string3 = this.rhs[i];
            }
        }
        return string3;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.8.30", "-port", "NULL", "-snmpPort", "161", "-snmpversion", "v1", "-snmpCommunity", "public"};
        DTUptimeTest dTUptimeTest = new DTUptimeTest(stringArray2);
        dTUptimeTest.computeMeasures(new Hashtable());
    }
}

