/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IPV6Helper;
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class DockerContainers {
    private static DockerContainers docContServer = null;
    public boolean isDockerServer = false;
    private Hashtable ht_runningContainerIpMap = new Hashtable();
    private long lastUpdatedTime = 0L;
    private static String sync = new String("sync");
    private Hashtable ht_containerIdAndPodName = new Hashtable();
    private Hashtable ht_containerIdAndPort = new Hashtable();

    private DockerContainers() {
        this.isDockerServer = this.isItDockerServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DockerContainers getDockerContainerInstance() {
        if (docContServer == null) {
            String string = sync;
            synchronized (string) {
                if (docContServer == null) {
                    docContServer = new DockerContainers();
                }
            }
        }
        return docContServer;
    }

    private boolean isItDockerServer() {
        String string = System.getProperty("os.name").toLowerCase();
        boolean bl = false;
        String string2 = "";
        try {
            ArrayList arrayList = null;
            String string3 = "";
            if (string != null && string.indexOf("linux") >= 0) {
                if (new File("/usr/bin/docker").exists()) {
                    string2 = "/usr/bin/";
                    string3 = "/usr/bin/docker info";
                    arrayList = this.executeCommand(string3);
                } else if (new File("/usr/sbin/docker").exists()) {
                    string2 = "/usr/sbin/";
                    string3 = "/usr/sbin/docker info";
                    arrayList = this.executeCommand(string3);
                } else if (new File("/bin/docker").exists()) {
                    string2 = "/bin/";
                    string3 = "/bin/docker info";
                    arrayList = this.executeCommand(string3);
                } else {
                    return false;
                }
                if (arrayList == null || arrayList.size() == 0) {
                    return false;
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string4 = ((String)arrayList.get(i)).trim();
                    if (string4 == null || string4.indexOf("Containers:") < 0 && string4.indexOf("Images:") < 0) continue;
                    bl = true;
                    break;
                }
            }
            System.out.println("[DockerContainers] flag = " + bl);
        }
        catch (Exception exception) {
            System.out.println("Exception Occured in DockerContainers while checking current server is docker :" + exception.toString());
            exception.printStackTrace();
        }
        return bl;
    }

    public String getContainerIp(String string) {
        long l = System.currentTimeMillis();
        if (l - this.lastUpdatedTime > 600000L) {
            this.ht_runningContainerIpMap = this.getRunningContainerIpDetails();
            this.lastUpdatedTime = l;
        }
        String string2 = "";
        if (this.ht_runningContainerIpMap != null && this.ht_runningContainerIpMap.containsKey(string)) {
            string2 = (String)this.ht_runningContainerIpMap.get(string);
        } else {
            this.ht_runningContainerIpMap = this.getRunningContainerIpDetails();
            this.lastUpdatedTime = l;
            if (this.ht_runningContainerIpMap != null && this.ht_runningContainerIpMap.containsKey(string)) {
                string2 = (String)this.ht_runningContainerIpMap.get(string);
            }
        }
        return string2;
    }

    public String getPodName(String string) {
        long l = System.currentTimeMillis();
        if (l - this.lastUpdatedTime > 600000L) {
            this.ht_runningContainerIpMap = this.getRunningContainerIpDetails();
            this.lastUpdatedTime = l;
        }
        String string2 = "";
        if (this.ht_containerIdAndPodName != null && this.ht_containerIdAndPodName.containsKey(string)) {
            string2 = (String)this.ht_containerIdAndPodName.get(string);
        } else {
            this.ht_runningContainerIpMap = this.getRunningContainerIpDetails();
            this.lastUpdatedTime = l;
            if (this.ht_containerIdAndPodName != null && this.ht_containerIdAndPodName.containsKey(string)) {
                string2 = (String)this.ht_containerIdAndPodName.get(string);
            }
        }
        return string2;
    }

    public Hashtable getRunningContainerIpDetails() {
        Hashtable hashtable;
        Hashtable<Object, String> hashtable2;
        String string;
        String string2;
        Object object;
        int n;
        Hashtable hashtable3 = this.geRunningtContainerDetails();
        ArrayList<String> arrayList = new ArrayList<String>();
        Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n2 = EgMainAgent.maxDockerThreads;
        if (hashtable3 != null && hashtable3.size() > 0) {
            int n3 = hashtable3.size();
            int n4 = 10;
            n = 1;
            int n5 = 0;
            object = hashtable3.keys();
            string2 = "";
            while (object.hasMoreElements()) {
                String string3;
                Hashtable hashtable5;
                string = (String)object.nextElement();
                ++n5;
                if (string == null || (hashtable5 = (Hashtable)hashtable3.get(string)) == null) continue;
                if (hashtable5.containsKey("Command")) {
                    string3 = (String)hashtable5.get("Command");
                    if (string3 != null && (string3 = string3.trim()).startsWith("\"") && string3.endsWith("\"")) {
                        string3.substring(1, string3.length() - 1);
                    }
                    if (string3 != null && string3.trim().equalsIgnoreCase("\"/pause\"")) continue;
                }
                if (n <= n4) {
                    string2 = n == 1 ? string : string2 + " " + string;
                    ++n;
                }
                if (n == n4) {
                    arrayList.add(string2);
                    string2 = "";
                    n = 1;
                }
                if (n5 == n3 && n != n4) {
                    arrayList.add(string2);
                }
                string3 = null;
                if (!hashtable5.containsKey("Names") || (string3 = (String)hashtable5.get("Names")) == null) continue;
                hashtable4.put(string3, string);
                if (string3.toLowerCase().startsWith("k8s_")) {
                    arrayList2.add(string);
                    continue;
                }
                hashtable4.put(string3, string);
            }
        }
        ArrayList arrayList3 = new ArrayList();
        if (arrayList != null && arrayList.size() > 0) {
            ArrayList<DockerContainersThread> arrayList4 = new ArrayList<DockerContainersThread>();
            n = arrayList.size();
            String string4 = "docker inspect --format=\"{{.Name}}#@#{{.NetworkSettings.Ports}}#@#{{.Config.Labels}}#@#{{.NetworkSettings.IPAddress}}#@#{{range.NetworkSettings.Networks}}{{.IPAddress}}{{end}}\" ";
            for (int i = 0; i < n; ++i) {
                string2 = (String)arrayList.get(i);
                if (string2 == null) continue;
                string = string4 + string2;
                long l = System.currentTimeMillis();
                long l2 = 360000L;
                long l3 = l - l2;
                while (arrayList4.size() >= n2) {
                    for (int j = 0; j < arrayList4.size(); ++j) {
                        DockerContainersThread dockerContainersThread = (DockerContainersThread)arrayList4.get(j);
                        if (dockerContainersThread.isDone()) {
                            ArrayList arrayList5 = dockerContainersThread.getOutput();
                            if (arrayList5 != null && arrayList5.size() > 0) {
                                arrayList3.addAll(arrayList5);
                            }
                            arrayList4.remove(j--);
                            continue;
                        }
                        l = System.currentTimeMillis();
                        l3 = l - l2;
                        if (dockerContainersThread.startTime >= l3) continue;
                        try {
                            dockerContainersThread.interrupt();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        arrayList4.remove(j);
                        --j;
                    }
                    if (arrayList4.size() < n2) break;
                    try {
                        Thread.currentThread();
                        Thread.sleep(300L);
                    }
                    catch (Exception exception) {}
                }
                DockerContainersThread dockerContainersThread = new DockerContainersThread(this, string);
                arrayList4.add(dockerContainersThread);
            }
            long l = 360000L;
            while (arrayList4.size() > 0) {
                long l4 = System.currentTimeMillis();
                long l5 = l4 - l;
                for (int i = 0; i < arrayList4.size(); ++i) {
                    DockerContainersThread dockerContainersThread = (DockerContainersThread)arrayList4.get(i);
                    if (dockerContainersThread.isDone()) {
                        ArrayList arrayList6 = dockerContainersThread.getOutput();
                        if (arrayList6 != null && arrayList6.size() > 0) {
                            arrayList3.addAll(arrayList6);
                        }
                        arrayList4.remove(i);
                        --i;
                        continue;
                    }
                    if (dockerContainersThread.startTime >= l5) continue;
                    try {
                        dockerContainersThread.interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    arrayList4.remove(i);
                    --i;
                }
                if (arrayList4 == null || arrayList4.size() == 0) break;
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
        if ((hashtable2 = this.getRunningContainerIp(arrayList3, hashtable4)) == null) {
            hashtable2 = new Hashtable<Object, String>();
        }
        if ((hashtable = this.getKubePodIpDetails(arrayList2)) != null && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (object == null || (string2 = (String)hashtable.get(object)) == null || string2.length() == 0) continue;
                hashtable2.put(object, string2);
            }
        }
        return hashtable2;
    }

    public Hashtable getRunningContainerIp(ArrayList arrayList, Hashtable hashtable) {
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        int n = arrayList.size();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        for (int i = 0; i < n; ++i) {
            String string;
            int n2;
            Object object;
            Object object2;
            Object object3;
            int n3;
            ArrayList arrayList2;
            String string2 = (String)arrayList.get(i);
            if (string2 == null || (arrayList2 = this.egTokenizer(string2, "#@#")) == null || arrayList2.size() < 5) continue;
            String string3 = (String)arrayList2.get(0);
            string3 = string3.trim();
            if ((string3 = string3.substring(1)).startsWith("/")) {
                string3 = string3.substring(1);
            }
            String string4 = (String)arrayList2.get(1);
            String string5 = (String)arrayList2.get(2);
            String string6 = (String)arrayList2.get(3);
            String string7 = (String)arrayList2.get(4);
            if (string6 != null) {
                if ((string6 = string6.trim()).equals("\"")) {
                    string6 = "";
                }
                if (string6.startsWith("\"") && string6.length() > 0) {
                    string6 = string6.substring(1);
                }
                if (string6.endsWith("\"") && string6.length() > 0) {
                    string6 = string6.substring(0, string6.length() - 1);
                }
            } else if (string7 != null) {
                if ((string7 = string7.trim()).startsWith("\"")) {
                    string7 = string7.substring(1);
                }
                if (string7.endsWith("\"")) {
                    string7 = string7.substring(0, string7.length() - 1);
                }
                string6 = string7;
            }
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            if (string4 != null && string4.length() > 0 && string4.trim().startsWith("map[") && string4.length() > 4 && (n3 = ((StringTokenizer)(object3 = new StringTokenizer(string4 = string4.substring(4, string4.length() - 1), ":"))).countTokens()) > 1) {
                for (int j = 0; j < n3; ++j) {
                    object2 = ((StringTokenizer)object3).nextToken();
                    if (object2 == null || ((String)object2).indexOf("/") <= 0) continue;
                    object = new StringTokenizer((String)(object2 = ((String)object2).substring(0, ((String)object2).indexOf("/"))));
                    n2 = ((StringTokenizer)object).countTokens();
                    if (n2 > 1) {
                        for (int k = 0; k < n2; ++k) {
                            string = ((StringTokenizer)object).nextToken();
                            if (k != n2 - 1) continue;
                            arrayList3.add(string);
                        }
                        continue;
                    }
                    arrayList3.add(object2);
                }
            }
            object3 = null;
            if (hashtable != null && string3 != null && hashtable.containsKey(string3)) {
                object3 = (String)hashtable.get(string3);
            }
            if (string6 != null && string6.length() > 0 && object3 != null) {
                hashtable2.put((String)object3, string6);
            }
            String string8 = "";
            String string9 = "";
            if (string3.toLowerCase().startsWith("k8s_") && string5 != null && (string5 = string5.trim()).startsWith("map[") && string5.endsWith("]")) {
                string5 = string5.substring(4, string5.length() - 1);
                object2 = new StringTokenizer(string5);
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    int n4;
                    String string10;
                    String string11;
                    object = ((StringTokenizer)object2).nextToken();
                    if (object == null || ((String)object).indexOf(":") <= 0) continue;
                    n2 = ((String)object).indexOf(":");
                    String string12 = ((String)object).substring(0, n2);
                    string = ((String)object).substring(n2 + 1);
                    if (string12.equalsIgnoreCase("io.kubernetes.pod.name")) {
                        string8 = string;
                    }
                    if (!string12.equalsIgnoreCase("annotation.io.kubernetes.container.ports") || (string11 = string) == null || string11.indexOf("\"containerPort\":") < 0 || (string10 = string11.substring((n4 = string11.indexOf("\"containerPort\":")) + 16)) == null || string10.indexOf(",") <= 0) continue;
                    string9 = string10.substring(0, string10.indexOf(","));
                }
            }
            if (string9 != null && string9.length() > 0 && (arrayList3 == null || arrayList3.size() == 0)) {
                arrayList3 = new ArrayList();
                arrayList3.add(string9);
            }
            if (string8 == null || object3 == null) continue;
            this.ht_containerIdAndPodName.put(object3, string8);
            if (arrayList3 == null || arrayList3.size() <= 0) continue;
            this.ht_containerIdAndPort.put(object3, this.getHighPriorityPort(arrayList3));
        }
        System.out.println("[DockerContainers] ht_containerIdAndPodName = " + this.ht_containerIdAndPodName);
        System.out.println("[DockerContainers] ht_PodContainerMap = " + this.ht_containerIdAndPort);
        System.out.println("[DockerContainers] ht_runningContainerIpMap = " + this.ht_runningContainerIpMap);
        return hashtable2;
    }

    public Hashtable getKubePodIpDetails(ArrayList arrayList) {
        Object object;
        Object object2;
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        int n = arrayList.size();
        int n2 = EgMainAgent.maxDockerThreads;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            if (string == null) continue;
            String string2 = "docker exec " + string + " hostname -i";
            long l = System.currentTimeMillis();
            long l2 = 360000L;
            long l3 = l - l2;
            while (arrayList2.size() >= n2) {
                for (int j = 0; j < arrayList2.size(); ++j) {
                    object2 = (DockerContainersThread)arrayList2.get(j);
                    if (((DockerContainersThread)object2).isDone()) {
                        String string3;
                        ArrayList arrayList3 = ((DockerContainersThread)object2).getOutput();
                        String string4 = ((DockerContainersThread)object2).getContainerId();
                        if (arrayList3 != null && arrayList3.size() > 0 && string4 != null && (string3 = (String)arrayList3.get(0)) != null && IPV6Helper.validateIPV4(string3.trim())) {
                            hashtable.put(string4, string3);
                        }
                        arrayList2.remove(j);
                        --j;
                        continue;
                    }
                    l = System.currentTimeMillis();
                    l3 = l - l2;
                    if (((DockerContainersThread)object2).startTime >= l3) continue;
                    try {
                        ((Thread)object2).interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    arrayList2.remove(j);
                    --j;
                }
                if (arrayList2.size() < n2) break;
                try {
                    Thread.currentThread();
                    Thread.sleep(300L);
                }
                catch (Exception exception) {}
            }
            object = new DockerContainersThread(this, string2, string);
            arrayList2.add(object);
        }
        long l = 360000L;
        while (arrayList2.size() > 0) {
            long l4 = System.currentTimeMillis();
            long l5 = l4 - l;
            for (int i = 0; i < arrayList2.size(); ++i) {
                DockerContainersThread dockerContainersThread = (DockerContainersThread)arrayList2.get(i);
                if (dockerContainersThread.isDone()) {
                    ArrayList arrayList4 = dockerContainersThread.getOutput();
                    object = dockerContainersThread.getContainerId();
                    if (arrayList4 != null && arrayList4.size() > 0 && object != null && (object2 = (String)arrayList4.get(0)) != null && IPV6Helper.validateIPV4(((String)object2).trim())) {
                        hashtable.put(object, object2);
                    }
                    arrayList2.remove(i);
                    --i;
                    continue;
                }
                if (dockerContainersThread.startTime >= l5) continue;
                try {
                    dockerContainersThread.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                arrayList2.remove(i);
                --i;
            }
            if (arrayList2 == null || arrayList2.size() == 0) break;
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        return hashtable;
    }

    public Hashtable geRunningtContainerDetails() {
        try {
            Hashtable hashtable = new Hashtable();
            String string = "docker ps -a -s";
            ArrayList arrayList = this.executeCommand(string);
            if (arrayList == null || arrayList.size() == 0) {
                System.out.println(" [DockerContainers] " + string + "\toutput is null so return  ");
                return null;
            }
            int n = arrayList.size();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            String string10 = "";
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                String string11 = (String)arrayList.get(i);
                if (string11 == null) continue;
                if (string11.indexOf("CONTAINER ID") >= 0) {
                    n2 = string11.indexOf("CONTAINER ID");
                    n3 = string11.indexOf("IMAGE");
                    n4 = string11.indexOf("COMMAND");
                    n5 = string11.indexOf("CREATED");
                    n6 = string11.indexOf("STATUS");
                    n7 = string11.indexOf("PORTS");
                    n8 = string11.indexOf("NAMES");
                    n9 = string11.indexOf("SIZE");
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                string2 = string11.substring(n2, n3 - 1).trim();
                string3 = string11.substring(n3, n4 - 1).trim();
                string4 = string11.substring(n4, n5 - 1).trim();
                string5 = string11.substring(n5, n6 - 1).trim();
                string7 = string11.substring(n6, n7 - 1).trim();
                string8 = string11.substring(n7, n8 - 1).trim();
                string9 = string11.substring(n8, n9 - 1).trim();
                string10 = string11.substring(n9).trim();
                hashtable2.put("Image", string3);
                hashtable2.put("Command", string4);
                hashtable2.put("Created", string5);
                hashtable2.put("Status", string7);
                hashtable2.put("Port", string8);
                hashtable2.put("Names", string9);
                hashtable2.put("Size", string10);
                if (string7 == null || string7.toLowerCase().indexOf("up") < 0) continue;
                hashtable.put(string2, hashtable2);
            }
            return hashtable;
        }
        catch (Exception exception) {
            System.err.println(" [DockerContainers] Exception occured while getting containerDetails");
            exception.printStackTrace();
            return null;
        }
    }

    public ArrayList executeCommand(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList arrayList = null;
        ArrayList arrayList2 = new ArrayList();
        try {
            EgUtilities egUtilities = EgUtilities.createInstance();
            arrayList2 = egUtilities.getExecOutputLines(string);
            if (arrayList2 != null && arrayList2.size() >= 2) {
                arrayList = (ArrayList)arrayList2.get(0);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception  occured in DockerContainers while calling executeCommand " + string + " \tdata =" + arrayList2);
            exception.printStackTrace();
        }
        return arrayList;
    }

    public String getDockerHostInternalIp() {
        Object object = "127.0.0.1";
        String string = "ip -4 addr show docker0 | grep -Po 'inet \\K[\\d.]+'";
        try {
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList = egUtilities.getCommandOutputLines(string, true, true);
            if (arrayList != null && arrayList.size() > 0) {
                Object object2;
                ArrayList arrayList2 = (ArrayList)arrayList.get(0);
                if (arrayList2 != null && arrayList2.size() > 0 && (object2 = (String)arrayList2.get(0)) != null && ((String)object2).length() > 0 && IPV6Helper.validateIPV4(((String)object2).trim())) {
                    object = object2;
                    System.out.println("Discovered DOCKER Internal IP Address : " + (String)object);
                }
                if (((String)object).equalsIgnoreCase("127.0.0.1")) {
                    object2 = (ArrayList)arrayList.get(1);
                    System.out.println("Unable to get DOCKER Internal IP Address, Std error is : " + object2);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception occured while finding DOCKER Internal IP Address by using the command " + string);
            exception.printStackTrace();
        }
        return object;
    }

    public ArrayList egTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = string2.length();
        int n2 = 0;
        int n3 = string.indexOf(string2);
        while (n3 >= 0) {
            string3 = string.substring(n2, n3);
            arrayList.add(string3);
            n2 = n3 + n;
            n3 = string.indexOf(string2, n2);
        }
        string3 = string.substring(n2);
        arrayList.add(string3);
        return arrayList;
    }

    public Hashtable getContinerPortDetails() {
        return this.ht_containerIdAndPort;
    }

    int getDockerPort(String string) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            StringTokenizer stringTokenizer;
            int n2;
            String string2 = "docker inspect --format=\"{{.NetworkSettings.Ports}}\" " + string;
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList2 = egUtilities.getExecOutputLines(string2);
            ArrayList arrayList3 = null;
            if (arrayList2 != null && arrayList2.size() > 0) {
                arrayList3 = (ArrayList)arrayList2.get(0);
            }
            if (arrayList3 == null || arrayList3.size() == 0) {
                return n;
            }
            String string3 = (String)arrayList3.get(0);
            if (string3 != null && string3.length() > 0) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            if (string3 != null && string3.length() > 0 && string3.trim().startsWith("map[") && string3.length() > 4 && (n2 = (stringTokenizer = new StringTokenizer(string3 = string3.substring(4, string3.length() - 1), ":")).countTokens()) > 1) {
                for (int i = 0; i < n2; ++i) {
                    String string4 = stringTokenizer.nextToken();
                    if (string4 == null || string4.indexOf("/") <= 0) continue;
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string4 = string4.substring(0, string4.indexOf("/")));
                    int n3 = stringTokenizer2.countTokens();
                    if (n3 > 1) {
                        for (int j = 0; j < n3; ++j) {
                            String string5 = stringTokenizer2.nextToken();
                            if (j != n3 - 1) continue;
                            arrayList.add(string5);
                        }
                    } else {
                        arrayList.add(string4);
                    }
                    n = Integer.parseInt(string4);
                    return n;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        if (arrayList.size() > 0) {
            n = Integer.parseInt(this.getHighPriorityPort(arrayList));
        }
        return n;
    }

    int getPodPort(String string) {
        int n = 0;
        try {
            String string2;
            String string3 = "docker inspect --format=\"{{.Config.Labels}}\" " + string;
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList = egUtilities.getExecOutputLines(string3);
            ArrayList arrayList2 = null;
            if (arrayList != null && arrayList.size() > 0) {
                arrayList2 = (ArrayList)arrayList.get(0);
            }
            if ((string2 = (String)arrayList2.get(0)) != null && string2.length() > 0) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (string2 != null && (string2 = string2.trim()).startsWith("map[") && string2.endsWith("]")) {
                string2 = string2.substring(4, string2.length() - 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    int n2;
                    String string4;
                    String string5;
                    String string6 = stringTokenizer.nextToken();
                    if (string6 == null || string6.indexOf(":") <= 0) continue;
                    int n3 = string6.indexOf(":");
                    String string7 = string6.substring(0, n3);
                    String string8 = string6.substring(n3 + 1);
                    if (string7.equalsIgnoreCase("io.kubernetes.pod.name")) {
                        string5 = string8;
                    }
                    if (!string7.equalsIgnoreCase("annotation.io.kubernetes.container.ports") || (string5 = string8) == null || string5.indexOf("\"containerPort\":") < 0 || (string4 = string5.substring((n2 = string5.indexOf("\"containerPort\":")) + 16)) == null || string4.indexOf(",") <= 0) continue;
                    String string9 = string4.substring(0, string4.indexOf(","));
                    n = Integer.parseInt(string9);
                    return n;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return n;
    }

    private String getHighPriorityPort(ArrayList arrayList) {
        if (arrayList != null && arrayList.size() > 0) {
            if (arrayList.contains("443")) {
                return "443";
            }
            if (arrayList.contains("8080")) {
                return "8080";
            }
            return (String)arrayList.get(0);
        }
        return "0000";
    }

    public static void main(String[] stringArray) {
    }
}

