/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class EcpAppServerTest
extends EgSnmpGenericTest {
    private static String cacheNameOid = ".1.3.6.1.4.1.16563.1.1.1.1.2";
    private static String cachePerfRowOid = ".1.3.6.1.4.1.16563.1.1.4.1";
    private static int numMeasures = 3;
    private String instance = "none";
    private Hashtable prevRefs = new Hashtable();
    private Hashtable prevBSent = new Hashtable();
    private Hashtable prevBRec = new Hashtable();

    public EcpAppServerTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
        this.instance = this.getValueForParam("instanceName");
        if (this.instance == null || this.instance.equals("")) {
            this.instance = "all";
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        Hashtable hashtable4 = new Hashtable();
        Hashtable hashtable5 = new Hashtable();
        String string = null;
        if (!this.runSnmpCmdForOid(cacheNameOid)) {
            this.prevRefs = new Hashtable();
            this.prevBSent = new Hashtable();
            this.prevBRec = new Hashtable();
            return;
        }
        Hashtable<String, String> hashtable6 = new Hashtable<String, String>();
        for (int i = 0; i < this.lhs.length; ++i) {
            hashtable6.put(this.lhs[i], this.rhs[i]);
        }
        hashtable2 = this.getFromSnmp(cachePerfRowOid);
        if (hashtable2 == null || hashtable2.size() == 0) {
            this.prevRefs = new Hashtable();
            this.prevBSent = new Hashtable();
            this.prevBRec = new Hashtable();
            return;
        }
        hashtable3 = this.getFromRows("1.", hashtable2);
        hashtable4 = this.getFromRows("2.", hashtable2);
        hashtable5 = this.getFromRows("3.", hashtable2);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        Enumeration enumeration = hashtable3.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = this.instance.equalsIgnoreCase("all") || this.instance.equalsIgnoreCase("none") ? (String)hashtable6.get(string2) : this.instance;
            arrayList = new ArrayList();
            if (string == null) continue;
            Double[] doubleArray = new Double[numMeasures];
            doubleArray[0] = (Double)hashtable3.get(string2);
            doubleArray[1] = (Double)hashtable4.get(string2);
            doubleArray[2] = (Double)hashtable5.get(string2);
            if (this.timeSinceLastTest <= 0.0) {
                this.prevRefs.put(string, doubleArray[0]);
                this.prevBSent.put(string, doubleArray[1]);
                this.prevBRec.put(string, doubleArray[2]);
                for (int i = 0; i < numMeasures; ++i) {
                    arrayList.add(new Double(-5.0));
                }
                this.addNewMeasure(string, arrayList);
                continue;
            }
            arrayList.add(new Double(this.getDiff(string, this.prevRefs, doubleArray[0])));
            double d = this.getDiff(string, this.prevBSent, doubleArray[1]);
            if (d > 0.0) {
                d /= 1024.0;
            }
            arrayList.add(new Double(d));
            d = this.getDiff(string, this.prevBRec, doubleArray[2]);
            if (d > 0.0) {
                d /= 1024.0;
            }
            arrayList.add(new Double(d));
            this.addNewMeasure(string, arrayList);
        }
    }

    private double getDiff(String string, Hashtable hashtable, Double d) {
        Double d2 = (Double)hashtable.get(string);
        if (d2 != null) {
            double d3 = d - d2;
            if (d3 < 0.0) {
                d3 = -5.0;
            }
            return d3;
        }
        hashtable.put(string, d);
        return -5.0;
    }

    private double getDouble(Hashtable hashtable, String string) {
        if (hashtable == null || hashtable.size() == 0) {
            return -5.0;
        }
        try {
            Double d = (Double)hashtable.get(string);
            if (d == null) {
                return -5.0;
            }
            return d;
        }
        catch (Exception exception) {
            return -5.0;
        }
    }

    private Hashtable getFromRows(String string, Hashtable hashtable) {
        if (hashtable == null) {
            return null;
        }
        Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            Double d = (Double)hashtable.get(string2);
            string2 = string2.substring(string.length());
            hashtable2.put(string2, d);
        }
        return hashtable2;
    }

    private Hashtable getFromSnmp(String string) {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        boolean bl = this.runSnmpCmdForOid(string);
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            return hashtable;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            try {
                double d = Double.parseDouble(this.rhs[i]);
                hashtable.put(this.lhs[i], new Double(d));
                continue;
            }
            catch (Exception exception) {
                hashtable.put(this.lhs[i], new Double(-5.0));
            }
        }
        return hashtable;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.10.53", "-port", "161", "-snmpPort", "161", "-snmpversion", "v1", "-snmpCommunity", "public"};
        EcpAppServerTest ecpAppServerTest = new EcpAppServerTest(stringArray2);
        ecpAppServerTest.computeMeasures(new Hashtable());
    }
}

