/*
 * Decompiled with CFR 0.152.
 */
import com.eg.snmpgetsubtree;
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public abstract class EgSmartSnmpTest
extends EgSmartTest {
    protected ArrayList al_measureNames;
    protected ArrayList al_oids;
    public String community = "public";
    public String username = "none";
    public String authPass = "none";
    public String authType = "none";
    public String snmpVersion = "v1";
    public String encryptType = "none";
    public String encryptPass = "none";
    public boolean isEncryptionEnabled = false;
    public String str_Context = "";
    public String engineIDVal = "";
    public String snmpWalkCmd = "snmpgetsubtree";
    public String[] lhs;
    public String[] rhs;
    public String snmpPortNo = "161";
    public String transportLayer = "udp";
    public String mibName;
    private boolean isWindowsOS = false;
    private EgUtilities egutil = EgUtilities.createInstance();
    int timeOut = 10;

    public EgSmartSnmpTest(String[] stringArray) {
        super(stringArray);
        String string;
        String string2;
        String string3;
        String string4;
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.community = this.getValueForParam("snmpCommunity");
        this.snmpVersion = this.getValueForParam("snmpversion");
        if (this.snmpVersion == null) {
            this.snmpVersion = "v1";
        }
        if (this.snmpVersion.equalsIgnoreCase("v1") || this.snmpVersion.equalsIgnoreCase("v2")) {
            this.community = this.getValueForParam("snmpCommunity");
            if (this.community == null) {
                this.community = "none";
            }
        } else {
            this.username = this.getValueForParam("username");
            string4 = this.getValueForParam("authpass");
            if (string4 != null) {
                this.authPass = EgCrypt.decrypt(string4);
            }
            this.authType = this.getValueForParam("authtype");
            string3 = this.getValueForParam("encryptflag");
            if (string3 != null) {
                this.isEncryptionEnabled = new Boolean(string3);
            }
            if (this.isEncryptionEnabled) {
                this.encryptType = this.getValueForParam("encrypttype");
                String string5 = this.getValueForParam("encryptpassword");
                if (string5 != null) {
                    this.encryptPass = EgCrypt.decrypt(string5);
                }
                if (this.encryptType == null) {
                    this.encryptType = "des";
                } else if (this.encryptPass == null) {
                    this.encryptPass = "none";
                }
            }
            if (this.username == null) {
                this.username = "none";
            } else if (this.authPass == null) {
                this.authPass = "none";
            } else if (this.authType == null) {
                this.authType = "md5";
            }
        }
        if (this.snmpPortNo == null || this.snmpPortNo.equals("")) {
            this.logToErrorFile("ERROR", this.entity, "snmpPort not defined");
        }
        if (this.community == null || this.community.equals("")) {
            this.logToErrorFile("ERROR", this.entity, "snmpCommunity not defined");
        }
        try {
            Integer.parseInt(this.snmpPortNo);
        }
        catch (NumberFormatException numberFormatException) {
            this.snmpPortNo = "161";
            numberFormatException.printStackTrace();
        }
        string4 = this.getValueForParam("timeout");
        this.timeOut = 10;
        if (string4 != null) {
            try {
                int n;
                this.timeOut = n = Integer.parseInt(string4);
            }
            catch (Exception exception) {}
        } else {
            string3 = System.getProperty("SNMPTIMEOUT");
            if (string3 != null) {
                int n = 10;
                try {
                    n = Integer.parseInt(string3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.timeOut = n;
            }
        }
        this.transportLayer = (string2 = this.getValueForParam("data_over_tcp")) != null && (string2.trim().equalsIgnoreCase("true") || string2.trim().equalsIgnoreCase("yes")) ? "tcp" : "udp";
        String string6 = this.getValueForParam("engineid");
        this.engineIDVal = string6 != null && (string6.trim().equalsIgnoreCase("true") || string6.trim().equalsIgnoreCase("yes")) ? "yes" : "no";
        this.str_Context = this.getValueForParam("context");
        if (this.str_Context == null || this.str_Context.length() == 0 || this.str_Context.equalsIgnoreCase("none")) {
            this.str_Context = "";
        }
        if ((string = System.getProperty("os.name").toLowerCase()).indexOf("win") >= 0) {
            this.isWindowsOS = true;
        }
        this.egutil.setTimeout((long)this.timeOut);
    }

    public boolean runSnmpCmdForOid(String string) {
        String string2;
        int n;
        CharSequence charSequence;
        Object[] objectArray;
        Object object;
        if (string == null) {
            return false;
        }
        if (string.endsWith(".0")) {
            string = string.substring(0, string.lastIndexOf(".0"));
        }
        String[] stringArray = null;
        stringArray = this.snmpVersion.equalsIgnoreCase("v1") || this.snmpVersion.equalsIgnoreCase("v2") ? new String[]{"-p", "" + this.snmpPortNo, "-c", this.community, "-o", "-v", this.snmpVersion.equalsIgnoreCase("v1") ? "1" : "2", this.targetHost, string, this.transportLayer} : (!this.isEncryptionEnabled ? new String[]{"-o", "-w", "2", "-v", "3", "-p", "" + this.snmpPortNo, "-u", this.username, "-a", this.authType, "-A", this.authPass, this.targetHost, string, "-n", this.str_Context, this.engineIDVal, this.transportLayer} : new String[]{"-o", "-w", "2", "-v", "3", "-p", "" + this.snmpPortNo, "-u", this.username, "-a", this.authType, "-A", this.authPass, "-x", this.encryptType, "-X", this.encryptPass, this.targetHost, string, "-n", this.str_Context, this.engineIDVal, this.transportLayer});
        snmpgetsubtree snmpgetsubtree2 = new snmpgetsubtree(stringArray, this.timeOut);
        ArrayList arrayList = snmpgetsubtree2.getSubTree();
        String string3 = "";
        String string4 = "";
        if (arrayList.size() == 0) {
            string3 = string;
            int n2 = string3.lastIndexOf(".");
            string4 = string3.substring(0, n2);
            if (this.snmpVersion.equalsIgnoreCase("v1") || this.snmpVersion.equalsIgnoreCase("v2")) {
                stringArray[8] = string4;
            } else if (!this.isEncryptionEnabled) {
                stringArray[14] = string4;
            } else {
                stringArray[18] = string4;
            }
            object = new snmpgetsubtree(stringArray, this.timeOut);
            objectArray = ((snmpgetsubtree)object).getSubTree();
            charSequence = "";
            if (objectArray != null && objectArray.size() > 0) {
                n = objectArray.size();
                for (int i = 0; i < n; ++i) {
                    charSequence = (String)objectArray.get(i);
                    StringTokenizer stringTokenizer = new StringTokenizer((String)charSequence, "=");
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (!string2.equalsIgnoreCase(string)) continue;
                        arrayList.add(charSequence);
                    }
                }
            }
        }
        this.lhs = null;
        this.rhs = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        object = new ArrayList();
        this.mibName = string;
        if (arrayList != null && arrayList.size() > 0) {
            int n3 = arrayList.size();
            for (n = 0; n < n3; ++n) {
                int n4;
                String string5 = ((String)arrayList.get(n)).trim();
                if (!string5.startsWith(string) || (n4 = string5.indexOf(61)) < 0) continue;
                string2 = string5.substring(0, n4);
                String string6 = string5.substring(n4 + 1);
                String string7 = this.replace(string2, string, "");
                if (string7.length() > 0) {
                    string7 = new String(string7.substring(1));
                }
                if (string6.startsWith("\"")) {
                    String string8;
                    int n5 = string6.lastIndexOf("\"");
                    while (n5 <= 0 && ++n < n3 && (string8 = (String)arrayList.get(n)) != null) {
                        string6 = string6 + " " + string8;
                        n5 = string6.lastIndexOf("\"");
                    }
                    string6 = new String(string6.substring(1, n5));
                }
                arrayList2.add(string6);
                ((ArrayList)object).add(string7);
            }
            objectArray = arrayList2.toArray();
            this.rhs = new String[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                this.rhs[n] = objectArray[n].toString();
            }
            objectArray = ((ArrayList)object).toArray();
            this.lhs = new String[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                this.lhs[n] = objectArray[n].toString();
            }
            return this.lhs.length > 0;
        }
        charSequence = new StringBuffer("java com/eg/snmpgetsubtree");
        for (n = 0; n < stringArray.length; ++n) {
            ((StringBuffer)charSequence).append(" ");
            if (this.snmpVersion.equalsIgnoreCase("v3")) {
                if (this.str_Context != null && this.str_Context.trim().length() == 0) {
                    if (!this.isEncryptionEnabled && n == 16) {
                        stringArray[n] = "\"\"";
                    } else if (this.isEncryptionEnabled && n == 20) {
                        stringArray[n] = "\"\"";
                    }
                }
                if (this.engineIDVal == null && this.engineIDVal.trim().length() == 0) {
                    if (!this.isEncryptionEnabled && n == 17) {
                        stringArray[n] = "no";
                    } else if (this.isEncryptionEnabled && n == 21) {
                        stringArray[n] = "no";
                    }
                }
                if (this.authPass != null && this.authPass.trim().length() == 0 && n == 12) {
                    stringArray[n] = "\" \"";
                }
                if (this.authPass != null && this.authPass.trim().length() > 0 && n == 12) {
                    stringArray[n] = EgCrypt.encrypt(stringArray[n]);
                }
                if (this.isEncryptionEnabled) {
                    if (this.encryptPass != null && this.encryptPass.trim().length() == 0 && n == 16) {
                        stringArray[n] = "\" \"";
                    }
                    if (this.encryptPass != null && this.encryptPass.trim().length() > 0 && n == 16) {
                        stringArray[n] = EgCrypt.encrypt(stringArray[n]);
                    }
                }
            }
            ((StringBuffer)charSequence).append(stringArray[n]);
        }
        this.errorMsg = new String("Failed to run " + charSequence + " for " + this.reportingName + " with community " + this.community + " and MIB=" + this.mibName);
        System.out.println("From EgSmartSnmpTest :" + this.errorMsg);
        return false;
    }

    public String replace(String string, String string2, String string3) {
        int n;
        do {
            if ((n = string.indexOf(string2)) == -1) continue;
            String string4 = string.substring(0, n);
            string4 = string4 + string3;
            string = string4 = string4 + string.substring(n + string2.length());
        } while (n != -1);
        return string;
    }

    protected void sop(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public void freeTest() {
        this.lhs = null;
        this.rhs = null;
    }

    public abstract void computeMeasures(Hashtable var1);
}

