/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class EndecaStatsParser
extends DefaultHandler {
    private static String perfSummaryNodeName = "performance_summary";
    private static String transactionStatsNodeName = "transaction_stats";
    private static String statNodeName = "stat";
    private static String throughputNodeName = "throughput";
    private static String attrTotalName = "total";
    private static String attrCountName = "n";
    private boolean isPerfSummaryNode = false;
    private boolean isTransactionStatsNode = false;
    private double throughput_5mins = -5.0;
    private double qlength = -5.0;
    private double threadsBusy = -5.0;
    private double totalProcessingTime = -5.0;
    private double timeInQueue = -5.0;
    private double timeInDGraph = -5.0;
    private double timeSendingData = -5.0;
    private double recordsInRS = -5.0;
    private double responseSize = -5.0;
    private double qlength_n = -5.0;
    private double threadsBusy_n = -5.0;
    private double totalProcessingTime_n = -5.0;
    private double timeInQueue_n = -5.0;
    private double timeInDGraph_n = -5.0;
    private double timeSendingData_n = -5.0;
    private double recordsInRS_n = -5.0;
    private double responseSize_n = -5.0;

    public static void main(String[] stringArray) {
        new EndecaStatsParser().parse("admin.xml");
    }

    public void parse(String string) {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(this);
            InputSource inputSource = this.getXMLInputSource(string);
            if (inputSource != null) {
                xMLReader.parse(inputSource);
            } else {
                System.out.println("Input Source is null");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public double getThroughputValue() {
        return this.throughput_5mins;
    }

    public double[] getPerfSummaryStatsTotal() {
        double[] dArray = new double[]{this.qlength, this.threadsBusy, this.totalProcessingTime, this.timeInQueue, this.timeInDGraph, this.timeSendingData, this.recordsInRS, this.responseSize};
        return dArray;
    }

    public double[] getPerfSummarySamplesCount() {
        double[] dArray = new double[]{this.qlength_n, this.threadsBusy_n, this.totalProcessingTime_n, this.timeInQueue_n, this.timeInDGraph_n, this.timeSendingData_n, this.recordsInRS_n, this.responseSize_n};
        return dArray;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equalsIgnoreCase(perfSummaryNodeName)) {
            this.isPerfSummaryNode = true;
        } else if (string2.equalsIgnoreCase(transactionStatsNodeName)) {
            this.isTransactionStatsNode = true;
        } else if (string2.equalsIgnoreCase(statNodeName)) {
            String string4;
            if (this.isPerfSummaryNode && this.isTransactionStatsNode && (string4 = attributes.getValue("name")) != null) {
                if (string4.equalsIgnoreCase("Queue length")) {
                    this.qlength_n = this.parseValue(attributes.getValue(attrCountName));
                    this.qlength = this.parseValue(attributes.getValue(attrTotalName));
                } else if (string4.equalsIgnoreCase("Number of threads busy")) {
                    this.threadsBusy_n = this.parseValue(attributes.getValue(attrCountName));
                    this.threadsBusy = this.parseValue(attributes.getValue(attrTotalName));
                } else if (string4.equalsIgnoreCase("Total processing time")) {
                    this.totalProcessingTime_n = this.parseValue(attributes.getValue(attrCountName));
                    this.totalProcessingTime = this.parseValue(attributes.getValue(attrTotalName));
                } else if (string4.equalsIgnoreCase("Time in queue")) {
                    this.timeInQueue_n = this.parseValue(attributes.getValue(attrCountName));
                    this.timeInQueue = this.parseValue(attributes.getValue(attrTotalName));
                } else if (string4.equalsIgnoreCase("Time in dgraph")) {
                    this.timeInDGraph_n = this.parseValue(attributes.getValue(attrCountName));
                    this.timeInDGraph = this.parseValue(attributes.getValue(attrTotalName));
                } else if (string4.equalsIgnoreCase("Time sending data")) {
                    this.timeSendingData_n = this.parseValue(attributes.getValue(attrCountName));
                    this.timeSendingData = this.parseValue(attributes.getValue(attrTotalName));
                } else if (string4.equalsIgnoreCase("Number of records in result set")) {
                    this.recordsInRS_n = this.parseValue(attributes.getValue(attrCountName));
                    this.recordsInRS = this.parseValue(attributes.getValue(attrTotalName));
                } else if (string4.equalsIgnoreCase("Response size")) {
                    this.responseSize_n = this.parseValue(attributes.getValue(attrCountName));
                    this.responseSize = this.parseValue(attributes.getValue(attrTotalName));
                    this.responseSize /= 1024.0;
                }
            }
        } else if (string2.equalsIgnoreCase(throughputNodeName) && this.isPerfSummaryNode) {
            this.throughput_5mins = this.parseValue(attributes.getValue("five_minute_avg"));
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    private double parseValue(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private InputSource getXMLInputSource(String string) {
        InputSource inputSource;
        block13: {
            String string2;
            URL uRL = null;
            HttpURLConnection httpURLConnection = null;
            inputSource = null;
            BufferedReader bufferedReader = null;
            uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.connect();
            bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
            }
            String string3 = stringBuffer.toString();
            inputSource = new InputSource(new StringReader(string3));
            Object var10_10 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            httpURLConnection.disconnect();
            {
                break block13;
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var10_11 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                    httpURLConnection.disconnect();
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                httpURLConnection.disconnect();
                throw throwable;
            }
        }
        return inputSource;
    }
}

