/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class FcSwConnUnitTest
extends EgSnmpGenericTest {
    private static String connUnitStateOid = ".1.3.6.1.3.94.1.6.1.5";
    private static String connUnitStatusOid = ".1.3.6.1.3.94.1.6.1.6";
    private static String connUnitNameoid = ".1.3.6.1.3.94.1.6.1.20";
    private static String connUnitTypeOid = ".1.3.6.1.3.94.1.6.1.3";
    private static String connUnitNumSensorsOid = ".1.3.6.1.3.94.1.6.1.14";
    private static String connUnitNumPortsOid = ".1.3.6.1.3.94.1.6.1.4";
    public Hashtable ddUnitType = null;
    public Hashtable ddSensors = null;
    public Hashtable ddPorts = null;
    public Hashtable ddStatus = null;
    public Hashtable ddState = null;
    public Hashtable ddStateId = null;
    public Hashtable ddStatusId = null;
    private double version_d = 5.6;
    boolean debug = false;

    public FcSwConnUnitTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.isDynamicInfoTest = true;
        String string = this.getValueForParam("debug");
        if (string == null) {
            this.debug = false;
        }
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
            this.debug = true;
        }
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini");
        String string2 = iniFile.getValue("MANAGER_SETTINGS", "ManagerVersion");
        if (this.debug) {
            System.out.println("[FcSwConnUnitTest] version :" + string2);
        }
        if (string2 != null && !string2.equals("")) {
            string2 = string2.substring(0, string2.lastIndexOf("."));
            if (this.debug) {
                System.out.println("[FcSwConnUnitTest] Manager Version After substring :" + string2);
            }
            try {
                this.version_d = Double.parseDouble(string2);
            }
            catch (Exception exception) {
                this.version_d = 5.6;
                System.out.println("[FcSwConnUnitTest] Exception e:" + exception);
            }
        }
    }

    private int getInteger(String string) {
        if (string == null || string.length() == 0) {
            return -5;
        }
        int n = -5;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -5;
        }
        return n;
    }

    private String getUnitType(int n) {
        switch (n) {
            case 1: {
                return "Unknown";
            }
            case 2: {
                return "unused";
            }
            case 3: {
                return "Hub";
            }
            case 4: {
                return "Switch";
            }
            case 5: {
                return "Gateway";
            }
            case 6: {
                return "Converter";
            }
            case 7: {
                return "HBA";
            }
            case 8: {
                return "Proxy Agent";
            }
            case 9: {
                return "Storage Device";
            }
            case 10: {
                return "Host";
            }
            case 11: {
                return "Storage subsystem";
            }
            case 12: {
                return "module";
            }
            case 13: {
                return "swdriver";
            }
            case 14: {
                return "Storage-access-device";
            }
            case 15: {
                return "wdm";
            }
            case 16: {
                return "UPS";
            }
        }
        return "-";
    }

    private String getStatus(int n) {
        switch (n) {
            case 1: {
                return "Unknown";
            }
            case 2: {
                return "unused";
            }
            case 3: {
                return "ok";
            }
            case 4: {
                return "warning";
            }
            case 5: {
                return "failed";
            }
        }
        return "-";
    }

    public void freeTest() {
        this.ddUnitType = new Hashtable();
        this.ddSensors = new Hashtable();
        this.ddPorts = new Hashtable();
        this.ddStatus = new Hashtable();
        this.ddState = new Hashtable();
        this.ddStateId = new Hashtable();
        this.ddStatusId = new Hashtable();
    }

    public void computeMeasures(Hashtable hashtable) {
        if (this.version_d > 5.2) {
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable5 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable6 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable7 = new Hashtable<String, String>();
            this.freeTest();
            if (this.debug) {
                System.out.println("[FcSwConnUnitTest ] in 5.3 agent code segment" + this.version_d);
            }
            try {
                String string;
                int n;
                if (!this.runSnmpCmdForOid(connUnitStateOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n = 0; n < this.lhs.length; ++n) {
                    hashtable2.put(this.lhs[n], this.rhs[n]);
                }
                if (this.debug) {
                    System.out.println("[FcSwConnUnitTest] Snmpwalk State Values ===> " + hashtable2.size());
                }
                if (!this.runSnmpCmdForOid(connUnitStatusOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n = 0; n < this.lhs.length; ++n) {
                    hashtable3.put(this.lhs[n], this.rhs[n]);
                }
                if (this.debug) {
                    System.out.println("[FcSwConnUnitTest] Snmpwalk Status Values ===> " + hashtable3.size());
                }
                if (!this.runSnmpCmdForOid(connUnitNameoid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n = 0; n < this.lhs.length; ++n) {
                    hashtable4.put(this.lhs[n], this.rhs[n]);
                }
                if (this.debug) {
                    System.out.println("[FcSwConnUnitTest] Snmpwalk Name values ===> " + hashtable4.size());
                }
                if (!this.runSnmpCmdForOid(connUnitTypeOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n = 0; n < this.lhs.length; ++n) {
                    int n2 = this.getInteger(this.rhs[n].trim());
                    string = this.getUnitType(n2);
                    hashtable5.put(this.lhs[n], string);
                }
                if (this.debug) {
                    System.out.println("[FcSwConnUnitTest] Snmpwalk UnitType values for DD ===> " + hashtable5.size());
                }
                if (!this.runSnmpCmdForOid(connUnitNumSensorsOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n = 0; n < this.lhs.length; ++n) {
                    hashtable6.put(this.lhs[n], this.rhs[n]);
                }
                if (this.debug) {
                    System.out.println("[FcSwConnUnitTest] Snmpwalk No Of Sensors for DD ===> " + hashtable6.size());
                }
                if (!this.runSnmpCmdForOid(connUnitNumPortsOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n = 0; n < this.lhs.length; ++n) {
                    hashtable7.put(this.lhs[n], this.rhs[n]);
                }
                if (this.debug) {
                    System.out.println("[FcSwConnUnitTest] Snmpwalk No Of Ports for DD ===> " + hashtable7.size());
                }
                Enumeration enumeration = hashtable4.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    string = (String)hashtable4.get(string2);
                    String string3 = (String)hashtable3.get(string2);
                    String string4 = (String)hashtable2.get(string2);
                    String string5 = (String)hashtable5.get(string2);
                    String string6 = (String)hashtable6.get(string2);
                    String string7 = (String)hashtable7.get(string2);
                    if (string == null || string.trim().length() == 0 || string3 == null || string4 == null || string5 == null || string6 == null || string7 == null) continue;
                    int n3 = this.getInteger(string4);
                    int n4 = this.getInteger(string3);
                    String string8 = "-";
                    if (n3 == 2) {
                        n3 = 100;
                        string8 = "online";
                    } else if (n3 == 3) {
                        n3 = 0;
                        string8 = "offline";
                    } else if (n3 == 1) {
                        n3 = 1;
                        string8 = "unknown";
                    }
                    String string9 = this.getStatus(n4);
                    if (n4 == 1) {
                        n4 = 2;
                    } else if (n4 == 2) {
                        n4 = 3;
                    } else if (n4 == 3) {
                        n4 = 100;
                    } else if (n4 == 4) {
                        n4 = 1;
                    } else if (n4 == 5) {
                        n4 = 0;
                    }
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    arrayList.add(new Double(n3));
                    arrayList.add(new Double(n4));
                    this.addNewMeasure(string, arrayList);
                    this.ddUnitType.put(string, string5);
                    this.ddSensors.put(string, string6);
                    this.ddPorts.put(string, string7);
                    this.ddStatus.put(string, string9);
                    this.ddState.put(string, string8);
                    this.ddStateId.put(string, string4);
                    this.ddStatusId.put(string, string3);
                    if (!this.debug) continue;
                    System.out.println("[FcSwConnUnitTest] Measures ===> " + string + " ===> " + arrayList);
                    System.out.println("[FcSwConnUnitTest] DD Unit Type ===> " + string + " ===> " + string5);
                    System.out.println("[FcSwConnUnitTest] DD No Of Sensors ===> " + string + " ===> " + string6);
                    System.out.println("[FcSwConnUnitTest] DD No Of Ports ===> " + string + " ===> " + string7);
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("[FcSwConnUnitTest].computeMeasures()", "Exception ", exception.toString());
            }
        } else {
            Hashtable<String, String> hashtable8 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable9 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable10 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable11 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable12 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable13 = new Hashtable<String, String>();
            this.freeTest();
            if (this.debug) {
                System.out.println("[FcSwConnUnitTest ] Else block in 5.2 agent code segment" + this.version_d);
            }
            try {
                String string;
                int n;
                if (!this.runSnmpCmdForOid(connUnitStateOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n = 0; n < this.lhs.length; ++n) {
                    hashtable8.put(this.lhs[n], this.rhs[n]);
                }
                if (this.debug) {
                    System.out.println("[FcSwConnUnitTest] Snmpwalk State Values ===> " + hashtable8.size());
                }
                if (!this.runSnmpCmdForOid(connUnitStatusOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n = 0; n < this.lhs.length; ++n) {
                    hashtable9.put(this.lhs[n], this.rhs[n]);
                }
                if (this.debug) {
                    System.out.println("[FcSwConnUnitTest] Snmpwalk Status Values ===> " + hashtable9.size());
                }
                if (!this.runSnmpCmdForOid(connUnitNameoid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n = 0; n < this.lhs.length; ++n) {
                    hashtable10.put(this.lhs[n], this.rhs[n]);
                }
                if (this.debug) {
                    System.out.println("[FcSwConnUnitTest] Snmpwalk Name values ===> " + hashtable10.size());
                }
                if (!this.runSnmpCmdForOid(connUnitTypeOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n = 0; n < this.lhs.length; ++n) {
                    int n5 = this.getInteger(this.rhs[n].trim());
                    string = this.getUnitType(n5);
                    hashtable11.put(this.lhs[n], string);
                }
                if (this.debug) {
                    System.out.println("[FcSwConnUnitTest] Snmpwalk UnitType values for DD ===> " + hashtable11.size());
                }
                if (!this.runSnmpCmdForOid(connUnitNumSensorsOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n = 0; n < this.lhs.length; ++n) {
                    hashtable12.put(this.lhs[n], this.rhs[n]);
                }
                if (this.debug) {
                    System.out.println("[FcSwConnUnitTest] Snmpwalk No Of Sensors for DD ===> " + hashtable12.size());
                }
                if (!this.runSnmpCmdForOid(connUnitNumPortsOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n = 0; n < this.lhs.length; ++n) {
                    hashtable13.put(this.lhs[n], this.rhs[n]);
                }
                if (this.debug) {
                    System.out.println("[FcSwConnUnitTest] Snmpwalk No Of Ports for DD ===> " + hashtable13.size());
                }
                Enumeration enumeration = hashtable10.keys();
                while (enumeration.hasMoreElements()) {
                    String string10 = (String)enumeration.nextElement();
                    string = (String)hashtable10.get(string10);
                    String string11 = (String)hashtable9.get(string10);
                    String string12 = (String)hashtable8.get(string10);
                    String string13 = (String)hashtable11.get(string10);
                    String string14 = (String)hashtable12.get(string10);
                    String string15 = (String)hashtable13.get(string10);
                    if (string == null || string.trim().length() == 0 || string11 == null || string12 == null || string13 == null || string14 == null || string15 == null) continue;
                    int n6 = this.getInteger(string12);
                    int n7 = this.getInteger(string11);
                    String string16 = "-";
                    if (n6 == 2) {
                        n6 = 1;
                        string16 = "online";
                    } else if (n6 == 3) {
                        n6 = 0;
                        string16 = "offline";
                    } else {
                        n6 = 2;
                        string16 = "unknown";
                    }
                    String string17 = this.getStatus(n7);
                    n7 = n7 == 3 ? 1 : (n7 == 5 || n7 == 4 ? 0 : 2);
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    arrayList.add(new Double(n6));
                    arrayList.add(new Double(n7));
                    this.addNewMeasure(string, arrayList);
                    this.ddUnitType.put(string, string13);
                    this.ddSensors.put(string, string14);
                    this.ddPorts.put(string, string15);
                    this.ddStatus.put(string, string17);
                    this.ddState.put(string, string16);
                    this.ddStateId.put(string, string12);
                    this.ddStatusId.put(string, string11);
                    if (!this.debug) continue;
                    System.out.println("[FcSwConnUnitTest] Measures ===> " + string + " ===> " + arrayList);
                    System.out.println("[FcSwConnUnitTest] DD Unit Type ===> " + string + " ===> " + string13);
                    System.out.println("[FcSwConnUnitTest] DD No Of Sensors ===> " + string + " ===> " + string14);
                    System.out.println("[FcSwConnUnitTest] DD No Of Ports ===> " + string + " ===> " + string15);
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("[FcSwConnUnitTest].computeMeasures()", "Exception ", exception.toString());
            }
        }
    }

    public static void main(String[] stringArray) {
        FcSwConnUnitTest fcSwConnUnitTest = new FcSwConnUnitTest(stringArray);
        fcSwConnUnitTest.computeMeasures(new Hashtable());
    }
}

