/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;

public class HanaCacheTest
extends GenericTest {
    private static final int CACHE_MEASURE_COUNT = 7;
    private String userName = "";
    private String password = "";
    private String hostNameToFilter = "";
    private boolean checkHostName = true;
    private DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
    private DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);

    public HanaCacheTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.needAgentlessDD = true;
        this.userName = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        this.dfs.setDecimalSeparator('.');
        this.df.applyPattern("#.##");
        this.df.setDecimalFormatSymbols(this.dfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void computeMeasures(Hashtable hashtable) {
        block27: {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            String string10;
            String string11;
            String string12;
            String string13;
            Statement statement;
            ResultSet resultSet;
            Object object;
            block26: {
                if (this.checkHostName) {
                    ConnectionManager.collectHanaHostDetails(this.reportingName, this.entity, this.targetHost, this.portNo, this.userName, this.password, debug);
                    object = ConnectionManager.getHanaDbDetails(this.reportingName + ":" + this.targetHost + ":" + this.portNo);
                    if (object != null && ((ArrayList)object).size() > 0) {
                        this.hostNameToFilter = (String)((ArrayList)object).get(0);
                        this.hostNameToFilter = this.hostNameToFilter.toLowerCase().trim();
                        this.checkHostName = false;
                    } else {
                        this.logToErrorFile("INFO :", this.entity, "Failed to find the Hana Host details for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                        return;
                    }
                }
                System.out.println(this.entity + " ::hostNameToFilter==>" + this.hostNameToFilter + ":targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                object = null;
                resultSet = null;
                statement = null;
                string13 = "";
                string12 = "";
                string11 = "";
                string10 = "";
                d7 = 0.0;
                d6 = 0.0;
                d5 = 0.0;
                d4 = 0.0;
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
                string9 = "";
                string8 = "";
                string7 = "";
                string6 = "";
                string5 = "";
                string4 = "";
                string3 = "";
                string2 = "";
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("select   host, port, volume_id, cache_id, total_size total_size_bytes,");
                stringBuffer.append(" used_size used_size_bytes, entry_count, insert_count, invalidate_count, ");
                stringBuffer.append("hit_count, miss_count from  m_caches where lower(host)='" + this.hostNameToFilter + "'");
                string = stringBuffer.toString();
                System.out.println(this.entity + "==>Query:" + string + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                object = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.userName, this.password, debug);
                if (object != null) break block26;
                this.logToErrorFile("ERROR :", this.entity, "Connection is null for targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                try {
                    this.closeRs(resultSet);
                    this.closeSt(statement);
                    this.closeConn((Connection)object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return;
            }
            try {
                statement = object.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR:", this.entity + " Failed to Create Statement targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                this.closeSt(statement);
                this.closeConn((Connection)object);
                exception.printStackTrace();
                try {
                    this.closeRs(resultSet);
                    this.closeSt(statement);
                    this.closeConn((Connection)object);
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                return;
            }
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                string13 = resultSet.getString(1);
                string12 = resultSet.getString(2);
                string11 = resultSet.getString(3);
                string10 = resultSet.getString(4);
                string9 = resultSet.getString(5);
                double d8 = this.getDoubleValue(string9);
                d7 = d8 / 1048576.0;
                d7 = this.roundDouble(d7);
                string8 = resultSet.getString(6);
                d6 = this.getDoubleValue(string8);
                d6 /= 1048576.0;
                d6 = this.roundDouble(d6);
                string7 = resultSet.getString(7);
                d5 = this.getDoubleValue(string7);
                string6 = resultSet.getString(8);
                d4 = this.getDoubleValue(string6);
                string5 = resultSet.getString(9);
                d3 = this.getDoubleValue(string5);
                string4 = resultSet.getString(10);
                d2 = this.getDoubleValue(string4);
                string3 = resultSet.getString(11);
                d = this.getDoubleValue(string3);
                string2 = string13 + ":" + string12 + ":" + string10;
                System.out.println("host " + string13);
                System.out.println("port   " + string12);
                System.out.println("cacheID  " + string10);
                System.out.println("totalSizeMB  " + d7);
                System.out.println("usedSizeBytes  " + d6);
                System.out.println("entryCount  " + d5);
                System.out.println("insertCount  " + d4);
                System.out.println("invalidateCount  " + d3);
                System.out.println("hitCount  " + d2);
                System.out.println("missCount  " + d);
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d7));
                arrayList.add(new Double(d6));
                arrayList.add(new Double(d5));
                arrayList.add(new Double(d4));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d));
                System.out.println("[" + this.entity + "]info===>" + string2 + " measure===>" + arrayList);
                this.addNewMeasure(string2, arrayList);
            }
            try {
                this.closeRs(resultSet);
                this.closeSt(statement);
                this.closeConn((Connection)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block27;
            catch (SQLException sQLException) {
                this.logToErrorFile("ERROR :", this.entity + " SQL Error in computeMeasures targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, sQLException.toString());
                System.out.println("ERROR : Exception occured in " + this.entity + "targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " Exception:" + sQLException.toString());
                sQLException.printStackTrace();
                try {
                    this.closeRs(resultSet);
                    this.closeSt(statement);
                    this.closeConn((Connection)object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break block27;
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR :", this.entity + " computeMeasures targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                System.out.println("ERROR : Exception occured in " + this.entity + "targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " Exception:" + exception.toString());
                exception.printStackTrace();
                {
                    catch (Throwable throwable) {
                        try {
                            this.closeRs(resultSet);
                            this.closeSt(statement);
                            this.closeConn((Connection)object);
                        }
                        catch (Exception exception3) {
                            exception3.printStackTrace();
                        }
                        throw throwable;
                    }
                }
                try {
                    this.closeRs(resultSet);
                    this.closeSt(statement);
                    this.closeConn((Connection)object);
                }
                catch (Exception exception4) {
                    exception4.printStackTrace();
                }
            }
        }
    }

    private void closeRs(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSt(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private double getDoubleValue(String string) {
        double d = 0.0;
        if (string == null || string.length() == 0 || string.equalsIgnoreCase("none")) {
            return d;
        }
        try {
            string = string.trim();
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = 0.0;
        }
        return d;
    }

    private double roundDouble(double d) {
        BigDecimal bigDecimal = new BigDecimal(d);
        String string = this.df.format(bigDecimal);
        return Double.parseDouble(string);
    }

    public static void main(String[] stringArray) {
        HanaCacheTest hanaCacheTest = new HanaCacheTest(stringArray);
        hanaCacheTest.computeMeasures(new Hashtable());
    }
}

