/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;

public class HanaSrvcStatTest
extends GenericTest {
    private static final int SERVICE_STATS_MEASURE_COUNT = 9;
    private String userName = "";
    private String password = "";
    private String hostNameToFilter = "";
    private boolean checkHostName = true;
    private DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
    private DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
    private boolean isTenantDB = false;
    private ArrayList tenantUnWantServiceList = null;

    public HanaSrvcStatTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.needAgentlessDD = true;
        this.userName = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        this.dfs.setDecimalSeparator('.');
        this.df.applyPattern("#.##");
        this.df.setDecimalFormatSymbols(this.dfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void computeMeasures(Hashtable hashtable) {
        block28: {
            String string;
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            String string10;
            String string11;
            String string12;
            String string13;
            String string14;
            String string15;
            String string16;
            Statement statement;
            Object object;
            Object object2;
            block27: {
                if (this.checkHostName) {
                    ConnectionManager.collectHanaHostDetails(this.reportingName, this.entity, this.targetHost, this.portNo, this.userName, this.password, debug);
                    object2 = ConnectionManager.getHanaDbDetails(this.reportingName + ":" + this.targetHost + ":" + this.portNo);
                    if (object2 != null && ((ArrayList)object2).size() > 0) {
                        this.hostNameToFilter = (String)((ArrayList)object2).get(0);
                        object = (String)((ArrayList)object2).get(1);
                        if (object != null && ((String)object).trim().length() > 0 && ((String)object).trim().equalsIgnoreCase("true")) {
                            this.isTenantDB = true;
                            this.tenantUnWantServiceList = new ArrayList();
                            this.tenantUnWantServiceList.add("nameserver");
                            this.tenantUnWantServiceList.add("webdispatcher");
                            this.tenantUnWantServiceList.add("compileserver");
                        }
                        this.hostNameToFilter = this.hostNameToFilter.toLowerCase().trim();
                        this.checkHostName = false;
                    } else {
                        this.logToErrorFile("INFO :", this.entity, "Failed to find the Hana Host details for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                        return;
                    }
                }
                System.out.println(this.entity + " ::hostNameToFilter==>" + this.hostNameToFilter + ":targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                System.out.println(this.entity + " ::isTenantDB==>" + this.isTenantDB + ":targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                object2 = null;
                object = null;
                statement = null;
                string16 = "";
                string15 = "";
                string14 = "";
                string13 = "";
                string12 = "";
                string11 = "";
                string10 = "";
                string9 = "";
                string8 = "";
                string7 = "";
                string6 = "";
                string5 = "";
                string4 = "";
                string3 = "";
                string2 = "";
                d9 = 0.0;
                d8 = 0.0;
                d7 = 0.0;
                d6 = 0.0;
                d5 = 0.0;
                d4 = 0.0;
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(" select  host, port,  service_name,  process_id,  active_status,  start_time,  process_cpu process_cpu_percent,");
                stringBuffer.append(" total_cpu total_cpu_percent, (process_memory/1024/1024) process_logical_memory_mb,");
                stringBuffer.append(" (process_physical_memory/1024/1024) process_phy_mem_mb, (total_memory/1024/1024) used_memory_mb,");
                stringBuffer.append(" ((available_memory-total_memory)/1024/1024) free_memory_mb, (available_memory/1024/1024) total_memory_mb,");
                stringBuffer.append(" (total_memory/available_memory)*100 used_memory_percent, ((available_memory-total_memory)/available_memory)*100 free_memory_percent,");
                stringBuffer.append(" (process_physical_memory/physical_memory)*100 physical_mem_usage from  m_service_statistics where process_cpu >-1 and lower(host)='" + this.hostNameToFilter + "'");
                string = stringBuffer.toString();
                System.out.println(this.entity + "==>Query:" + string + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                object2 = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.userName, this.password, debug);
                if (object2 != null) break block27;
                this.logToErrorFile("ERROR :", this.entity, "Connection is null for targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                try {
                    this.closeRs((ResultSet)object);
                    this.closeSt(statement);
                    this.closeConn((Connection)object2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return;
            }
            try {
                statement = object2.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR:", this.entity + " Failed to Create Statement targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                this.closeSt(statement);
                this.closeConn((Connection)object2);
                exception.printStackTrace();
                try {
                    this.closeRs((ResultSet)object);
                    this.closeSt(statement);
                    this.closeConn((Connection)object2);
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                return;
            }
            object = statement.executeQuery(string);
            while (object.next()) {
                string16 = object.getString(1);
                string15 = object.getString(2);
                string14 = object.getString(3);
                if (this.isTenantDB && this.tenantUnWantServiceList.contains(string14)) continue;
                string13 = object.getString(4);
                string12 = object.getString(5);
                string11 = object.getString(6);
                string10 = object.getString(7);
                d9 = this.getDoubleValue(string10);
                string9 = object.getString(8);
                d8 = this.getDoubleValue(string9);
                string8 = object.getString(9);
                d7 = this.getDoubleValue(string8);
                d7 = this.roundDouble(d7);
                string7 = object.getString(10);
                d6 = this.getDoubleValue(string7);
                d6 = this.roundDouble(d6);
                string6 = object.getString(11);
                d5 = this.getDoubleValue(string6);
                d5 = this.roundDouble(d5);
                string5 = object.getString(12);
                d4 = this.getDoubleValue(string5);
                d4 = this.roundDouble(d4);
                string4 = object.getString(13);
                d3 = this.getDoubleValue(string4);
                d3 = this.roundDouble(d3);
                string3 = object.getString(15);
                d2 = this.getDoubleValue(string3);
                d2 = this.roundDouble(d2);
                string2 = object.getString(16);
                d = this.getDoubleValue(string2);
                d = this.roundDouble(d);
                System.out.println("processCPUUsage  " + d9);
                System.out.println(" totalCPUUsage   " + d8);
                System.out.println(" processLogicalMem   " + d7);
                System.out.println(" processPhysicalMem    " + d6);
                System.out.println(" usedMemMB    " + d5);
                System.out.println(" freeMemMB  " + d4);
                System.out.println(" totalMemMB   " + d3);
                System.out.println(" freeMemPCT   " + d2);
                System.out.println(" phyMemUsagePCT   " + d);
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d9));
                arrayList.add(new Double(d8));
                arrayList.add(new Double(d7));
                arrayList.add(new Double(d6));
                arrayList.add(new Double(d5));
                arrayList.add(new Double(d4));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d));
                System.out.println("[" + this.entity + "]info===>" + string14 + " measure===>" + arrayList);
                this.addNewMeasure(string14, arrayList);
            }
            try {
                this.closeRs((ResultSet)object);
                this.closeSt(statement);
                this.closeConn((Connection)object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block28;
            catch (SQLException sQLException) {
                this.logToErrorFile("ERROR :", this.entity + " SQL Error in computeMeasures targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, sQLException.toString());
                System.out.println("ERROR : Exception occured in " + this.entity + "targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " Exception:" + sQLException.toString());
                sQLException.printStackTrace();
                try {
                    this.closeRs((ResultSet)object);
                    this.closeSt(statement);
                    this.closeConn((Connection)object2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break block28;
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR :", this.entity + " computeMeasures targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                System.out.println("ERROR : Exception occured in " + this.entity + "targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " Exception:" + exception.toString());
                exception.printStackTrace();
                {
                    catch (Throwable throwable) {
                        try {
                            this.closeRs((ResultSet)object);
                            this.closeSt(statement);
                            this.closeConn((Connection)object2);
                        }
                        catch (Exception exception3) {
                            exception3.printStackTrace();
                        }
                        throw throwable;
                    }
                }
                try {
                    this.closeRs((ResultSet)object);
                    this.closeSt(statement);
                    this.closeConn((Connection)object2);
                }
                catch (Exception exception4) {
                    exception4.printStackTrace();
                }
            }
        }
    }

    private double getDoubleValue(String string) {
        double d = 0.0;
        if (string == null || string.length() == 0 || string.equalsIgnoreCase("none")) {
            d = 0.0;
        } else {
            try {
                string = string.trim();
                d = Double.parseDouble(string);
            }
            catch (Exception exception) {
                d = 0.0;
            }
        }
        return d;
    }

    private void closeRs(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSt(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private double roundDouble(double d) {
        BigDecimal bigDecimal = new BigDecimal(d);
        String string = this.df.format(bigDecimal);
        return Double.parseDouble(string);
    }

    public static void main(String[] stringArray) {
        HanaSrvcStatTest hanaSrvcStatTest = new HanaSrvcStatTest(stringArray);
        hanaSrvcStatTest.computeMeasures(new Hashtable());
    }
}

