/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

class HwPowerSupplyTest
extends EgSnmpGenericTest {
    private String key = "";
    private String StVal = "";
    private String SupplyVal = "";
    private String SensorVal = "";
    private String OutputVal = "";
    private String info = "";
    private int Len = 0;
    private String chasisIndex = "";
    private String deviceIndex = "";
    private boolean isDell = false;
    private boolean isCpq = false;
    private boolean isIbm = false;

    public HwPowerSupplyTest(String[] stringArray) {
        super(stringArray);
        this.isDynamicInfoTest = true;
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.setMeasureCount(3);
    }

    public void computeMeasures(Hashtable hashtable) {
        boolean bl = false;
        if (this.isDell || this.isCpq || this.isIbm) {
            bl = true;
        }
        if (this.isDell || !bl) {
            this.runDellSupplyTest();
        }
        if (!this.isDell && this.isCpq && !this.isIbm || !bl) {
            this.runCpqSupplyTest();
        }
        if (!this.isDell && !this.isCpq && this.isIbm || !bl) {
            this.runIbmSupplyTest();
        }
    }

    public void runDellSupplyTest() {
        Hashtable hashtable = this.getMeasure(".1.3.6.1.4.1.674.10892.1.600.12.1.8");
        Hashtable hashtable2 = this.getMeasure(".1.3.6.1.4.1.674.10892.1.600.12.1.5");
        Hashtable hashtable3 = this.getMeasure(".1.3.6.1.4.1.674.10892.1.600.12.1.11");
        Hashtable hashtable4 = this.getMeasure(".1.3.6.1.4.1.674.10892.1.600.12.1.6");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            this.key = (String)enumeration.nextElement();
            this.Len = this.key.indexOf(".");
            this.chasisIndex = this.key.substring(0, this.Len);
            this.deviceIndex = this.key.substring(this.Len + 1);
            this.info = (String)hashtable.get(this.key);
            this.info = "chasis" + this.chasisIndex + "_" + "PS" + this.deviceIndex + "_" + this.info;
            this.StVal = (String)hashtable2.get(this.key);
            this.StVal = this.checkNull(this.StVal);
            double d = Double.parseDouble(this.StVal);
            if (d == 3.0) {
                d = 0.0;
            }
            this.SensorVal = (String)hashtable3.get(this.key);
            this.SensorVal = this.checkNull(this.SensorVal);
            this.OutputVal = (String)hashtable4.get(this.key);
            this.OutputVal = this.checkNull(this.OutputVal);
            arrayList.add(new Double(d));
            arrayList.add(new Double(this.SensorVal));
            arrayList.add(new Double(this.OutputVal));
            System.out.println("[HwPowerSupplyTest]info========>" + this.info + "Measure=======>" + arrayList);
            this.addNewMeasure(this.info, arrayList);
        }
    }

    public Hashtable getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "";
        String string3 = "";
        if (bl) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.lhs[i];
                string3 = this.rhs[i];
                hashtable.put(string2, string3);
            }
        }
        return hashtable;
    }

    public String checkNull(String string) {
        if (string == null || string.length() == 0) {
            string = "-5";
        }
        return string;
    }

    public void runCpqSupplyTest() {
    }

    public void runIbmSupplyTest() {
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.8.50", "-port", "NULL", "-snmpPort", "161", "-snmpversion", "v1", "-snmpCommunity", "public"};
        HwPowerSupplyTest hwPowerSupplyTest = new HwPowerSupplyTest(stringArray2);
        hwPowerSupplyTest.computeMeasures(new Hashtable());
    }
}

