/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HwTemperatureTest
extends EgSnmpGenericTest {
    private static String temp = ".1.3.6.1.4.1.674.10892.1.700.20.1.6";
    private static String tempName = ".1.3.6.1.4.1.674.10892.1.700.20.1.8";
    private static String state = ".1.3.6.1.4.1.674.10892.1.700.20.1.4";
    private static String status = ".1.3.6.1.4.1.674.10892.1.700.20.1.5";
    private static String oid = ".1.3.6.1.4.1.674.10892.1.700.20.1";
    private static String cpqTempOid = ".1.3.6.1.4.1.232.6.2.6.8.1.4";
    private static String cpqTempCondition = ".1.3.6.1.4.1.232.6.2.6.8.1.6";
    private static String cpqTempLocation = ".1.3.6.1.4.1.232.6.2.6.8.1.3";
    private static String ibmTempOid = ".1.3.6.1.4.1.2.6.159.1.1.80.1.1.2";
    private static String ibmTempCondition = ".1.3.6.1.4.1.2.6.159.1.1.80.1.1.21";
    private static String ibmTempName = ".1.3.6.1.4.1.2.6.159.1.1.80.1.1.1";
    private boolean isDell = false;
    private boolean isCpq = false;
    private boolean isIbm = false;
    private boolean reportDeg = false;
    private static int numMeasures = 2;
    private boolean isAix = false;

    public static void main(String[] stringArray) {
        HwTemperatureTest hwTemperatureTest = new HwTemperatureTest(stringArray);
        hwTemperatureTest.computeMeasures(new Hashtable());
    }

    public HwTemperatureTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
        this.isDynamicInfoTest = true;
        String string = this.getValueForParam("reportInDegC");
        this.reportDeg = string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"));
        String string2 = System.getProperty("os.name");
        if (string2 != null && string2.equalsIgnoreCase("aix")) {
            this.isAix = true;
        }
    }

    private double getValue(int n) {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d < 0.0) {
            d = -5.0;
        }
        return d;
    }

    public void runAixTest() {
        EgUtilities egUtilities = EgUtilities.createInstance();
        ArrayList arrayList = egUtilities.getExecOutputLines("/usr/lpp/diagnostics/bin/uesensor -a");
        if (arrayList == null) {
            return;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        for (int i = 0; i < arrayList2.size(); ++i) {
            String string = (String)arrayList2.get(i);
            if (string == null || string.trim().length() == 0) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() != 5) {
                System.out.println("Fan speed values are not obtained properly. " + string);
                continue;
            }
            if (!stringTokenizer.nextToken().equals("3")) continue;
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            String string6 = string5 + ":" + string2;
            double d = -5.0;
            try {
                d = Double.parseDouble(string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = 1;
            if (string3.equals("11")) {
                n = 1;
            } else if (string3.equals("10")) {
                n = 2;
            } else if (string3.equals("9")) {
                n = 2;
            } else if (string3.equals("12")) {
                n = 3;
            } else if (string3.equals("13")) {
                n = 4;
            }
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            arrayList3.add(new Double(d));
            arrayList3.add(new Double(n));
            this.addNewMeasure(string6, arrayList3);
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        if (!this.meAgentless && this.isAix) {
            this.runAixTest();
            return;
        }
        boolean bl = false;
        if (this.isDell || this.isCpq || this.isIbm) {
            bl = true;
        }
        if (this.isDell && !this.isCpq && !this.isIbm || !bl) {
            this.runDellHwTest();
        }
        if (!this.isDell && this.isCpq && !this.isIbm || !bl) {
            this.runCpqHwTest();
        }
        if (!this.isDell && !this.isCpq && this.isIbm || !bl) {
            this.runIbmHwTest();
        }
    }

    private void runCpqHwTest() {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        System.out.println("In compaq Temp test ");
        this.isCpq = false;
        if (this.runSnmpCmdForOid(cpqTempOid)) {
            double d;
            int n;
            if (this.lhs == null) {
                return;
            }
            this.isCpq = true;
            for (n = 0; n < this.lhs.length; ++n) {
                d = this.getValue(n);
                hashtable.put(this.lhs[n], new Double(d));
            }
            System.out.println("Temp1 is " + hashtable);
            if (this.runSnmpCmdForOid(cpqTempCondition) && this.lhs != null) {
                for (n = 0; n < this.lhs.length; ++n) {
                    d = this.getValue(n);
                    if (d <= 2.0) {
                        hashtable2.put(this.lhs[n], new Double(1.0));
                        continue;
                    }
                    if (d == 3.0) {
                        hashtable2.put(this.lhs[n], new Double(3.0));
                        continue;
                    }
                    hashtable2.put(this.lhs[n], new Double(4.0));
                }
            }
            if (this.runSnmpCmdForOid(cpqTempLocation) && this.lhs != null) {
                for (n = 0; n < this.lhs.length; ++n) {
                    d = this.getValue(n);
                    if (d == 1.0) {
                        hashtable3.put(this.lhs[n], "Other");
                    } else if (d == 2.0) {
                        hashtable3.put(this.lhs[n], "Unknown");
                    }
                    if (d == 3.0) {
                        hashtable3.put(this.lhs[n], "System");
                        continue;
                    }
                    if (d == 4.0) {
                        hashtable3.put(this.lhs[n], "SystemBoard");
                        continue;
                    }
                    if (d == 5.0) {
                        hashtable3.put(this.lhs[n], "ioBoard");
                        continue;
                    }
                    if (d == 6.0) {
                        hashtable3.put(this.lhs[n], "cpu");
                        continue;
                    }
                    if (d == 7.0) {
                        hashtable3.put(this.lhs[n], "memory");
                        continue;
                    }
                    if (d == 8.0) {
                        hashtable3.put(this.lhs[n], "storage");
                        continue;
                    }
                    if (d == 9.0) {
                        hashtable3.put(this.lhs[n], "removableMedia");
                        continue;
                    }
                    if (d == 10.0) {
                        hashtable3.put(this.lhs[n], "powerSupply");
                        continue;
                    }
                    if (d == 11.0) {
                        hashtable3.put(this.lhs[n], "ambient");
                        continue;
                    }
                    if (d == 12.0) {
                        hashtable3.put(this.lhs[n], "chassis");
                        continue;
                    }
                    if (d == 13.0) {
                        hashtable3.put(this.lhs[n], "bridgeCard");
                        continue;
                    }
                    hashtable3.put(this.lhs[n], "Unknown");
                }
            }
        } else {
            this.isCpq = false;
        }
        Enumeration enumeration = hashtable.keys();
        System.out.println("TempCond is " + hashtable2);
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            double d = (Double)hashtable.get(string);
            if (d >= 0.0 && !this.reportDeg) {
                d = 1.8 * d + 32.0;
            }
            double d2 = -5.0;
            Double d3 = (Double)hashtable2.get(string);
            if (d3 != null) {
                d2 = d3;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            String string2 = (String)hashtable3.get(string);
            if (string2 != null) {
                string = string2 + "_" + string;
            }
            this.addNewMeasure(string, arrayList);
        }
    }

    private void runDellHwTest() {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Hashtable<String, Double> hashtable3 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable4 = new Hashtable<String, Double>();
        this.isDell = false;
        if (this.runSnmpCmdForOid(oid)) {
            if (this.lhs == null) {
                return;
            }
            this.isDell = true;
            for (int i = 0; i < this.lhs.length; ++i) {
                if (this.lhs[i].startsWith("6.")) {
                    this.lhs[i] = this.lhs[i].substring(2);
                    hashtable.put(this.lhs[i], new Double(this.getValue(i)));
                    continue;
                }
                if (this.lhs[i].startsWith("8.")) {
                    this.lhs[i] = this.lhs[i].substring(2);
                    hashtable2.put(this.lhs[i], this.rhs[i]);
                    continue;
                }
                if (this.lhs[i].startsWith("4.")) {
                    this.lhs[i] = this.lhs[i].substring(2);
                    hashtable3.put(this.lhs[i], new Double(this.getValue(i)));
                    continue;
                }
                if (!this.lhs[i].startsWith("5.")) continue;
                this.lhs[i] = this.lhs[i].substring(2);
                hashtable4.put(this.lhs[i], new Double(this.getValue(i)));
            }
        } else {
            this.isDell = false;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            double d;
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable2.get(string);
            if (string2 == null) continue;
            double d2 = (Double)hashtable.get(string);
            if (d2 > 0.0) {
                d2 /= 10.0;
                if (!this.reportDeg) {
                    d2 = 1.8 * d2 + 32.0;
                }
            }
            if ((d = ((Double)hashtable3.get(string)).doubleValue()) != 2.0) continue;
            double d3 = (Double)hashtable4.get(string);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d2));
            double d4 = -1.0;
            if (d3 == 3.0) {
                d4 = 1.0;
            } else if (d3 == 4.0 || d3 == 7.0) {
                d4 = 2.0;
            } else if (d3 == 6.0 || d3 == 9.0) {
                d4 = 3.0;
            } else if (d3 == 5.0 || d3 == 8.0 || d3 == 10.0) {
                d4 = 4.0;
            }
            arrayList.add(new Double(d4));
            this.addNewMeasure(string2, arrayList);
        }
    }

    private void runIbmHwTest() {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        this.isCpq = false;
        this.isDell = false;
        this.isIbm = false;
        if (this.runSnmpCmdForOid(ibmTempOid)) {
            int n;
            if (this.lhs == null) {
                return;
            }
            this.isIbm = true;
            for (n = 0; n < this.lhs.length; ++n) {
                double d = this.getValue(n);
                hashtable.put(this.lhs[n], new Double(d));
            }
            if (this.runSnmpCmdForOid(ibmTempCondition) && this.lhs != null) {
                for (n = 0; n < this.lhs.length; ++n) {
                    if (this.rhs[n] == null || this.rhs[n].equalsIgnoreCase("null")) continue;
                    if (this.rhs[n].equalsIgnoreCase("OK") || this.rhs[n].equalsIgnoreCase("Normal")) {
                        hashtable2.put(this.lhs[n], new Double(1.0));
                        continue;
                    }
                    if (this.rhs[n].equalsIgnoreCase("Degraded") || this.rhs[n].equalsIgnoreCase("Error")) {
                        hashtable2.put(this.lhs[n], new Double(4.0));
                        continue;
                    }
                    if (this.rhs[n].equalsIgnoreCase("Warning") || this.rhs[n].equalsIgnoreCase("Pred Fail")) {
                        hashtable2.put(this.lhs[n], new Double(3.0));
                        continue;
                    }
                    hashtable2.put(this.lhs[n], new Double(-5.0));
                }
            }
            if (this.runSnmpCmdForOid(ibmTempName) && this.lhs != null) {
                for (n = 0; n < this.lhs.length; ++n) {
                    hashtable3.put(this.lhs[n], this.rhs[n]);
                }
            }
        } else {
            this.isIbm = false;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            double d = (Double)hashtable.get(string);
            if (d >= 0.0 && !this.reportDeg) {
                d = 1.8 * d + 32.0;
            }
            double d2 = -5.0;
            Double d3 = (Double)hashtable2.get(string);
            if (d3 != null) {
                d2 = d3;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            String string2 = (String)hashtable3.get(string);
            if (string2 == null) continue;
            this.addNewMeasure(string2, arrayList);
        }
    }
}

