/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class IBMDb2DbmTest
extends GenericTest {
    private static final int MEASURES_COUNT = 4;
    private String user;
    private String password;
    private String dbName;
    private double lastPostThresholdSorts = -1.0;
    private double lastPipedSortsRequested = -1.0;
    private double lastPipedSortsAccepted = -1.0;
    private double lastPostThresholdHashJoins = -1.0;

    public static void main(String[] stringArray) {
        new IBMDb2DbmTest(stringArray).computeMeasures(null);
    }

    public IBMDb2DbmTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(4);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.dbName = this.getValueForParam("database");
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList arrayList = this.getDbmStats();
        if (arrayList != null) {
            this.addNewMeasure(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getDbmStats() {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        DB2JdbcHelper dB2JdbcHelper = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = -5.0;
        double d6 = -5.0;
        double d7 = -5.0;
        double d8 = -5.0;
        dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
        connection = dB2JdbcHelper.getConnection();
        if (connection == null) {
            System.out.println("Error in getting database connection");
            return null;
        }
        String string = dB2JdbcHelper.getDbmSnapshotFunction(connection);
        System.out.println("snapshotTable for " + this.entity + " = " + string);
        String string2 = "SELECT POST_THRESHOLD_SORTS,PIPED_SORTS_REQUESTED,PIPED_SORTS_ACCEPTED,POST_THRESHOLD_HASH_JOINS   FROM TABLE(" + string + ") DBM";
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                d = resultSet.getDouble("POST_THRESHOLD_SORTS");
                d2 = resultSet.getDouble("PIPED_SORTS_REQUESTED");
                d3 = resultSet.getDouble("PIPED_SORTS_ACCEPTED");
                d4 = resultSet.getDouble("POST_THRESHOLD_HASH_JOINS");
            }
            if (this.lastPostThresholdSorts != -1.0 && this.lastPipedSortsRequested != -1.0 && this.lastPipedSortsAccepted != -1.0 && this.lastPostThresholdHashJoins != -1.0) {
                double d9 = d - this.lastPostThresholdSorts;
                double d10 = d2 - this.lastPipedSortsRequested;
                double d11 = d3 - this.lastPipedSortsAccepted;
                double d12 = d4 - this.lastPostThresholdHashJoins;
                if (this.timeSinceLastTest > 0.0) {
                    if (d9 >= 0.0) {
                        d5 = d9 / this.timeSinceLastTest;
                    }
                    if (d10 >= 0.0) {
                        d6 = d10 / this.timeSinceLastTest;
                    }
                    if (d12 >= 0.0) {
                        d8 = d12 / this.timeSinceLastTest;
                    }
                }
                d7 = d10 > 0.0 ? (d10 - d11) * 100.0 / d10 : 0.0;
            }
            this.lastPostThresholdSorts = d;
            this.lastPipedSortsRequested = d2;
            this.lastPipedSortsAccepted = d3;
            this.lastPostThresholdHashJoins = d4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ArrayList arrayList = null;
            return arrayList;
        }
        finally {
            dB2JdbcHelper.closeStatement(statement);
            dB2JdbcHelper.closeResultSet(resultSet);
        }
        dB2JdbcHelper.closeConnection(connection);
        ArrayList<Double> arrayList = new ArrayList<Double>(4);
        arrayList.add(new Double(d5));
        arrayList.add(new Double(d6));
        arrayList.add(new Double(d7));
        arrayList.add(new Double(d8));
        return arrayList;
    }
}

