/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;

public class IBMDb2SortTest
extends GenericTest {
    private static final int MEASURES_COUNT = 5;
    private String user;
    private String password;
    private String dbName;
    private HashMap lastValues;
    private ArrayList activeDatabases;

    public IBMDb2SortTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.dbName = this.getValueForParam("database");
        this.lastValues = new HashMap();
    }

    public static void main(String[] stringArray) {
        new IBMDb2SortTest(stringArray).computeMeasures(null);
    }

    public void computeMeasures(Hashtable hashtable) {
        HashMap hashMap = this.getSortStats();
        if (hashMap != null && hashMap.size() > 0) {
            Set set = hashMap.keySet();
            for (String string : set) {
                ArrayList arrayList = (ArrayList)hashMap.get(string);
                System.out.println(string + "=" + arrayList);
                if (this.activeDatabases.contains(string)) {
                    this.addNewMeasure(string, arrayList);
                    continue;
                }
                this.addNewMeasure(string, this.getNotAvailableMeasures());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getSortStats() {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        HashMap hashMap = new HashMap();
        DB2JdbcHelper dB2JdbcHelper = null;
        String string = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = -5.0;
        double d7 = -5.0;
        double d8 = -5.0;
        double d9 = -5.0;
        dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
        connection = dB2JdbcHelper.getConnection();
        if (connection == null) {
            System.out.println("Error in getting database connection");
            return null;
        }
        String string2 = dB2JdbcHelper.getDbSnapshotFunction(connection);
        System.out.println("snapshotTable for " + this.entity + " = " + string2);
        String string3 = "SELECT DB_NAME,SORT_HEAP_ALLOCATED,ACTIVE_SORTS,TOTAL_SORTS,SORT_OVERFLOWS,TOTAL_SORT_TIME FROM table(" + string2 + ") AS DB";
        try {
            statement = connection.createStatement();
            statement.execute(string3);
            resultSet = statement.executeQuery(string3);
            this.activeDatabases = new ArrayList();
            while (resultSet.next()) {
                string = resultSet.getString("DB_NAME");
                d = resultSet.getDouble("SORT_HEAP_ALLOCATED");
                d2 = resultSet.getDouble("ACTIVE_SORTS");
                d3 = resultSet.getDouble("TOTAL_SORTS");
                d4 = resultSet.getDouble("SORT_OVERFLOWS");
                d5 = resultSet.getDouble("TOTAL_SORT_TIME");
                this.activeDatabases.add(string);
                ArrayList<Double> arrayList = (ArrayList<Double>)this.lastValues.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<Double>(3);
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d4));
                    arrayList.add(new Double(d5));
                } else {
                    double d10 = (Double)arrayList.get(0);
                    double d11 = (Double)arrayList.get(1);
                    double d12 = (Double)arrayList.get(2);
                    double d13 = d3 - d10;
                    if (d13 < 0.0) {
                        d13 = 0.0;
                    }
                    if (this.timeSinceLastTest > 0.0) {
                        d7 = d13 / this.timeSinceLastTest;
                    }
                    if (d13 > 0.0) {
                        d8 = (d4 - d11) / d13;
                        d9 = (d5 - d12) / d13;
                    } else {
                        d8 = 0.0;
                        d9 = 0.0;
                    }
                    d9 = d9 < 0.0 ? -5.0 : d9;
                    d8 = d8 < 0.0 ? -5.0 : d8;
                    arrayList.set(0, new Double(d3));
                    arrayList.set(1, new Double(d4));
                    arrayList.set(2, new Double(d5));
                }
                d6 = d2 > 0.0 ? d / d2 : 0.0;
                this.lastValues.put(string, arrayList);
                ArrayList<Double> arrayList2 = new ArrayList<Double>(5);
                arrayList2.add(new Double(d));
                arrayList2.add(new Double(d6));
                arrayList2.add(new Double(d7));
                arrayList2.add(new Double(d8));
                arrayList2.add(new Double(d9));
                hashMap.put(string, arrayList2);
            }
            dB2JdbcHelper.closeStatement(statement);
            dB2JdbcHelper.closeResultSet(resultSet);
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                dB2JdbcHelper.closeStatement(statement);
                dB2JdbcHelper.closeResultSet(resultSet);
            }
            catch (Throwable throwable) {
                dB2JdbcHelper.closeStatement(statement);
                dB2JdbcHelper.closeResultSet(resultSet);
                throw throwable;
            }
        }
        dB2JdbcHelper.closeConnection(connection);
        return hashMap;
    }

    private ArrayList getNotAvailableMeasures() {
        ArrayList<Double> arrayList = new ArrayList<Double>(5);
        for (int i = 0; i < 5; ++i) {
            arrayList.add(new Double(-5.0));
        }
        return arrayList;
    }
}

