/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class IBMDb2TbsTest
extends GenericTest {
    private static final int MEASURES_COUNT = 5;
    private String user;
    private String password;
    private String includeDb;
    private String excludeDb;
    private String sys_OS = "";
    private String debugFlag = "";
    private static final int BYTE_TO_MB = 0x100000;
    private EgUtilities egutil = EgUtilities.createInstance();
    private String scriptDir = EgConfigInfo.homeDir + "/bin/";
    boolean debug = false;

    public static void main(String[] stringArray) {
        IBMDb2TbsTest iBMDb2TbsTest = new IBMDb2TbsTest(stringArray);
        while (true) {
            try {
                while (true) {
                    iBMDb2TbsTest.computeMeasures(new Hashtable());
                    Thread.sleep(3000L);
                }
            }
            catch (Exception exception) {
                System.out.println("[IBMDb2TbsTest]exception==========>" + exception);
                continue;
            }
            break;
        }
    }

    public IBMDb2TbsTest(String[] stringArray) {
        super(stringArray);
        this.isDynamicInfoTest = true;
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.includeDb = this.getValueForParam("include_db");
        this.excludeDb = this.getValueForParam("exclude_db");
        this.sys_OS = System.getProperty("os.name");
        this.debugFlag = this.getValueForParam("debug");
        if (this.sys_OS == null || this.sys_OS.length() == 0) {
            this.logToErrorFile("Error", "IBMDb2TbsTest", "Operating System Name not Found");
            return;
        }
        this.sys_OS = this.sys_OS.trim().toUpperCase();
        this.debug = this.debugFlag == null ? false : this.debugFlag != null && (this.debugFlag.equalsIgnoreCase("true") || this.debugFlag.equalsIgnoreCase("yes"));
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            Object object;
            if (this.meAgentless) {
                return;
            }
            ArrayList arrayList = null;
            arrayList = this.sys_OS.startsWith("WIN") ? this.getDatabasesForWindows() : this.getDatabasesForOtherOs();
            if (arrayList == null) {
                this.logToErrorFile("Error", "[IBMDb2TbsTest]computeMeasures", "get databases list returns null");
                return;
            }
            if (this.debug) {
                System.out.println("DbList==========>" + arrayList);
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            StringTokenizer stringTokenizer = null;
            if (!this.includeDb.equalsIgnoreCase("none")) {
                stringTokenizer = new StringTokenizer(this.includeDb, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    if (arrayList2.contains(object = ((String)object).toUpperCase())) continue;
                    arrayList2.add(object);
                }
            }
            if (!this.excludeDb.equalsIgnoreCase("none")) {
                stringTokenizer = new StringTokenizer(this.excludeDb, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    if (arrayList3.contains(object = ((String)object).toUpperCase())) continue;
                    arrayList3.add(object);
                }
            }
            object = new ArrayList();
            if (arrayList2 != null && arrayList2.size() > 0) {
                object = (ArrayList)arrayList2.clone();
            } else {
                ArrayList arrayList4 = arrayList;
                if (arrayList4 != null) {
                    for (int i = 0; i < arrayList4.size(); ++i) {
                        String string = (String)arrayList4.get(i);
                        if (arrayList3 != null && arrayList3.contains(string)) continue;
                        ((ArrayList)object).add(string);
                    }
                }
            }
            if (object != null && ((ArrayList)object).size() > 0) {
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    String string = (String)((ArrayList)object).get(i);
                    this.getTablespaces(string);
                }
            } else {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    this.getTablespaces(string);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error", "[IBMDb2TbsTest]computeMeasures", exception.toString());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTablespaces(String string) {
        try {
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            DB2JdbcHelper dB2JdbcHelper = null;
            if (this.debug) {
                System.out.println("[IbmDb2TbsTest] inside getTablespaces dbname===========>" + string);
            }
            if ((connection = (dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, string)).getConnection()) == null) {
                System.out.println("Error in getting database connection");
                return;
            }
            String string2 = "";
            int n = dB2JdbcHelper.getDb2MajorVersion(connection);
            String string3 = dB2JdbcHelper.getTbsSnapshotFunction(connection);
            if (n == 8) {
                string2 = "SELECT TABLESPACE_NAME,TABLESPACE_TYPE,USABLE_PAGES,USED_PAGES,FREE_PAGES,PAGE_SIZE FROM table(" + string3 + ") DBM";
            } else if (n >= 9) {
                string2 = "select t.tbsp_name tablespace_name ,case when ts.tbsp_type='DMS' then 0 when ts.tbsp_type='SMS' then 1 end tablespace_type,t.tbsp_usable_pages usable_pages,t.tbsp_used_pages used_pages,t.tbsp_free_pages free_pages,ts.tbsp_page_size page_size from TABLE(SNAP_GET_TBSP_PART_V97(CAST(NULL AS VARCHAR(128)),-1)) AS T, TABLE(SNAP_GET_TBSP_V91('')) AS TS where t.tbsp_id=ts.tbsp_id";
            }
            try {
                statement = connection.createStatement();
                if (this.debug) {
                    System.out.println("query==========>" + string2);
                }
                resultSet = statement.executeQuery(string2);
                while (resultSet.next()) {
                    double d = resultSet.getDouble("USABLE_PAGES");
                    double d2 = resultSet.getDouble("USED_PAGES");
                    double d3 = resultSet.getDouble("FREE_PAGES");
                    double d4 = resultSet.getDouble("PAGE_SIZE");
                    String string4 = resultSet.getString("TABLESPACE_NAME");
                    String string5 = string + "_" + string4;
                    int n2 = resultSet.getInt("TABLESPACE_TYPE");
                    d = d * d4 / 1048576.0;
                    d2 = d2 * d4 / 1048576.0;
                    d3 = d3 * d4 / 1048576.0;
                    double d5 = -5.0;
                    if (n2 == 0 && d > 0.0) {
                        d5 = d3 / d * 100.0;
                    }
                    ArrayList<Double> arrayList = new ArrayList<Double>(5);
                    arrayList.add(new Double(n2));
                    arrayList.add(new Double(d));
                    arrayList.add(new Double(d2));
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d5));
                    if (this.debug) {
                        System.out.println("[IBMDb2TbsTest]===info===>" + string5 + "==Measures===>" + arrayList);
                    }
                    this.addNewMeasure(string5, arrayList);
                }
                dB2JdbcHelper.closeResultSet(resultSet);
                dB2JdbcHelper.closeStatement(statement);
                dB2JdbcHelper.closeConnection(connection);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                dB2JdbcHelper.closeResultSet(resultSet);
                dB2JdbcHelper.closeStatement(statement);
                dB2JdbcHelper.closeConnection(connection);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error", "[IBMDb2TbsTest]getTablespaces", exception.toString());
            exception.printStackTrace();
        }
    }

    private ArrayList getDatabasesForOtherOs() {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = this.scriptDir + "db2GetDb.sh";
            ArrayList arrayList2 = this.egutil.getExecOutputLines(string);
            if (this.debug) {
                System.out.println("[getDatabasesForOtherOs]AL2 ==========>" + arrayList2);
            }
            if (arrayList2 == null || arrayList2.size() < 1) {
                return arrayList;
            }
            ArrayList arrayList3 = (ArrayList)arrayList2.get(0);
            if (this.debug) {
                System.out.println("[getDatabasesForOtherOs]out ==========>" + arrayList3);
            }
            String string2 = "";
            for (int i = 0; i < arrayList3.size(); ++i) {
                StringTokenizer stringTokenizer;
                string2 = (String)arrayList3.get(i);
                if (!string2.trim().startsWith("Database name") || !(stringTokenizer = new StringTokenizer(string2, "=")).hasMoreTokens()) continue;
                stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken().trim();
                if (arrayList.contains(string3)) continue;
                arrayList.add(string3);
            }
            return arrayList;
        }
        catch (Exception exception) {
            this.logToErrorFile("Error", "[IBMDb2TbsTest]getDatabasesForOtherOs", exception.toString());
            exception.printStackTrace();
            return null;
        }
    }

    private ArrayList getDatabasesForWindows() {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = "db2cmd -c -w -i db2 \"list database directory\" ";
            ArrayList arrayList2 = this.egutil.getExecOutputLines(string);
            if (this.debug) {
                System.out.println("AL2 ==========>" + arrayList2);
            }
            if (arrayList2 == null || arrayList2.size() < 1) {
                return arrayList;
            }
            ArrayList arrayList3 = (ArrayList)arrayList2.get(0);
            if (this.debug) {
                System.out.println("[IBMDb2TbsTEst]out=========>" + arrayList3);
            }
            String string2 = "";
            for (int i = 0; i < arrayList3.size(); ++i) {
                StringTokenizer stringTokenizer;
                string2 = (String)arrayList3.get(i);
                if (!string2.trim().startsWith("Database name") || !(stringTokenizer = new StringTokenizer(string2, "=")).hasMoreTokens()) continue;
                stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken().trim();
                if (arrayList.contains(string3)) continue;
                arrayList.add(string3);
            }
            return arrayList;
        }
        catch (Exception exception) {
            this.logToErrorFile("Error", "[IBMDb2TbsTest]getDatabasesForWindows", exception.toString());
            exception.printStackTrace();
            return null;
        }
    }
}

