/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgCrypt;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class IIBResourceStatisticsBase
extends GenericTest
implements MessageListener {
    private TopicConnection connection = null;
    private TopicSession session;
    private TopicSubscriber subscriber;
    private static final String FILE_BASED_CF_CLASS_NAME = "com.sun.jndi.fscontext.RefFSContextFactory";
    private static final String LDAP_BASED_CF_CLASS_NAME = "com.sun.jndi.ldap.LdapCtxFactory";
    private String WMQ_URL = null;
    private String TCF_NAME = null;
    private boolean isFirstTime = true;
    private String DESTINATION_NAME = null;
    private String CLIENT_ID = "";
    private Context INITIAL_CONTEXT = null;
    private boolean isFirstTimeInitialContext = true;
    IIBResourceStatisticsParserHandler handler = new IIBResourceStatisticsParserHandler();
    Hashtable measureData = new Hashtable();
    private static Hashtable syncHash = new Hashtable();
    private static final String syncString = new String("IIB");
    private static final String syncString2 = new String("IIB1");
    private static Hashtable ht_lastTime = new Hashtable();
    protected static Hashtable ht_ht_monValues = new Hashtable();
    private static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    private static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    private ArrayList xmlStringArrayList = new ArrayList();
    private boolean ldapBasedJNDI = false;
    private String user_DN = null;
    private String password = null;
    private String errorMessage = "";
    private String infoMessage = "";
    private boolean isSSL = false;

    public IIBResourceStatisticsBase(String[] args) {
        super(args);
        String dummyDestinationName;
        String jndiNamespaceLocation = this.getValueForParam("jndi_Namespace_Location");
        this.ldapBasedJNDI = jndiNamespaceLocation != null && jndiNamespaceLocation.trim().length() != 0 && !jndiNamespaceLocation.equalsIgnoreCase("FILE");
        this.user_DN = this.getValueForParam("user_DN");
        this.password = this.getValueForParam("password");
        String strSSL = this.getValueForParam("ssl");
        if (this.ldapBasedJNDI) {
            if (this.user_DN == null || this.user_DN.trim().length() == 0 || this.user_DN.equalsIgnoreCase("NONE")) {
                this.errorMessage = " Please provide a valid User DN";
                this.printOut(this.errorMessage);
                this.putErrorMessageToLogfile(this.errorMessage);
            }
            if (this.password == null || this.password.trim().length() == 0 || this.password.equalsIgnoreCase("NONE")) {
                this.errorMessage = " Please provide a valid password";
                this.printOut(this.errorMessage);
                this.putErrorMessageToLogfile(this.errorMessage);
            }
            this.isSSL = strSSL != null && strSSL.trim().length() != 0 && !strSSL.equalsIgnoreCase("FALSE");
        } else {
            this.user_DN = "NONE";
            this.password = "NONE";
        }
        this.WMQ_URL = this.getValueForParam("jndi_Provider_URL");
        if (this.WMQ_URL == null || this.WMQ_URL.trim().length() == 0) {
            this.errorMessage = "Please provide the JNDI provider URL ";
            this.printOut(this.errorMessage);
            this.putErrorMessageToLogfile(this.errorMessage);
        }
        this.TCF_NAME = this.getValueForParam("topicConnectionFactory");
        if (this.TCF_NAME == null || this.TCF_NAME.trim().length() == 0) {
            this.errorMessage = "Please provide the Topic Connection Factory name ";
            this.printOut(this.errorMessage);
            this.putErrorMessageToLogfile(this.errorMessage);
        }
        this.DESTINATION_NAME = this.getValueForParam("JMS_Resource_Stats");
        if (this.DESTINATION_NAME == null || this.DESTINATION_NAME.trim().length() == 0) {
            this.errorMessage = "Please provide the JMS_Resource_Stats(resource statiscics destination)  name ";
            this.printOut(this.errorMessage);
            this.putErrorMessageToLogfile(this.errorMessage);
        }
        if ((dummyDestinationName = this.getValueForParam("JMS_Flow_Stats")) == null || dummyDestinationName.trim().length() == 0) {
            this.errorMessage = "Please provide the JMS_Flow_Stats(Statistics accounting destination) name ";
            this.printOut(this.errorMessage);
            this.putErrorMessageToLogfile(this.errorMessage);
        }
        this.infoMessage = "Reporting Name :" + this.reportingName;
        this.printOut(this.infoMessage);
        this.infoMessage = "Destination Name :" + this.DESTINATION_NAME;
        this.printOut(this.infoMessage);
        this.CLIENT_ID = String.valueOf(this.reportingName) + "_" + this.portNo;
        this.infoMessage = "CLIENT_ID  :" + this.CLIENT_ID;
        this.printOut(this.infoMessage);
        this.fixedTestPeriod = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setData() {
        String string;
        long startTime = 0L;
        long totalStartTime = System.currentTimeMillis();
        boolean dataStatus = false;
        String mySync = "";
        mySync = (String)syncHash.get(this.targetHost);
        if (mySync == null || mySync.trim().length() == 0) {
            string = syncString;
            synchronized (string) {
                mySync = (String)syncHash.get(this.targetHost);
                if (mySync == null) {
                    syncHash.put(this.targetHost, new String(this.targetHost));
                    mySync = (String)syncHash.get(this.targetHost);
                }
            }
        }
        string = mySync;
        synchronized (string) {
            long diff;
            long now = System.currentTimeMillis();
            Long l = null;
            try {
                l = (Long)ht_lastTime.get(String.valueOf(this.reportingName) + "_" + this.portNo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long lastTime = 0L;
            if (l != null) {
                lastTime = l;
            }
            if ((double)(diff = now - lastTime) >= 0.9 * (double)this.measurePeriod) {
                dataStatus = false;
                lastTime = now;
                String string2 = syncString2;
                synchronized (string2) {
                    try {
                        if (ht_ht_monValues != null) {
                            this.measureData = (Hashtable)ht_ht_monValues.get(String.valueOf(this.reportingName) + "_" + this.portNo);
                            if (this.measureData != null) {
                                ht_ht_monValues.remove(String.valueOf(this.reportingName) + "_" + this.portNo);
                            }
                        } else {
                            ht_ht_monValues = new Hashtable();
                        }
                        ht_lastTime.put(String.valueOf(this.reportingName) + "_" + this.portNo, new Long(lastTime));
                    }
                    catch (Exception grr) {
                        return;
                    }
                }
            }
            dataStatus = true;
            this.printOut("IIB data status :" + dataStatus);
            if (!dataStatus) {
                long t1 = System.currentTimeMillis();
                try {
                    this.printOut("Verifying connection ");
                    if (!this.verifyConnection()) {
                        String string3 = syncString2;
                        synchronized (string3) {
                            try {
                                ht_lastTime.put(String.valueOf(this.reportingName) + "_" + this.portNo, new Long(System.currentTimeMillis()));
                            }
                            catch (Exception grr) {
                                this.printOut("Exception while setting data values (after connection failure) : " + grr.toString());
                            }
                        }
                        this.printOut("server:" + this.reportingName + "_" + this.portNo);
                        return;
                    }
                    this.measureData = new Hashtable();
                    startTime = System.currentTimeMillis();
                    this.printOut("Tracing - - verifyConnection  took " + (startTime - t1) + " millisecs");
                    Hashtable jvmMemoryMetrics = new Hashtable();
                    Hashtable jvmGCMetrics = new Hashtable();
                    Hashtable odbcMetrics = new Hashtable();
                    Hashtable parserMetrics = new Hashtable();
                    Hashtable dotNetMetrics = new Hashtable();
                    Hashtable securityMetrics = new Hashtable();
                    Hashtable globalCacheMetrics = new Hashtable();
                    Hashtable jmsMetrics = new Hashtable();
                    Hashtable cicsMetrics = new Hashtable();
                    Hashtable ftpMetrics = new Hashtable();
                    Hashtable jdbcMetrics = new Hashtable();
                    Hashtable decisionMetrics = new Hashtable();
                    Hashtable tcpClientMetrics = new Hashtable();
                    Hashtable tcpServerMetrics = new Hashtable();
                    Hashtable soapMetrics = new Hashtable();
                    this.getXMLFormatRawData();
                    Hashtable allDataHT = this.getFinalAllHashtable();
                    jvmMemoryMetrics = (Hashtable)allDataHT.get("JVM_Memory");
                    jvmGCMetrics = (Hashtable)allDataHT.get("JVM_GC");
                    odbcMetrics = (Hashtable)allDataHT.get("ODBC");
                    parserMetrics = (Hashtable)allDataHT.get("Parsers");
                    dotNetMetrics = (Hashtable)allDataHT.get("DotNet_GC");
                    securityMetrics = (Hashtable)allDataHT.get("Security");
                    globalCacheMetrics = (Hashtable)allDataHT.get("GlobalCache");
                    jmsMetrics = (Hashtable)allDataHT.get("JMS");
                    cicsMetrics = (Hashtable)allDataHT.get("CICS");
                    ftpMetrics = (Hashtable)allDataHT.get("FTP");
                    jdbcMetrics = (Hashtable)allDataHT.get("JDBCConnectionPools");
                    decisionMetrics = (Hashtable)allDataHT.get("DecisionServices");
                    tcpClientMetrics = (Hashtable)allDataHT.get("TCPIPClientNodes");
                    tcpServerMetrics = (Hashtable)allDataHT.get("TCPIPServerNodes");
                    soapMetrics = (Hashtable)allDataHT.get("SOAPInput");
                    this.printOut("Data Collected for  " + this.targetHost + " service for message flow  metrics " + (System.currentTimeMillis() - startTime) + "ms.");
                    this.measureData.put("JVM_Memory", jvmMemoryMetrics);
                    this.measureData.put("JVM_GC", jvmGCMetrics);
                    this.measureData.put("ODBC", odbcMetrics);
                    this.measureData.put("Parsers", parserMetrics);
                    this.measureData.put("DotNet_GC", dotNetMetrics);
                    this.measureData.put("Security", securityMetrics);
                    this.measureData.put("GlobalCache", globalCacheMetrics);
                    this.measureData.put("JMS", jmsMetrics);
                    this.measureData.put("CICS", cicsMetrics);
                    this.measureData.put("FTP", ftpMetrics);
                    this.measureData.put("JDBCConnectionPools", jdbcMetrics);
                    this.measureData.put("DecisionServices", decisionMetrics);
                    this.measureData.put("TCPIPClientNodes", tcpClientMetrics);
                    this.measureData.put("TCPIPServerNodes", tcpServerMetrics);
                    this.measureData.put("SOAPInput", soapMetrics);
                    String string4 = syncString2;
                    synchronized (string4) {
                        try {
                            if (ht_ht_monValues == null) {
                                ht_ht_monValues = new Hashtable();
                            }
                            ht_ht_monValues.put(String.valueOf(this.reportingName) + "_" + this.portNo, this.measureData);
                            ht_lastTime.put(String.valueOf(this.reportingName) + "_" + this.portNo, new Long(System.currentTimeMillis()));
                        }
                        catch (Exception grr) {
                            this.printOut("Exception while setting data values  : " + grr.toString());
                        }
                    }
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
            this.printOut("setData took " + (System.currentTimeMillis() - totalStartTime) + "ms.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getData(String testKey) {
        Hashtable ht_monValues = null;
        String string = syncString2;
        synchronized (string) {
            try {
                if (ht_ht_monValues == null) {
                    return null;
                }
                ht_monValues = (Hashtable)ht_ht_monValues.get(String.valueOf(this.reportingName) + "_" + this.portNo);
                if (ht_monValues == null || ht_monValues.size() == 0) {
                    this.putWarningMessageToLogfile("No data for " + this.entity);
                    return null;
                }
                Hashtable h_Measures = new Hashtable();
                h_Measures = (Hashtable)ht_monValues.get(testKey);
                if (h_Measures == null) {
                    return null;
                }
                return h_Measures;
            }
            catch (Exception grr) {
                this.putErrorMessageToLogfile("Exception in getData : " + grr.toString());
                grr.printStackTrace();
                return null;
            }
        }
    }

    public void printOut(String msg) {
        System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + msg);
    }

    public void putErrorMessageToLogfile(String msg) {
        this.logToErrorFile("ERROR :", String.valueOf(this.reportingName) + " : " + this.entity, msg);
    }

    public void putInfoMessageToLogfile(String msg) {
        this.logToErrorFile("INFO :", String.valueOf(this.reportingName) + " : " + this.entity, msg);
    }

    public void putWarningMessageToLogfile(String msg) {
        this.logToErrorFile("WARNING :", String.valueOf(this.reportingName) + " : " + this.entity, msg);
    }

    private void getXMLFormatRawData() {
        if (this.isFirstTime) {
            this.unSubcribe();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.isFirstTime = false;
        }
        this.connect();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.disconnect();
    }

    public static void main(String[] args) {
        IIBResourceStatisticsBase subsc = new IIBResourceStatisticsBase(args);
        while (true) {
            subsc.getXMLFormatRawData();
            System.out.println("All Hashtable values  :" + subsc.getFinalAllHashtable());
            try {
                Thread.sleep(60000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public Hashtable getFinalAllHashtable() {
        Hashtable<String, Hashtable> allHT = new Hashtable<String, Hashtable>();
        XMLReader reader = null;
        try {
            reader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e1) {
            e1.printStackTrace();
        }
        reader.setContentHandler(this.handler);
        this.printOut("Size of xmlStringArrayList is :" + this.xmlStringArrayList.size());
        Hashtable jvmMemoryHT = new Hashtable();
        Hashtable jvmGCHT = new Hashtable();
        Hashtable odbcHT = new Hashtable();
        Hashtable parsersHT = new Hashtable();
        Hashtable dotNetHT = new Hashtable();
        Hashtable securityHT = new Hashtable();
        Hashtable globalCacheHT = new Hashtable();
        Hashtable jmsHT = new Hashtable();
        Hashtable cicsHT = new Hashtable();
        Hashtable ftpHT = new Hashtable();
        Hashtable jdbcHT = new Hashtable();
        Hashtable decisionHT = new Hashtable();
        Hashtable tcpClientHT = new Hashtable();
        Hashtable tcpServerHT = new Hashtable();
        Hashtable soapHT = new Hashtable();
        int i = 0;
        while (i < this.xmlStringArrayList.size()) {
            String xmlString = (String)this.xmlStringArrayList.get(i);
            try {
                reader.parse(new InputSource(new StringReader(xmlString)));
                Hashtable data = this.handler.getAllDataHashtable();
                jvmMemoryHT = (Hashtable)data.get("JVM_Memory");
                jvmGCHT = (Hashtable)data.get("JVM_GC");
                odbcHT = (Hashtable)data.get("ODBC");
                parsersHT = (Hashtable)data.get("Parsers");
                dotNetHT = (Hashtable)data.get("DotNet_GC");
                securityHT = (Hashtable)data.get("Security");
                globalCacheHT = (Hashtable)data.get("GlobalCache");
                jmsHT = (Hashtable)data.get("JMS");
                cicsHT = (Hashtable)data.get("CICS");
                ftpHT = (Hashtable)data.get("FTP");
                jdbcHT = (Hashtable)data.get("JDBCConnectionPools");
                decisionHT = (Hashtable)data.get("DecisionServices");
                tcpClientHT = (Hashtable)data.get("TCPIPClientNodes");
                tcpServerHT = (Hashtable)data.get("TCPIPServerNodes");
                soapHT = (Hashtable)data.get("SOAPInput");
            }
            catch (Exception e) {
                this.putErrorMessageToLogfile("Exception while parse the XML file");
            }
            ++i;
        }
        allHT.put("JVM_Memory", jvmMemoryHT);
        allHT.put("JVM_GC", jvmGCHT);
        allHT.put("ODBC", odbcHT);
        allHT.put("Parsers", parsersHT);
        allHT.put("DotNet_GC", dotNetHT);
        allHT.put("Security", securityHT);
        allHT.put("GlobalCache", globalCacheHT);
        allHT.put("JMS", jmsHT);
        allHT.put("CICS", cicsHT);
        allHT.put("FTP", ftpHT);
        allHT.put("JDBCConnectionPools", jdbcHT);
        allHT.put("DecisionServices", decisionHT);
        allHT.put("TCPIPClientNodes", tcpClientHT);
        allHT.put("TCPIPServerNodes", tcpServerHT);
        allHT.put("SOAPInput", soapHT);
        return allHT;
    }

    private void connect() {
        boolean errFlag = false;
        this.printOut("JMS Connection proceding to connect");
        this.connection = this.getConnection();
        if (this.connection == null) {
            this.printOut("Could not get topic connection factory ..");
            return;
        }
        this.printOut("topic connection factory created ");
        boolean transacted = false;
        try {
            this.session = this.connection.createTopicSession(transacted, 1);
            this.connection.stop();
            this.subscriber = this.session.createDurableSubscriber(this.getTopic(), this.DESTINATION_NAME);
            this.xmlStringArrayList = new ArrayList();
            this.subscriber.setMessageListener((MessageListener)this);
            this.connection.start();
            if (EgTest.debug) {
                this.printOut("Message listener  and Topicconnection started ");
            }
        }
        catch (JMSException e) {
            errFlag = true;
            e.printStackTrace();
        }
        catch (Exception e) {
            errFlag = true;
            e.printStackTrace();
        }
        if (!errFlag) {
            this.printOut("Subscriber started.");
        }
    }

    public void onMessage(Message message) {
        try {
            String text;
            TextMessage tMessage = (TextMessage)message;
            String xmlString = text = tMessage.getText();
            this.xmlStringArrayList.add(xmlString);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlString)));
            this.printOut("OUTPUT  :  " + IIBResourceStatisticsBase.getStringFromDocument(doc));
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getStringFromDocument(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void disconnect() {
        try {
            this.subscriber.close();
            this.session.close();
            this.connection.stop();
            this.connection.close();
            this.printOut("Subscriber and connection are stopped and closed");
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void unSubcribe() {
        boolean isErrFlag = false;
        this.printOut("unSubcribing process starts very first time ");
        this.connection = this.getConnection();
        if (this.connection == null) {
            this.printOut("While unsubscribe the TopicConnection is null");
            isErrFlag = true;
        }
        boolean transacted = false;
        try {
            this.session = this.connection.createTopicSession(transacted, 1);
            this.subscriber = this.session.createDurableSubscriber(this.getTopic(), this.DESTINATION_NAME);
            this.subscriber.close();
            this.session.unsubscribe(this.DESTINATION_NAME);
            this.session.close();
            this.connection.stop();
            this.connection.close();
        }
        catch (JMSException e) {
            isErrFlag = true;
            e.printStackTrace();
        }
        catch (Exception e) {
            isErrFlag = true;
            e.printStackTrace();
        }
        if (!isErrFlag) {
            this.printOut("unSubcribing process sucessfully completed ");
        }
    }

    private boolean verifyConnection() {
        this.printOut("Connetion verification started ..");
        boolean flag = false;
        if (this.getConnection() == null || this.getTopic() == null) {
            flag = false;
            this.printOut("connection cannot be establish ,please check the topic connection factory and topics details");
        } else {
            flag = true;
            this.printOut("connection can be establish ");
        }
        return flag;
    }

    public TopicConnection getConnection() {
        Context context = this.getInitialContext();
        TopicConnectionFactory tcf = null;
        try {
            if (this.ldapBasedJNDI) {
                this.printOut("Topic Connection Factory name :" + this.TCF_NAME);
                tcf = (TopicConnectionFactory)context.lookup("cn=" + this.TCF_NAME);
            } else {
                this.printOut("Topic Connection Factory name :" + this.TCF_NAME);
                tcf = (TopicConnectionFactory)context.lookup(this.TCF_NAME);
            }
        }
        catch (NamingException e) {
            this.putErrorMessageToLogfile("Please check the TopicConnectionFactory name " + e.toString());
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TopicConnection topicConn = null;
        try {
            topicConn = tcf.createTopicConnection();
            topicConn.setClientID(this.CLIENT_ID);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return topicConn;
    }

    public Topic getTopic() {
        Topic topic = null;
        Context context = this.getInitialContext();
        try {
            if (this.ldapBasedJNDI) {
                this.printOut("Destination topic name :" + this.DESTINATION_NAME);
                topic = (Topic)context.lookup("cn=" + this.DESTINATION_NAME);
            } else {
                this.printOut("Destination topic name :" + this.DESTINATION_NAME);
                topic = (Topic)context.lookup(this.DESTINATION_NAME);
            }
        }
        catch (NamingException e) {
            this.putErrorMessageToLogfile("Please check the Destination name " + e.toString());
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return topic;
    }

    protected Context getInitialContext() {
        if (this.isFirstTimeInitialContext) {
            this.INITIAL_CONTEXT = this.getInitialContext(true);
            this.isFirstTimeInitialContext = false;
        }
        return this.INITIAL_CONTEXT;
    }

    protected Context getInitialContext(boolean override) {
        InitialContext context = null;
        Properties props = new Properties();
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.ldapBasedJNDI) {
            if (this.isSSL) {
                String javaHome = System.getProperty("java.home");
                String keystore = String.valueOf(javaHome) + "/lib/security/cacerts";
                System.setProperty("javax.net.ssl.trustStore", keystore);
                env.put("java.naming.security.protocol", "ssl");
            }
            env.put("java.naming.factory.initial", LDAP_BASED_CF_CLASS_NAME);
            env.put("java.naming.provider.url", this.WMQ_URL);
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", this.user_DN);
            env.put("java.naming.security.credentials", this.password);
            env.put("javax.security.sasl.qop", "auth-int");
            env.put("java.naming.referral", "follow");
        } else {
            ((Hashtable)props).put("java.naming.factory.initial", FILE_BASED_CF_CLASS_NAME);
            ((Hashtable)props).put("java.naming.provider.url", this.WMQ_URL);
        }
        try {
            if (this.ldapBasedJNDI) {
                context = new InitialContext(env);
                this.printOut("Sucessfully created LDAP based intial context");
            } else {
                context = new InitialContext(props);
                this.printOut("Sucessfully created file based intial context");
            }
        }
        catch (NamingException e) {
            String errMsg = "Failed to create intial context";
            this.printOut(errMsg);
            this.putErrorMessageToLogfile(errMsg);
            e.printStackTrace();
        }
        return context;
    }

    public String findUserDN(String ldapIP, String ConnectUserDN, String ConnectPwd, String Domain, String port, boolean ssl, String SearchUser) {
        String userDN = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        String validIP = ldapIP;
        String adminName = ConnectUserDN;
        String adminPassword = EgCrypt.decrypt(ConnectPwd);
        String ldapURL = "ldap://" + validIP + ":" + port;
        if (ssl) {
            String javaHome = System.getProperty("java.home");
            String keystore = String.valueOf(javaHome) + "/lib/security/cacerts";
            System.setProperty("javax.net.ssl.trustStore", keystore);
            env.put("java.naming.security.protocol", "ssl");
        }
        env.put("java.naming.factory.initial", LDAP_BASED_CF_CLASS_NAME);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", adminName);
        env.put("java.naming.security.credentials", adminPassword);
        env.put("javax.security.sasl.qop", "auth-int");
        env.put("java.naming.referral", "follow");
        env.put("java.naming.provider.url", ldapURL);
        InitialDirContext ctx = null;
        try {
            ctx = new InitialDirContext(env);
            SearchControls searchCtls = new SearchControls();
            String[] returnedAtts = new String[]{"distinguishedName"};
            searchCtls.setReturningAttributes(returnedAtts);
            searchCtls.setSearchScope(2);
            String searchFilter = "(&(objectClass=User)(objectCategory=person)(sAMAccountName=" + SearchUser + "))";
            String searchBase1 = this.getSearchBase(Domain);
            NamingEnumeration<SearchResult> answer = ctx.search(searchBase1, searchFilter, searchCtls);
            if (answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                userDN = sr.getName();
            }
            ctx.close();
            env = null;
        }
        catch (NamingException e) {
            e.printStackTrace();
            env = null;
            userDN = null;
        }
        return userDN;
    }

    private String getSearchBase(String domain) {
        String d = "DC=";
        StringTokenizer t = new StringTokenizer(domain, ".");
        String token = t.nextToken();
        d = String.valueOf(d) + token;
        while (t.hasMoreTokens()) {
            d = String.valueOf(d) + ",DC=" + t.nextToken();
        }
        return d;
    }
}

