/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class IIBStatisticsAccountingBase
extends GenericTest
implements MessageListener {
    private TopicConnection connection;
    private TopicSession session;
    private TopicSubscriber subscriber;
    private static final String FILE_BASED_CF_CLASS_NAME = "com.sun.jndi.fscontext.RefFSContextFactory";
    private static final String LDAP_BASED_CF_CLASS_NAME = "com.sun.jndi.ldap.LdapCtxFactory";
    private String WMQ_URL = null;
    private String TCF_NAME = null;
    private boolean isFirstTime = true;
    private String DESTINATION_NAME = null;
    private String CLIENT_ID = "";
    private Context INITIAL_CONTEXT = null;
    private boolean isFirstTimeInitialContext = true;
    IIBStatisticsAccountingParserHandler handler = new IIBStatisticsAccountingParserHandler();
    Hashtable measureData = new Hashtable();
    private static Hashtable syncHash = new Hashtable();
    private static final String syncString = new String("IIB");
    private static final String syncString2 = new String("IIB1");
    private static Hashtable ht_lastTime = new Hashtable();
    protected static Hashtable ht_ht_monValues = new Hashtable();
    private static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    private static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    private ArrayList xmlStringArrayList = new ArrayList();
    private boolean ldapBasedJNDI = false;
    private String user_DN = null;
    private String password = null;
    private String errorMessage = "";
    private String infoMessage = "";
    private boolean isSSL = false;

    public IIBStatisticsAccountingBase(String[] args) {
        super(args);
        String dummyDestinationName;
        String jndiNamespaceLocation = this.getValueForParam("jndi_Namespace_Location");
        this.ldapBasedJNDI = jndiNamespaceLocation != null && jndiNamespaceLocation.trim().length() != 0 && !jndiNamespaceLocation.equalsIgnoreCase("FILE");
        this.user_DN = this.getValueForParam("user_DN");
        this.password = this.getValueForParam("password");
        String strSSL = this.getValueForParam("ssl");
        if (this.ldapBasedJNDI) {
            if (this.user_DN == null || this.user_DN.trim().length() == 0 || this.user_DN.equalsIgnoreCase("NONE")) {
                this.errorMessage = " Please provide a valid User DN";
                this.printOut(this.errorMessage);
                this.putErrorMessageToLogfile(this.errorMessage);
            }
            if (this.password == null || this.password.trim().length() == 0 || this.password.equalsIgnoreCase("NONE")) {
                this.errorMessage = " Please provide a valid password";
                this.printOut(this.errorMessage);
                this.putErrorMessageToLogfile(this.errorMessage);
            }
            this.isSSL = strSSL != null && strSSL.trim().length() != 0 && !strSSL.equalsIgnoreCase("FALSE");
        } else {
            this.user_DN = "NONE";
            this.password = "NONE";
        }
        this.WMQ_URL = this.getValueForParam("jndi_Provider_URL");
        if (this.WMQ_URL == null || this.WMQ_URL.trim().length() == 0) {
            this.errorMessage = "Please provide the JNDI provider URL ";
            this.printOut(this.errorMessage);
            this.putErrorMessageToLogfile(this.errorMessage);
        }
        this.TCF_NAME = this.getValueForParam("topicConnectionFactory");
        if (this.TCF_NAME == null || this.TCF_NAME.trim().length() == 0) {
            this.errorMessage = "Please provide the Topic Connection Factory name ";
            this.printOut(this.errorMessage);
            this.putErrorMessageToLogfile(this.errorMessage);
        }
        this.DESTINATION_NAME = this.getValueForParam("JMS_Flow_Stats");
        if (this.DESTINATION_NAME == null || this.DESTINATION_NAME.trim().length() == 0) {
            this.errorMessage = "Please provide the JMS_Flow_Stats(Statistics accounting destination) name ";
            this.printOut(this.errorMessage);
            this.putErrorMessageToLogfile(this.errorMessage);
        }
        if ((dummyDestinationName = this.getValueForParam("JMS_Resource_Stats")) == null || dummyDestinationName.trim().length() == 0) {
            this.errorMessage = "Please provide the JMS_Resource_Stats(resource statiscics destination)  name ";
            this.printOut(this.errorMessage);
            this.putErrorMessageToLogfile(this.errorMessage);
        }
        this.infoMessage = "Reporting Name :" + this.reportingName;
        this.printOut(this.infoMessage);
        this.infoMessage = "Destination Name :" + this.DESTINATION_NAME;
        this.printOut(this.infoMessage);
        this.CLIENT_ID = String.valueOf(this.reportingName) + "_" + this.portNo;
        this.infoMessage = "CLIENT_ID  :" + this.CLIENT_ID;
        this.printOut(this.infoMessage);
        this.fixedTestPeriod = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setData() {
        String string;
        long startTime = 0L;
        long totalStartTime = System.currentTimeMillis();
        boolean dataStatus = false;
        String mySync = "";
        mySync = (String)syncHash.get(this.targetHost);
        if (mySync == null || mySync.trim().length() == 0) {
            string = syncString;
            synchronized (string) {
                mySync = (String)syncHash.get(this.targetHost);
                if (mySync == null) {
                    syncHash.put(this.targetHost, new String(this.targetHost));
                    mySync = (String)syncHash.get(this.targetHost);
                }
            }
        }
        string = mySync;
        synchronized (string) {
            long diff;
            long now = System.currentTimeMillis();
            Long l = null;
            try {
                l = (Long)ht_lastTime.get(String.valueOf(this.reportingName) + "_" + this.portNo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long lastTime = 0L;
            if (l != null) {
                lastTime = l;
            }
            if ((double)(diff = now - lastTime) >= 0.9 * (double)this.measurePeriod) {
                dataStatus = false;
                lastTime = now;
                String string2 = syncString2;
                synchronized (string2) {
                    try {
                        if (ht_ht_monValues != null) {
                            this.measureData = (Hashtable)ht_ht_monValues.get(String.valueOf(this.reportingName) + "_" + this.portNo);
                            if (this.measureData != null) {
                                ht_ht_monValues.remove(String.valueOf(this.reportingName) + "_" + this.portNo);
                            }
                        } else {
                            ht_ht_monValues = new Hashtable();
                        }
                        ht_lastTime.put(String.valueOf(this.reportingName) + "_" + this.portNo, new Long(lastTime));
                    }
                    catch (Exception grr) {
                        return;
                    }
                }
            }
            dataStatus = true;
            this.printOut("IIB data status :" + dataStatus);
            if (!dataStatus) {
                long t1 = System.currentTimeMillis();
                try {
                    this.printOut("Verifying connection ");
                    if (!this.verifyConnection()) {
                        String string3 = syncString2;
                        synchronized (string3) {
                            try {
                                ht_lastTime.put(String.valueOf(this.reportingName) + "_" + this.portNo, new Long(System.currentTimeMillis()));
                            }
                            catch (Exception grr) {
                                this.printOut("Exception while setting data values (after connection failure) : " + grr.toString());
                            }
                        }
                        this.printOut("server:" + this.reportingName + "_" + this.portNo);
                        return;
                    }
                    this.measureData = new Hashtable();
                    startTime = System.currentTimeMillis();
                    this.printOut("Tracing - - verifyConnection  took " + (startTime - t1) + " millisecs");
                    Hashtable messageFlowMetrics = new Hashtable();
                    Hashtable threadStatisticsMetrics = new Hashtable();
                    Hashtable nodeStatisticsMetrics = new Hashtable();
                    Hashtable statisticsInterval = new Hashtable();
                    this.getXMLFormatRawData();
                    Hashtable allDataHT = this.getFinalAllHashtable();
                    messageFlowMetrics = (Hashtable)allDataHT.get("MSG");
                    threadStatisticsMetrics = (Hashtable)allDataHT.get("THREAD");
                    nodeStatisticsMetrics = (Hashtable)allDataHT.get("NODE");
                    statisticsInterval = (Hashtable)allDataHT.get("INTERVAL");
                    this.printOut("Data Collected for  " + this.targetHost + "  for message flow  metrics " + (System.currentTimeMillis() - startTime) + "ms.");
                    this.measureData.put("MESSAGE_FLOW", messageFlowMetrics);
                    this.measureData.put("THREAD_STATS", threadStatisticsMetrics);
                    this.measureData.put("NODE_STATS", nodeStatisticsMetrics);
                    this.measureData.put("INTERVAL_VALUE", statisticsInterval);
                    String string4 = syncString2;
                    synchronized (string4) {
                        try {
                            if (ht_ht_monValues == null) {
                                ht_ht_monValues = new Hashtable();
                            }
                            ht_ht_monValues.put(String.valueOf(this.reportingName) + "_" + this.portNo, this.measureData);
                            ht_lastTime.put(String.valueOf(this.reportingName) + "_" + this.portNo, new Long(System.currentTimeMillis()));
                        }
                        catch (Exception grr) {
                            this.printOut("Exception while setting data values  : " + grr.toString());
                        }
                    }
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
            this.printOut("setData took " + (System.currentTimeMillis() - totalStartTime) + "ms.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getData(String testKey) {
        Hashtable ht_monValues = null;
        String string = syncString2;
        synchronized (string) {
            try {
                if (ht_ht_monValues == null) {
                    return null;
                }
                ht_monValues = (Hashtable)ht_ht_monValues.get(String.valueOf(this.reportingName) + "_" + this.portNo);
                if (ht_monValues == null || ht_monValues.size() == 0) {
                    this.putWarningMessageToLogfile("No data for " + this.entity);
                    return null;
                }
                Hashtable h_Measures = new Hashtable();
                h_Measures = (Hashtable)ht_monValues.get(testKey);
                if (h_Measures == null) {
                    return null;
                }
                return h_Measures;
            }
            catch (Exception grr) {
                this.putErrorMessageToLogfile("Exception in getData : " + grr.toString());
                grr.printStackTrace();
                return null;
            }
        }
    }

    public void printOut(String msg) {
        System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + msg);
    }

    public void putErrorMessageToLogfile(String msg) {
        this.logToErrorFile("ERROR :", String.valueOf(this.reportingName) + " : " + this.entity, msg);
    }

    public void putInfoMessageToLogfile(String msg) {
        this.logToErrorFile("INFO :", String.valueOf(this.reportingName) + " : " + this.entity, msg);
    }

    public void putWarningMessageToLogfile(String msg) {
        this.logToErrorFile("WARNING :", String.valueOf(this.reportingName) + " : " + this.entity, msg);
    }

    private void getXMLFormatRawData() {
        if (this.isFirstTime) {
            this.unSubcribe();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.isFirstTime = false;
        }
        this.connect();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.disconnect();
    }

    public static void main(String[] args) {
        IIBStatisticsAccountingBase subsc = new IIBStatisticsAccountingBase(args);
        while (true) {
            subsc.getXMLFormatRawData();
            System.out.println("All Hashtable values  :" + subsc.getFinalAllHashtable());
            try {
                Thread.sleep(60000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public Hashtable getFinalAllHashtable() {
        Hashtable<String, Hashtable> allHT = new Hashtable<String, Hashtable>();
        XMLReader reader = null;
        try {
            reader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e1) {
            e1.printStackTrace();
        }
        reader.setContentHandler(this.handler);
        this.printOut("Size of xmlStringArrayList is :" + this.xmlStringArrayList.size());
        Hashtable msgHT1 = new Hashtable();
        Hashtable threadHT1 = new Hashtable();
        Hashtable nodeHT1 = new Hashtable();
        Hashtable intervalHT1 = new Hashtable();
        int i = 0;
        while (i < this.xmlStringArrayList.size()) {
            String xmlString = (String)this.xmlStringArrayList.get(i);
            try {
                reader.parse(new InputSource(new StringReader(xmlString)));
                Hashtable data = this.handler.getAllDataHashtable();
                Hashtable msgHT2 = (Hashtable)data.get("MSG");
                msgHT1 = this.addingDatas(i, msgHT1, msgHT2);
                Hashtable threadHT2 = (Hashtable)data.get("THREAD");
                threadHT1 = this.addingDatas(i, threadHT1, threadHT2);
                Hashtable nodeHT2 = (Hashtable)data.get("NODE");
                nodeHT1 = this.addingDatas(i, nodeHT1, nodeHT2);
                Hashtable intervalHT2 = (Hashtable)data.get("INTERVAL");
                intervalHT1 = this.addingDatas(i, intervalHT1, intervalHT2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        allHT.put("MSG", msgHT1);
        allHT.put("THREAD", threadHT1);
        allHT.put("NODE", nodeHT1);
        allHT.put("INTERVAL", intervalHT1);
        if (EgTest.debug) {
            this.printOut("Messsage flow Hashtable :" + msgHT1);
            this.printOut("Thread Hashtable :" + threadHT1);
            this.printOut("Node Hashtable :" + nodeHT1);
            this.printOut("Interval Hashtable :" + intervalHT1);
        }
        return allHT;
    }

    private Hashtable addingDatas(int i, Hashtable HT1, Hashtable HT2) {
        boolean insideDebug = false;
        ArrayList<Double> ar3 = null;
        if (insideDebug) {
            this.printOut("HT2    :" + HT2 + " Time :" + new Date());
        }
        if (i == 0) {
            HT1 = new Hashtable<String, ArrayList>(HT2);
            if (insideDebug) {
                this.printOut("i is 0 so HT1= HT2 assigned ");
            }
        } else {
            if (insideDebug) {
                this.printOut("i value is  " + i);
            }
            Enumeration en1 = HT2.keys();
            while (en1.hasMoreElements()) {
                String key = (String)en1.nextElement();
                if (insideDebug) {
                    this.printOut("HT2 key  :" + key);
                }
                if (HT1.containsKey(key)) {
                    ArrayList ar1 = (ArrayList)HT1.get(key);
                    ArrayList ar2 = (ArrayList)HT2.get(key);
                    if (insideDebug) {
                        this.printOut("ar1 size is : " + ar1.size() + "  ar1 value is :" + ar1);
                        this.printOut("ar2 size is : " + ar2.size() + "  ar2 value is :" + ar2);
                    }
                    if (ar1.size() == ar2.size()) {
                        ar3 = new ArrayList<Double>(ar1.size());
                        int j = 0;
                        while (j < ar1.size()) {
                            double d1 = (Double)ar1.get(j);
                            double d2 = (Double)ar2.get(j);
                            ar3.add(new Double(d1 + d2));
                            ++j;
                        }
                    } else {
                        if (insideDebug) {
                            this.printOut("ArrayList size does not match .....So re-assinging ar3 value");
                        }
                        HT1.put(key, ar1);
                    }
                    HT1.put(key, ar3);
                } else {
                    ArrayList ar4 = (ArrayList)HT2.get(key);
                    HT1.put(key, ar4);
                }
                if (!insideDebug) continue;
                this.printOut("HT1  value is  :" + HT1);
            }
        }
        return HT1;
    }

    private void connect() {
        boolean errFlag = false;
        this.printOut("JMS Connection proceding to connect");
        this.connection = this.getConnection();
        if (this.connection == null) {
            this.printOut("Could not get topic connection factory ..");
            return;
        }
        this.printOut("topic connection factory created ");
        boolean transacted = false;
        try {
            this.session = this.connection.createTopicSession(transacted, 1);
            this.connection.stop();
            this.subscriber = this.session.createDurableSubscriber(this.getTopic(), this.DESTINATION_NAME);
            this.xmlStringArrayList = new ArrayList();
            this.subscriber.setMessageListener((MessageListener)this);
            this.connection.start();
            if (EgTest.debug) {
                this.printOut("Message listener  and Topicconnection started ");
            }
        }
        catch (JMSException e) {
            errFlag = true;
            e.printStackTrace();
        }
        catch (Exception e) {
            errFlag = true;
            e.printStackTrace();
        }
        if (!errFlag) {
            this.printOut("Subscriber started.");
        }
    }

    public void onMessage(Message message) {
        try {
            String text;
            TextMessage tMessage = (TextMessage)message;
            String xmlString = text = tMessage.getText();
            this.xmlStringArrayList.add(xmlString);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(text)));
            this.printOut("OUTPUT  :  " + IIBStatisticsAccountingBase.getStringFromDocument(doc));
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getStringFromDocument(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void disconnect() {
        try {
            this.subscriber.close();
            this.session.close();
            this.connection.stop();
            this.connection.close();
            this.printOut("Subscriber and connection are stopped and closed");
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void unSubcribe() {
        boolean isErrFlag = false;
        this.printOut("unSubcribing process starts very first time ");
        this.connection = this.getConnection();
        if (this.connection == null) {
            this.printOut("While unsubscribe the TopicConnection is null");
            isErrFlag = true;
        }
        boolean transacted = false;
        try {
            this.session = this.connection.createTopicSession(transacted, 1);
            this.subscriber = this.session.createDurableSubscriber(this.getTopic(), this.DESTINATION_NAME);
            this.subscriber.close();
            this.session.unsubscribe(this.DESTINATION_NAME);
            this.session.close();
            this.connection.stop();
            this.connection.close();
        }
        catch (JMSException e) {
            isErrFlag = true;
            e.printStackTrace();
        }
        catch (Exception e) {
            isErrFlag = true;
            e.printStackTrace();
        }
        if (!isErrFlag) {
            this.printOut("unSubcribing process sucessfully completed ");
        }
    }

    private boolean verifyConnection() {
        this.printOut("Connetion verification started ..");
        boolean flag = false;
        if (this.getConnection() == null || this.getTopic() == null) {
            flag = false;
            this.printOut("connection cannot be establish ,please check the topic connection factory and topics details");
        } else {
            flag = true;
            this.printOut("connection can be establish ");
        }
        return flag;
    }

    public TopicConnection getConnection() {
        Context context = this.getInitialContext();
        TopicConnectionFactory tcf = null;
        try {
            if (this.ldapBasedJNDI) {
                this.printOut("Topic Connection Factory name :" + this.TCF_NAME);
                tcf = (TopicConnectionFactory)context.lookup("cn=" + this.TCF_NAME);
            } else {
                this.printOut("Topic Connection Factory name :" + this.TCF_NAME);
                tcf = (TopicConnectionFactory)context.lookup(this.TCF_NAME);
            }
        }
        catch (NamingException e) {
            this.putErrorMessageToLogfile("Please check the TopicConnectionFactory name " + e.toString());
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TopicConnection topicConn = null;
        try {
            topicConn = tcf.createTopicConnection();
            topicConn.setClientID(this.CLIENT_ID);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return topicConn;
    }

    public Topic getTopic() {
        Topic topic = null;
        Context context = this.getInitialContext();
        try {
            if (this.ldapBasedJNDI) {
                this.printOut("Destination topic name :" + this.DESTINATION_NAME);
                topic = (Topic)context.lookup("cn=" + this.DESTINATION_NAME);
            } else {
                this.printOut("Destination topic name :" + this.DESTINATION_NAME);
                topic = (Topic)context.lookup(this.DESTINATION_NAME);
            }
        }
        catch (NamingException e) {
            this.putErrorMessageToLogfile("Please check the Destination name " + e.toString());
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return topic;
    }

    protected Context getInitialContext() {
        if (this.isFirstTimeInitialContext) {
            this.INITIAL_CONTEXT = this.getInitialContext(true);
            this.isFirstTimeInitialContext = false;
        }
        return this.INITIAL_CONTEXT;
    }

    protected Context getInitialContext(boolean override) {
        InitialContext context = null;
        Properties props = new Properties();
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.ldapBasedJNDI) {
            if (this.isSSL) {
                String javaHome = System.getProperty("java.home");
                String keystore = String.valueOf(javaHome) + "/lib/security/cacerts";
                System.setProperty("javax.net.ssl.trustStore", keystore);
                env.put("java.naming.security.protocol", "ssl");
            }
            env.put("java.naming.factory.initial", LDAP_BASED_CF_CLASS_NAME);
            env.put("java.naming.provider.url", this.WMQ_URL);
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", this.user_DN);
            env.put("java.naming.security.credentials", this.password);
            env.put("javax.security.sasl.qop", "auth-int");
            env.put("java.naming.referral", "follow");
        } else {
            ((Hashtable)props).put("java.naming.factory.initial", FILE_BASED_CF_CLASS_NAME);
            ((Hashtable)props).put("java.naming.provider.url", this.WMQ_URL);
        }
        try {
            if (this.ldapBasedJNDI) {
                context = new InitialContext(env);
                this.printOut("Sucessfully created LDAP based intial context");
            } else {
                context = new InitialContext(props);
                this.printOut("Sucessfully created file based intial context");
            }
        }
        catch (NamingException e) {
            String errMsg = "Failed to create intial context";
            this.printOut(errMsg);
            this.putErrorMessageToLogfile(errMsg);
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return context;
    }
}

