/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

class LtmVSrvDetailsTest
extends EgSnmpGenericTest {
    private Hashtable prevBytesIn = new Hashtable();
    private Hashtable prevBytesOut = new Hashtable();
    private Hashtable prevPktsIn = new Hashtable();
    private Hashtable prevPktsOut = new Hashtable();
    private Hashtable prevTotConns = new Hashtable();
    private Hashtable prevTotReq = new Hashtable();
    private static final double BYTE_TO_MB = 1048576.0;
    private static int numMeasures = 12;
    public static boolean ft = true;

    public LtmVSrvDetailsTest(String[] stringArray) {
        super(stringArray);
        Object object;
        if (ft) {
            ft = false;
            object = new EgThresholdInfo("agent");
            String[] stringArray2 = ((com.eg.EgThresholdInfo)object).getMeasurementsForTest("LtmVSrvDetailsTest");
            if (stringArray2 != null) {
                numMeasures = stringArray2.length;
            }
            object = null;
        }
        this.setMeasureCount(numMeasures);
        object = new double[numMeasures];
        for (int i = 0; i < numMeasures; ++i) {
            object[i] = -5.0;
        }
        this.setDefaultFinalValues((double[])object);
        this.eg_default_value = -5L;
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            Hashtable hashtable2 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.10.2.3.1.1");
            Hashtable hashtable3 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.10.2.3.1.7");
            Hashtable hashtable4 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.10.2.3.1.9");
            Hashtable hashtable5 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.10.2.3.1.6");
            Hashtable hashtable6 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.10.2.3.1.8");
            Hashtable hashtable7 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.10.2.3.1.12");
            Hashtable hashtable8 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.10.2.3.1.11");
            Hashtable hashtable9 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.10.2.3.1.10");
            Hashtable hashtable10 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.10.2.3.1.27");
            Hashtable hashtable11 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.10.2.3.1.4");
            Hashtable hashtable12 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.10.2.3.1.32");
            if (hashtable2 == null || hashtable2.size() == 0) {
                this.logToErrorFile("Error :", "LtmVSrvDetailsTest error occured in Compute Measures for ", this.targetHost);
            }
            Hashtable hashtable13 = this.getDiff(hashtable3, this.prevBytesIn, true);
            Hashtable hashtable14 = this.getDiff(hashtable4, this.prevBytesOut, true);
            Hashtable hashtable15 = this.getDiff(hashtable5, this.prevPktsIn, false);
            Hashtable hashtable16 = this.getDiff(hashtable6, this.prevPktsOut, false);
            Hashtable hashtable17 = this.getDiff(hashtable10, this.prevTotReq, false);
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable2.get(string);
                String string3 = (String)hashtable8.get(string);
                String string4 = (String)hashtable7.get(string);
                String string5 = (String)hashtable9.get(string);
                String string6 = (String)this.prevTotConns.get(string);
                String string7 = (String)hashtable11.get(string);
                String string8 = (String)hashtable12.get(string);
                if (string3 == null || string3.length() == 0) {
                    string3 = "-5";
                }
                if (string4 == null || string4.length() == 0) {
                    string4 = "-5";
                }
                if (string5 == null || string5.length() == 0) {
                    string5 = "-5";
                }
                if (string7 == null || string7.length() == 0) {
                    string7 = "-5";
                }
                if (string8 == null || string8.length() == 0) {
                    string8 = "-5";
                }
                double d = this.getDoubleValue(string6);
                double d2 = this.getDoubleValue(string4);
                double d3 = this.getDoubleValue(string3);
                double d4 = -5.0;
                double d5 = -5.0;
                if (d3 >= 0.0 && d >= 0.0) {
                    d5 = d3 - d;
                }
                if (d5 > 0.0 && d5 >= d2) {
                    d4 = d2 / d5 * 100.0;
                }
                if (d4 < 0.0) {
                    d4 = -5.0;
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(this.getValue(hashtable14, string));
                arrayList.add(this.getValue(hashtable13, string));
                arrayList.add(this.getValue(hashtable16, string));
                arrayList.add(this.getValue(hashtable15, string));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d5));
                arrayList.add(new Double(d4));
                arrayList.add(new Double(string5));
                arrayList.add(this.getValue(hashtable17, string));
                if (numMeasures > 10) {
                    arrayList.add(new Double(string8));
                    arrayList.add(new Double(string7));
                }
                System.out.println("[LtmVSrvDetailsTest]info===>" + string2 + "  measure===>" + arrayList);
                this.addNewMeasure(string2, arrayList);
            }
            this.prevBytesIn = hashtable3;
            this.prevBytesOut = hashtable4;
            this.prevPktsIn = hashtable5;
            this.prevPktsOut = hashtable6;
            this.prevTotConns = hashtable8;
            this.prevTotReq = hashtable10;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Hashtable getDiff(Hashtable hashtable, Hashtable hashtable2, boolean bl) {
        Hashtable<String, Double> hashtable3 = new Hashtable<String, Double>();
        if (hashtable == null || hashtable2 == null) {
            return hashtable3;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            String string3 = (String)hashtable2.get(string);
            if (string3 == null) {
                hashtable3.put(string, new Double(-5.0));
                continue;
            }
            if (string2 == null) continue;
            try {
                double d = -5.0;
                double d2 = this.getDoubleValue(string2);
                double d3 = this.getDoubleValue(string3);
                if (d2 >= 0.0 && d3 >= 0.0) {
                    d = d2 - d3;
                    if (bl) {
                        d /= 1048576.0;
                    }
                    d = this.timeSinceLastTest > 0.0 && d >= 0.0 ? (d /= this.timeSinceLastTest) : -5.0;
                }
                hashtable3.put(string, new Double(d));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return hashtable3;
    }

    public Hashtable getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "";
        String string3 = "";
        try {
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    if (this.lhs[i].startsWith(".")) continue;
                    string2 = this.lhs[i];
                    string3 = this.rhs[i];
                    hashtable.put(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "LtmVSrvDetailsTest error occured in getMeasures", exception.toString());
            exception.printStackTrace();
        }
        return hashtable;
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            d = string != null && string.trim().length() > 0 ? Double.parseDouble(string) : -5.0;
        }
        catch (Exception exception) {
            System.out.println("Exception in getDoubleValue Method:" + exception);
            exception.printStackTrace();
        }
        return d;
    }

    private Double getValue(Hashtable hashtable, String string) {
        Double d = new Double(-5.0);
        if (hashtable == null) {
            return d;
        }
        try {
            Double d2 = (Double)hashtable.get(string);
            if (d2 == null) {
                return d;
            }
            return d2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return d;
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "10.1.1.5", "-port", "NULL", "-snmpPort", "161", "-snmpversion", "v1", "-snmpCommunity", "public"};
        LtmVSrvDetailsTest ltmVSrvDetailsTest = new LtmVSrvDetailsTest(stringArray);
        ltmVSrvDetailsTest.computeMeasures(new Hashtable());
    }
}

