/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import com.egurkha.util.EgJNIUtil;
import com.egurkha.util.EgUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;

public class MainAgentHelper
extends Thread {
    ArrayList perfObjs = new ArrayList();
    boolean doPerfmonCheck = false;
    ArrayList perfCounters = new ArrayList();
    boolean recoveryStarted = false;
    public long stampPeriod = 5L * EgConfigInfo.msecPerMin;
    private long prev_stamp = 0L;
    private boolean toRestart = false;
    private long lastIpCheckTime = System.currentTimeMillis();
    private long ipCheckTimeout = 2L * EgConfigInfo.msecPerHour;
    private static EgJNIUtil egPerfUtil = null;
    private boolean isInit = false;
    private static boolean currentDebug = false;
    private static String debugIni = null;
    private static boolean isFirstTime = true;
    private static boolean is64BitAgent = false;
    public static boolean isJsMaxMem = false;
    private static int xmxValue = 128;
    public static String debugSync = new String("debugSync");
    private double JsHandle = 0.0;

    public MainAgentHelper() {
    }

    public MainAgentHelper(boolean bl, ArrayList arrayList, ArrayList arrayList2) {
        this.doPerfmonCheck = bl;
        this.perfObjs = arrayList;
        this.perfCounters = arrayList2;
        this.isInit = true;
    }

    private boolean hasIpChanged() {
        String[] stringArray = EgMainAgent.getIpAddressesOfHost();
        if (stringArray == null && EgMainAgent.ipAddresses != null) {
            return false;
        }
        if (EgMainAgent.ipAddresses == null && stringArray != null) {
            return false;
        }
        if (stringArray.length != EgMainAgent.ipAddresses.length) {
            this.logToErrorFile("WARN", "MainAgentHelper", "IP Addresses has been changed!. IP Addresses of Host length is " + stringArray.length + " EgMainAgent IP Addresses length is " + EgMainAgent.ipAddresses.length);
            this.logToErrorFile("WARN", "MainAgentHelper", "IP Addresses of Host is " + new ArrayList<String>(Arrays.asList(stringArray)).toString());
            this.logToErrorFile("WARN", "MainAgentHelper", "EgMainAgent IP Addresses is " + new ArrayList<String>(Arrays.asList(EgMainAgent.ipAddresses)).toString());
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < EgMainAgent.ipAddresses.length; ++j) {
                if (!EgMainAgent.ipAddresses[j].equals(stringArray[i])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.logToErrorFile("WARN", "MainAgentHelper", "IP Addresses could not find!. IP Addresses of Host length is " + stringArray.length + " EgMainAgent IP Addresses length is " + EgMainAgent.ipAddresses.length);
            this.logToErrorFile("WARN", "MainAgentHelper", "IP Addresses of Host is " + new ArrayList<String>(Arrays.asList(stringArray)).toString());
            this.logToErrorFile("WARN", "MainAgentHelper", "EgMainAgent IP Addresses is " + new ArrayList<String>(Arrays.asList(EgMainAgent.ipAddresses)).toString());
            return true;
        }
        return false;
    }

    private boolean checkPerfmon() {
        boolean bl = true;
        if (this.perfObjs == null || this.perfObjs.size() == 0 || this.perfObjs.size() != this.perfCounters.size()) {
            return true;
        }
        for (int i = 0; i < this.perfObjs.size(); ++i) {
            bl = false;
            String string = (String)this.perfObjs.get(i);
            String string2 = (String)this.perfCounters.get(i);
            String[] stringArray = EgJNIUtil.discoverInstances((String)string);
            if (stringArray == null || stringArray.length == 0) {
                this.logToErrorFile("WARN", "MainAgentHelper", "Perfmon check failed to get instances for object " + string + " counter " + string2);
                return false;
            }
            if (string.equalsIgnoreCase("Process")) continue;
            egPerfUtil = new EgJNIUtil();
            String[] stringArray2 = new String[]{string2};
            double[][] dArray = egPerfUtil.getCounterValue(string, stringArray, stringArray2);
            if (egPerfUtil != null) {
                egPerfUtil.stop();
            }
            egPerfUtil = null;
            if (dArray == null) {
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
                this.logToErrorFile("WARN", "MainAgentHelper", "Perfmon check failed for the object " + string + " instances " + arrayList.toString());
                this.logToErrorFile("WARN", "MainAgentHelper", "Perfmon check failed for the object " + string + " counter " + string2);
                return false;
            }
            for (int j = 0; j < stringArray.length; ++j) {
                if (!(dArray[j][0] >= 0.0)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.logToErrorFile("WARN", "MainAgentHelper", "Perfmon check failed to get valid values for object " + string + " counter " + string2);
            return false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCurrentLocalTime(long l) {
        long l2 = System.currentTimeMillis();
        Object object = EgMainAgent.syncMgrUpload;
        synchronized (object) {
            if (EgMainAgent.mgrUpload != null) {
                long l3 = l2 - EgMainAgent.mgrUpload.lastUpdated;
                System.out.println("MgrUpload check currentTime " + new Date(l2) + " last updated " + new Date(EgMainAgent.mgrUpload.lastUpdated) + l3);
                if (l3 >= EgConfigInfo.msecPerMin * 20L) {
                    for (int i = 0; i < 3; ++i) {
                        try {
                            EgMainAgent.mgrUpload.interrupt();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            Thread.currentThread();
                            Thread.sleep(2000L);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        EgMainAgent.mgrUpload.stop();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.out.println("To restart MgrUpload at ... " + new Date());
                    EgMainAgent.mgrUpload = new EgMgrUpload(EgMainAgent.me);
                    System.out.println("After restart MgrUpload at ... " + new Date());
                }
            } else {
                System.out.println("To start MgrUpload at ... " + new Date());
                EgMainAgent.mgrUpload = new EgMgrUpload(EgMainAgent.me);
                System.out.println("After start MgrUpload at ... " + new Date());
            }
        }
        try {
            object = new Properties();
            File file = new File(EgInstallInfo.getInstallDir() + "/agent/config/eg_recover.ini");
            if (!file.exists()) {
                file.createNewFile();
            }
            ((Properties)object).setProperty("CurrentTime", "" + l);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((Properties)object).store(fileOutputStream, null);
            fileOutputStream.close();
            file = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void startRecovery() {
        System.out.println("Starting the recovery Process");
        try {
            String string = "net start eGAgentmon";
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList = egUtilities.getExecOutputLines(string);
        }
        catch (Exception exception) {
            System.out.println("Failed to start eGurkha Agent self monitor!");
        }
    }

    public void run() {
        while (true) {
            this.doWork();
            this.sleepFor(this.stampPeriod);
        }
    }

    public void doWork() {
        long l;
        if (!this.isInit) {
            return;
        }
        long l2 = System.currentTimeMillis();
        if (EgMainAgent.hasChgMgrIPorDNSRestartRequired) {
            l = EgMgrUpload.lastSuccessfulUploadTime;
            long l3 = EgMgrUpload.lastUploadAttemptTime;
            long l4 = EgMainAgent.hasChgMgrIPorDNSRestartRequiredTime;
            if (l4 > 0L && l2 - l > l4 && l2 - l3 < l4) {
                this.toRestart = true;
                this.writeCurrentLocalTime(l2 - EgConfigInfo.msecPerMin * 15L);
                this.logToErrorFile("WARN", "MainAgentHelper", "Agent does not detect the IP Addresses or DNS name during migration. So restart the eGAgent");
            }
        }
        if (l2 - this.lastIpCheckTime >= this.ipCheckTimeout) {
            if (!this.toRestart && EgMainAgent.hasIPChangedToRestartAgent && this.hasIpChanged()) {
                this.toRestart = true;
                this.writeCurrentLocalTime(l2 - EgConfigInfo.msecPerMin * 15L);
                this.logToErrorFile("WARN", "MainAgentHelper", "IP Addresses has been changed!. So restart the eGAgent");
            }
            this.lastIpCheckTime = System.currentTimeMillis();
        }
        if (!this.toRestart && EgMainAgent.isRunningWinpcap && EgMainAgent.winpCapRestart > 0L && l2 - EgMainAgent.agentStartTime > EgMainAgent.winpCapRestart) {
            this.toRestart = true;
            this.writeCurrentLocalTime(l2 - EgConfigInfo.msecPerMin * 15L);
            this.logToErrorFile("WARN", "MainAgentHelper", "WinPcap restart!. So restart the eGAgent");
        }
        this.setJsMaxMemory();
        if (!this.toRestart && isJsMaxMem && EgMainAgent.isRestartAgent) {
            this.toRestart = true;
            this.writeCurrentLocalTime(l2 - EgConfigInfo.msecPerMin * 15L);
            this.logToErrorFile("WARN", "MainAgentHelper", "eGAgent has reached maximum memory configured!. So restart the eGAgent");
        }
        if (!this.toRestart && EgMainAgent.jsHandleCount != -1L) {
            double d = this.getJsMemory();
            if (this.JsHandle >= (double)EgMainAgent.jsHandleCount) {
                this.toRestart = true;
                this.writeCurrentLocalTime(l2 - EgConfigInfo.msecPerMin * 15L);
                this.JsHandle = 0.0;
                this.logToErrorFile("WARN", "MainAgentHelper", "eGAgent has reached the maximum handle count!. So restart the eGAgent");
            }
        }
        if ((l = System.currentTimeMillis()) - this.prev_stamp >= this.stampPeriod) {
            if (!(this.doPerfmonCheck && !this.checkPerfmon() || this.toRestart)) {
                this.writeCurrentLocalTime(l);
            }
            this.prev_stamp = l;
            if (!this.recoveryStarted) {
                this.startRecovery();
                this.recoveryStarted = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkForDebugOnOff() {
        boolean bl;
        String string = "";
        String string2 = debugSync;
        synchronized (string2) {
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_output.ini");
            string = iniFile.getValue("OUTPUT", "Output");
        }
        boolean bl2 = bl = string != null && (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("t"));
        if (currentDebug) {
            if (!bl) {
                MainAgentHelper.setDebugOff();
            }
        } else if (bl) {
            MainAgentHelper.setDebugOn();
        } else {
            MainAgentHelper.setDebugOff();
        }
    }

    public static synchronized boolean setDebugOff() {
        currentDebug = false;
        return EgAgentLogController.setDebugOff();
    }

    public static synchronized boolean setDebugOn() {
        currentDebug = true;
        return EgAgentLogController.setDebugOn();
    }

    private void sleepFor(long l) {
        long l2 = System.currentTimeMillis() + l;
        long l3 = l;
        while (l3 > 0L) {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            } else if (l3 > EgAgentCommon.maxSleep) {
                l3 = EgAgentCommon.maxSleep;
            }
            try {
                Thread.currentThread();
                Thread.sleep(l3);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long l4 = System.currentTimeMillis();
            l3 = l2 - l4;
        }
    }

    private void logToErrorFile(String string, String string2, String string3) {
        PrintWriter printWriter;
        EgDateInfo egDateInfo = new EgDateInfo();
        String string4 = egDateInfo.egetDate(false);
        EgConfigInfo egConfigInfo = new EgConfigInfo("agent");
        try {
            printWriter = new PrintWriter(new FileWriter(EgConfigInfo.egAgentErrorFile, true));
        }
        catch (Exception exception) {
            System.err.println("Cannot open log file ");
            return;
        }
        String string5 = new String(string4 + " " + string + " " + string2 + ": " + string3);
        printWriter.println(string5);
        printWriter.close();
    }

    private boolean getAgentOsArch() {
        boolean bl = false;
        String string = System.getProperty("os.arch");
        bl = string != null && string.length() > 0 ? !(string = string.trim()).equalsIgnoreCase("x86") : false;
        return bl;
    }

    private double getJsMemory() {
        double d = 0.0;
        String string = "Process";
        String[] stringArray = new String[]{"Working Set", "Handle Count"};
        String[] stringArray2 = new String[]{"js"};
        EgJNIUtil egJNIUtil = new EgJNIUtil();
        double[][] dArray = egJNIUtil.getCounterValue(string, stringArray2, stringArray);
        if (egJNIUtil != null) {
            egJNIUtil.stop();
        }
        if (dArray == null || dArray.length == 0) {
            return d;
        }
        d = dArray[0][0];
        this.JsHandle = dArray[0][1];
        if (d > 0.0) {
            d /= 1048576.0;
        }
        return d;
    }

    public void setJsMaxMemory() {
        if (isFirstTime) {
            isFirstTime = false;
            is64BitAgent = true;
            if (is64BitAgent) {
                File file;
                long l = System.currentTimeMillis();
                long l2 = 0L;
                String string = EgInstallInfo.getInstallDir() + "\\agent\\logs\\agentout.log";
                xmxValue = string != null ? ((file = new File(new String(string = string.trim()))).exists() ? (l - (l2 = file.lastModified()) < EgConfigInfo.msecPerMin * 10L ? this.getXmxValue(true) : this.getXmxValue(false)) : this.getXmxValue(false)) : this.getXmxValue(false);
            } else {
                return;
            }
        }
        if (is64BitAgent && EgMainAgent.isRestartAgent) {
            double d;
            double d2 = this.getJsMemory();
            if (d2 > (d = (double)xmxValue + (double)(xmxValue * EgMainAgent.agentRestartMemoryPct) / 100.0)) {
                isJsMaxMem = true;
                this.logToErrorFile("WARN", "MainAgentHelper", "Configured Memory of js is " + d2 + " Current Memory of js is " + d);
            } else {
                isJsMaxMem = false;
            }
        } else {
            isJsMaxMem = false;
        }
    }

    private int getXmxValue(boolean bl) {
        String string;
        int n;
        block9: {
            n = 0;
            String string2 = null;
            string2 = bl ? EgInstallInfo.getInstallDir() + "/lib/debugon.bat" : EgInstallInfo.getInstallDir() + "/lib/debugoff.bat";
            string = "128";
            if (string2 != null) {
                try {
                    File file = new File(string2);
                    if (file.exists() && file.isFile() && file.canRead()) {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                        String string3 = "";
                        while ((string3 = bufferedReader.readLine()) != null) {
                            if ((string3 = string3.toLowerCase()).indexOf("-xmx") < 0) continue;
                            int n2 = string3.indexOf("-xmx");
                            if ((string3 = string3.substring(n2)).indexOf(" ") > -1) {
                                int n3 = string3.indexOf(" ");
                                string3 = string3.substring(0, n3);
                                string3 = string3.substring(4);
                                string3 = string3.trim();
                                string = string3.substring(0, string3.length() - 1);
                                break;
                            }
                            string = "128";
                            break;
                        }
                        bufferedReader.close();
                        break block9;
                    }
                    string = "128";
                }
                catch (Exception exception) {
                    string = "128";
                }
            } else {
                string = "128";
            }
        }
        try {
            string = string.trim();
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 128;
        }
        return n;
    }
}

