/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MosqMQTTBroTest
extends GenericTest
implements MqttCallback {
    public static final String username = System.getProperty("username", System.getProperty("user.name"));
    public static final boolean cleanSession = Boolean.parseBoolean(System.getProperty("cleanSession", "false"));
    public static final int QoS = Integer.parseInt(System.getProperty("QoS", "1"));
    static final String[] MQTT_TOPICS = new String[]{"$SYS/broker/uptime", "$SYS/broker/clients/#", "$SYS/broker/messages/#", "$SYS/broker/subscriptions/count", "$SYS/broker/publish/#", "$SYS/broker/bytes/#", "$SYS/broker/retained messages/count"};
    static final String[] MQTT_MEASURE_ATTRIBUTS = new String[]{"$SYS/broker/uptime", "$SYS/broker/clients/total", "$SYS/broker/clients/connected", "$SYS/broker/clients/disconnected", "$SYS/broker/clients/expired", "$SYS/broker/clients/maximum", "$SYS/broker/subscriptions/count", "$SYS/broker/messages/sent", "$SYS/broker/messages/received", "$SYS/broker/bytes/sent", "$SYS/broker/bytes/received", "$SYS/broker/publish/messages/sent", "$SYS/broker/publish/messages/received", "$SYS/broker/publish/messages/dropped", "$SYS/broker/publish/bytes/sent", "$SYS/broker/publish/bytes/received", "$SYS/broker/retained messages/count"};
    private String installdir = "";
    private File file = null;
    private DataOutputStream dos = null;
    private DataInputStream dis = null;
    protected String logMessage = null;
    private static final String EG_TIME_FORMAT = "MM/dd/yyyy HH:mm:ss a";
    private static final SimpleDateFormat MY_SDF = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss a");
    protected static final String HYPHEN = "-";
    protected static final double DEFAULT_MINUS_FIVE = -5.0;
    protected static final double DEFAULT_MINUS_ONE = -1.0;
    protected static final double BYTES_TO_KB = 1024.0;
    protected static final double BYTES_TO_MB = 1048576.0;
    protected static final double BYTES_TO_GB = 1.073741824E9;
    protected static final double KB_TO_MB = 1024.0;
    protected static final double MB_TO_GB = 1024.0;
    protected String user = "";
    protected String password = "";
    protected String ssl = "";
    boolean isSSL = false;
    boolean usingJKS = false;
    ArrayList prevMeasureList = new ArrayList();
    MqttClient client;
    Hashtable resultData = new Hashtable();
    private String caCertFile = "";
    private String clientCertFile = "";
    private String clientKeyFile = "";
    private String clientKeyPassword = "";

    public MosqMQTTBroTest(String[] stringArray) {
        super(stringArray);
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        String string = "MosqMQTTBrokerTest";
        string = this.methodNameTemplate(string);
        this.installdir = EgInstallInfo.getInstallDir() + "/agent/logs/MosquittoMQTTUptime_" + this.targetHost + "_" + this.portNo + "_" + this.reportingName;
        this.file = new File(this.installdir);
        this.user = this.getValueForParam("user");
        if (this.user == null || this.user.trim().length() == 0 || this.user.equalsIgnoreCase("null") || this.user.equalsIgnoreCase("none")) {
            this.logMessage = string + "Mosquitto MQTT broker User is null or empty : " + this.user;
            this.printOut(this.logMessage);
            this.putWarningMessageToLogfile(this.logMessage);
            this.logMessage = "";
            this.user = "none";
        } else {
            this.logMessage = string + "Mosquitto MQTT broker User is :" + this.user;
            this.printOut(this.logMessage);
        }
        this.password = this.getValueForParam("password");
        if (this.password == null || this.password.trim().length() == 0 || this.password.equalsIgnoreCase("null") || this.password.equalsIgnoreCase("none")) {
            this.logMessage = string + "Mosquitto MQTT broker password is null or empty ";
            this.printOut(this.logMessage);
            this.putWarningMessageToLogfile(this.logMessage);
            this.logMessage = "";
            this.password = "none";
        } else {
            this.logMessage = string + "Mosquitto MQTT broker password is ******** ";
            this.printOut(this.logMessage);
        }
        this.ssl = this.getValueForParam("ssl");
        if (this.ssl != null && (this.ssl.equalsIgnoreCase("true") || this.ssl.equalsIgnoreCase("yes"))) {
            this.isSSL = true;
            this.logMessage = string + "Mosquitto MQTT broker ssl : " + this.ssl;
            this.printOut(this.logMessage);
            this.putInfoMessageToLogfile(this.logMessage);
            this.logMessage = "";
        }
        this.printOut(string + "Mosquitto MQTT broker SSL : " + this.isSSL);
        if (this.isSSL) {
            this.caCertFile = this.getValueForParam("ca_file");
            if (this.caCertFile == null || this.caCertFile.trim().length() == 0 || this.caCertFile.equalsIgnoreCase("null") || this.caCertFile.equalsIgnoreCase("none")) {
                this.logMessage = string + "Mosquitto MQTT broker caCertFile is null or empty : " + this.caCertFile;
                this.printOut(this.logMessage);
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
                this.caCertFile = "";
            } else {
                this.logMessage = string + "Mosquitto MQTT broker caCertFile is :" + this.caCertFile;
                this.printOut(this.logMessage);
            }
            this.clientCertFile = this.getValueForParam("client_cert_file");
            if (this.clientCertFile == null || this.clientCertFile.trim().length() == 0 || this.clientCertFile.equalsIgnoreCase("null") || this.clientCertFile.equalsIgnoreCase("none")) {
                this.logMessage = string + "Mosquitto MQTT broker clientCertFile is null or empty : " + this.clientCertFile;
                this.printOut(this.logMessage);
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
                this.clientCertFile = "";
            } else {
                this.logMessage = string + "Mosquitto MQTT broker clientCertFile is :" + this.clientCertFile;
                this.printOut(this.logMessage);
            }
            this.clientKeyFile = this.getValueForParam("client_key_file");
            if (this.clientKeyFile == null || this.clientKeyFile.trim().length() == 0 || this.clientKeyFile.equalsIgnoreCase("null") || this.clientKeyFile.equalsIgnoreCase("none")) {
                this.logMessage = string + "Mosquitto MQTT broker clientKeyFile is null or empty  :" + this.clientKeyFile;
                this.printOut(this.logMessage);
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
                this.clientKeyFile = "";
            } else {
                this.logMessage = string + "Mosquitto MQTT broker clientKeyFile is : " + this.clientKeyFile;
                this.printOut(this.logMessage);
            }
            this.clientKeyPassword = this.getValueForParam("key_file_password");
            if (this.clientKeyPassword == null || this.clientKeyPassword.trim().length() == 0 || this.clientKeyPassword.equalsIgnoreCase("null") || this.clientKeyPassword.equalsIgnoreCase("none")) {
                this.logMessage = string + "Mosquitto MQTT broker clientKeyPassword is null or empty : " + this.clientKeyPassword;
                this.printOut(this.logMessage);
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
                this.clientKeyPassword = "";
            } else {
                this.logMessage = string + "Mosquitto MQTT broker clientKeyPassword is : **************";
                this.printOut(this.logMessage);
            }
            String string2 = this.getValueForParam("using_jks");
            if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes"))) {
                this.usingJKS = true;
                this.logMessage = string + "Mosquitto MQTT broker usingJKS : " + this.usingJKS;
                this.printOut(this.logMessage);
                this.putInfoMessageToLogfile(this.logMessage);
                this.logMessage = "";
            }
        }
    }

    public static void main(String[] stringArray) {
        MosqMQTTBroTest mosqMQTTBroTest = new MosqMQTTBroTest(stringArray);
        int n = 0;
        while (++n < 3) {
            try {
                Thread.sleep(5000L);
                mosqMQTTBroTest.debugComputeMeasures(null, true);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        String string = "debugComputeMeasures";
        string = this.methodNameTemplate(string);
        this.resultData = new Hashtable();
        try {
            MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
            mqttConnectOptions.setCleanSession(true);
            mqttConnectOptions.setUserName(this.user);
            mqttConnectOptions.setPassword(this.password.toCharArray());
            if (this.isSSL) {
                this.client = new MqttClient("ssl://" + this.targetHost + ":" + this.portNo, "egurkha");
                if (this.usingJKS) {
                    mqttConnectOptions.setSocketFactory((SocketFactory)this.getSocketFactoryForJKS(this.caCertFile, this.clientKeyPassword));
                } else {
                    mqttConnectOptions.setSocketFactory((SocketFactory)this.getSocketFactory(this.caCertFile, this.clientCertFile, this.clientKeyFile, this.clientKeyPassword));
                }
            } else {
                this.client = new MqttClient("tcp://" + this.targetHost + ":" + this.portNo, "egurkha");
            }
            this.client.connect(mqttConnectOptions);
            for (int i = 0; i < MQTT_TOPICS.length; ++i) {
                this.printOut(string + "Topic : " + MQTT_TOPICS[i] + " using QoS " + QoS + ". Clean session is " + cleanSession);
                this.client.setCallback((MqttCallback)this);
                this.client.subscribe(MQTT_TOPICS[i], QoS);
                this.client.unsubscribe(MQTT_TOPICS[i]);
            }
            this.client.disconnect();
            this.client = null;
            this.printOut(string + "Reuslt  " + this.resultData);
            if (this.resultData == null || this.resultData.isEmpty() || this.resultData.size() == 0) {
                this.printOut(string + "Result data is null or empty ");
                return;
            }
            ArrayList<Double> arrayList = this.getmeasure(this.resultData, MQTT_MEASURE_ATTRIBUTS);
            this.printOut(string + " Measure data list " + arrayList);
            if (arrayList == null || arrayList.isEmpty() || arrayList.size() == 0) {
                this.printOut(string + "Measure data is null or empty ");
                return;
            }
            this.printOut(string + "CurrmeasureList " + arrayList);
            this.printOut(string + "PrevMeasureList " + this.prevMeasureList);
            ArrayList arrayList2 = this.getDiffValues(arrayList, this.prevMeasureList, 7, 16);
            this.printOut(string + " Diff measures " + arrayList2);
            double d = (Double)arrayList.get(0) > 0.0 ? (Double)arrayList.get(0) : -5.0;
            double d2 = 0.0;
            double d3 = this.readUpTimeFromFile();
            if (d != -5.0) {
                if (d3 != -5.0) {
                    d2 = d < d3 ? 1.0 : 0.0;
                }
            } else {
                d = -5.0;
                d2 = -5.0;
            }
            this.writeUpTimeToFile(d);
            d = this.roundDouble(d / 60.0, 2);
            double d4 = (Double)arrayList.get(1) >= 0.0 ? this.roundDouble((Double)arrayList.get(1), 2) : -5.0;
            double d5 = (Double)arrayList.get(2) >= 0.0 ? this.roundDouble((Double)arrayList.get(2), 2) : -5.0;
            double d6 = (Double)arrayList.get(3) >= 0.0 ? this.roundDouble((Double)arrayList.get(3), 2) : -5.0;
            double d7 = (Double)arrayList.get(4) >= 0.0 ? this.roundDouble((Double)arrayList.get(4), 2) : -5.0;
            double d8 = (Double)arrayList.get(5) >= 0.0 ? this.roundDouble((Double)arrayList.get(5), 2) : -5.0;
            double d9 = (Double)arrayList.get(6) >= 0.0 ? this.roundDouble((Double)arrayList.get(6), 2) : -5.0;
            double d10 = (Double)arrayList2.get(0) >= 0.0 ? this.roundDouble((Double)arrayList2.get(0), 2) : -5.0;
            double d11 = (Double)arrayList2.get(1) >= 0.0 ? this.roundDouble((Double)arrayList2.get(1), 2) : -5.0;
            double d12 = (Double)arrayList2.get(2) >= 0.0 ? this.roundDouble((Double)arrayList2.get(2) / 1048576.0 / this.timeSinceLastTest, 2) : -5.0;
            double d13 = (Double)arrayList2.get(3) >= 0.0 ? this.roundDouble((Double)arrayList2.get(3) / 1048576.0 / this.timeSinceLastTest, 2) : -5.0;
            double d14 = (Double)arrayList2.get(4) >= 0.0 ? this.roundDouble((Double)arrayList2.get(4), 2) : -5.0;
            double d15 = (Double)arrayList2.get(5) >= 0.0 ? this.roundDouble((Double)arrayList2.get(5), 2) : -5.0;
            double d16 = (Double)arrayList2.get(6) >= 0.0 ? this.roundDouble((Double)arrayList2.get(6), 2) : -5.0;
            double d17 = (Double)arrayList2.get(7) >= 0.0 ? this.roundDouble((Double)arrayList2.get(7) / 1048576.0 / this.timeSinceLastTest, 2) : -5.0;
            double d18 = (Double)arrayList2.get(8) >= 0.0 ? this.roundDouble((Double)arrayList2.get(8) / 1048576.0 / this.timeSinceLastTest, 2) : -5.0;
            double d19 = (Double)arrayList2.get(9) >= 0.0 ? this.roundDouble((Double)arrayList2.get(9), 2) : -5.0;
            double d20 = d10 >= 0.0 & this.timeSinceLastTest > 0.0 ? this.roundDouble(d10 / this.timeSinceLastTest, 2) : -5.0;
            double d21 = d11 >= 0.0 & this.timeSinceLastTest > 0.0 ? this.roundDouble(d11 / this.timeSinceLastTest, 2) : -5.0;
            double d22 = d14 >= 0.0 & this.timeSinceLastTest > 0.0 ? this.roundDouble(d14 / this.timeSinceLastTest, 2) : -5.0;
            double d23 = d15 >= 0.0 & this.timeSinceLastTest > 0.0 ? this.roundDouble(d15 / this.timeSinceLastTest, 2) : -5.0;
            double d24 = d16 >= 0.0 & this.timeSinceLastTest > 0.0 ? this.roundDouble(d16 / this.timeSinceLastTest, 2) : -5.0;
            double d25 = d19 >= 0.0 & this.timeSinceLastTest > 0.0 ? this.roundDouble(d19 / this.timeSinceLastTest, 2) : -5.0;
            d12 = d10 > 0.0 ? d12 : d10;
            d13 = d11 > 0.0 ? d13 : d11;
            d17 = d14 > 0.0 ? d17 : d14;
            d18 = d15 > 0.0 ? d18 : d15;
            this.prevMeasureList = arrayList;
            arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d4));
            arrayList.add(new Double(d5));
            arrayList.add(new Double(d6));
            arrayList.add(new Double(d7));
            arrayList.add(new Double(d8));
            arrayList.add(new Double(d9));
            arrayList.add(new Double(d10));
            arrayList.add(new Double(d11));
            arrayList.add(new Double(d12));
            arrayList.add(new Double(d13));
            arrayList.add(new Double(d14));
            arrayList.add(new Double(d15));
            arrayList.add(new Double(d16));
            arrayList.add(new Double(d17));
            arrayList.add(new Double(d18));
            arrayList.add(new Double(d19));
            arrayList.add(new Double(d20));
            arrayList.add(new Double(d21));
            arrayList.add(new Double(d22));
            arrayList.add(new Double(d23));
            arrayList.add(new Double(d24));
            arrayList.add(new Double(d25));
            if (!bl) {
                this.addNewMeasure(arrayList);
            }
            this.printOut(string + " Measure list added : " + arrayList);
        }
        catch (Exception exception) {
            this.printOutStackTrace("Error ", exception);
        }
        finally {
            try {
                if (this.client != null) {
                    this.client.disconnect();
                }
            }
            catch (Exception exception) {
                this.printOutStackTrace(string + "Error in closing client connection", exception);
            }
        }
    }

    private ArrayList getDiffValues(ArrayList arrayList, ArrayList arrayList2, int n, int n2) {
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        for (int i = n; i <= n2; ++i) {
            double d;
            if (arrayList2 == null || arrayList2.isEmpty() || arrayList2.size() == 0) {
                arrayList3.add(new Double(-5.0));
                continue;
            }
            double d2 = (Double)arrayList.get(i);
            double d3 = d2 >= (d = ((Double)arrayList2.get(i)).doubleValue()) ? d2 - d : -5.0;
            arrayList3.add(new Double(d3));
        }
        return arrayList3;
    }

    private ArrayList getmeasure(Hashtable hashtable, String[] stringArray) {
        String string = "getmeasure";
        string = this.methodNameTemplate(string);
        try {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = hashtable.containsKey(stringArray[i]) ? hashtable.get(stringArray[i]).toString().trim() : HYPHEN;
                string2 = string2.indexOf(" ") > -1 ? string2.substring(0, string2.indexOf(" ")) : string2;
                arrayList.add(new Double(this.convertToDouble(string2)));
            }
            return arrayList;
        }
        catch (Exception exception) {
            this.printOutStackTrace(string, exception);
            return null;
        }
    }

    public void connectionLost(Throwable throwable) {
        String string = "connectionLost";
        string = this.methodNameTemplate(string);
        try {
            this.printOut(string + "Connection lost \" with cause \"" + throwable.getMessage() + "\" Reason code " + ((MqttException)throwable).getReasonCode() + "\" Cause \"" + ((MqttException)throwable).getCause() + "\"");
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + "Error connectionLost", exception);
        }
    }

    public void messageArrived(String string, MqttMessage mqttMessage) {
        String string2 = "messageArrived";
        string2 = this.methodNameTemplate(string2);
        try {
            this.printOut(string2 + "Message: " + mqttMessage.toString() + " topic : " + string);
            this.resultData.put(string, mqttMessage.toString());
        }
        catch (Exception exception) {
            this.printOutStackTrace(string2 + "Error ", exception);
        }
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
        String string = "deliveryComplete";
        string = this.methodNameTemplate(string);
        try {
            this.printOut(string + "Delivery token \"" + iMqttDeliveryToken.hashCode() + "\" received by instance ");
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + "Error ", exception);
        }
    }

    protected double convertToDouble(String string) {
        String string2 = "convertToDouble";
        string2 = this.methodNameTemplate(string2);
        double d = 0.0;
        if (string == null || string.trim().length() <= 0) {
            return d;
        }
        string = string.trim();
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = -5.0;
        }
        return d;
    }

    protected double roundDouble(double d, int n) {
        String string = "roundDouble";
        string = this.methodNameTemplate(string);
        double d2 = 0.0;
        try {
            Object object;
            Object object2 = "";
            if (n <= 0) {
                object2 = object = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
            } else {
                String string2;
                object = "";
                if (d < 0.0) {
                    object = (String)object + HYPHEN;
                    d = -d;
                }
                if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
                    int n2 = (int)d;
                    object = (String)object + n2;
                    d -= (double)n2;
                } else {
                    object = (String)object + "0";
                }
                if (d > 0.0) {
                    String string3 = "" + (int)((d += 1.0) * Math.pow(10.0, n));
                    object = (String)object + "." + string3.substring(1);
                }
                object2 = (string2 = EgDbInfo.formatValue((String)object)) == null || string2.trim().length() == 0 ? object : string2;
            }
            object = new Double((String)object2);
            d2 = ((Double)object).isNaN() ? 0.0 : (Double)object;
        }
        catch (Exception exception) {
            this.printOut(string + "Error in  roundDouble method :" + exception.toString());
            this.putErrorMessageToLogfile("Error in  roundDouble method :" + exception.toString());
        }
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeUpTimeToFile(double d) {
        try {
            this.dos = new DataOutputStream(new FileOutputStream(this.file));
            this.dos.writeBytes("" + d);
            this.dos.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                this.dos.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.dos = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized double readUpTimeFromFile() {
        double d = -5.0;
        try {
            if (!this.file.exists()) {
                double d2 = d;
                return d2;
            }
            this.dis = new DataInputStream(new FileInputStream(this.file));
            String string = null;
            while ((string = this.dis.readLine()) != null) {
                String string2 = string;
                d = Double.parseDouble(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (this.dis != null) {
                    this.dis.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.dis = null;
        }
        return d;
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + MY_SDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.printOut(string2 + string3);
        this.putErrorMessageToLogfile(string2 + string3);
    }

    protected SSLSocketFactory getSocketFactory(String string, String string2, String string3, String string4) throws Exception {
        String string5 = "getSocketFactory";
        string5 = this.methodNameTemplate(string5);
        try {
            KeyPair keyPair;
            Security.addProvider((Provider)new BouncyCastleProvider());
            PEMParser pEMParser = new PEMParser((Reader)new InputStreamReader(new ByteArrayInputStream(MosqMQTTBroTest.readBytesFromFile(string))));
            X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)pEMParser.readObject();
            X509Certificate x509Certificate = new JcaX509CertificateConverter().getCertificate(x509CertificateHolder);
            pEMParser.close();
            pEMParser = new PEMParser((Reader)new InputStreamReader(new ByteArrayInputStream(MosqMQTTBroTest.readBytesFromFile(string2))));
            X509CertificateHolder x509CertificateHolder2 = (X509CertificateHolder)pEMParser.readObject();
            X509Certificate x509Certificate2 = new JcaX509CertificateConverter().getCertificate(x509CertificateHolder2);
            pEMParser.close();
            pEMParser = new PEMParser((Reader)new InputStreamReader(new ByteArrayInputStream(MosqMQTTBroTest.readBytesFromFile(string3))));
            Object object = pEMParser.readObject();
            char[] cArray = string4.toCharArray();
            PEMDecryptorProvider pEMDecryptorProvider = new JcePEMDecryptorProviderBuilder().build(cArray);
            JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
            if (object instanceof PEMEncryptedKeyPair) {
                this.printOut(string5 + "Encrypted key - we will use provided password");
                keyPair = jcaPEMKeyConverter.getKeyPair(((PEMEncryptedKeyPair)object).decryptKeyPair(pEMDecryptorProvider));
            } else {
                this.printOut(string5 + "Unencrypted key - no password needed");
                keyPair = jcaPEMKeyConverter.getKeyPair((PEMKeyPair)object);
            }
            pEMParser.close();
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setCertificateEntry("ca-certificate", x509Certificate);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            KeyStore keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore2.load(null, null);
            keyStore2.setCertificateEntry("certificate", x509Certificate2);
            keyStore2.setKeyEntry("private-key", keyPair.getPrivate(), string4.toCharArray(), new Certificate[]{x509Certificate2});
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore2, string4.toCharArray());
            SSLContext sSLContext = SSLContext.getInstance("TLSv1");
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            return sSLContext.getSocketFactory();
        }
        catch (Exception exception) {
            throw new MyMQTTException(string5, exception);
        }
    }

    protected SSLSocketFactory getSocketFactoryForJKS(String string, String string2) throws Exception {
        String string3 = "getSocketFactoryForJKS";
        string3 = this.methodNameTemplate(string3);
        try {
            char[] cArray = string2.toCharArray();
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(string), cArray);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, cArray);
            KeyStore keyStore2 = KeyStore.getInstance("JKS");
            keyStore2.load(new FileInputStream(string), cArray);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(keyStore2);
            SSLContext sSLContext = SSLContext.getInstance("SSLv3");
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            return sSLContext.getSocketFactory();
        }
        catch (Exception exception) {
            throw new MyMQTTException(string3, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readBytesFromFile(String string) {
        FileInputStream fileInputStream = null;
        byte[] byArray = null;
        try {
            File file = new File(string);
            byArray = new byte[(int)file.length()];
            fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return byArray;
    }

    public class MyMQTTException
    extends Exception {
        public MyMQTTException(String string) {
            MosqMQTTBroTest.this.printOutStackTrace(string + " MQTT Exception occured", null);
        }

        public MyMQTTException(String string, Throwable throwable) {
            MosqMQTTBroTest.this.printOutStackTrace(string + " MQTT Exception occured", (Exception)throwable);
        }

        public MyMQTTException(String string, String string2) {
            MosqMQTTBroTest.this.printOutStackTrace(string + " " + string2, null);
        }
    }
}

