/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSpecsInfo;
import com.eg.IPV6Helper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class MySqlValidator
extends EgServerValidator {
    public String reportingName = "";
    public String test = "";
    public String host = "";
    public String port = "";
    public String user = "";
    public String password = "";
    public String domain = "";
    public String isAgentLess = "";
    public String alMode = "";
    public String alUser = "";
    public String alPassword = "";
    public boolean isConnectivityOk = true;
    public boolean isExternalTest = false;
    public boolean meAgentLess = false;
    private String ssl = "false";
    private String dbName = "mysql";
    public String validationErrorMsg = "";
    public ArrayList validationMsgs = null;
    public Hashtable validationErrorMap = new Hashtable();
    EgSpecsInfo specsInfo = new EgSpecsInfo("manager");

    public MySqlValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-port")) {
                    this.port = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-db")) {
                    this.dbName = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-test")) {
                    this.test = string3;
                    if (!this.specsInfo.isExternalTest(this.test)) continue;
                    this.isExternalTest = true;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-userName")) {
                    this.user = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-password")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.password = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-agentless")) {
                    this.isAgentLess = string3;
                    if (this.isAgentLess != null && this.isAgentLess.equalsIgnoreCase("y")) {
                        this.meAgentLess = true;
                        continue;
                    }
                    this.isAgentLess = "false";
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-almode")) {
                    this.alMode = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-aluser")) {
                    this.alUser = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-alpassword")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.alPassword = string3;
                    continue;
                }
                if (string2 == null || !string2.equalsIgnoreCase("-ssl")) continue;
                this.ssl = string3;
            }
        }
        this.validationMsgs = new ArrayList();
        this.validate();
    }

    public void validate() {
        try {
            if (!this.checkMySqlConnectivity()) {
                if (!this.isIPReachable()) {
                    this.validationMsgs.add("MySQL Server Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or Host IP/Name is unreachable");
                    this.validationMsgs.add("Port$#$NA");
                } else if (!this.isPortReachable()) {
                    this.validationMsgs.add("MySQL Server Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$Port settings is incorrect");
                } else {
                    String string = (String)this.validationErrorMap.get("MySql_Connectivity");
                    this.validationMsgs.add("MySQL Server Connectivity$#$" + string);
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                }
            } else {
                this.validationMsgs.add("MySQL Server Connectivity$#$OK");
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$OK");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkMySqlConnectivity() {
        boolean bl = false;
        boolean bl2 = true;
        String string = "";
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = null;
        String string2 = "show tables";
        double d = this.getDatabaseVersion();
        if (d <= 0.0) {
            return false;
        }
        string2 = d >= 5.0 ? "show global status" : "show status";
        try {
            this.host = IPV6Helper.getValidIPAddress(this.host);
            Class.forName("com.mysql.cj.jdbc.Driver");
            String string3 = "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.dbName + "?useSSL=false";
            if (this.ssl != null && "true".equalsIgnoreCase(this.ssl)) {
                string3 = string3 + ";ssl=request";
            }
            String string4 = new String(string3);
            Properties properties = new Properties();
            properties.put("user", this.user);
            properties.put("password", this.password);
            connection = DriverManager.getConnection(string4, properties);
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(1);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                String string5 = resultSet.getString(1);
            }
            resultSet.close();
            statement.close();
            connection.commit();
            connection.close();
        }
        catch (SQLException sQLException) {
            CharSequence charSequence;
            Object object;
            sQLException.printStackTrace();
            int n = sQLException.getErrorCode();
            String string6 = sQLException.getMessage();
            this.isConnectivityOk = false;
            String string7 = this.getStackTraceAsString(sQLException);
            boolean bl3 = true;
            if (d >= 5.0 && (object = this.checkMySqlUserPrivilleges()) != null && ((String)object).equalsIgnoreCase("NO")) {
                bl3 = false;
                string6 = (String)this.validationErrorMap.get("MySql_User_privileges");
                charSequence = this.checkDBPrivilleges();
                if (charSequence != null && ((String)charSequence).equalsIgnoreCase("NO")) {
                    string6 = (String)this.validationErrorMap.get("MySql_DB_privileges");
                }
                bl = true;
            }
            string = string7 != null && string7.indexOf("at") > 0 ? string7.substring(0, string7.indexOf("at")) : string7;
            this.validationErrorMsg = bl ? string6.trim() : string;
            if (this.validationErrorMsg != null && this.validationErrorMsg.indexOf(":") > 0) {
                object = new StringTokenizer(this.validationErrorMsg, ":");
                charSequence = new StringBuffer();
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string8 = ((StringTokenizer)object).nextToken();
                    ((StringBuffer)charSequence).append(string8.trim() + " ");
                }
                this.validationErrorMsg = ((StringBuffer)charSequence).toString();
                this.validationErrorMsg = this.validationErrorMsg.trim();
            }
            this.validationErrorMap.put("MySql_Connectivity", this.validationErrorMsg);
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception exception) {
            this.isConnectivityOk = false;
            String string9 = this.getStackTraceAsString(exception);
            string = string9 != null && string9.indexOf("at") > 0 ? string9.substring(0, string9.indexOf("at")) : string9;
            this.validationErrorMsg = string;
            this.validationErrorMap.put("MySql_Connectivity", this.validationErrorMsg);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return this.isConnectivityOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDatabaseVersion() {
        Object object;
        String string;
        Connection connection = null;
        double d = 0.0;
        String string2 = "";
        boolean bl = false;
        String string3 = "";
        try {
            this.host = IPV6Helper.getValidIPAddress(this.host);
            Class.forName("com.mysql.cj.jdbc.Driver");
            connection = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.dbName + "?useSSL=false", this.user, this.password);
            string2 = connection.getMetaData().getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            int n = sQLException.getErrorCode();
            string = sQLException.getMessage();
            this.isConnectivityOk = false;
            String string4 = this.getStackTraceAsString(sQLException);
            switch (n) {
                case 1044: {
                    string = " User '" + this.user + "' doesn't have privilege to access database";
                    bl = true;
                    break;
                }
                case 1045: {
                    string = " Invalid username/password; logon denied Or User Permission denied on database";
                    bl = true;
                    break;
                }
                case 1049: {
                    string = " Invalid database Or database unavailable";
                    bl = true;
                    break;
                }
                case 1146: {
                    string = " User '" + this.user + "' doesn't have privilege to access database";
                    bl = true;
                }
            }
            string3 = string4 != null && string4.indexOf("at") > 0 ? string4.substring(0, string4.indexOf("at")) : string4;
            this.validationErrorMsg = bl ? string.trim() : string3;
            if (this.validationErrorMsg != null && this.validationErrorMsg.indexOf(":") > 0) {
                object = new StringTokenizer(this.validationErrorMsg, ":");
                StringBuffer stringBuffer = new StringBuffer();
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string5 = ((StringTokenizer)object).nextToken();
                    stringBuffer.append(string5.trim() + " ");
                }
                this.validationErrorMsg = stringBuffer.toString();
                this.validationErrorMsg = this.validationErrorMsg.trim();
            }
            this.validationErrorMap.put("MySql_Connectivity", this.validationErrorMsg);
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception exception) {
            String string6 = this.getStackTraceAsString(exception);
            string3 = string6 != null && string6.indexOf("at") > 0 ? string6.substring(0, string6.indexOf("at")) : string6;
            this.validationErrorMsg = string3;
            this.validationErrorMap.put("MySql_Connectivity", this.validationErrorMsg);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        System.out.println("[EGMySqlStatTest]-dbversion : " + string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        String string7 = "";
        string = "";
        int n = stringTokenizer.countTokens();
        if (stringTokenizer.hasMoreTokens()) {
            string7 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        object = "";
        object = n >= 3 ? string7 + "." + string : string7;
        object = ((String)object).trim();
        try {
            if (object != null && ((String)object).length() > 0) {
                d = Double.parseDouble((String)object);
                return d;
            }
        }
        catch (Exception exception) {
            d = 0.0;
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkMySqlUserPrivilleges() {
        String string = "";
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = null;
        String string2 = "NA";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = "select PRIVILEGE_TYPE,IS_GRANTABLE from USER_PRIVILEGES where GRANTEE in(\"'" + this.user + "'@'" + this.host + "'\",\"'" + this.user + "'@'localhost'\")";
        try {
            String string4;
            Class.forName("com.mysql.cj.jdbc.Driver");
            String string5 = "jdbc:mysql://" + this.host + ":" + this.port + "/information_schema" + "?useSSL=false";
            if (this.ssl != null && "true".equalsIgnoreCase(this.ssl)) {
                string5 = string5 + ";ssl=request";
            }
            String string6 = new String(string5);
            Properties properties = new Properties();
            properties.put("user", this.user);
            properties.put("password", this.password);
            connection = DriverManager.getConnection(string6, properties);
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(1);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                string4 = resultSet.getString(1);
                String string7 = resultSet.getString(2);
                if (string4 == null) continue;
                if (string4.equalsIgnoreCase("SELECT")) {
                    if (!string7.equalsIgnoreCase("YES")) continue;
                    bl = true;
                    continue;
                }
                if (string4.equalsIgnoreCase("PROCESS")) {
                    if (!string7.equalsIgnoreCase("YES")) continue;
                    bl2 = true;
                    continue;
                }
                if (!string4.equalsIgnoreCase("RELOAD") || !string7.equalsIgnoreCase("YES")) continue;
                bl3 = true;
            }
            string4 = "";
            if (!bl) {
                string4 = "User lacks in  Select ";
            }
            if (!bl2) {
                string4 = !bl ? string4 + ",Process" : "User lacks in Process Privilege";
            }
            if (!bl3) {
                string4 = !bl || bl2 ? string4 + ",Reload" : "User lacks in  Reload Privilege";
            }
            if (!(bl && bl2 && bl3)) {
                string4 = string4 + " Privileges";
                this.validationErrorMap.put("MySql_User_privileges", string4);
                string2 = "NO";
            }
            resultSet.close();
            statement.close();
            connection.commit();
            connection.close();
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            String string8 = sQLException.getMessage();
            String string9 = this.getStackTraceAsString(sQLException);
            string2 = "NA";
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception exception) {
            string2 = "NA";
            String string10 = this.getStackTraceAsString(exception);
            return string10;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkDBPrivilleges() {
        String string = "";
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = null;
        String string2 = "NA";
        boolean bl = false;
        String string3 = "select select_priv from db where db='" + this.dbName + "' and user+':'+host in (\"'" + this.user + "'+':'+'" + this.host + "'\",\"'" + this.user + "'+':'+'localhost'\")";
        try {
            String string4;
            Class.forName("com.mysql.cj.jdbc.Driver");
            String string5 = "jdbc:mysql://" + this.host + ":" + this.port + "/mysql" + "?useSSL=false";
            if (this.ssl != null && "true".equalsIgnoreCase(this.ssl)) {
                string5 = string5 + ";ssl=request";
            }
            String string6 = new String(string5);
            Properties properties = new Properties();
            properties.put("user", this.user);
            properties.put("password", this.password);
            connection = DriverManager.getConnection(string6, properties);
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(1);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                string4 = resultSet.getString(1);
                if (string4 == null || !string4.equalsIgnoreCase("YES")) continue;
                bl = true;
                string2 = "YES";
            }
            if (!bl) {
                string4 = "User doesn't  Select Privilege on '" + this.dbName + "' database ";
                this.validationErrorMap.put("MySql_DB_privileges", string4);
                string2 = "NO";
            }
            resultSet.close();
            statement.close();
            connection.commit();
            connection.close();
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            String string7 = sQLException.getMessage();
            String string8 = this.getStackTraceAsString(sQLException);
            string2 = "NA";
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception exception) {
            string2 = "NA";
            String string9 = this.getStackTraceAsString(exception);
            return string9;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
            return string2;
        }
    }

    public ArrayList getValidationMsgs() {
        System.out.println("########getting Validation Hashtable---->" + this.validationMsgs);
        return this.validationMsgs;
    }
}

