/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

class NetSnmpCpuTest
extends EgSnmpGenericTest {
    private static String oid = ".1.3.6.1.4.1.2021.11";
    private static int numMeasures = 5;

    public NetSnmpCpuTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
    }

    private double getValue(int n) {
        double d = -1.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    public ArrayList collectMeasures() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.lhs.length; ++i) {
            if (this.lhs[i].startsWith("50.")) {
                d = this.getValue(i);
                continue;
            }
            if (this.lhs[i].startsWith("51.")) {
                d2 = this.getValue(i);
                continue;
            }
            if (this.lhs[i].startsWith("52.")) {
                d3 = this.getValue(i);
                continue;
            }
            if (!this.lhs[i].startsWith("53.")) continue;
            d4 = this.getValue(i);
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(d));
        arrayList.add(new Double(d2));
        arrayList.add(new Double(d3));
        arrayList.add(new Double(d4));
        return arrayList;
    }

    public void computeMeasures(Hashtable hashtable) {
        if (!this.runSnmpCmdForOid(oid)) {
            return;
        }
        if (this.lhs == null || this.lhs.length == 0) {
            return;
        }
        ArrayList arrayList = this.collectMeasures();
        try {
            Thread.sleep(4000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!this.runSnmpCmdForOid(oid)) {
            return;
        }
        if (this.lhs == null || this.lhs.length == 0) {
            return;
        }
        ArrayList arrayList2 = this.collectMeasures();
        double d = (Double)arrayList.get(0);
        double d2 = (Double)arrayList.get(1);
        double d3 = (Double)arrayList.get(2);
        double d4 = (Double)arrayList.get(3);
        double d5 = (Double)arrayList2.get(0);
        double d6 = (Double)arrayList2.get(1);
        double d7 = (Double)arrayList2.get(2);
        double d8 = (Double)arrayList2.get(3);
        double d9 = d8 - d4;
        double d10 = d5 - d;
        double d11 = d7 - d3;
        double d12 = d6 - d2;
        double d13 = d9 + d10 + d11 + d12;
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        if (d13 == 0.0) {
            arrayList3.add(new Double(-5.0));
            arrayList3.add(new Double(-5.0));
            arrayList3.add(new Double(-5.0));
            arrayList3.add(new Double(-5.0));
            arrayList3.add(new Double(-5.0));
        } else {
            double d14 = d10 * 100.0 / d13;
            double d15 = d9 * 100.0 / d13;
            double d16 = d12 * 100.0 / d13;
            double d17 = d11 * 100.0 / d13;
            double d18 = d14 + d17 + d16;
            arrayList3.add(new Double(d18));
            arrayList3.add(new Double(d14));
            arrayList3.add(new Double(d17));
            arrayList3.add(new Double(d16));
            arrayList3.add(new Double(d15));
        }
        this.addNewMeasure(arrayList3);
    }

    public static void main(String[] stringArray) {
        NetSnmpCpuTest netSnmpCpuTest = new NetSnmpCpuTest(stringArray);
        netSnmpCpuTest.computeMeasures(new Hashtable());
    }
}

