/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;

public class OHS12cPrcTest
extends OHS12cBase {
    private String installdir = "";
    private File file = null;
    private DataOutputStream dos = null;
    private DataInputStream dis = null;
    private String[] ohsAttributes = new String[]{"upTime.value"};
    private final int MEASURE_COUNT = 2;

    public OHS12cPrcTest(String[] stringArray) {
        super(stringArray);
        this.installdir = EgInstallInfo.getInstallDir() + "/agent/logs/OHS12cServerUptime_" + this.targetHost + "_" + this.reportingName;
        this.file = new File(this.installdir);
        this.setMeasureCount(2);
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        try {
            this.methodName = "[debugComputeMeasures] ";
            String string = "OHS_" + this.reportingName + "_" + this.targetHost + "_" + this.adminPort;
            this.getMetrics(string, this.measurePeriod);
            ArrayList arrayList = this.getOHSProcessDataList(string, this.ohsAttributes);
            this.printOut(this.methodName + "Data returned from getOHSModulesDataList " + arrayList);
            if (arrayList != null && arrayList.size() > 0) {
                ArrayList arrayList2 = this.getFinalMetrics(this.entity + "_" + string, arrayList);
                this.printOut(this.methodName + "Adding measure, measureList " + arrayList2);
                if (!bl) {
                    this.addNewMeasure(arrayList2);
                }
            } else {
                ArrayList<Double> arrayList3 = new ArrayList<Double>();
                for (int i = 0; i < 2; ++i) {
                    arrayList3.add(new Double(-5.0));
                }
                if (!bl) {
                    this.addNewMeasure(arrayList3);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logMessage = this.methodName + "[Error] " + exception;
            this.printOut(this.logMessage);
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
        }
    }

    private ArrayList getFinalMetrics(String string, ArrayList arrayList) {
        this.methodName = "[getFinalMetrics] ";
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        try {
            this.printOut(this.methodName + "Current measure data hash " + arrayList);
            double d = -5.0;
            double d2 = -5.0;
            double d3 = this.readUpTimeFromFile();
            d = (Double)arrayList.get(0);
            double d4 = d = d > 0.0 ? d : -5.0;
            d2 = d3 == -5.0 ? -5.0 : (d < d3 ? 1.0 : 0.0);
            this.writeUpTimeToFile(d);
            d = d > 0.0 ? this.removeExpAndRound(d / 60000.0) : 0.0;
            arrayList2.add(new Double(d));
            arrayList2.add(new Double(d2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logMessage = this.methodName + "[Error] " + exception;
            this.printOut(this.logMessage);
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeUpTimeToFile(double d) {
        try {
            this.dos = new DataOutputStream(new FileOutputStream(this.file));
            this.dos.writeBytes("" + d);
            this.dos.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (this.dos != null) {
                    this.dos.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized double readUpTimeFromFile() {
        double d = -5.0;
        try {
            if (!this.file.exists()) {
                double d2 = d;
                return d2;
            }
            this.dis = new DataInputStream(new FileInputStream(this.file));
            String string = null;
            while ((string = this.dis.readLine()) != null) {
                String string2 = string;
                d = Double.parseDouble(string2);
            }
            double d3 = d;
            return d3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (this.dis != null) {
                    this.dis.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return d;
    }

    public static void main(String[] stringArray) {
        OHS12cPrcTest oHS12cPrcTest = new OHS12cPrcTest(stringArray);
        int n = 0;
        while (n < 3) {
            oHS12cPrcTest.computeMeasures(null);
            try {
                Thread.sleep(30000L);
            }
            catch (Exception exception) {}
        }
    }
}

