/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraTsStatusTest
extends GenericTest {
    String username = null;
    String password = null;
    String oraSid = null;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;

    public OraTsStatusTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(1);
        this.username = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        this.setSid(this.oraSid);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        String string;
        Object object;
        Object object2;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            object2 = new ArrayList();
            object2 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (object2 != null && ((ArrayList)object2).size() > 2) {
                int n = (Integer)((ArrayList)object2).get(0);
                object = (String)((ArrayList)object2).get(1);
                if (((String)object).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    string = (String)((ArrayList)object2).get(2);
                    if (string.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                this.logToErrorFile("Error  :", this.entity, "Failed to find the Oracle version detail for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
            }
        }
        if (this.isDataguardEnabled) {
            object2 = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            if (object2 == null || ((Hashtable)object2).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)object2).get(this.reportingName + ":" + this.oraSid);
            if (arrayList != null && arrayList.size() > 0) {
                object = (String)arrayList.get(2);
                string = (String)arrayList.get(3);
                if (!((String)object).equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        object2 = null;
        Statement statement = null;
        object = null;
        string = "select tablespace_name,status from dba_tablespaces";
        try {
            if (this.isMultitenantDb) {
                if (this.isCDB) {
                    if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                        this.logToErrorFile("INFO", "OraTsStatusTest doesnot run for CDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        this.msgLogCounter = 0;
                    }
                    ++this.msgLogCounter;
                    return;
                }
                object2 = ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
            } else {
                object2 = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
            }
            if (object2 == null) {
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                statement = object2.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraTsStatusTest Failed to Create Statement targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (object2 != null) {
                        object2.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return;
            }
            object = statement.executeQuery(string);
            ArrayList<Double> arrayList = null;
            String string2 = "";
            String string3 = "";
            double d = 0.0;
            while (object.next()) {
                string2 = object.getString(1);
                string3 = object.getString(2);
                arrayList = new ArrayList<Double>();
                if (string3.equalsIgnoreCase("online")) {
                    d = 100.0;
                    arrayList.add(new Double(d));
                } else if (string3.equalsIgnoreCase("read only")) {
                    d = 10.0;
                    arrayList.add(new Double(d));
                } else if (string3.equalsIgnoreCase("read write")) {
                    d = 20.0;
                    arrayList.add(new Double(d));
                } else if (string3.equalsIgnoreCase("offline")) {
                    d = 0.0;
                    arrayList.add(new Double(d));
                } else {
                    if (this.isPassive) {
                        d = -5.0;
                    }
                    arrayList.add(new Double(d));
                }
                System.out.println("[OraTsStatusTest] INFO NAME ==>" + string2 + "==measure==>" + arrayList);
                this.addNewMeasure(string2, arrayList);
            }
            try {
                object.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object2.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            exception.printStackTrace();
            try {
                object.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            try {
                statement.close();
            }
            catch (Exception exception4) {
                // empty catch block
            }
            try {
                object2.close();
            }
            catch (Exception exception5) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        OraTsStatusTest oraTsStatusTest = new OraTsStatusTest(stringArray);
        oraTsStatusTest.computeMeasures(new Hashtable());
    }
}

