/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgExternalInfo;
import com.eg.EgSpecsInfo;
import com.eg.IPV6Helper;
import com.egurkha.util.EgUtilities;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class OracleValidator
extends EgServerValidator {
    public String reportingName = "";
    public String test = "";
    public String host = "";
    public String port = "";
    public String sid = "";
    public String user = "";
    public String password = "";
    public String domain = "";
    public String isAgentLess = "";
    public String oracle_homeDir = "";
    public String alMode = "";
    public String alUser = "";
    public String alPassword = "";
    public boolean meAgentLess = false;
    public boolean service = true;
    public boolean isSID = true;
    public String serviceName = "";
    public String service_name = "";
    public boolean isOracleInstanceOk = false;
    public boolean isServiceNameOk = true;
    public boolean isConnectivityOk = true;
    public boolean isMultitenantDb = false;
    public String connectivityMsg = "";
    public String subject = "WORKING_TESTS";
    public String key = "";
    public String errorMsg = "error";
    public String validationMsg = "";
    public String validationErrorMsg = "";
    public boolean isFromManager = false;
    public boolean isTargetIp = true;
    public ArrayList validationMsgs = null;
    public Hashtable validationErrorMap = new Hashtable();
    EgSpecsInfo specsInfo = new EgSpecsInfo("agent");
    EgExternalInfo extInfo = new EgExternalInfo("agent");
    boolean isCDB = false;
    boolean isOracle12c = false;

    public OracleValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-port")) {
                    this.port = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-info")) {
                    this.sid = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-oracle_sid")) {
                    this.sid = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-test")) {
                    this.test = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-user")) {
                    this.user = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-username")) {
                    this.user = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-password")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.password = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-domain")) {
                    this.domain = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-agentless")) {
                    this.isAgentLess = string3;
                    if (this.isAgentLess == null || !this.isAgentLess.equalsIgnoreCase("y")) continue;
                    this.meAgentLess = true;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-almode")) {
                    this.alMode = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-aluser")) {
                    this.alUser = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-alpassword")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.alPassword = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-oracle_home")) {
                    this.oracle_homeDir = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-oraclesid")) {
                    this.sid = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-orasid")) {
                    this.sid = string3;
                    continue;
                }
                if (string2 == null || !string2.equalsIgnoreCase("-servicename")) continue;
                this.serviceName = string3;
            }
        }
        if (!this.isIpAddress(this.host)) {
            this.isTargetIp = false;
        }
        this.key = this.test + "#~#" + this.reportingName + ":" + this.port + ":" + this.sid;
        this.validationMsgs = new ArrayList();
        if (this.serviceName == null || this.serviceName.equalsIgnoreCase("NULL") || this.serviceName.equalsIgnoreCase("none") || this.serviceName.length() == 0) {
            this.service = false;
        }
        if (this.sid == null || this.sid.equalsIgnoreCase("NULL") || this.sid.equalsIgnoreCase("none") || this.sid.length() == 0) {
            this.isSID = false;
        }
        if (this.extInfo.isRemoteBased(this.reportingName)) {
            this.meAgentLess = true;
        }
        this.validate();
        this.isFromManager = bl;
    }

    public void validate() {
        try {
            if (!this.checkOracleConnectivity()) {
                this.subject = "ERROR_TESTS";
                this.logMsgToStatusFile(this.subject, this.key, this.errorMsg);
                if (!this.isIPReachable()) {
                    this.validationMsgs.add("Oracle Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or Host IP/Name is unreachable");
                    this.validationMsgs.add("Port$#$NA");
                } else if (!this.isPortReachable()) {
                    this.validationMsgs.add("Oracle Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$Port is down or listener is down");
                } else if (!this.isOracleInstanceReachable()) {
                    String string = (String)this.validationErrorMap.get("Oracle_Instance");
                    this.validationMsgs.add("Oracle Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                    this.validationMsgs.add("Oracle Instance Name$#$" + string);
                } else if (!this.isOracleServiceReachable()) {
                    String string = (String)this.validationErrorMap.get("Oracle_Service");
                    this.validationMsgs.add("Oracle Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                    this.validationMsgs.add("Oracle Service Name$#$" + string);
                } else {
                    String string = (String)this.validationErrorMap.get("Oracle_Connectivity");
                    String string2 = (String)this.validationErrorMap.get("Oracle_Instance");
                    this.validationMsgs.add("Oracle Connectivity$#$" + string);
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                }
                if (!this.isFromManager) {
                    return;
                }
            } else {
                this.validationMsgs.add("Oracle Connectivity$#$OK");
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$OK");
                this.validationMsgs.add("Oracle SID/Service Name$#$OK");
            }
            this.logMsgToStatusFile(this.subject, this.key, "OK#" + this.getCurrentTime());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ArrayList getValidationMsgs() {
        return this.validationMsgs;
    }

    public boolean isOracleInstanceReachable() {
        if (this.meAgentLess || this.service || this.isSID) {
            this.validationErrorMap.put("Oracle_Instance", "NA");
            return true;
        }
        EgUtilities egUtilities = EgUtilities.createInstance();
        String string = "";
        this.agentOS = this.agentOS.toLowerCase();
        ArrayList arrayList = new ArrayList();
        String string2 = "";
        String string3 = this.getNBTName(this.host);
        if (this.agentOS != null && this.agentOS.indexOf("windows") > -1) {
            string2 = "oracleservice" + this.sid.toLowerCase();
            string = " net start ";
            arrayList = egUtilities.getCommandOutputLines(string);
            if (arrayList != null && !arrayList.isEmpty()) {
                for (String string4 : arrayList) {
                    string4 = string4.toLowerCase();
                    if ((string4 = string4.trim()) == null || !string4.equalsIgnoreCase(string2)) continue;
                    this.isOracleInstanceOk = true;
                    break;
                }
            }
            if (!this.isOracleInstanceOk) {
                this.validationErrorMsg = "Oracle Instance '" + this.sid + "' is not running or unavailable";
                this.validationErrorMap.put("Oracle_Instance", this.validationErrorMsg);
            }
        } else if (this.agentOS != null && (this.agentOS.indexOf("linux") > -1 || this.agentOS.indexOf("sunos") > -1 || this.agentOS.indexOf("hpux") > -1 || this.agentOS.indexOf("aix") > -1 || this.agentOS.indexOf("osf1") > -1)) {
            string2 = "ora_pmon_" + this.sid;
            string = "ps -e | grep '" + string2 + "'";
            arrayList = egUtilities.getCommandOutputLines(string, true);
            if (arrayList != null && !arrayList.isEmpty()) {
                for (String string5 : arrayList) {
                    string5 = string5.toLowerCase();
                    if ((string5 = string5.trim()) == null || !string5.equalsIgnoreCase(string2)) continue;
                    this.isOracleInstanceOk = true;
                    break;
                }
            }
            if (!this.isOracleInstanceOk) {
                this.validationErrorMsg = "Oracle Instance '" + this.sid + "' is not running or unavailable";
                this.validationErrorMap.put("Oracle_Instance", this.validationErrorMsg);
            }
        }
        return this.isOracleInstanceOk;
    }

    private void setServiceName(String string) {
        this.service_name = string;
    }

    private String getServiceName() {
        return this.service_name;
    }

    public boolean isOracleServiceReachable() {
        String string = this.getServiceName();
        if (string != null && !string.equals("") && !string.equals(this.serviceName)) {
            this.isServiceNameOk = false;
        }
        if (!this.isServiceNameOk) {
            this.validationErrorMsg = "Oracle Service '" + this.serviceName + "' is not running or unavailable";
            this.validationErrorMap.put("Oracle_Service", this.validationErrorMsg);
        }
        return this.isServiceNameOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean checkOracleConnectivity() {
        block16: {
            Connection connection;
            block15: {
                boolean bl = false;
                boolean bl2 = false;
                String string = "";
                connection = null;
                Object var5_5 = null;
                Object var6_6 = null;
                this.host = IPV6Helper.getValidIPAddress(this.host);
                Class.forName("oracle.jdbc.driver.OracleDriver");
                Properties properties = new Properties();
                properties.put("user", this.user);
                properties.put("password", this.password);
                String string2 = "jdbc:oracle:thin:@" + this.host + ":" + this.port + ":" + this.sid;
                connection = this.getConnection("oracle.jdbc.driver.OracleDriver", string2, properties);
                if (!this.service) {
                    this.serviceName = this.sid;
                }
                if (connection == null) {
                    string2 = "jdbc:oracle:thin:@//" + this.host + ":" + this.port + "/" + this.serviceName;
                    connection = this.getConnection("oracle.jdbc.driver.OracleDriver", string2, properties);
                }
                if (connection != null) break block15;
                boolean bl3 = false;
                Object var13_10 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return bl3;
            }
            Object var13_11 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block16;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block16;
            {
                catch (Exception exception) {
                    boolean bl = false;
                    Object var13_12 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean checkORAUserRoles() {
        boolean bl;
        block22: {
            bl = false;
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            this.host = IPV6Helper.getValidIPAddress(this.host);
            Class.forName("oracle.jdbc.driver.OracleDriver");
            String string = "";
            if (this.service) {
                string = "jdbc:oracle:thin:@//" + this.host + ":" + this.port + "/" + this.serviceName;
            } else {
                this.checkOracleVersion();
                string = this.isMultitenantDb && !this.isCDB ? "jdbc:oracle:thin:@//" + this.host + ":" + this.port + "/" + this.sid : "jdbc:oracle:thin:@" + this.host + ":" + this.port + ":" + this.sid;
            }
            Properties properties = new Properties();
            properties.put("user", this.user);
            properties.put("password", this.password);
            if (this.domain != null && !this.domain.equalsIgnoreCase("none")) {
                properties.put("domain", this.domain);
            }
            connection = DriverManager.getConnection(string, properties);
            statement = connection.createStatement();
            String string2 = "SELECT  GRANTED_ROLE  from user_role_privs";
            resultSet = statement.executeQuery(string2);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                arrayList.add(string3);
            }
            if (arrayList != null && arrayList.contains("SELECT_CATALOG_ROLE")) {
                bl = true;
            }
            resultSet.close();
            statement.close();
            connection.close();
            Object var11_11 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                break block22;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block22;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var11_12 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block22;
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
        return bl;
    }

    public boolean checkOracleHome() {
        boolean bl = false;
        if (this.oracle_homeDir != null && !this.oracle_homeDir.equals("") && !this.oracle_homeDir.equalsIgnoreCase("null")) {
            if (!bl) {
                this.validationErrorMsg = "Oracle Home Directory:Oracle Home Directory '" + this.oracle_homeDir + "' does not exist or corrupted ";
            }
        } else {
            this.validationErrorMsg = "NA";
        }
        this.validationErrorMap.put("Oracle_Home", this.validationErrorMsg);
        return bl;
    }

    public String getNBTName(String string) {
        EgUtilities egUtilities = EgUtilities.createInstance();
        String string2 = !this.isTargetIp ? "nbtstat -a " + string : "nbtstat -A " + string;
        String string3 = string;
        ArrayList arrayList = egUtilities.getExecOutputLines(string2);
        ArrayList arrayList2 = null;
        String string4 = null;
        if (arrayList != null && (arrayList2 = (ArrayList)arrayList.get(0)) != null) {
            int n = arrayList2.size();
            if (n <= 0) {
                return string3;
            }
            for (int i = 0; i < n; ++i) {
                int n2;
                StringTokenizer stringTokenizer;
                int n3;
                string4 = (String)arrayList2.get(i);
                if (string4 == null || string4.length() == 0 || string4.equalsIgnoreCase("Name") || string4.startsWith("-") || (n3 = (stringTokenizer = new StringTokenizer(string4)).countTokens()) < 3 || string4.indexOf("<00>") <= 0 || string4.indexOf("UNIQUE") <= 0) continue;
                string3 = stringTokenizer.nextToken();
                if (string3.endsWith("<00>")) {
                    n2 = string3.indexOf("<00>");
                    string3 = string3.substring(0, n2);
                }
                if (string3.indexOf("~") >= 0) continue;
                n2 = string3.indexOf("~");
                string3 = string3.toLowerCase().trim();
                break;
            }
        }
        return string3;
    }

    public boolean isIpAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            try {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 <= 255 && n2 >= 0) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public void checkOracleVersion() {
        ArrayList arrayList = new ArrayList();
        arrayList = ConnectionManager.checkOracleVersion("", this.host, this.port, this.sid, this.user, this.password, true);
        if (arrayList != null && arrayList.size() > 2) {
            int n = (Integer)arrayList.get(0);
            String string = (String)arrayList.get(1);
            if (string.equalsIgnoreCase("true")) {
                this.isCDB = true;
            }
            if (n >= 12) {
                this.isOracle12c = true;
                String string2 = (String)arrayList.get(2);
                if (string2 != null && string2.equalsIgnoreCase("true")) {
                    this.isMultitenantDb = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Connection getConnection(String string, String string2, Properties properties) {
        Connection connection;
        block34: {
            String string3;
            boolean bl;
            boolean bl2;
            ResultSet resultSet;
            Statement statement;
            block33: {
                connection = null;
                statement = null;
                resultSet = null;
                bl2 = false;
                bl = false;
                string3 = "";
                long l = System.currentTimeMillis();
                Class.forName(string);
                connection = DriverManager.getConnection(string2, properties);
                statement = connection.createStatement();
                String string4 = "select value from v$parameter where name='service_names'";
                resultSet = statement.executeQuery(string4);
                if (!resultSet.next()) break block33;
                String string5 = resultSet.getString("VALUE");
                this.setServiceName(string5);
            }
            Object var20_17 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                break block34;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block34;
            {
                catch (SQLException sQLException) {
                    int n = sQLException.getErrorCode();
                    String string6 = sQLException.getMessage();
                    this.isConnectivityOk = false;
                    switch (n) {
                        case 1017: {
                            string6 = " Invalid username/password; logon denied";
                            bl = true;
                            break;
                        }
                        case 1045: {
                            string6 = " User '" + this.user + "' lacks CONNECT/CREATE SESSION privilege; logon denied";
                            bl = true;
                            break;
                        }
                        case 942: {
                            bl2 = this.checkORAUserRoles();
                            string6 = !bl2 ? " User '" + this.user + "' doesn't have  SELECT_CATALOG role" : " User '" + this.user + "' has sufficient privileges error occurred while selecting with data dictionary. Please check with actual exception";
                            bl = true;
                            break;
                        }
                        case 28000: {
                            string6 = " The account '" + this.user + "' is locked";
                            bl = true;
                            break;
                        }
                        case 12519: {
                            string6 = " Listener refused the connection due to ' TNS:no appropriate service handler found'";
                            bl = true;
                            break;
                        }
                        case 12505: {
                            string6 = " Listener refused the connection due to 'Unknown  SID'";
                            bl = true;
                            break;
                        }
                        case 12514: {
                            string6 = " Listener refused the connection due to 'Unknown  SID/Service Name'";
                            bl = true;
                        }
                    }
                    String string7 = this.getStackTraceAsString(sQLException);
                    string3 = string7.substring(0, string7.indexOf("at"));
                    this.validationErrorMsg = bl ? string6.trim() : string3;
                    if (this.validationErrorMsg != null && this.validationErrorMsg.indexOf(":") > 0) {
                        StringTokenizer stringTokenizer = new StringTokenizer(this.validationErrorMsg, ":");
                        StringBuffer stringBuffer = new StringBuffer();
                        while (stringTokenizer.hasMoreTokens()) {
                            String string8 = stringTokenizer.nextToken();
                            stringBuffer.append(string8.trim() + " ");
                        }
                        this.validationErrorMsg = stringBuffer.toString();
                        this.validationErrorMsg = this.validationErrorMsg.trim();
                    }
                    this.validationErrorMap.put("Oracle_Connectivity", this.validationErrorMsg);
                    this.errorMsg = string6.trim() + "#Stack Trace:" + sQLException.getMessage().trim() + " " + string7.trim() + "#" + this.getCurrentTime();
                    Object var20_18 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block34;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break block34;
                }
                catch (Exception exception) {
                    this.isConnectivityOk = false;
                    String string9 = this.getStackTraceAsString(exception);
                    this.validationErrorMsg = string3;
                    this.validationErrorMap.put("Oracle_Connectivity", this.validationErrorMsg);
                    this.errorMsg = "Stack Trace:" + exception.getMessage().trim() + " " + string9.trim() + "#" + this.getCurrentTime();
                    Object var20_19 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block34;
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var20_20 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
        return connection;
    }

    public static void main(String[] stringArray) {
        OracleValidator oracleValidator = new OracleValidator(stringArray, new Boolean(false));
    }
}

