/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class RZDMemoryTest
extends EgSnmpGenericTest {
    private static final int RUCKUS_MemoryTest_MEASURE_COUNT = 4;

    public RZDMemoryTest(String[] stringArray) {
        super(stringArray);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpversion");
        this.community = this.getValueForParam("snmpCommunity");
        this.setMeasureCount(4);
        this.isNewDynamicInfoTest = true;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.11.71", "-port", "NULL", "-snmpPort", "161", "-snmpversion", "v1", "-snmpCommunity", "public"};
        RZDCPUMgtTest rZDCPUMgtTest = new RZDCPUMgtTest(stringArray2);
        rZDCPUMgtTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            double d = this.getMeasure(".1.3.6.1.4.1.25053.1.2.1.1.1.5.60");
            double d2 = this.getMeasure(".1.3.6.1.4.1.25053.1.2.1.1.1.5.59");
            double d3 = -5.0;
            double d4 = -5.0;
            if (d > 0.0) {
                d3 = d2 * d / 100.0;
                d4 = d - d3;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            arrayList.add(new Double(d3));
            arrayList.add(new Double(d4));
            arrayList.add(new Double(d2));
            this.addNewMeasure(arrayList);
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", this.entity + "error occured in computeMeasures", exception.toString());
            exception.printStackTrace();
        }
    }

    public double getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        double d = -5.0;
        String string2 = "";
        if (bl) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.rhs[i];
                try {
                    d = Double.parseDouble(string2);
                    continue;
                }
                catch (Exception exception) {
                    d = -5.0;
                    this.logToErrorFile("Error :", this.entity + "error occured in getMeasure", exception.toString());
                    exception.printStackTrace();
                }
            }
        }
        return d;
    }
}

