/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSpecsInfo;
import com.egurkha.util.EgUtilities;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Scanner;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;

public class RabbitMQValidator
extends EgServerValidator {
    public String reportingName = "";
    public String test = "";
    public String host = "";
    public String port = "";
    public String isAgentLess = "";
    public String alMode = "";
    public String alUser = "";
    public String alPassword = "";
    public String url = "";
    public String user = "none";
    public String password = "none";
    public String ssl = null;
    public boolean isSSL = false;
    private long timeout;
    public boolean isConnectivityOk = false;
    public boolean isTableInfoComing = true;
    public boolean isExternalTest = false;
    public boolean meAgentLess = false;
    public String connectivityMsg = "";
    public String subject = "WORKING_TESTS";
    public String key = "";
    public String errorMsg = "error";
    public String validationMsg = "";
    public String validationErrorMsg = "";
    public boolean isFromManager = false;
    public boolean isTargetIp = true;
    public ArrayList validationMsgs = null;
    public Hashtable validationErrorMap = new Hashtable();
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    protected static final int DEFAULT_READ_TIMEOUT = 60000;
    protected static final String METHOD_GET = "GET";
    protected static final String AUTHORIZATION_KEY = "Authorization";
    protected static final String CONTENT_TYPE_KEY = "Content-Type";
    protected static final String CONTENT_TYPE_VALUE = "application/json";
    protected static final String CACHE_CONTROL_KEY = "Cache-Control";
    protected static final String CACHE_CONTROL_VALUE = "no-cache";
    protected String token = null;
    EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
    EgUtilities egutil = EgUtilities.createInstance();
    String logMessage = "";

    public RabbitMQValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        try {
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    String string2 = string.substring(0, string.indexOf(":"));
                    String string3 = string.substring(string.indexOf(":") + 1);
                    if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                        this.host = string3;
                    } else if (string2 != null && string2.equalsIgnoreCase("-port")) {
                        this.port = string3;
                    } else if (string2 != null && string2.equalsIgnoreCase("-rptname")) {
                        this.reportingName = string3;
                    } else if (string2 != null && string2.equalsIgnoreCase("-test")) {
                        this.test = string3;
                        if (this.specsInfo.isExternalTest(this.test)) {
                            this.isExternalTest = true;
                        }
                    } else if (string2 != null && string2.equalsIgnoreCase("-username")) {
                        this.user = string3;
                    } else if (string2 != null && string2.equalsIgnoreCase("-password")) {
                        this.password = string3;
                    } else if (string2 != null && string2.equalsIgnoreCase("-ssl")) {
                        this.ssl = string3;
                    } else if (string2 != null && string2.equalsIgnoreCase("-agentless")) {
                        this.isAgentLess = string3;
                        if (this.isAgentLess != null && this.isAgentLess.equalsIgnoreCase("y")) {
                            this.meAgentLess = true;
                        } else {
                            this.isAgentLess = "false";
                        }
                    } else if (string2 != null && string2.equalsIgnoreCase("-almode")) {
                        this.alMode = string3;
                    } else if (string2 != null && string2.equalsIgnoreCase("-aluser")) {
                        this.alUser = string3;
                    } else if (string2 != null && string2.equalsIgnoreCase("-alpassword")) {
                        this.alPassword = string3;
                    }
                    if ("true".equalsIgnoreCase(this.ssl)) {
                        this.url = "https://";
                        this.isSSL = true;
                        continue;
                    }
                    this.url = "http://";
                }
                this.token = this.createBasicAuthToken(this.user, this.password);
            }
            if (this.timeout == 0L) {
                this.timeout = 2L * EgConfigInfo.msecPerMin;
            }
            if (!this.isIpAddress(this.host)) {
                this.isTargetIp = false;
            }
            this.key = this.test + "#~#" + this.reportingName + ":" + this.port + ":" + this.host;
            this.validationMsgs = new ArrayList();
            this.validate();
            this.isFromManager = bl;
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void validate() {
        try {
            System.out.println("admin_host " + this.admin_host);
            if (!this.isIPReachable()) {
                String string = this.host;
                if (this.url != null || !this.url.equals("")) {
                    string = this.admin_host;
                }
                this.validationMsgs.add("RabbitMQ Server Connectivity$#$NA");
                this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + string + "' is invalid or Host IP/Name is unreachable");
                this.validationMsgs.add("Port$#$NA");
            } else if (!this.isPortReachable()) {
                this.validationMsgs.add("RabbitMQ Server Connectivity$#$NA");
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$Port settings is incorrect or RabbitMQ Server is down");
            } else {
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$OK");
                this.checkRabbitMQConnectivity();
                System.out.println("final arrayList " + this.getValidationMsgs());
            }
            if (!this.isFromManager) {
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isIpAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            try {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 <= 255 && n2 >= 0) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private String createBasicAuthToken(String string, String string2) {
        String string3 = string + ":" + string2;
        byte[] byArray = Base64.encodeBase64((byte[])string3.getBytes());
        String string4 = new String(byArray);
        return "Basic " + string4;
    }

    public void checkRabbitMQConnectivity() {
        HttpURLConnection httpURLConnection = null;
        String string = "[checkRabbitMQConnectivity] :";
        String string2 = "";
        string2 = this.isSSL ? "https://" + this.host + ":" + this.port : "http://" + this.host + ":" + this.port;
        this.enableSSLForRabbitMQRESTAPI();
        URL uRL = null;
        try {
            uRL = new URL(null, string2 + "/api/overview");
        }
        catch (MalformedURLException malformedURLException) {
            this.logMessage = string + " MalformedURLException ";
            this.logMessage = "";
            malformedURLException.printStackTrace();
        }
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
        }
        catch (IOException iOException) {
            this.logMessage = string + " HttpURLConnection  error ";
            this.logMessage = "";
            iOException.printStackTrace();
        }
        try {
            httpURLConnection.setRequestMethod(METHOD_GET);
        }
        catch (ProtocolException protocolException) {
            this.logMessage = string + " Your HTTP connection does not support  setRequestMethod ";
            this.logMessage = "";
            protocolException.printStackTrace();
        }
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setConnectTimeout(15000);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.addRequestProperty(CONTENT_TYPE_KEY, CONTENT_TYPE_VALUE);
        httpURLConnection.setRequestProperty(AUTHORIZATION_KEY, this.token);
        httpURLConnection.setRequestProperty(CACHE_CONTROL_KEY, CACHE_CONTROL_VALUE);
        RabbitMQConnectionThread rabbitMQConnectionThread = new RabbitMQConnectionThread(httpURLConnection, string);
        int n = 0;
        boolean bl = this.checkForTimeout(rabbitMQConnectionThread);
        if (bl) {
            n = rabbitMQConnectionThread.code;
            if (n == 200) {
                this.validationErrorMsg = "code 200 - Server is running normal";
                this.validationMsgs.add("User/Password$#$OK");
                this.validationMsgs.add("RabbitMQ Server Connectivity$#$OK");
            }
            if (n == 500) {
                this.validationErrorMsg = "Error 500 - No Response from server due to internal server error";
                this.validationMsgs.add("User/Password$#$NA");
                this.validationMsgs.add("RabbitMQ Server Connectivity$#$No Response from server due to internal server error");
            } else if (n == 404) {
                this.validationErrorMsg = "Error 404 - No Response from server";
                this.validationMsgs.add("User/Password$#$NA");
                this.validationMsgs.add("RabbitMQ Server Connectivity$#$No Response from server");
            } else if (n == 503) {
                this.validationErrorMsg = "Error 503 - The server is currently unavailable or not started";
                this.validationMsgs.add("User/Password$#$NA");
                this.validationMsgs.add("RabbitMQ Server Connectivity$#$The server is currently unavailable or not started");
            } else if (n == 401) {
                this.validationErrorMsg = "Error 401 - Unauthorized: Access is denied due to invalid credentials";
                this.validationMsgs.add("User/Password$#$NA");
                this.validationMsgs.add("RabbitMQ Server Connectivity$#$ Access denied. Please check Username/Password");
            }
        }
        if (!bl || n != 200) {
            this.logMessage = string + " Timing out or invalid response code:" + n;
            this.logMessage = "";
        }
        httpURLConnection.disconnect();
    }

    void enableSSLForRabbitMQRESTAPI() {
        if (this.isSSL) {
            Security.addProvider((java.security.Provider)new Provider());
            System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var2_2 = null;
            RabbitMQX509TrustManager rabbitMQX509TrustManager = new RabbitMQX509TrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{rabbitMQX509TrustManager};
            SSLContext sSLContext = null;
            try {
                sSLContext = SSLContext.getInstance("SSL");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
                return;
            }
            try {
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            }
            catch (KeyManagementException keyManagementException) {
                keyManagementException.printStackTrace();
                return;
            }
            SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
            HttpsURLConnection.setDefaultHostnameVerifier(new RabbitMQHostnameVerifier());
        }
    }

    protected String decodeResponse(InputStream inputStream) throws IOException {
        Scanner scanner = new Scanner(inputStream);
        scanner.useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }

    private boolean checkForTimeout(RabbitMQConnectionThread rabbitMQConnectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        long l4 = 2L * EgConfigInfo.msecPerMin;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (rabbitMQConnectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= l4) {
                this.logMessage = "Timed out and hence going to kill the thread :" + System.currentTimeMillis();
                this.logMessage = "";
                rabbitMQConnectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                this.logMessage = " Timed out and killed the thread :" + System.currentTimeMillis();
                this.logMessage = "";
                rabbitMQConnectionThread.stop();
                return false;
            }
            l = l3;
            if (l4 - l2 >= l) continue;
            l = l4 - l2;
        } while ((l3 = l) > 0L);
        this.logMessage = " sleepTime less than zero in checkForTimeout :" + System.currentTimeMillis();
        this.logMessage = "";
        rabbitMQConnectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        rabbitMQConnectionThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host:192.168.11.147", "-port:15672", "-username:admin", "-password:password", "-ssl:false", "-test:RabMQCluster"};
        RabbitMQValidator rabbitMQValidator = new RabbitMQValidator(stringArray2, false);
        rabbitMQValidator.checkRabbitMQConnectivity();
        System.out.println(rabbitMQValidator.getValidationMsgs());
    }

    public ArrayList getValidationMsgs() {
        System.out.println(this.validationMsgs);
        return this.validationMsgs;
    }

    class RabbitMQConnectionThread
    extends Thread {
        private HttpURLConnection connection;
        private String methodName = "[run]:";
        public String responseString = null;
        public boolean done = false;
        public int code = 0;

        public RabbitMQConnectionThread(HttpURLConnection httpURLConnection, String string) {
            this.connection = httpURLConnection;
            this.methodName = this.methodName + string;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.connection.connect();
            }
            catch (IOException iOException) {
                RabbitMQValidator.this.logMessage = this.methodName + " Error : URL connect and returned ";
                RabbitMQValidator.this.logMessage = "";
                iOException.printStackTrace();
                return;
            }
            try {
                RabbitMQValidator.this.logMessage = this.methodName + " and its Response code :" + this.connection.getResponseCode();
                RabbitMQValidator.this.logMessage = "";
            }
            catch (IOException iOException) {
                RabbitMQValidator.this.logMessage = this.methodName + " Error ";
                RabbitMQValidator.this.logMessage = "";
                iOException.printStackTrace();
                return;
            }
            InputStream inputStream = null;
            try {
                this.code = this.connection.getResponseCode();
                System.out.println("code " + this.code);
                inputStream = this.code == 200 ? this.connection.getInputStream() : this.connection.getErrorStream();
                System.out.println("Response before decode :" + this.connection.getErrorStream());
            }
            catch (IOException iOException) {
                RabbitMQValidator.this.logMessage = this.methodName + " response  exception ";
                RabbitMQValidator.this.logMessage = "";
                iOException.printStackTrace();
                return;
            }
            try {
                this.responseString = RabbitMQValidator.this.decodeResponse(inputStream);
                System.out.println("After decode for the method  " + this.methodName + "  ====> Response  : " + this.responseString);
            }
            catch (IOException iOException) {
                RabbitMQValidator.this.logMessage = this.methodName + " response after decode , Error ";
                RabbitMQValidator.this.logMessage = "";
                iOException.printStackTrace();
                return;
            }
            finally {
                if (null != inputStream) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        RabbitMQValidator.this.logMessage = this.methodName + "  response close error ";
                        RabbitMQValidator.this.logMessage = "";
                        iOException.printStackTrace();
                        return;
                    }
                }
            }
            this.done = true;
        }
    }

    class RabbitMQX509TrustManager
    implements X509TrustManager {
        RabbitMQX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    class RabbitMQHostnameVerifier
    implements HostnameVerifier {
        RabbitMQHostnameVerifier() {
        }

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }

        public boolean verify(String string, String string2) {
            return true;
        }
    }
}

