/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import net.sourceforge.jradiusclient.RadiusClient;
import net.sourceforge.jradiusclient.RadiusPacket;
import net.sourceforge.jradiusclient.packets.ChapAccessRequest;
import net.sourceforge.jradiusclient.packets.PapAccessRequest;
import net.sourceforge.jradiusclient.util.ChapUtil;

public class RadiusServiceTest
extends GenericTest {
    private String authType = null;
    private String userName = null;
    private String passWord = null;
    private String timeOut = null;
    private double responseTime = 0.0;
    private int loginStatus = 0;
    private int i_timeOut = 15000;
    private String sharedSecret;
    private int port;
    private int acctPort;

    public RadiusServiceTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.sharedSecret = this.getValueForParam("SharedSecret");
        this.acctPort = Integer.parseInt(this.getValueForParam("AcctPort"));
        this.userName = this.getValueForParam("UserName");
        this.passWord = this.getValueForParam("PassWord");
        this.authType = this.getValueForParam("AuthType");
        this.timeOut = this.getValueForParam("timeOut");
        if (this.timeOut != null && this.timeOut.trim().length() > 0) {
            try {
                this.i_timeOut = Integer.parseInt(this.timeOut);
                this.i_timeOut *= 1000;
            }
            catch (Exception exception) {
                this.i_timeOut = 15000;
            }
        }
        this.port = Integer.parseInt(this.portNo);
    }

    private void isAuthticate() {
        RadiusClient radiusClient = null;
        ChapUtil chapUtil = null;
        System.out.println("To getRadiusClient ..." + this.targetHost + " " + this.port + " " + this.acctPort);
        try {
            radiusClient = new RadiusClient(this.targetHost, this.port, this.acctPort, this.sharedSecret, this.i_timeOut);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            radiusClient = null;
            System.out.println(exception.getMessage());
            return;
        }
        System.out.println("After getRadiusClient ...");
        chapUtil = new ChapUtil();
        System.out.println("After getChapUtil ...");
        try {
            Object object = null;
            System.out.println("auth type is " + this.authType);
            object = this.authType.equalsIgnoreCase("chap") ? new ChapAccessRequest(this.userName, this.passWord) : new PapAccessRequest(this.userName, this.passWord);
            System.out.println("after access request " + object);
            long l = System.currentTimeMillis();
            RadiusPacket radiusPacket = radiusClient.authenticate((RadiusPacket)object);
            long l2 = System.currentTimeMillis();
            System.out.println("Radius Packet type is :" + radiusPacket.getPacketType());
            switch (radiusPacket.getPacketType()) {
                case 2: {
                    this.loginStatus = 100;
                    break;
                }
                case 3: {
                    this.loginStatus = 0;
                    break;
                }
                case 11: {
                    this.loginStatus = 0;
                    break;
                }
                default: {
                    this.loginStatus = 0;
                }
            }
            this.responseTime = l2 - l;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.loginStatus = 0;
            this.responseTime = -5.0;
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        this.loginStatus = 0;
        this.responseTime = 0.0;
        this.isAuthticate();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(this.loginStatus));
        double d = this.responseTime / 1000.0;
        arrayList.add(new Double(d));
        this.addNewMeasure(arrayList);
    }

    public static void main(String[] stringArray) {
        RadiusServiceTest radiusServiceTest = new RadiusServiceTest(stringArray);
        radiusServiceTest.computeMeasures(new Hashtable());
    }
}

